/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.okhttp;

import com.ustadmobile.ihttp.okhttp.request.HttpRequestOkHttpAdapterKt;
import com.ustadmobile.ihttp.okhttp.request.OkHttpRequestAdapterKt;
import com.ustadmobile.ihttp.request.IHttpRequest;
import com.ustadmobile.libcache.distributed.DistributedCacheHashtable;
import com.ustadmobile.libcache.logging.UstadCacheLogger;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/ustadmobile/libcache/okhttp/DistributedCacheInterceptor;", "Lokhttp3/Interceptor;", "distributedCacheHashtable", "Lcom/ustadmobile/libcache/distributed/DistributedCacheHashtable;", "logger", "Lcom/ustadmobile/libcache/logging/UstadCacheLogger;", "<init>", "(Lcom/ustadmobile/libcache/distributed/DistributedCacheHashtable;Lcom/ustadmobile/libcache/logging/UstadCacheLogger;)V", "getDistributedCacheHashtable", "()Lcom/ustadmobile/libcache/distributed/DistributedCacheHashtable;", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "respect-lib-cache_release"})
public final class DistributedCacheInterceptor
implements Interceptor {
    @NotNull
    private final DistributedCacheHashtable distributedCacheHashtable;
    @NotNull
    private final UstadCacheLogger logger;

    public DistributedCacheInterceptor(@NotNull DistributedCacheHashtable distributedCacheHashtable, @NotNull UstadCacheLogger logger) {
        Intrinsics.checkNotNullParameter((Object)distributedCacheHashtable, (String)"distributedCacheHashtable");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.distributedCacheHashtable = distributedCacheHashtable;
        this.logger = logger;
    }

    @NotNull
    public final DistributedCacheHashtable getDistributedCacheHashtable() {
        return this.distributedCacheHashtable;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request chainRequest = chain.request();
        IHttpRequest localRequest = this.distributedCacheHashtable.localRequestFor(OkHttpRequestAdapterKt.asIHttpRequest((Request)chainRequest));
        if (localRequest != null) {
            UstadCacheLogger.i$default(this.logger, "DistCache", "Local Download: " + chainRequest.url() + " from " + localRequest.getUrl(), null, 4, null);
            try {
                Response response = chain.proceed(HttpRequestOkHttpAdapterKt.asOkHttpRequest((IHttpRequest)localRequest));
                if (response.isSuccessful()) {
                    return response;
                }
                Util.closeQuietly((Closeable)((Closeable)response));
            }
            catch (Exception e) {
                this.logger.w("DistCache", "Local request failed", e);
            }
        }
        return chain.proceed(chainRequest);
    }
}

