/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.webauthn4j.util.AssertUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class PublicKeyCredentialType {
    public static final PublicKeyCredentialType PUBLIC_KEY = new PublicKeyCredentialType("public-key");
    private final String value;

    private PublicKeyCredentialType(String value) {
        this.value = value;
    }

    @JsonCreator
    @NotNull
    public static PublicKeyCredentialType create(@NotNull String value) {
        AssertUtil.notNull((Object)value, (String)"value must not be null.");
        if ("public-key".equals(value)) {
            return PUBLIC_KEY;
        }
        return new PublicKeyCredentialType(value);
    }

    @JsonValue
    @NotNull
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicKeyCredentialType that = (PublicKeyCredentialType)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

