/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.util;

import org.jetbrains.annotations.NotNull;

public class HexUtil {
    private static final String HEX_CHARS = "0123456789ABCDEF";
    private static final char[] HEX_CHAR_ARRAY = "0123456789ABCDEF".toCharArray();

    private HexUtil() {
    }

    @NotNull
    public static byte[] decode(@NotNull String source2) {
        int sourceLength = (source2 = source2.toUpperCase()).length();
        if (sourceLength % 2 != 0) {
            throw new IllegalArgumentException("source length must be even-length.");
        }
        byte[] bytes = new byte[sourceLength / 2];
        char[] sourceChars = source2.toCharArray();
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            bytes[i2] = (byte)((HEX_CHARS.indexOf(sourceChars[i2 * 2]) << 4) + HEX_CHARS.indexOf(sourceChars[i2 * 2 + 1]));
        }
        return bytes;
    }

    @NotNull
    public static String encodeToString(@NotNull byte[] source2) {
        StringBuilder stringBuilder = new StringBuilder(source2.length * 2);
        for (byte item2 : source2) {
            stringBuilder.append(HEX_CHAR_ARRAY[item2 >> 4 & 0xF]);
            stringBuilder.append(HEX_CHAR_ARRAY[item2 & 0xF]);
        }
        return stringBuilder.toString();
    }
}

