/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.annotation.IntRange;
import androidx.collection.DoubleList;
import androidx.collection.internal.RuntimeHelpersKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0002\b\u0011\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bJ\u0011\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0001H\u0086\bJ\u0011\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0086\bJ\u0018\u0010\u000e\u001a\u00020\t2\b\b\u0001\u0010\r\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0001J\u0018\u0010\u000e\u001a\u00020\t2\b\b\u0001\u0010\r\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\fJ\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0003J\u0011\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0001H\u0086\u0002J\u0011\u0010\u0013\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u000bH\u0086\nJ\u0011\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0086\u0002J\u0011\u0010\u0014\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0001H\u0086\nJ\u0011\u0010\u0014\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u000bH\u0086\nJ\u0011\u0010\u0014\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0086\nJ\u000e\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0016\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0001J\u000e\u0010\u0016\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0017\u001a\u00020\u000b2\b\b\u0001\u0010\r\u001a\u00020\u0003J\u001a\u0010\u0018\u001a\u00020\f2\b\b\u0001\u0010\u0019\u001a\u00020\u00032\b\b\u0001\u0010\u001a\u001a\u00020\u0003J\u000e\u0010\u001b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0001J\u000e\u0010\u001b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010J\u001b\u0010\u001c\u001a\u00020\u000b2\b\b\u0001\u0010\r\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0086\u0002J\u0006\u0010\u001d\u001a\u00020\fJ\u0006\u0010\u001e\u001a\u00020\fJ\u0010\u0010\u001f\u001a\u00020\f2\b\b\u0002\u0010 \u001a\u00020\u0003R\u0012\u0010\u0005\u001a\u00020\u00038\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006!"}, d2={"Landroidx/collection/MutableDoubleList;", "Landroidx/collection/DoubleList;", "initialCapacity", "", "(I)V", "capacity", "getCapacity", "()I", "add", "", "element", "", "", "index", "addAll", "elements", "", "clear", "ensureCapacity", "minusAssign", "plusAssign", "remove", "removeAll", "removeAt", "removeRange", "start", "end", "retainAll", "set", "sort", "sortDescending", "trim", "minCapacity", "collection"})
@SourceDebugExtension(value={"SMAP\nDoubleList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DoubleList.kt\nandroidx/collection/MutableDoubleList\n+ 2 DoubleList.kt\nandroidx/collection/DoubleList\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,983:1\n562#1:985\n367#2:984\n72#2:986\n239#2,6:989\n72#2:995\n72#2:996\n72#2:1003\n13351#3,2:987\n1699#3,6:997\n*S KotlinDebug\n*F\n+ 1 DoubleList.kt\nandroidx/collection/MutableDoubleList\n*L\n698#1:985\n634#1:984\n758#1:986\n771#1:989,6\n785#1:995\n831#1:996\n848#1:1003\n766#1:987,2\n833#1:997,6\n*E\n"})
public final class MutableDoubleList
extends DoubleList {
    public MutableDoubleList(int initialCapacity) {
        super(initialCapacity, null);
    }

    public /* synthetic */ MutableDoubleList(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 16;
        }
        this(n);
    }

    public final int getCapacity() {
        boolean $i$f$getCapacity = false;
        return this.content.length;
    }

    public final boolean add(double element) {
        this.ensureCapacity(this._size + 1);
        this.content[this._size] = element;
        int n = this._size;
        this._size = n + 1;
        return true;
    }

    public final void add(@IntRange(from=0L) int index2, double element) {
        if (!(0 <= index2 ? index2 <= this._size : false)) {
            RuntimeHelpersKt.throwIndexOutOfBoundsException("Index must be between 0 and size");
        }
        this.ensureCapacity(this._size + 1);
        double[] content2 = this.content;
        if (index2 != this._size) {
            ArraysKt.copyInto(content2, content2, index2 + 1, index2, this._size);
        }
        content2[index2] = element;
        int n = this._size;
        this._size = n + 1;
    }

    public final boolean addAll(@IntRange(from=0L) int index2, @NotNull double[] elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        if (!(0 <= index2 ? index2 <= this._size : false)) {
            RuntimeHelpersKt.throwIndexOutOfBoundsException("");
        }
        if (elements.length == 0) {
            return false;
        }
        this.ensureCapacity(this._size + elements.length);
        double[] content2 = this.content;
        if (index2 != this._size) {
            ArraysKt.copyInto(content2, content2, index2 + elements.length, index2, this._size);
        }
        ArraysKt.copyInto$default(elements, content2, index2, 0, 0, 12, null);
        this._size += elements.length;
        return true;
    }

    public final boolean addAll(@IntRange(from=0L) int index2, @NotNull DoubleList elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        if (!(0 <= index2 ? index2 <= this._size : false)) {
            RuntimeHelpersKt.throwIndexOutOfBoundsException("");
        }
        DoubleList this_$iv = elements;
        boolean $i$f$isEmpty = false;
        if (this_$iv._size == 0) {
            return false;
        }
        this.ensureCapacity(this._size + elements._size);
        double[] content2 = this.content;
        if (index2 != this._size) {
            ArraysKt.copyInto(content2, content2, index2 + elements._size, index2, this._size);
        }
        ArraysKt.copyInto(elements.content, content2, index2, 0, elements._size);
        this._size += elements._size;
        return true;
    }

    public final boolean addAll(@NotNull DoubleList elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        boolean $i$f$addAll = false;
        return this.addAll(this._size, elements);
    }

    public final boolean addAll(@NotNull double[] elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        boolean $i$f$addAll = false;
        return this.addAll(this._size, elements);
    }

    public final void plusAssign(@NotNull DoubleList elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        boolean $i$f$plusAssign = false;
        this.addAll(this._size, elements);
    }

    public final void plusAssign(@NotNull double[] elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        boolean $i$f$plusAssign = false;
        this.addAll(this._size, elements);
    }

    public final void clear() {
        this._size = 0;
    }

    public final void trim(int minCapacity) {
        int minSize = Math.max(minCapacity, this._size);
        MutableDoubleList this_$iv = this;
        boolean $i$f$getCapacity = false;
        if (this_$iv.content.length > minSize) {
            double[] dArray = Arrays.copyOf(this.content, minSize);
            Intrinsics.checkNotNullExpressionValue(dArray, "copyOf(...)");
            this.content = dArray;
        }
    }

    public static /* synthetic */ void trim$default(MutableDoubleList mutableDoubleList, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = mutableDoubleList._size;
        }
        mutableDoubleList.trim(n);
    }

    public final void ensureCapacity(int capacity) {
        double[] oldContent = this.content;
        if (oldContent.length < capacity) {
            int newSize = Math.max(capacity, oldContent.length * 3 / 2);
            double[] dArray = Arrays.copyOf(oldContent, newSize);
            Intrinsics.checkNotNullExpressionValue(dArray, "copyOf(...)");
            this.content = dArray;
        }
    }

    public final void plusAssign(double element) {
        boolean $i$f$plusAssign = false;
        this.add(element);
    }

    public final void minusAssign(double element) {
        boolean $i$f$minusAssign = false;
        this.remove(element);
    }

    public final boolean remove(double element) {
        int index2 = this.indexOf(element);
        if (index2 >= 0) {
            this.removeAt(index2);
            return true;
        }
        return false;
    }

    public final boolean removeAll(@NotNull double[] elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        int initialSize = this._size;
        int n = elements.length;
        for (int i2 = 0; i2 < n; ++i2) {
            this.remove(elements[i2]);
        }
        return initialSize != this._size;
    }

    public final boolean removeAll(@NotNull DoubleList elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        int initialSize = this._size;
        int i2 = 0;
        DoubleList this_$iv = elements;
        boolean $i$f$getLastIndex = false;
        int n = this_$iv._size - 1;
        if (i2 <= n) {
            while (true) {
                this.remove(elements.get(i2));
                if (i2 == n) break;
                ++i2;
            }
        }
        return initialSize != this._size;
    }

    public final void minusAssign(@NotNull double[] elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        double[] $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            double element$iv;
            double element = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            this.remove(element);
        }
    }

    public final void minusAssign(@NotNull DoubleList elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        DoubleList this_$iv = elements;
        boolean $i$f$forEach = false;
        double[] content$iv = this_$iv.content;
        int n = this_$iv._size;
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            double element = content$iv[i$iv];
            boolean bl = false;
            this.remove(element);
        }
    }

    public final double removeAt(@IntRange(from=0L) int index2) {
        if (!(0 <= index2 ? index2 < this._size : false)) {
            RuntimeHelpersKt.throwIndexOutOfBoundsException("Index must be between 0 and size");
        }
        double[] content2 = this.content;
        double item2 = content2[index2];
        DoubleList this_$iv = this;
        boolean $i$f$getLastIndex = false;
        if (index2 != this_$iv._size - 1) {
            ArraysKt.copyInto(content2, content2, index2, index2 + 1, this._size);
        }
        int n = this._size;
        this._size = n + -1;
        return item2;
    }

    public final void removeRange(@IntRange(from=0L) int start2, @IntRange(from=0L) int end) {
        block7: {
            block6: {
                boolean bl = 0 <= start2 ? start2 <= this._size : false;
                if (!bl) break block6;
                if (0 <= end ? end <= this._size : false) break block7;
            }
            RuntimeHelpersKt.throwIndexOutOfBoundsException("Index must be between 0 and size");
        }
        if (end < start2) {
            RuntimeHelpersKt.throwIllegalArgumentException("The end index must be < start index");
        }
        if (end != start2) {
            if (end < this._size) {
                ArraysKt.copyInto(this.content, this.content, start2, end, this._size);
            }
            this._size -= end - start2;
        }
    }

    public final boolean retainAll(@NotNull double[] elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        int initialSize = this._size;
        double[] content2 = this.content;
        DoubleList this_$iv = this;
        boolean $i$f$getLastIndex = false;
        for (int i2 = this_$iv._size - 1; -1 < i2; --i2) {
            int n;
            block2: {
                double item2 = content2[i2];
                double[] $this$indexOfFirst$iv = elements;
                boolean $i$f$indexOfFirst = false;
                int n2 = $this$indexOfFirst$iv.length;
                for (int index$iv = 0; index$iv < n2; ++index$iv) {
                    double it = $this$indexOfFirst$iv[index$iv];
                    boolean bl = false;
                    if (!(it == item2)) continue;
                    n = index$iv;
                    break block2;
                }
                n = -1;
            }
            if (n >= 0) continue;
            this.removeAt(i2);
        }
        return initialSize != this._size;
    }

    public final boolean retainAll(@NotNull DoubleList elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        int initialSize = this._size;
        double[] content2 = this.content;
        DoubleList this_$iv = this;
        boolean $i$f$getLastIndex = false;
        for (int i2 = this_$iv._size - 1; -1 < i2; --i2) {
            double item2 = content2[i2];
            if (elements.contains(item2)) continue;
            this.removeAt(i2);
        }
        return initialSize != this._size;
    }

    public final double set(@IntRange(from=0L) int index2, double element) {
        if (!(0 <= index2 ? index2 < this._size : false)) {
            RuntimeHelpersKt.throwIndexOutOfBoundsException("Index must be between 0 and size");
        }
        double[] content2 = this.content;
        double old = content2[index2];
        content2[index2] = element;
        return old;
    }

    public final void sort() {
        if (this._size == 0) {
            return;
        }
        ArraysKt.sort(this.content, 0, this._size);
    }

    public final void sortDescending() {
        if (this._size == 0) {
            return;
        }
        ArraysKt.sortDescending(this.content, 0, this._size);
    }

    public MutableDoubleList() {
        this(0, 1, null);
    }
}

