/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.config;

import io.ktor.server.config.ApplicationConfig;
import io.ktor.server.config.ConfigLoadersJvmKt;
import io.ktor.server.config.MapApplicationConfig;
import io.ktor.server.config.MergedApplicationConfigKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007J\u001b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H&\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\b\u00c0\u0006\u0003"}, d2={"Lio/ktor/server/config/ConfigLoader;", "", "", "path", "Lio/ktor/server/config/ApplicationConfig;", "load", "(Ljava/lang/String;)Lio/ktor/server/config/ApplicationConfig;", "Companion", "ktor-server-core"})
public interface ConfigLoader {
    @NotNull
    public static final Companion Companion = io.ktor.server.config.ConfigLoader$Companion.$$INSTANCE;

    @Nullable
    public ApplicationConfig load(@Nullable String var1);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\b\u001a\u00020\u00072\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0019\u0010\u000b\u001a\u00020\u00072\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0011\u0010\r\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lio/ktor/server/config/ConfigLoader$Companion;", "", "<init>", "()V", "", "", "configPaths", "Lio/ktor/server/config/ApplicationConfig;", "loadAll", "([Ljava/lang/String;)Lio/ktor/server/config/ApplicationConfig;", "path", "load", "(Ljava/lang/String;)Lio/ktor/server/config/ApplicationConfig;", "loadDefault", "()Lio/ktor/server/config/ApplicationConfig;", "ktor-server-core"})
    @SourceDebugExtension(value={"SMAP\nConfigLoaders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigLoaders.kt\nio/ktor/server/config/ConfigLoader$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n11228#2:86\n11563#2,3:87\n2783#3,7:90\n*S KotlinDebug\n*F\n+ 1 ConfigLoaders.kt\nio/ktor/server/config/ConfigLoader$Companion\n*L\n44#1:86\n44#1:87,3\n44#1:90,7\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ApplicationConfig loadAll(String ... configPaths) {
            ApplicationConfig applicationConfig;
            Intrinsics.checkNotNullParameter(configPaths, "configPaths");
            switch (configPaths.length) {
                case 0: {
                    applicationConfig = io.ktor.server.config.ConfigLoader$Companion.load$default(this, null, 1, null);
                    break;
                }
                case 1: {
                    applicationConfig = this.load(ArraysKt.single(configPaths));
                    break;
                }
                default: {
                    void $this$mapTo$iv$iv;
                    String[] $this$map$iv = configPaths;
                    boolean $i$f$map = false;
                    String[] stringArray = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                    boolean $i$f$mapTo2 = false;
                    int n = ((void)$this$mapTo$iv$iv).length;
                    for (int j = 0; j < n; ++j) {
                        void p0;
                        void item$iv$iv;
                        void var10_12 = item$iv$iv = $this$mapTo$iv$iv[j];
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(this.load((String)p0));
                    }
                    Iterable $this$reduce$iv = (List)destination$iv$iv;
                    boolean $i$f$reduce = false;
                    Iterator iterator$iv = $this$reduce$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        throw new UnsupportedOperationException("Empty collection can't be reduced.");
                    }
                    Object accumulator$iv = iterator$iv.next();
                    while (iterator$iv.hasNext()) {
                        void p1;
                        ApplicationConfig $i$f$mapTo2 = (ApplicationConfig)iterator$iv.next();
                        ApplicationConfig p0 = (ApplicationConfig)accumulator$iv;
                        boolean bl = false;
                        accumulator$iv = MergedApplicationConfigKt.mergeWith(p0, (ApplicationConfig)p1);
                    }
                    applicationConfig = (ApplicationConfig)accumulator$iv;
                }
            }
            return applicationConfig;
        }

        @NotNull
        public final ApplicationConfig load(@Nullable String path) {
            ApplicationConfig applicationConfig;
            if (path == null && (applicationConfig = this.loadDefault()) != null) {
                return applicationConfig;
            }
            for (ConfigLoader loader : ConfigLoadersJvmKt.getConfigLoaders()) {
                ApplicationConfig config2 = loader.load(path);
                if (config2 == null) continue;
                return config2;
            }
            return new MapApplicationConfig();
        }

        public static /* synthetic */ ApplicationConfig load$default(Companion companion, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = null;
            }
            return companion.load(string2);
        }

        private final ApplicationConfig loadDefault() {
            for (String defaultPath : ConfigLoadersJvmKt.getCONFIG_PATH()) {
                for (ConfigLoader loader : ConfigLoadersJvmKt.getConfigLoaders()) {
                    ApplicationConfig config2 = loader.load(defaultPath);
                    if (config2 == null) continue;
                    return config2;
                }
            }
            return null;
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

