/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.UtcOffset;
import kotlinx.datetime.UtcOffsetJvmKt;
import kotlinx.datetime.YearMonth;
import kotlinx.datetime.YearMonthJvmKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\t\b\u0016\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lkotlinx/datetime/Ser;", "Ljava/io/Externalizable;", "typeTag", "", "value", "", "<init>", "(ILjava/lang/Object;)V", "()V", "writeExternal", "", "out", "Ljava/io/ObjectOutput;", "readExternal", "in", "Ljava/io/ObjectInput;", "readResolve", "Companion", "kotlinx-datetime"})
@PublishedApi
public final class Ser
implements Externalizable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int typeTag;
    @Nullable
    private Object value;
    private static final long serialVersionUID = 0L;
    public static final int DATE_TAG = 2;
    public static final int TIME_TAG = 3;
    public static final int DATE_TIME_TAG = 4;
    public static final int UTC_OFFSET_TAG = 10;
    public static final int YEAR_MONTH_TAG = 11;

    public Ser(int typeTag, @Nullable Object value) {
        this.typeTag = typeTag;
        this.value = value;
    }

    public Ser() {
        this(0, null);
    }

    @Override
    public void writeExternal(@NotNull ObjectOutput out) {
        Intrinsics.checkNotNullParameter(out, "out");
        out.writeByte(this.typeTag);
        Object value = this.value;
        switch (this.typeTag) {
            case 2: {
                Intrinsics.checkNotNull(value, "null cannot be cast to non-null type kotlinx.datetime.LocalDate");
                LocalDate cfr_ignored_0 = (LocalDate)value;
                out.writeLong(((LocalDate)value).getValue$kotlinx_datetime().toEpochDay());
                break;
            }
            case 3: {
                Intrinsics.checkNotNull(value, "null cannot be cast to non-null type kotlinx.datetime.LocalTime");
                LocalTime cfr_ignored_1 = (LocalTime)value;
                out.writeLong(((LocalTime)value).toNanosecondOfDay());
                break;
            }
            case 4: {
                Intrinsics.checkNotNull(value, "null cannot be cast to non-null type kotlinx.datetime.LocalDateTime");
                LocalDateTime cfr_ignored_2 = (LocalDateTime)value;
                out.writeLong(((LocalDateTime)value).getDate().getValue$kotlinx_datetime().toEpochDay());
                out.writeLong(((LocalDateTime)value).getTime().toNanosecondOfDay());
                break;
            }
            case 10: {
                Intrinsics.checkNotNull(value, "null cannot be cast to non-null type kotlinx.datetime.UtcOffset");
                UtcOffset cfr_ignored_3 = (UtcOffset)value;
                out.writeInt(((UtcOffset)value).getTotalSeconds());
                break;
            }
            case 11: {
                Intrinsics.checkNotNull(value, "null cannot be cast to non-null type kotlinx.datetime.YearMonth");
                YearMonth cfr_ignored_4 = (YearMonth)value;
                out.writeLong(YearMonthJvmKt.toEpochMonths((YearMonth)value));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type tag: " + this.typeTag + " for value: " + value);
            }
        }
    }

    @Override
    public void readExternal(@NotNull ObjectInput in) {
        Serializable serializable;
        Intrinsics.checkNotNullParameter(in, "in");
        this.typeTag = in.readByte();
        switch (this.typeTag) {
            case 2: {
                java.time.LocalDate localDate = java.time.LocalDate.ofEpochDay(in.readLong());
                Intrinsics.checkNotNullExpressionValue(localDate, "ofEpochDay(...)");
                serializable = new LocalDate(localDate);
                break;
            }
            case 3: {
                serializable = LocalTime.Companion.fromNanosecondOfDay(in.readLong());
                break;
            }
            case 4: {
                java.time.LocalDate localDate = java.time.LocalDate.ofEpochDay(in.readLong());
                Intrinsics.checkNotNullExpressionValue(localDate, "ofEpochDay(...)");
                serializable = new LocalDateTime(new LocalDate(localDate), LocalTime.Companion.fromNanosecondOfDay(in.readLong()));
                break;
            }
            case 10: {
                serializable = UtcOffsetJvmKt.UtcOffset$default(null, null, in.readInt(), 3, null);
                break;
            }
            case 11: {
                serializable = YearMonthJvmKt.fromEpochMonths(YearMonth.Companion, in.readLong());
                break;
            }
            default: {
                throw new IOException("Unknown type tag: " + this.typeTag);
            }
        }
        this.value = serializable;
    }

    private final Object readResolve() {
        Object object = this.value;
        Intrinsics.checkNotNull(object);
        return object;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lkotlinx/datetime/Ser$Companion;", "", "<init>", "()V", "serialVersionUID", "", "DATE_TAG", "", "TIME_TAG", "DATE_TIME_TAG", "UTC_OFFSET_TAG", "YEAR_MONTH_TAG", "kotlinx-datetime"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

