/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import org.jsoup.internal.QuietAppendable;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Entities;
import org.jsoup.nodes.LeafNode;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.NodeUtils;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.Tag;
import org.jsoup.select.NodeVisitor;
import org.jspecify.annotations.Nullable;

class Printer
implements NodeVisitor {
    final Node root;
    final QuietAppendable accum;
    final Document.OutputSettings settings;

    Printer(Node root, QuietAppendable accum, Document.OutputSettings settings) {
        this.root = root;
        this.accum = accum;
        this.settings = settings;
    }

    void addHead(Element el, int depth) {
        el.outerHtmlHead(this.accum, this.settings);
    }

    void addTail(Element el, int depth) {
        el.outerHtmlTail(this.accum, this.settings);
    }

    void addText(TextNode textNode, int textOptions, int depth) {
        int options2 = 1 | textOptions;
        Entities.escape(this.accum, textNode.coreValue(), this.settings, options2);
    }

    void addNode(LeafNode node2, int depth) {
        node2.outerHtmlHead(this.accum, this.settings);
    }

    void indent(int depth) {
        this.accum.append('\n').append(StringUtil.padding(depth * this.settings.indentAmount(), this.settings.maxPaddingWidth()));
    }

    @Override
    public void head(Node node2, int depth) {
        if (node2.getClass() == TextNode.class) {
            this.addText((TextNode)node2, 0, depth);
        } else if (node2 instanceof Element) {
            this.addHead((Element)node2, depth);
        } else {
            this.addNode((LeafNode)node2, depth);
        }
    }

    @Override
    public void tail(Node node2, int depth) {
        if (node2 instanceof Element) {
            this.addTail((Element)node2, depth);
        }
    }

    static Printer printerFor(Node root, QuietAppendable accum) {
        Document.OutputSettings settings = NodeUtils.outputSettings(root);
        if (settings.outline()) {
            return new Outline(root, accum, settings);
        }
        if (settings.prettyPrint()) {
            return new Pretty(root, accum, settings);
        }
        return new Printer(root, accum, settings);
    }

    static class Outline
    extends Pretty {
        Outline(Node root, QuietAppendable accum, Document.OutputSettings settings) {
            super(root, accum, settings);
        }

        @Override
        boolean isBlockEl(@Nullable Node node2) {
            return node2 != null;
        }

        @Override
        boolean shouldIndent(@Nullable Node node2) {
            if (node2 == null || node2 == this.root || this.preserveWhitespace || Outline.isBlankText(node2)) {
                return false;
            }
            if (node2 instanceof TextNode) {
                return node2.previousSibling() != null || node2.nextSibling() != null;
            }
            return true;
        }
    }

    static class Pretty
    extends Printer {
        boolean preserveWhitespace = false;
        private static final int maxScan = 5;

        Pretty(Node root, QuietAppendable accum, Document.OutputSettings settings) {
            super(root, accum, settings);
            for (Node node2 = root; node2 != null; node2 = node2.parentNode()) {
                if (!Pretty.tagIs(Tag.PreserveWhitespace, node2)) continue;
                this.preserveWhitespace = true;
                break;
            }
        }

        @Override
        void addHead(Element el, int depth) {
            if (this.shouldIndent(el)) {
                this.indent(depth);
            }
            super.addHead(el, depth);
            if (Pretty.tagIs(Tag.PreserveWhitespace, el)) {
                this.preserveWhitespace = true;
            }
        }

        @Override
        void addTail(Element el, int depth) {
            if (this.shouldIndent(Pretty.nextNonBlank(el.firstChild()))) {
                this.indent(depth);
            }
            super.addTail(el, depth);
            if (this.preserveWhitespace && el.tag.is(Tag.PreserveWhitespace)) {
                for (Element parent = el.parent(); parent != null; parent = parent.parent()) {
                    if (!parent.tag().preserveWhitespace()) continue;
                    return;
                }
                this.preserveWhitespace = false;
            }
        }

        @Override
        void addNode(LeafNode node2, int depth) {
            if (this.shouldIndent(node2)) {
                this.indent(depth);
            }
            super.addNode(node2, depth);
        }

        @Override
        void addText(TextNode node2, int textOptions, int depth) {
            if (!this.preserveWhitespace) {
                textOptions |= 4;
                textOptions = this.textTrim(node2, textOptions);
                if (!node2.isBlank() && this.isBlockEl(node2.parentNode) && this.shouldIndent(node2)) {
                    this.indent(depth);
                }
            }
            super.addText(node2, textOptions, depth);
        }

        int textTrim(TextNode node2, int options2) {
            if (!this.isBlockEl(node2.parentNode)) {
                return options2;
            }
            Node prev = node2.previousSibling();
            Node next2 = node2.nextSibling();
            if ((!(prev instanceof Element) || this.isBlockEl(prev)) && (prev == null || !(prev instanceof TextNode) && this.shouldIndent(prev))) {
                options2 |= 8;
            }
            if (next2 == null || !(next2 instanceof TextNode) && this.shouldIndent(next2)) {
                options2 |= 0x10;
            } else if ((next2 = Pretty.nextNonBlank(next2)) instanceof TextNode && StringUtil.isWhitespace(next2.nodeValue().codePointAt(0))) {
                options2 |= 0x10;
            }
            return options2;
        }

        boolean shouldIndent(@Nullable Node node2) {
            if (node2 == null || node2 == this.root || this.preserveWhitespace || Pretty.isBlankText(node2)) {
                return false;
            }
            if (this.isBlockEl(node2)) {
                return true;
            }
            Node prevSib = Pretty.previousNonblank(node2);
            if (this.isBlockEl(prevSib)) {
                return true;
            }
            Element parent = node2.parentNode;
            if (!this.isBlockEl(parent) || parent.tag().is(Tag.InlineContainer) || !Pretty.hasNonTextNodes(parent)) {
                return false;
            }
            return prevSib == null || !(prevSib instanceof TextNode) && (this.isBlockEl(prevSib) || !(prevSib instanceof Element));
        }

        boolean isBlockEl(@Nullable Node node2) {
            if (node2 == null) {
                return false;
            }
            if (node2 instanceof Element) {
                Element el = (Element)node2;
                return el.isBlock() || !el.tag.isKnownTag() && (el.parentNode instanceof Document || Pretty.hasChildBlocks(el));
            }
            return false;
        }

        static boolean hasChildBlocks(Element el) {
            Element child = el.firstElementChild();
            for (int i2 = 0; i2 < 5 && child != null; child = child.nextElementSibling(), ++i2) {
                if (!child.isBlock() && child.tag.isKnownTag()) continue;
                return true;
            }
            return false;
        }

        static boolean hasNonTextNodes(Element el) {
            Node child = el.firstChild();
            for (int i2 = 0; i2 < 5 && child != null; child = child.nextSibling(), ++i2) {
                if (child instanceof TextNode) continue;
                return true;
            }
            return false;
        }

        static @Nullable Node previousNonblank(Node node2) {
            Node prev = node2.previousSibling();
            while (Pretty.isBlankText(prev)) {
                prev = prev.previousSibling();
            }
            return prev;
        }

        static @Nullable Node nextNonBlank(@Nullable Node node2) {
            while (Pretty.isBlankText(node2)) {
                node2 = node2.nextSibling();
            }
            return node2;
        }

        static boolean isBlankText(@Nullable Node node2) {
            return node2 instanceof TextNode && ((TextNode)node2).isBlank();
        }

        static boolean tagIs(int option2, @Nullable Node node2) {
            return node2 instanceof Element && ((Element)node2).tag.is(option2);
        }
    }
}

