/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy.grid;

import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.gestures.snapping.LazyGridSnapLayoutInfoProviderKt;
import androidx.compose.foundation.lazy.grid.LazyGridItemInfo;
import androidx.compose.foundation.lazy.grid.LazyGridLayoutInfo;
import androidx.compose.foundation.lazy.grid.LazyGridPrefetchScope;
import androidx.compose.foundation.lazy.grid.LazyGridPrefetchStrategy;
import androidx.compose.foundation.lazy.layout.LazyLayoutPrefetchState;
import androidx.compose.foundation.lazy.layout.NestedPrefetchScope;
import androidx.compose.runtime.Stable;
import androidx.compose.runtime.collection.MutableVector;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0014\u0010\u0015\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0014\u0010\u0016\u001a\u00020\u0010*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u001c\u0010\u0019\u001a\u00020\u0010*\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\u0014\u0010\u001c\u001a\u00020\u0003*\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\u0014\u0010\u001d\u001a\u00020\u0003*\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\b\u0010\u001e\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Landroidx/compose/foundation/lazy/grid/DefaultLazyGridPrefetchStrategy;", "Landroidx/compose/foundation/lazy/grid/LazyGridPrefetchStrategy;", "initialNestedPrefetchItemCount", "", "<init>", "(I)V", "lineToPrefetch", "currentLinePrefetchHandles", "Landroidx/compose/runtime/collection/MutableVector;", "Landroidx/compose/foundation/lazy/layout/LazyLayoutPrefetchState$PrefetchHandle;", "wasScrollingForward", "", "previousPassItemCount", "previousPassDelta", "", "onScroll", "", "Landroidx/compose/foundation/lazy/grid/LazyGridPrefetchScope;", "delta", "layoutInfo", "Landroidx/compose/foundation/lazy/grid/LazyGridLayoutInfo;", "onVisibleItemsUpdated", "onNestedPrefetch", "Landroidx/compose/foundation/lazy/layout/NestedPrefetchScope;", "firstVisibleItemIndex", "evaluatePrefetchForCancellation", "currentPrefetchingLineIndex", "scrollingForward", "calculateLineIndexToPrefetch", "calculateClosestNextItemToPrefetch", "resetPrefetchState", "foundation"})
@Stable
@SourceDebugExtension(value={"SMAP\nLazyGridPrefetchStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyGridPrefetchStrategy.kt\nandroidx/compose/foundation/lazy/grid/DefaultLazyGridPrefetchStrategy\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n+ 3 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n*L\n1#1,341:1\n1107#2:342\n1085#2,2:343\n424#3,8:345\n136#3:353\n424#3,8:354\n424#3,8:362\n136#3:370\n424#3,8:371\n*S KotlinDebug\n*F\n+ 1 LazyGridPrefetchStrategy.kt\nandroidx/compose/foundation/lazy/grid/DefaultLazyGridPrefetchStrategy\n*L\n164#1:342\n164#1:343,2\n192#1:345,8\n197#1:353\n208#1:354,8\n217#1:362,8\n246#1:370\n303#1:371,8\n*E\n"})
final class DefaultLazyGridPrefetchStrategy
implements LazyGridPrefetchStrategy {
    private final int initialNestedPrefetchItemCount;
    private int lineToPrefetch;
    @NotNull
    private final MutableVector<LazyLayoutPrefetchState.PrefetchHandle> currentLinePrefetchHandles;
    private boolean wasScrollingForward;
    private int previousPassItemCount;
    private float previousPassDelta;

    public DefaultLazyGridPrefetchStrategy(int initialNestedPrefetchItemCount) {
        this.initialNestedPrefetchItemCount = initialNestedPrefetchItemCount;
        this.lineToPrefetch = -1;
        boolean $i$f$mutableVectorOf = false;
        int capacity$iv$iv = 16;
        boolean $i$f$MutableVector = false;
        this.currentLinePrefetchHandles = new MutableVector<LazyLayoutPrefetchState.PrefetchHandle>(new LazyLayoutPrefetchState.PrefetchHandle[capacity$iv$iv], 0);
        this.previousPassItemCount = -1;
    }

    public /* synthetic */ DefaultLazyGridPrefetchStrategy(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        this(n);
    }

    @Override
    public void onScroll(@NotNull LazyGridPrefetchScope $this$onScroll, float delta, @NotNull LazyGridLayoutInfo layoutInfo) {
        Intrinsics.checkNotNullParameter($this$onScroll, "<this>");
        Intrinsics.checkNotNullParameter(layoutInfo, "layoutInfo");
        if (!((Collection)layoutInfo.getVisibleItemsInfo()).isEmpty()) {
            boolean scrollingForward = delta < 0.0f;
            int lineToPrefetch = this.calculateLineIndexToPrefetch(layoutInfo, scrollingForward);
            int closestNextItemToPrefetch = this.calculateClosestNextItemToPrefetch(layoutInfo, scrollingForward);
            boolean bl = 0 <= closestNextItemToPrefetch ? closestNextItemToPrefetch < layoutInfo.getTotalItemsCount() : false;
            if (bl) {
                if (lineToPrefetch != this.lineToPrefetch && lineToPrefetch >= 0) {
                    MutableVector<LazyLayoutPrefetchState.PrefetchHandle> this_$iv;
                    if (this.wasScrollingForward != scrollingForward) {
                        this_$iv = this.currentLinePrefetchHandles;
                        boolean $i$f$forEach = false;
                        T[] content$iv = this_$iv.content;
                        int size$iv = this_$iv.getSize();
                        for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
                            LazyLayoutPrefetchState.PrefetchHandle it = (LazyLayoutPrefetchState.PrefetchHandle)content$iv[i$iv];
                            boolean bl2 = false;
                            it.cancel();
                        }
                    }
                    this.wasScrollingForward = scrollingForward;
                    this.lineToPrefetch = lineToPrefetch;
                    this.currentLinePrefetchHandles.clear();
                    this_$iv = this.currentLinePrefetchHandles;
                    List<LazyLayoutPrefetchState.PrefetchHandle> elements$iv = $this$onScroll.scheduleLinePrefetch(lineToPrefetch);
                    boolean $i$f$addAll = false;
                    this_$iv.addAll(this_$iv.getSize(), elements$iv);
                }
                if (scrollingForward) {
                    LazyGridItemInfo lastItem = CollectionsKt.last(layoutInfo.getVisibleItemsInfo());
                    int itemSize = LazyGridSnapLayoutInfoProviderKt.sizeOnMainAxis(lastItem, layoutInfo.getOrientation());
                    int itemSpacing = layoutInfo.getMainAxisItemSpacing();
                    int distanceToPrefetchItem = LazyGridSnapLayoutInfoProviderKt.offsetOnMainAxis(lastItem, layoutInfo.getOrientation()) + itemSize + itemSpacing - layoutInfo.getViewportEndOffset();
                    if ((float)distanceToPrefetchItem < -delta) {
                        MutableVector<LazyLayoutPrefetchState.PrefetchHandle> this_$iv = this.currentLinePrefetchHandles;
                        boolean $i$f$forEach = false;
                        T[] content$iv = this_$iv.content;
                        int size$iv = this_$iv.getSize();
                        for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
                            LazyLayoutPrefetchState.PrefetchHandle it = (LazyLayoutPrefetchState.PrefetchHandle)content$iv[i$iv];
                            boolean bl3 = false;
                            it.markAsUrgent();
                        }
                    }
                } else {
                    LazyGridItemInfo firstItem = CollectionsKt.first(layoutInfo.getVisibleItemsInfo());
                    int distanceToPrefetchItem = layoutInfo.getViewportStartOffset() - LazyGridSnapLayoutInfoProviderKt.offsetOnMainAxis(firstItem, layoutInfo.getOrientation());
                    if ((float)distanceToPrefetchItem < delta) {
                        MutableVector<LazyLayoutPrefetchState.PrefetchHandle> this_$iv = this.currentLinePrefetchHandles;
                        boolean $i$f$forEach = false;
                        T[] content$iv = this_$iv.content;
                        int size$iv = this_$iv.getSize();
                        for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
                            LazyLayoutPrefetchState.PrefetchHandle it = (LazyLayoutPrefetchState.PrefetchHandle)content$iv[i$iv];
                            boolean bl4 = false;
                            it.markAsUrgent();
                        }
                    }
                }
            }
        }
        this.previousPassDelta = delta;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onVisibleItemsUpdated(@NotNull LazyGridPrefetchScope $this$onVisibleItemsUpdated, @NotNull LazyGridLayoutInfo layoutInfo) {
        Intrinsics.checkNotNullParameter($this$onVisibleItemsUpdated, "<this>");
        Intrinsics.checkNotNullParameter(layoutInfo, "layoutInfo");
        this.evaluatePrefetchForCancellation(layoutInfo, this.lineToPrefetch, this.wasScrollingForward);
        int currentPassItemCount = layoutInfo.getTotalItemsCount();
        if (this.previousPassItemCount != -1 && !(this.previousPassDelta == 0.0f) && this.previousPassItemCount != currentPassItemCount && !((Collection)layoutInfo.getVisibleItemsInfo()).isEmpty()) {
            int lineToPrefetch = this.calculateLineIndexToPrefetch(layoutInfo, this.previousPassDelta < 0.0f);
            int closestNextItemToPrefetch = this.calculateClosestNextItemToPrefetch(layoutInfo, this.previousPassDelta < 0.0f);
            boolean bl = 0 <= closestNextItemToPrefetch ? closestNextItemToPrefetch < layoutInfo.getTotalItemsCount() : false;
            if (bl && lineToPrefetch != this.lineToPrefetch && lineToPrefetch >= 0) {
                void this_$iv;
                this.lineToPrefetch = lineToPrefetch;
                this.currentLinePrefetchHandles.clear();
                MutableVector<LazyLayoutPrefetchState.PrefetchHandle> mutableVector = this.currentLinePrefetchHandles;
                List<LazyLayoutPrefetchState.PrefetchHandle> elements$iv = $this$onVisibleItemsUpdated.scheduleLinePrefetch(lineToPrefetch);
                boolean $i$f$addAll = false;
                this_$iv.addAll(this_$iv.getSize(), elements$iv);
            }
        }
        this.previousPassItemCount = currentPassItemCount;
    }

    @Override
    public void onNestedPrefetch(@NotNull NestedPrefetchScope $this$onNestedPrefetch, int firstVisibleItemIndex) {
        Intrinsics.checkNotNullParameter($this$onNestedPrefetch, "<this>");
        int resolvedNestedPrefetchItemCount = $this$onNestedPrefetch.getNestedPrefetchItemCount() == -1 ? this.initialNestedPrefetchItemCount : $this$onNestedPrefetch.getNestedPrefetchItemCount();
        int n = 0;
        while (n < resolvedNestedPrefetchItemCount) {
            int i2 = n++;
            boolean bl = false;
            $this$onNestedPrefetch.schedulePrecomposition(firstVisibleItemIndex + i2);
        }
    }

    private final void evaluatePrefetchForCancellation(LazyGridLayoutInfo $this$evaluatePrefetchForCancellation, int currentPrefetchingLineIndex, boolean scrollingForward) {
        int expectedLineToPrefetch;
        if (currentPrefetchingLineIndex != -1 && !((Collection)$this$evaluatePrefetchForCancellation.getVisibleItemsInfo()).isEmpty() && currentPrefetchingLineIndex != (expectedLineToPrefetch = this.calculateLineIndexToPrefetch($this$evaluatePrefetchForCancellation, scrollingForward))) {
            this.resetPrefetchState();
        }
    }

    private final int calculateLineIndexToPrefetch(LazyGridLayoutInfo $this$calculateLineIndexToPrefetch, boolean scrollingForward) {
        int n;
        if (scrollingForward) {
            LazyGridItemInfo it = CollectionsKt.last($this$calculateLineIndexToPrefetch.getVisibleItemsInfo());
            boolean bl = false;
            n = ($this$calculateLineIndexToPrefetch.getOrientation() == Orientation.Vertical ? it.getRow() : it.getColumn()) + 1;
        } else {
            LazyGridItemInfo it = CollectionsKt.first($this$calculateLineIndexToPrefetch.getVisibleItemsInfo());
            boolean bl = false;
            n = ($this$calculateLineIndexToPrefetch.getOrientation() == Orientation.Vertical ? it.getRow() : it.getColumn()) - 1;
        }
        return n;
    }

    private final int calculateClosestNextItemToPrefetch(LazyGridLayoutInfo $this$calculateClosestNextItemToPrefetch, boolean scrollingForward) {
        return scrollingForward ? CollectionsKt.last($this$calculateClosestNextItemToPrefetch.getVisibleItemsInfo()).getIndex() + 1 : CollectionsKt.first($this$calculateClosestNextItemToPrefetch.getVisibleItemsInfo()).getIndex() - 1;
    }

    private final void resetPrefetchState() {
        this.lineToPrefetch = -1;
        MutableVector<LazyLayoutPrefetchState.PrefetchHandle> this_$iv = this.currentLinePrefetchHandles;
        boolean $i$f$forEach = false;
        T[] content$iv = this_$iv.content;
        int size$iv = this_$iv.getSize();
        for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
            LazyLayoutPrefetchState.PrefetchHandle it = (LazyLayoutPrefetchState.PrefetchHandle)content$iv[i$iv];
            boolean bl = false;
            it.cancel();
        }
        this.currentLinePrefetchHandles.clear();
    }

    public DefaultLazyGridPrefetchStrategy() {
        this(0, 1, null);
    }
}

