/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.argparse4j.helper;

import java.io.PrintWriter;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.sourceforge.argparse4j.helper.TextWidthCounter;

public final class TextHelper {
    public static final Locale LOCALE_ROOT = Locale.ROOT;
    public static final String LINESEP = System.lineSeparator();

    private TextHelper() {
    }

    public static <T> String concat(T[] a2, int offset, String sep, String start2, String end) {
        StringBuilder sb = new StringBuilder();
        sb.append(start2);
        if (a2.length - offset > 0) {
            sb.append(a2[offset]);
            int len = a2.length;
            for (int i2 = offset + 1; i2 < len; ++i2) {
                sb.append(sep).append(a2[i2]);
            }
        }
        sb.append(end);
        return sb.toString();
    }

    public static <T> String concat(T[] a2, int offset, String sep) {
        return TextHelper.concat(a2, offset, sep, "", "");
    }

    public static <T> String concat(Collection<T> a2, int offset, String sep, String start2, String end) {
        StringBuilder sb = new StringBuilder();
        sb.append(start2);
        Iterator<T> it = a2.iterator();
        while (offset > 0 && it.hasNext()) {
            --offset;
            it.next();
        }
        if (offset == 0 && it.hasNext()) {
            sb.append(it.next());
            while (it.hasNext()) {
                sb.append(sep).append(it.next());
            }
        }
        sb.append(end);
        return sb.toString();
    }

    public static <T> String concat(Collection<T> a2, int offset, String sep) {
        return TextHelper.concat(a2, offset, sep, "", "");
    }

    public static String wrap(TextWidthCounter textWidthCounter, String s2, int width2, int initialOffset, String initialIndent, String subsequentIndent) {
        BreakIterator iter = BreakIterator.getLineInstance();
        iter.setText(s2);
        StringBuilder res = new StringBuilder(initialIndent);
        StringBuilder sb = new StringBuilder();
        int currentWidth = initialOffset + initialIndent.length();
        int start2 = iter.first();
        int end = iter.next();
        while (end != -1) {
            String sub2 = s2.substring(start2, end);
            int subWidth = textWidthCounter.width(sub2);
            if ((currentWidth += subWidth) > width2) {
                res.append((CharSequence)TextHelper.adjustSpace(sb, width2, currentWidth - subWidth)).append(LINESEP).append(subsequentIndent);
                sb.delete(0, sb.length());
                currentWidth = subsequentIndent.length() + subWidth;
            }
            sb.append(sub2);
            if (sub2.endsWith(LINESEP) || sub2.endsWith("\n")) {
                res.append((CharSequence)sb).append(subsequentIndent);
                sb.delete(0, sb.length());
                currentWidth = subsequentIndent.length();
            }
            start2 = end;
            end = iter.next();
        }
        res.append((CharSequence)sb);
        return res.toString();
    }

    public static StringBuilder adjustSpace(StringBuilder sb, int width2, int curWidth) {
        int i2;
        int len;
        int origLen = len = sb.length();
        for (i2 = 0; i2 < len && sb.charAt(i2) == ' '; ++i2) {
        }
        sb.delete(0, i2);
        len = sb.length();
        for (i2 = len - 1; i2 >= 0 && sb.charAt(i2) == ' '; --i2) {
        }
        sb.delete(i2 + 1, len);
        len = sb.length();
        curWidth -= origLen - len;
        int numWsBlock = 0;
        boolean cont = false;
        for (i2 = 0; i2 < len; ++i2) {
            if (sb.charAt(i2) == ' ') {
                if (cont) continue;
                cont = true;
                ++numWsBlock;
                continue;
            }
            cont = false;
        }
        if (numWsBlock == 0) {
            return sb;
        }
        int needWs = width2 - curWidth;
        int eachWs = needWs / numWsBlock;
        int rem = needWs % numWsBlock;
        int remStart = (numWsBlock - rem + 1) / 2;
        int remEnd = remStart + rem;
        cont = false;
        int b2 = 0;
        for (i2 = 0; i2 < len; ++i2) {
            if (sb.charAt(i2) == ' ') {
                if (cont) continue;
                cont = true;
                int add2 = eachWs + (remStart <= b2 && b2 < remEnd ? 1 : 0);
                for (int j = 0; j < add2; ++j) {
                    sb.insert(i2, ' ');
                }
                len = sb.length();
                ++b2;
                continue;
            }
            cont = false;
        }
        return sb;
    }

    public static void printHelp(PrintWriter writer2, String title2, String help, TextWidthCounter textWidthCounter, int width2) {
        int INDENT_WIDTH = 25;
        writer2.print("  ");
        writer2.print(title2);
        if (!help.isEmpty()) {
            int titleWidth = textWidthCounter.width(title2);
            int indentWidth = INDENT_WIDTH;
            if (titleWidth <= 21) {
                indentWidth -= titleWidth + 2;
            } else {
                writer2.println();
            }
            for (int i2 = 0; i2 < indentWidth; ++i2) {
                writer2.print(" ");
            }
            writer2.println(TextHelper.wrap(textWidthCounter, help, width2, INDENT_WIDTH, "", "                         "));
        } else {
            writer2.println();
        }
    }

    public static String nonNull(String str2) {
        if (str2 == null) {
            return "";
        }
        return str2;
    }

    public static List<String> findPrefix(Collection<String> src, String prefix) {
        ArrayList<String> res = new ArrayList<String>();
        for (String s2 : src) {
            if (!s2.startsWith(prefix)) continue;
            res.add(s2);
        }
        return res;
    }
}

