/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.utils;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class SetView<E>
implements Set<E> {
    private final List<Set<E>> sets = new ArrayList<Set<E>>();

    public SetView<E> union(Set<E> set2) {
        if (set2 != null && !set2.isEmpty()) {
            this.sets.add(set2);
        }
        return this;
    }

    @Override
    public int size() {
        int size2 = 0;
        for (Set<E> set2 : this.sets) {
            size2 += set2.size();
        }
        return size2;
    }

    @Override
    public boolean isEmpty() {
        return this.sets.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        for (Set<E> set2 : this.sets) {
            if (!set2.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new SetViewIterator(this);
    }

    @Override
    public Object[] toArray() {
        int size2 = this.size();
        Object[] result2 = new Object[size2];
        Iterator<E> iterator2 = this.iterator();
        for (int x2 = 0; x2 < size2; ++x2) {
            result2[x2] = iterator2.hasNext() ? iterator2.next() : null;
        }
        return result2;
    }

    @Override
    public <T> T[] toArray(T[] a2) {
        int size2 = this.size();
        T[] result2 = size2 <= a2.length ? a2 : (Object[])Array.newInstance(a2.getClass().getComponentType(), size2);
        Iterator<E> iterator2 = this.iterator();
        for (int x2 = 0; x2 < size2; ++x2) {
            result2[x2] = iterator2.hasNext() ? iterator2.next() : null;
        }
        return result2;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.sets);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Set)) {
            return false;
        }
        Collection collection = (Collection)obj;
        if (collection.size() != this.size()) {
            return false;
        }
        try {
            return this.containsAll(collection);
        }
        catch (ClassCastException ignore) {
            return false;
        }
        catch (NullPointerException ignore) {
            return false;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        Iterator<E> iterator2 = this.iterator();
        if (iterator2.hasNext()) {
            builder.append(iterator2.next().toString());
        }
        while (iterator2.hasNext()) {
            builder.append(", ");
            builder.append(iterator2.next().toString());
        }
        builder.append(']');
        return builder.toString();
    }

    public static class SetViewIterator<E>
    implements Iterator<E> {
        private Iterator<Set<E>> sets = null;
        private Iterator<E> current = null;

        public SetViewIterator(SetView<E> view) {
            this.sets = ((SetView)view).sets.iterator();
            if (this.sets.hasNext()) {
                this.current = this.sets.next().iterator();
            }
        }

        @Override
        public boolean hasNext() {
            if (this.current.hasNext()) {
                return true;
            }
            while (this.sets.hasNext()) {
                this.current = this.sets.next().iterator();
                if (!this.current.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public E next() {
            return this.current.next();
        }
    }
}

