/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.RolloverFailure;
import java.io.File;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;

public class FileStoreUtil {
    static final String PATH_CLASS_STR = "java.nio.file.Path";
    static final String FILES_CLASS_STR = "java.nio.file.Files";

    public static boolean areOnSameFileStore(File a2, File b2) throws RolloverFailure {
        if (!a2.exists()) {
            throw new IllegalArgumentException("File [" + String.valueOf(a2) + "] does not exist.");
        }
        if (!b2.exists()) {
            throw new IllegalArgumentException("File [" + String.valueOf(b2) + "] does not exist.");
        }
        try {
            Path pathA = a2.toPath();
            Path pathB = b2.toPath();
            FileStore fileStoreA = Files.getFileStore(pathA);
            FileStore fileStoreB = Files.getFileStore(pathB);
            return fileStoreA.equals(fileStoreB);
        }
        catch (Exception e) {
            throw new RolloverFailure("Failed to check file store equality for [" + String.valueOf(a2) + "] and [" + String.valueOf(b2) + "]", e);
        }
    }
}

