/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.argparse4j.impl.type;

import net.sourceforge.argparse4j.helper.MessageLocalization;
import net.sourceforge.argparse4j.helper.TextHelper;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.MetavarInference;

public class BooleanArgumentType
implements ArgumentType<Boolean>,
MetavarInference {
    private final String trueValue_;
    private final String falseValue_;

    public BooleanArgumentType() {
        this("true", "false");
    }

    public BooleanArgumentType(String trueValue, String falseValue) {
        this.trueValue_ = trueValue;
        this.falseValue_ = falseValue;
    }

    @Override
    public Boolean convert(ArgumentParser parser, Argument arg, String value) throws ArgumentParserException {
        if (this.trueValue_.equals(value)) {
            return Boolean.TRUE;
        }
        if (this.falseValue_.equals(value)) {
            return Boolean.FALSE;
        }
        throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, MessageLocalization.localize(parser.getConfig().getResourceBundle(), "couldNotConvertChooseFromError"), value, this.inferMetavar()[0]), parser, arg);
    }

    @Override
    public String[] inferMetavar() {
        return new String[]{TextHelper.concat(new String[]{this.trueValue_, this.falseValue_}, 0, ",", "{", "}")};
    }
}

