/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import java.util.Objects;

public class AbsoluteIri {
    private final String value;

    public AbsoluteIri(String value) {
        this.value = value;
    }

    public static AbsoluteIri of(String iri) {
        return new AbsoluteIri(iri);
    }

    public AbsoluteIri resolve(String iri) {
        return new AbsoluteIri(AbsoluteIri.resolve(this.value, iri));
    }

    public String getScheme() {
        return AbsoluteIri.getScheme(this.value);
    }

    protected String getSchemeAuthority() {
        return AbsoluteIri.getSchemeAuthority(this.value);
    }

    private static boolean isAbsoluteIri(String iri) {
        int length = iri.length();
        for (int x2 = 0; x2 < length; ++x2) {
            char ch = iri.charAt(x2);
            if (ch == ':') {
                return true;
            }
            if (ch != '/' && ch != '?' && ch != '#') continue;
            return false;
        }
        return false;
    }

    public static String resolve(String parent, String iri) {
        if (AbsoluteIri.isAbsoluteIri(iri)) {
            return iri;
        }
        if (parent == null) {
            return iri;
        }
        if (iri.startsWith("/")) {
            return AbsoluteIri.getSchemeAuthority(parent) + iri;
        }
        String base2 = parent;
        int scheme = parent.indexOf("://");
        if (scheme == -1) {
            scheme = parent.indexOf(58);
            if (scheme == -1) {
                scheme = 0;
            }
        } else {
            scheme += 3;
        }
        base2 = AbsoluteIri.parent(base2, scheme);
        String[] iriParts = iri.split("/");
        for (int x2 = 0; x2 < iriParts.length; ++x2) {
            if ("..".equals(iriParts[x2])) {
                base2 = AbsoluteIri.parent(base2, scheme);
                continue;
            }
            if (".".equals(iriParts[x2])) continue;
            if (base2.endsWith(":")) {
                if (parent.length() > base2.length() && parent.charAt(base2.length()) == '/') {
                    base2 = base2 + "/" + iriParts[x2];
                    continue;
                }
                base2 = base2 + iriParts[x2];
                continue;
            }
            base2 = base2 + "/" + iriParts[x2];
        }
        if (iri.endsWith("/")) {
            base2 = base2 + "/";
        }
        return base2;
    }

    protected static String parent(String iri, int scheme) {
        int slash = iri.lastIndexOf(47);
        if (slash == -1 && (slash = iri.lastIndexOf(58)) != -1) {
            ++slash;
        }
        if (slash != -1 && slash > scheme) {
            return iri.substring(0, slash);
        }
        return iri;
    }

    protected static String getSchemeAuthority(String iri) {
        if (iri == null) {
            return "";
        }
        int start2 = iri.indexOf("://");
        start2 = start2 == -1 ? 0 : (start2 += 3);
        int end = iri.indexOf(47, start2);
        return end != -1 ? iri.substring(0, end) : iri;
    }

    public static String getScheme(String iri) {
        if (iri == null) {
            return "";
        }
        int start2 = iri.indexOf(58);
        if (start2 == -1) {
            return "";
        }
        return iri.substring(0, start2);
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbsoluteIri other = (AbsoluteIri)obj;
        return Objects.equals(this.value, other.value);
    }
}

