package world.respect.datalayer.db.opds.daos

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import com.eygraber.uri.Uri
import javax.`annotation`.processing.Generated
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass
import kotlinx.datetime.LocalDateTime
import world.respect.datalayer.db.opds.OpdsTypeConverters
import world.respect.datalayer.db.opds.entities.OpdsFeedMetadataEntity
import world.respect.datalayer.db.shared.SharedConverters

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class OpdsFeedMetadataEntityDao_Impl(
  __db: RoomDatabase,
) : OpdsFeedMetadataEntityDao() {
  private val __db: RoomDatabase

  private val __insertAdapterOfOpdsFeedMetadataEntity: EntityInsertAdapter<OpdsFeedMetadataEntity>

  private val __opdsTypeConverters: OpdsTypeConverters = OpdsTypeConverters()

  private val __sharedConverters: SharedConverters = SharedConverters()
  init {
    this.__db = __db
    this.__insertAdapterOfOpdsFeedMetadataEntity = object : EntityInsertAdapter<OpdsFeedMetadataEntity>() {
      protected override fun createQuery(): String = "INSERT OR ABORT INTO `OpdsFeedMetadataEntity` (`ofmeUid`,`ofmeOfeUid`,`ofmePropType`,`ofmePropFk`,`ofmeIdentifier`,`ofmeType`,`ofmeTitle`,`ofmeSubtitle`,`ofmeModified`,`ofmeDescription`,`ofmeItemsPerPage`,`ofmeCurrentPage`,`ofmeNumberOfItems`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: OpdsFeedMetadataEntity) {
        statement.bindLong(1, entity.ofmeUid)
        statement.bindLong(2, entity.ofmeOfeUid)
        val _tmp: Int = __opdsTypeConverters.fromOpdsFeedMetadataPropType(entity.ofmePropType)
        statement.bindLong(3, _tmp.toLong())
        statement.bindLong(4, entity.ofmePropFk)
        val _tmpOfmeIdentifier: Uri? = entity.ofmeIdentifier
        val _tmp_1: String? = __sharedConverters.fromUri(_tmpOfmeIdentifier)
        if (_tmp_1 == null) {
          statement.bindNull(5)
        } else {
          statement.bindText(5, _tmp_1)
        }
        val _tmpOfmeType: String? = entity.ofmeType
        if (_tmpOfmeType == null) {
          statement.bindNull(6)
        } else {
          statement.bindText(6, _tmpOfmeType)
        }
        statement.bindText(7, entity.ofmeTitle)
        val _tmpOfmeSubtitle: String? = entity.ofmeSubtitle
        if (_tmpOfmeSubtitle == null) {
          statement.bindNull(8)
        } else {
          statement.bindText(8, _tmpOfmeSubtitle)
        }
        val _tmpOfmeModified: LocalDateTime? = entity.ofmeModified
        val _tmp_2: String? = __sharedConverters.fromLocalDateTime(_tmpOfmeModified)
        if (_tmp_2 == null) {
          statement.bindNull(9)
        } else {
          statement.bindText(9, _tmp_2)
        }
        val _tmpOfmeDescription: String? = entity.ofmeDescription
        if (_tmpOfmeDescription == null) {
          statement.bindNull(10)
        } else {
          statement.bindText(10, _tmpOfmeDescription)
        }
        val _tmpOfmeItemsPerPage: Int? = entity.ofmeItemsPerPage
        if (_tmpOfmeItemsPerPage == null) {
          statement.bindNull(11)
        } else {
          statement.bindLong(11, _tmpOfmeItemsPerPage.toLong())
        }
        val _tmpOfmeCurrentPage: Int? = entity.ofmeCurrentPage
        if (_tmpOfmeCurrentPage == null) {
          statement.bindNull(12)
        } else {
          statement.bindLong(12, _tmpOfmeCurrentPage.toLong())
        }
        val _tmpOfmeNumberOfItems: Int? = entity.ofmeNumberOfItems
        if (_tmpOfmeNumberOfItems == null) {
          statement.bindNull(13)
        } else {
          statement.bindLong(13, _tmpOfmeNumberOfItems.toLong())
        }
      }
    }
  }

  public override suspend fun insertList(entities: List<OpdsFeedMetadataEntity>): Unit = performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfOpdsFeedMetadataEntity.insert(_connection, entities)
  }

  public override suspend fun findByFeedUid(feedUid: Long): List<OpdsFeedMetadataEntity> {
    val _sql: String = """
        |
        |        SELECT OpdsFeedMetadataEntity.*
        |          FROM OpdsFeedMetadataEntity
        |         WHERE ofmeOfeUid = ? 
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, feedUid)
        val _columnIndexOfOfmeUid: Int = getColumnIndexOrThrow(_stmt, "ofmeUid")
        val _columnIndexOfOfmeOfeUid: Int = getColumnIndexOrThrow(_stmt, "ofmeOfeUid")
        val _columnIndexOfOfmePropType: Int = getColumnIndexOrThrow(_stmt, "ofmePropType")
        val _columnIndexOfOfmePropFk: Int = getColumnIndexOrThrow(_stmt, "ofmePropFk")
        val _columnIndexOfOfmeIdentifier: Int = getColumnIndexOrThrow(_stmt, "ofmeIdentifier")
        val _columnIndexOfOfmeType: Int = getColumnIndexOrThrow(_stmt, "ofmeType")
        val _columnIndexOfOfmeTitle: Int = getColumnIndexOrThrow(_stmt, "ofmeTitle")
        val _columnIndexOfOfmeSubtitle: Int = getColumnIndexOrThrow(_stmt, "ofmeSubtitle")
        val _columnIndexOfOfmeModified: Int = getColumnIndexOrThrow(_stmt, "ofmeModified")
        val _columnIndexOfOfmeDescription: Int = getColumnIndexOrThrow(_stmt, "ofmeDescription")
        val _columnIndexOfOfmeItemsPerPage: Int = getColumnIndexOrThrow(_stmt, "ofmeItemsPerPage")
        val _columnIndexOfOfmeCurrentPage: Int = getColumnIndexOrThrow(_stmt, "ofmeCurrentPage")
        val _columnIndexOfOfmeNumberOfItems: Int = getColumnIndexOrThrow(_stmt, "ofmeNumberOfItems")
        val _result: MutableList<OpdsFeedMetadataEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: OpdsFeedMetadataEntity
          val _tmpOfmeUid: Long
          _tmpOfmeUid = _stmt.getLong(_columnIndexOfOfmeUid)
          val _tmpOfmeOfeUid: Long
          _tmpOfmeOfeUid = _stmt.getLong(_columnIndexOfOfmeOfeUid)
          val _tmpOfmePropType: OpdsFeedMetadataEntity.PropType
          val _tmp: Int
          _tmp = _stmt.getLong(_columnIndexOfOfmePropType).toInt()
          _tmpOfmePropType = __opdsTypeConverters.toOpdsFeedMetadataPropType(_tmp)
          val _tmpOfmePropFk: Long
          _tmpOfmePropFk = _stmt.getLong(_columnIndexOfOfmePropFk)
          val _tmpOfmeIdentifier: Uri?
          val _tmp_1: String?
          if (_stmt.isNull(_columnIndexOfOfmeIdentifier)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getText(_columnIndexOfOfmeIdentifier)
          }
          _tmpOfmeIdentifier = __sharedConverters.toUri(_tmp_1)
          val _tmpOfmeType: String?
          if (_stmt.isNull(_columnIndexOfOfmeType)) {
            _tmpOfmeType = null
          } else {
            _tmpOfmeType = _stmt.getText(_columnIndexOfOfmeType)
          }
          val _tmpOfmeTitle: String
          _tmpOfmeTitle = _stmt.getText(_columnIndexOfOfmeTitle)
          val _tmpOfmeSubtitle: String?
          if (_stmt.isNull(_columnIndexOfOfmeSubtitle)) {
            _tmpOfmeSubtitle = null
          } else {
            _tmpOfmeSubtitle = _stmt.getText(_columnIndexOfOfmeSubtitle)
          }
          val _tmpOfmeModified: LocalDateTime?
          val _tmp_2: String?
          if (_stmt.isNull(_columnIndexOfOfmeModified)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getText(_columnIndexOfOfmeModified)
          }
          _tmpOfmeModified = __sharedConverters.toLocalDateTime(_tmp_2)
          val _tmpOfmeDescription: String?
          if (_stmt.isNull(_columnIndexOfOfmeDescription)) {
            _tmpOfmeDescription = null
          } else {
            _tmpOfmeDescription = _stmt.getText(_columnIndexOfOfmeDescription)
          }
          val _tmpOfmeItemsPerPage: Int?
          if (_stmt.isNull(_columnIndexOfOfmeItemsPerPage)) {
            _tmpOfmeItemsPerPage = null
          } else {
            _tmpOfmeItemsPerPage = _stmt.getLong(_columnIndexOfOfmeItemsPerPage).toInt()
          }
          val _tmpOfmeCurrentPage: Int?
          if (_stmt.isNull(_columnIndexOfOfmeCurrentPage)) {
            _tmpOfmeCurrentPage = null
          } else {
            _tmpOfmeCurrentPage = _stmt.getLong(_columnIndexOfOfmeCurrentPage).toInt()
          }
          val _tmpOfmeNumberOfItems: Int?
          if (_stmt.isNull(_columnIndexOfOfmeNumberOfItems)) {
            _tmpOfmeNumberOfItems = null
          } else {
            _tmpOfmeNumberOfItems = _stmt.getLong(_columnIndexOfOfmeNumberOfItems).toInt()
          }
          _item = OpdsFeedMetadataEntity(_tmpOfmeUid,_tmpOfmeOfeUid,_tmpOfmePropType,_tmpOfmePropFk,_tmpOfmeIdentifier,_tmpOfmeType,_tmpOfmeTitle,_tmpOfmeSubtitle,_tmpOfmeModified,_tmpOfmeDescription,_tmpOfmeItemsPerPage,_tmpOfmeCurrentPage,_tmpOfmeNumberOfItems)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteByFeedUid(feedUid: Long) {
    val _sql: String = """
        |
        |        DELETE FROM OpdsFeedMetadataEntity 
        |         WHERE ofmeOfeUid = ?
        |    
        """.trimMargin()
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, feedUid)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
