/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.webauthn4j.data.AttachmentHint;
import com.webauthn4j.data.AuthenticatorAttestationType;
import java.io.IOException;

public class AuthenticatorAttestationTypeFromIntDeserializer
extends StdDeserializer<AuthenticatorAttestationType> {
    public AuthenticatorAttestationTypeFromIntDeserializer() {
        super(AuthenticatorAttestationType.class);
    }

    @Override
    public AuthenticatorAttestationType deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        int value = p2.getValueAsInt();
        try {
            return AuthenticatorAttestationType.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, AttachmentHint.class);
        }
    }
}

