package world.respect.datalayer.db.school.daos

import androidx.collection.LongSparseArray
import androidx.paging.PagingSource
import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.RoomRawQuery
import androidx.room.coroutines.createFlow
import androidx.room.paging.LimitOffsetPagingSource
import androidx.room.util.appendPlaceholders
import androidx.room.util.getColumnIndex
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.room.util.recursiveFetchLongSparseArray
import androidx.sqlite.SQLiteConnection
import androidx.sqlite.SQLiteStatement
import io.ktor.http.Url
import javax.`annotation`.processing.Generated
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass
import kotlin.text.StringBuilder
import kotlin.time.Instant
import kotlinx.coroutines.flow.Flow
import world.respect.datalayer.db.school.SchoolTypeConverters
import world.respect.datalayer.db.school.adapters.AssignmentEntities
import world.respect.datalayer.db.school.entities.AssignmentAssigneeRefEntity
import world.respect.datalayer.db.school.entities.AssignmentEntity
import world.respect.datalayer.db.school.entities.AssignmentLearningResourceRefEntity
import world.respect.datalayer.db.shared.SharedConverters
import world.respect.datalayer.school.model.AssignmentAssigneeRefTypeEnum

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class AssignmentEntityDao_Impl(
  __db: RoomDatabase,
) : AssignmentEntityDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfAssignmentEntity: EntityInsertAdapter<AssignmentEntity>

  private val __sharedConverters: SharedConverters = SharedConverters()

  private val __schoolTypeConverters: SchoolTypeConverters = SchoolTypeConverters()
  init {
    this.__db = __db
    this.__insertAdapterOfAssignmentEntity = object : EntityInsertAdapter<AssignmentEntity>() {
      protected override fun createQuery(): String = "INSERT OR REPLACE INTO `AssignmentEntity` (`aeUid`,`aeUidNum`,`aeTitle`,`aeDescription`,`aeDeadline`,`aeLastModified`,`aeStored`) VALUES (?,?,?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: AssignmentEntity) {
        statement.bindText(1, entity.aeUid)
        statement.bindLong(2, entity.aeUidNum)
        statement.bindText(3, entity.aeTitle)
        statement.bindText(4, entity.aeDescription)
        val _tmpAeDeadline: Instant? = entity.aeDeadline
        val _tmp: Long? = __sharedConverters.fromInstant(_tmpAeDeadline)
        if (_tmp == null) {
          statement.bindNull(5)
        } else {
          statement.bindLong(5, _tmp)
        }
        val _tmp_1: Long? = __sharedConverters.fromInstant(entity.aeLastModified)
        if (_tmp_1 == null) {
          statement.bindNull(6)
        } else {
          statement.bindLong(6, _tmp_1)
        }
        val _tmp_2: Long? = __sharedConverters.fromInstant(entity.aeStored)
        if (_tmp_2 == null) {
          statement.bindNull(7)
        } else {
          statement.bindLong(7, _tmp_2)
        }
      }
    }
  }

  public override suspend fun upsert(entities: List<AssignmentEntity>): Unit = performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfAssignmentEntity.insert(_connection, entities)
  }

  public override suspend fun list(uidNum: Long): List<AssignmentEntities> {
    val _sql: String = """
        |
        |        SELECT AssignmentEntity.*
        |          FROM AssignmentEntity
        |         WHERE (? = 0 OR AssignmentEntity.aeUidNum = ?)
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, uidNum)
        _argIndex = 2
        _stmt.bindLong(_argIndex, uidNum)
        val _columnIndexOfAeUid: Int = getColumnIndexOrThrow(_stmt, "aeUid")
        val _columnIndexOfAeUidNum: Int = getColumnIndexOrThrow(_stmt, "aeUidNum")
        val _columnIndexOfAeTitle: Int = getColumnIndexOrThrow(_stmt, "aeTitle")
        val _columnIndexOfAeDescription: Int = getColumnIndexOrThrow(_stmt, "aeDescription")
        val _columnIndexOfAeDeadline: Int = getColumnIndexOrThrow(_stmt, "aeDeadline")
        val _columnIndexOfAeLastModified: Int = getColumnIndexOrThrow(_stmt, "aeLastModified")
        val _columnIndexOfAeStored: Int = getColumnIndexOrThrow(_stmt, "aeStored")
        val _collectionAssignees: LongSparseArray<MutableList<AssignmentAssigneeRefEntity>> = LongSparseArray<MutableList<AssignmentAssigneeRefEntity>>()
        val _collectionLearningUnits: LongSparseArray<MutableList<AssignmentLearningResourceRefEntity>> = LongSparseArray<MutableList<AssignmentLearningResourceRefEntity>>()
        while (_stmt.step()) {
          val _tmpKey: Long
          _tmpKey = _stmt.getLong(_columnIndexOfAeUidNum)
          if (!_collectionAssignees.containsKey(_tmpKey)) {
            _collectionAssignees.put(_tmpKey, mutableListOf())
          }
          val _tmpKey_1: Long
          _tmpKey_1 = _stmt.getLong(_columnIndexOfAeUidNum)
          if (!_collectionLearningUnits.containsKey(_tmpKey_1)) {
            _collectionLearningUnits.put(_tmpKey_1, mutableListOf())
          }
        }
        _stmt.reset()
        __fetchRelationshipAssignmentAssigneeRefEntityAsworldRespectDatalayerDbSchoolEntitiesAssignmentAssigneeRefEntity(_connection, _collectionAssignees)
        __fetchRelationshipAssignmentLearningResourceRefEntityAsworldRespectDatalayerDbSchoolEntitiesAssignmentLearningResourceRefEntity(_connection, _collectionLearningUnits)
        val _result: MutableList<AssignmentEntities> = mutableListOf()
        while (_stmt.step()) {
          val _item: AssignmentEntities
          val _tmpAssignment: AssignmentEntity
          val _tmpAeUid: String
          _tmpAeUid = _stmt.getText(_columnIndexOfAeUid)
          val _tmpAeUidNum: Long
          _tmpAeUidNum = _stmt.getLong(_columnIndexOfAeUidNum)
          val _tmpAeTitle: String
          _tmpAeTitle = _stmt.getText(_columnIndexOfAeTitle)
          val _tmpAeDescription: String
          _tmpAeDescription = _stmt.getText(_columnIndexOfAeDescription)
          val _tmpAeDeadline: Instant?
          val _tmp: Long?
          if (_stmt.isNull(_columnIndexOfAeDeadline)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfAeDeadline)
          }
          _tmpAeDeadline = __sharedConverters.toInstant(_tmp)
          val _tmpAeLastModified: Instant
          val _tmp_1: Long?
          if (_stmt.isNull(_columnIndexOfAeLastModified)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getLong(_columnIndexOfAeLastModified)
          }
          val _tmp_2: Instant? = __sharedConverters.toInstant(_tmp_1)
          if (_tmp_2 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpAeLastModified = _tmp_2
          }
          val _tmpAeStored: Instant
          val _tmp_3: Long?
          if (_stmt.isNull(_columnIndexOfAeStored)) {
            _tmp_3 = null
          } else {
            _tmp_3 = _stmt.getLong(_columnIndexOfAeStored)
          }
          val _tmp_4: Instant? = __sharedConverters.toInstant(_tmp_3)
          if (_tmp_4 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpAeStored = _tmp_4
          }
          _tmpAssignment = AssignmentEntity(_tmpAeUid,_tmpAeUidNum,_tmpAeTitle,_tmpAeDescription,_tmpAeDeadline,_tmpAeLastModified,_tmpAeStored)
          val _tmpAssigneesCollection: MutableList<AssignmentAssigneeRefEntity>
          val _tmpKey_2: Long
          _tmpKey_2 = _stmt.getLong(_columnIndexOfAeUidNum)
          _tmpAssigneesCollection = checkNotNull(_collectionAssignees.get(_tmpKey_2))
          val _tmpLearningUnitsCollection: MutableList<AssignmentLearningResourceRefEntity>
          val _tmpKey_3: Long
          _tmpKey_3 = _stmt.getLong(_columnIndexOfAeUidNum)
          _tmpLearningUnitsCollection = checkNotNull(_collectionLearningUnits.get(_tmpKey_3))
          _item = AssignmentEntities(_tmpAssignment,_tmpAssigneesCollection,_tmpLearningUnitsCollection)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun listAsPagingSource(uidNum: Long): PagingSource<Int, AssignmentEntities> {
    val _sql: String = """
        |
        |        SELECT AssignmentEntity.*
        |          FROM AssignmentEntity
        |         WHERE (? = 0 OR AssignmentEntity.aeUidNum = ?)
        |    
        """.trimMargin()
    val _rawQuery: RoomRawQuery = RoomRawQuery(_sql) { _stmt ->
      var _argIndex: Int = 1
      _stmt.bindLong(_argIndex, uidNum)
      _argIndex = 2
      _stmt.bindLong(_argIndex, uidNum)
    }
    return object : LimitOffsetPagingSource<AssignmentEntities>(_rawQuery, __db, "AssignmentAssigneeRefEntity", "AssignmentLearningResourceRefEntity", "AssignmentEntity") {
      protected override suspend fun convertRows(limitOffsetQuery: RoomRawQuery, itemCount: Int): List<AssignmentEntities> = performSuspending(__db, true, false) { _connection ->
        val _stmt: SQLiteStatement = _connection.prepare(limitOffsetQuery.sql)
        limitOffsetQuery.getBindingFunction().invoke(_stmt)
        try {
          val _columnIndexOfAeUid: Int = getColumnIndexOrThrow(_stmt, "aeUid")
          val _columnIndexOfAeUidNum: Int = getColumnIndexOrThrow(_stmt, "aeUidNum")
          val _columnIndexOfAeTitle: Int = getColumnIndexOrThrow(_stmt, "aeTitle")
          val _columnIndexOfAeDescription: Int = getColumnIndexOrThrow(_stmt, "aeDescription")
          val _columnIndexOfAeDeadline: Int = getColumnIndexOrThrow(_stmt, "aeDeadline")
          val _columnIndexOfAeLastModified: Int = getColumnIndexOrThrow(_stmt, "aeLastModified")
          val _columnIndexOfAeStored: Int = getColumnIndexOrThrow(_stmt, "aeStored")
          val _collectionAssignees: LongSparseArray<MutableList<AssignmentAssigneeRefEntity>> = LongSparseArray<MutableList<AssignmentAssigneeRefEntity>>()
          val _collectionLearningUnits: LongSparseArray<MutableList<AssignmentLearningResourceRefEntity>> = LongSparseArray<MutableList<AssignmentLearningResourceRefEntity>>()
          while (_stmt.step()) {
            val _tmpKey: Long
            _tmpKey = _stmt.getLong(_columnIndexOfAeUidNum)
            if (!_collectionAssignees.containsKey(_tmpKey)) {
              _collectionAssignees.put(_tmpKey, mutableListOf())
            }
            val _tmpKey_1: Long
            _tmpKey_1 = _stmt.getLong(_columnIndexOfAeUidNum)
            if (!_collectionLearningUnits.containsKey(_tmpKey_1)) {
              _collectionLearningUnits.put(_tmpKey_1, mutableListOf())
            }
          }
          _stmt.reset()
          __fetchRelationshipAssignmentAssigneeRefEntityAsworldRespectDatalayerDbSchoolEntitiesAssignmentAssigneeRefEntity(_connection, _collectionAssignees)
          __fetchRelationshipAssignmentLearningResourceRefEntityAsworldRespectDatalayerDbSchoolEntitiesAssignmentLearningResourceRefEntity(_connection, _collectionLearningUnits)
          val _result: MutableList<AssignmentEntities> = mutableListOf()
          while (_stmt.step()) {
            val _item: AssignmentEntities
            val _tmpAssignment: AssignmentEntity
            val _tmpAeUid: String
            _tmpAeUid = _stmt.getText(_columnIndexOfAeUid)
            val _tmpAeUidNum: Long
            _tmpAeUidNum = _stmt.getLong(_columnIndexOfAeUidNum)
            val _tmpAeTitle: String
            _tmpAeTitle = _stmt.getText(_columnIndexOfAeTitle)
            val _tmpAeDescription: String
            _tmpAeDescription = _stmt.getText(_columnIndexOfAeDescription)
            val _tmpAeDeadline: Instant?
            val _tmp: Long?
            if (_stmt.isNull(_columnIndexOfAeDeadline)) {
              _tmp = null
            } else {
              _tmp = _stmt.getLong(_columnIndexOfAeDeadline)
            }
            _tmpAeDeadline = __sharedConverters.toInstant(_tmp)
            val _tmpAeLastModified: Instant
            val _tmp_1: Long?
            if (_stmt.isNull(_columnIndexOfAeLastModified)) {
              _tmp_1 = null
            } else {
              _tmp_1 = _stmt.getLong(_columnIndexOfAeLastModified)
            }
            val _tmp_2: Instant? = __sharedConverters.toInstant(_tmp_1)
            if (_tmp_2 == null) {
              error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
            } else {
              _tmpAeLastModified = _tmp_2
            }
            val _tmpAeStored: Instant
            val _tmp_3: Long?
            if (_stmt.isNull(_columnIndexOfAeStored)) {
              _tmp_3 = null
            } else {
              _tmp_3 = _stmt.getLong(_columnIndexOfAeStored)
            }
            val _tmp_4: Instant? = __sharedConverters.toInstant(_tmp_3)
            if (_tmp_4 == null) {
              error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
            } else {
              _tmpAeStored = _tmp_4
            }
            _tmpAssignment = AssignmentEntity(_tmpAeUid,_tmpAeUidNum,_tmpAeTitle,_tmpAeDescription,_tmpAeDeadline,_tmpAeLastModified,_tmpAeStored)
            val _tmpAssigneesCollection: MutableList<AssignmentAssigneeRefEntity>
            val _tmpKey_2: Long
            _tmpKey_2 = _stmt.getLong(_columnIndexOfAeUidNum)
            _tmpAssigneesCollection = checkNotNull(_collectionAssignees.get(_tmpKey_2))
            val _tmpLearningUnitsCollection: MutableList<AssignmentLearningResourceRefEntity>
            val _tmpKey_3: Long
            _tmpKey_3 = _stmt.getLong(_columnIndexOfAeUidNum)
            _tmpLearningUnitsCollection = checkNotNull(_collectionLearningUnits.get(_tmpKey_3))
            _item = AssignmentEntities(_tmpAssignment,_tmpAssigneesCollection,_tmpLearningUnitsCollection)
            _result.add(_item)
          }
          _result
        } finally {
          _stmt.close()
        }
      }
    }
  }

  public override suspend fun getLastModifiedByUidNum(uidNum: Long): Long? {
    val _sql: String = """
        |
        |        SELECT AssignmentEntity.aeLastModified
        |          FROM AssignmentEntity
        |         WHERE AssignmentEntity.aeUidNum = ?
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, uidNum)
        val _result: Long?
        if (_stmt.step()) {
          if (_stmt.isNull(0)) {
            _result = null
          } else {
            _result = _stmt.getLong(0)
          }
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findByUidNum(uidNum: Long): AssignmentEntities? {
    val _sql: String = """
        |
        |        SELECT AssignmentEntity.*
        |          FROM AssignmentEntity
        |         WHERE AssignmentEntity.aeUidNum = ?
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, uidNum)
        val _columnIndexOfAeUid: Int = getColumnIndexOrThrow(_stmt, "aeUid")
        val _columnIndexOfAeUidNum: Int = getColumnIndexOrThrow(_stmt, "aeUidNum")
        val _columnIndexOfAeTitle: Int = getColumnIndexOrThrow(_stmt, "aeTitle")
        val _columnIndexOfAeDescription: Int = getColumnIndexOrThrow(_stmt, "aeDescription")
        val _columnIndexOfAeDeadline: Int = getColumnIndexOrThrow(_stmt, "aeDeadline")
        val _columnIndexOfAeLastModified: Int = getColumnIndexOrThrow(_stmt, "aeLastModified")
        val _columnIndexOfAeStored: Int = getColumnIndexOrThrow(_stmt, "aeStored")
        val _collectionAssignees: LongSparseArray<MutableList<AssignmentAssigneeRefEntity>> = LongSparseArray<MutableList<AssignmentAssigneeRefEntity>>()
        val _collectionLearningUnits: LongSparseArray<MutableList<AssignmentLearningResourceRefEntity>> = LongSparseArray<MutableList<AssignmentLearningResourceRefEntity>>()
        while (_stmt.step()) {
          val _tmpKey: Long
          _tmpKey = _stmt.getLong(_columnIndexOfAeUidNum)
          if (!_collectionAssignees.containsKey(_tmpKey)) {
            _collectionAssignees.put(_tmpKey, mutableListOf())
          }
          val _tmpKey_1: Long
          _tmpKey_1 = _stmt.getLong(_columnIndexOfAeUidNum)
          if (!_collectionLearningUnits.containsKey(_tmpKey_1)) {
            _collectionLearningUnits.put(_tmpKey_1, mutableListOf())
          }
        }
        _stmt.reset()
        __fetchRelationshipAssignmentAssigneeRefEntityAsworldRespectDatalayerDbSchoolEntitiesAssignmentAssigneeRefEntity(_connection, _collectionAssignees)
        __fetchRelationshipAssignmentLearningResourceRefEntityAsworldRespectDatalayerDbSchoolEntitiesAssignmentLearningResourceRefEntity(_connection, _collectionLearningUnits)
        val _result: AssignmentEntities?
        if (_stmt.step()) {
          val _tmpAssignment: AssignmentEntity
          val _tmpAeUid: String
          _tmpAeUid = _stmt.getText(_columnIndexOfAeUid)
          val _tmpAeUidNum: Long
          _tmpAeUidNum = _stmt.getLong(_columnIndexOfAeUidNum)
          val _tmpAeTitle: String
          _tmpAeTitle = _stmt.getText(_columnIndexOfAeTitle)
          val _tmpAeDescription: String
          _tmpAeDescription = _stmt.getText(_columnIndexOfAeDescription)
          val _tmpAeDeadline: Instant?
          val _tmp: Long?
          if (_stmt.isNull(_columnIndexOfAeDeadline)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfAeDeadline)
          }
          _tmpAeDeadline = __sharedConverters.toInstant(_tmp)
          val _tmpAeLastModified: Instant
          val _tmp_1: Long?
          if (_stmt.isNull(_columnIndexOfAeLastModified)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getLong(_columnIndexOfAeLastModified)
          }
          val _tmp_2: Instant? = __sharedConverters.toInstant(_tmp_1)
          if (_tmp_2 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpAeLastModified = _tmp_2
          }
          val _tmpAeStored: Instant
          val _tmp_3: Long?
          if (_stmt.isNull(_columnIndexOfAeStored)) {
            _tmp_3 = null
          } else {
            _tmp_3 = _stmt.getLong(_columnIndexOfAeStored)
          }
          val _tmp_4: Instant? = __sharedConverters.toInstant(_tmp_3)
          if (_tmp_4 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpAeStored = _tmp_4
          }
          _tmpAssignment = AssignmentEntity(_tmpAeUid,_tmpAeUidNum,_tmpAeTitle,_tmpAeDescription,_tmpAeDeadline,_tmpAeLastModified,_tmpAeStored)
          val _tmpAssigneesCollection: MutableList<AssignmentAssigneeRefEntity>
          val _tmpKey_2: Long
          _tmpKey_2 = _stmt.getLong(_columnIndexOfAeUidNum)
          _tmpAssigneesCollection = checkNotNull(_collectionAssignees.get(_tmpKey_2))
          val _tmpLearningUnitsCollection: MutableList<AssignmentLearningResourceRefEntity>
          val _tmpKey_3: Long
          _tmpKey_3 = _stmt.getLong(_columnIndexOfAeUidNum)
          _tmpLearningUnitsCollection = checkNotNull(_collectionLearningUnits.get(_tmpKey_3))
          _result = AssignmentEntities(_tmpAssignment,_tmpAssigneesCollection,_tmpLearningUnitsCollection)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun findByUidNumAsFlow(uidNum: Long): Flow<AssignmentEntities?> {
    val _sql: String = """
        |
        |        SELECT AssignmentEntity.*
        |          FROM AssignmentEntity
        |         WHERE AssignmentEntity.aeUidNum = ?
        |    
        """.trimMargin()
    return createFlow(__db, false, arrayOf("AssignmentAssigneeRefEntity", "AssignmentLearningResourceRefEntity", "AssignmentEntity")) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, uidNum)
        val _columnIndexOfAeUid: Int = getColumnIndexOrThrow(_stmt, "aeUid")
        val _columnIndexOfAeUidNum: Int = getColumnIndexOrThrow(_stmt, "aeUidNum")
        val _columnIndexOfAeTitle: Int = getColumnIndexOrThrow(_stmt, "aeTitle")
        val _columnIndexOfAeDescription: Int = getColumnIndexOrThrow(_stmt, "aeDescription")
        val _columnIndexOfAeDeadline: Int = getColumnIndexOrThrow(_stmt, "aeDeadline")
        val _columnIndexOfAeLastModified: Int = getColumnIndexOrThrow(_stmt, "aeLastModified")
        val _columnIndexOfAeStored: Int = getColumnIndexOrThrow(_stmt, "aeStored")
        val _collectionAssignees: LongSparseArray<MutableList<AssignmentAssigneeRefEntity>> = LongSparseArray<MutableList<AssignmentAssigneeRefEntity>>()
        val _collectionLearningUnits: LongSparseArray<MutableList<AssignmentLearningResourceRefEntity>> = LongSparseArray<MutableList<AssignmentLearningResourceRefEntity>>()
        while (_stmt.step()) {
          val _tmpKey: Long
          _tmpKey = _stmt.getLong(_columnIndexOfAeUidNum)
          if (!_collectionAssignees.containsKey(_tmpKey)) {
            _collectionAssignees.put(_tmpKey, mutableListOf())
          }
          val _tmpKey_1: Long
          _tmpKey_1 = _stmt.getLong(_columnIndexOfAeUidNum)
          if (!_collectionLearningUnits.containsKey(_tmpKey_1)) {
            _collectionLearningUnits.put(_tmpKey_1, mutableListOf())
          }
        }
        _stmt.reset()
        __fetchRelationshipAssignmentAssigneeRefEntityAsworldRespectDatalayerDbSchoolEntitiesAssignmentAssigneeRefEntity(_connection, _collectionAssignees)
        __fetchRelationshipAssignmentLearningResourceRefEntityAsworldRespectDatalayerDbSchoolEntitiesAssignmentLearningResourceRefEntity(_connection, _collectionLearningUnits)
        val _result: AssignmentEntities?
        if (_stmt.step()) {
          val _tmpAssignment: AssignmentEntity
          val _tmpAeUid: String
          _tmpAeUid = _stmt.getText(_columnIndexOfAeUid)
          val _tmpAeUidNum: Long
          _tmpAeUidNum = _stmt.getLong(_columnIndexOfAeUidNum)
          val _tmpAeTitle: String
          _tmpAeTitle = _stmt.getText(_columnIndexOfAeTitle)
          val _tmpAeDescription: String
          _tmpAeDescription = _stmt.getText(_columnIndexOfAeDescription)
          val _tmpAeDeadline: Instant?
          val _tmp: Long?
          if (_stmt.isNull(_columnIndexOfAeDeadline)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfAeDeadline)
          }
          _tmpAeDeadline = __sharedConverters.toInstant(_tmp)
          val _tmpAeLastModified: Instant
          val _tmp_1: Long?
          if (_stmt.isNull(_columnIndexOfAeLastModified)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getLong(_columnIndexOfAeLastModified)
          }
          val _tmp_2: Instant? = __sharedConverters.toInstant(_tmp_1)
          if (_tmp_2 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpAeLastModified = _tmp_2
          }
          val _tmpAeStored: Instant
          val _tmp_3: Long?
          if (_stmt.isNull(_columnIndexOfAeStored)) {
            _tmp_3 = null
          } else {
            _tmp_3 = _stmt.getLong(_columnIndexOfAeStored)
          }
          val _tmp_4: Instant? = __sharedConverters.toInstant(_tmp_3)
          if (_tmp_4 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpAeStored = _tmp_4
          }
          _tmpAssignment = AssignmentEntity(_tmpAeUid,_tmpAeUidNum,_tmpAeTitle,_tmpAeDescription,_tmpAeDeadline,_tmpAeLastModified,_tmpAeStored)
          val _tmpAssigneesCollection: MutableList<AssignmentAssigneeRefEntity>
          val _tmpKey_2: Long
          _tmpKey_2 = _stmt.getLong(_columnIndexOfAeUidNum)
          _tmpAssigneesCollection = checkNotNull(_collectionAssignees.get(_tmpKey_2))
          val _tmpLearningUnitsCollection: MutableList<AssignmentLearningResourceRefEntity>
          val _tmpKey_3: Long
          _tmpKey_3 = _stmt.getLong(_columnIndexOfAeUidNum)
          _tmpLearningUnitsCollection = checkNotNull(_collectionLearningUnits.get(_tmpKey_3))
          _result = AssignmentEntities(_tmpAssignment,_tmpAssigneesCollection,_tmpLearningUnitsCollection)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findByUidNums(uidNums: List<Long>): List<AssignmentEntities> {
    val _stringBuilder: StringBuilder = StringBuilder()
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("        SELECT AssignmentEntity.*")
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("          FROM AssignmentEntity")
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("         WHERE AssignmentEntity.aeUidNum IN (")
    val _inputSize: Int = uidNums.size
    appendPlaceholders(_stringBuilder, _inputSize)
    _stringBuilder.append(")")
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("    ")
    val _sql: String = _stringBuilder.toString()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        for (_item: Long in uidNums) {
          _stmt.bindLong(_argIndex, _item)
          _argIndex++
        }
        val _columnIndexOfAeUid: Int = getColumnIndexOrThrow(_stmt, "aeUid")
        val _columnIndexOfAeUidNum: Int = getColumnIndexOrThrow(_stmt, "aeUidNum")
        val _columnIndexOfAeTitle: Int = getColumnIndexOrThrow(_stmt, "aeTitle")
        val _columnIndexOfAeDescription: Int = getColumnIndexOrThrow(_stmt, "aeDescription")
        val _columnIndexOfAeDeadline: Int = getColumnIndexOrThrow(_stmt, "aeDeadline")
        val _columnIndexOfAeLastModified: Int = getColumnIndexOrThrow(_stmt, "aeLastModified")
        val _columnIndexOfAeStored: Int = getColumnIndexOrThrow(_stmt, "aeStored")
        val _collectionAssignees: LongSparseArray<MutableList<AssignmentAssigneeRefEntity>> = LongSparseArray<MutableList<AssignmentAssigneeRefEntity>>()
        val _collectionLearningUnits: LongSparseArray<MutableList<AssignmentLearningResourceRefEntity>> = LongSparseArray<MutableList<AssignmentLearningResourceRefEntity>>()
        while (_stmt.step()) {
          val _tmpKey: Long
          _tmpKey = _stmt.getLong(_columnIndexOfAeUidNum)
          if (!_collectionAssignees.containsKey(_tmpKey)) {
            _collectionAssignees.put(_tmpKey, mutableListOf())
          }
          val _tmpKey_1: Long
          _tmpKey_1 = _stmt.getLong(_columnIndexOfAeUidNum)
          if (!_collectionLearningUnits.containsKey(_tmpKey_1)) {
            _collectionLearningUnits.put(_tmpKey_1, mutableListOf())
          }
        }
        _stmt.reset()
        __fetchRelationshipAssignmentAssigneeRefEntityAsworldRespectDatalayerDbSchoolEntitiesAssignmentAssigneeRefEntity(_connection, _collectionAssignees)
        __fetchRelationshipAssignmentLearningResourceRefEntityAsworldRespectDatalayerDbSchoolEntitiesAssignmentLearningResourceRefEntity(_connection, _collectionLearningUnits)
        val _result: MutableList<AssignmentEntities> = mutableListOf()
        while (_stmt.step()) {
          val _item_1: AssignmentEntities
          val _tmpAssignment: AssignmentEntity
          val _tmpAeUid: String
          _tmpAeUid = _stmt.getText(_columnIndexOfAeUid)
          val _tmpAeUidNum: Long
          _tmpAeUidNum = _stmt.getLong(_columnIndexOfAeUidNum)
          val _tmpAeTitle: String
          _tmpAeTitle = _stmt.getText(_columnIndexOfAeTitle)
          val _tmpAeDescription: String
          _tmpAeDescription = _stmt.getText(_columnIndexOfAeDescription)
          val _tmpAeDeadline: Instant?
          val _tmp: Long?
          if (_stmt.isNull(_columnIndexOfAeDeadline)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfAeDeadline)
          }
          _tmpAeDeadline = __sharedConverters.toInstant(_tmp)
          val _tmpAeLastModified: Instant
          val _tmp_1: Long?
          if (_stmt.isNull(_columnIndexOfAeLastModified)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getLong(_columnIndexOfAeLastModified)
          }
          val _tmp_2: Instant? = __sharedConverters.toInstant(_tmp_1)
          if (_tmp_2 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpAeLastModified = _tmp_2
          }
          val _tmpAeStored: Instant
          val _tmp_3: Long?
          if (_stmt.isNull(_columnIndexOfAeStored)) {
            _tmp_3 = null
          } else {
            _tmp_3 = _stmt.getLong(_columnIndexOfAeStored)
          }
          val _tmp_4: Instant? = __sharedConverters.toInstant(_tmp_3)
          if (_tmp_4 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpAeStored = _tmp_4
          }
          _tmpAssignment = AssignmentEntity(_tmpAeUid,_tmpAeUidNum,_tmpAeTitle,_tmpAeDescription,_tmpAeDeadline,_tmpAeLastModified,_tmpAeStored)
          val _tmpAssigneesCollection: MutableList<AssignmentAssigneeRefEntity>
          val _tmpKey_2: Long
          _tmpKey_2 = _stmt.getLong(_columnIndexOfAeUidNum)
          _tmpAssigneesCollection = checkNotNull(_collectionAssignees.get(_tmpKey_2))
          val _tmpLearningUnitsCollection: MutableList<AssignmentLearningResourceRefEntity>
          val _tmpKey_3: Long
          _tmpKey_3 = _stmt.getLong(_columnIndexOfAeUidNum)
          _tmpLearningUnitsCollection = checkNotNull(_collectionLearningUnits.get(_tmpKey_3))
          _item_1 = AssignmentEntities(_tmpAssignment,_tmpAssigneesCollection,_tmpLearningUnitsCollection)
          _result.add(_item_1)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  private fun __fetchRelationshipAssignmentAssigneeRefEntityAsworldRespectDatalayerDbSchoolEntitiesAssignmentAssigneeRefEntity(_connection: SQLiteConnection, _map: LongSparseArray<MutableList<AssignmentAssigneeRefEntity>>) {
    if (_map.isEmpty()) {
      return
    }
    if (_map.size() > 999) {
      recursiveFetchLongSparseArray(_map, true) { _tmpMap ->
        __fetchRelationshipAssignmentAssigneeRefEntityAsworldRespectDatalayerDbSchoolEntitiesAssignmentAssigneeRefEntity(_connection, _tmpMap)
      }
      return
    }
    val _stringBuilder: StringBuilder = StringBuilder()
    _stringBuilder.append("SELECT `aarAeUidNum`,`aarType`,`aarAeAssigneeUid`,`aarAeAssigneeUidNum` FROM `AssignmentAssigneeRefEntity` WHERE `aarAeUidNum` IN (")
    val _inputSize: Int = _map.size()
    appendPlaceholders(_stringBuilder, _inputSize)
    _stringBuilder.append(")")
    val _sql: String = _stringBuilder.toString()
    val _stmt: SQLiteStatement = _connection.prepare(_sql)
    var _argIndex: Int = 1
    for (i in 0 until _map.size()) {
      val _item: Long = _map.keyAt(i)
      _stmt.bindLong(_argIndex, _item)
      _argIndex++
    }
    try {
      val _itemKeyIndex: Int = getColumnIndex(_stmt, "aarAeUidNum")
      if (_itemKeyIndex == -1) {
        return
      }
      val _columnIndexOfAarAeUidNum: Int = 0
      val _columnIndexOfAarType: Int = 1
      val _columnIndexOfAarAeAssigneeUid: Int = 2
      val _columnIndexOfAarAeAssigneeUidNum: Int = 3
      while (_stmt.step()) {
        val _tmpKey: Long
        _tmpKey = _stmt.getLong(_itemKeyIndex)
        val _tmpRelation: MutableList<AssignmentAssigneeRefEntity>? = _map.get(_tmpKey)
        if (_tmpRelation != null) {
          val _item_1: AssignmentAssigneeRefEntity
          val _tmpAarAeUidNum: Long
          _tmpAarAeUidNum = _stmt.getLong(_columnIndexOfAarAeUidNum)
          val _tmpAarType: AssignmentAssigneeRefTypeEnum
          val _tmp: Int
          _tmp = _stmt.getLong(_columnIndexOfAarType).toInt()
          _tmpAarType = __schoolTypeConverters.toAssignmentAssigneeRefTypeEnum(_tmp)
          val _tmpAarAeAssigneeUid: String
          _tmpAarAeAssigneeUid = _stmt.getText(_columnIndexOfAarAeAssigneeUid)
          val _tmpAarAeAssigneeUidNum: Long
          _tmpAarAeAssigneeUidNum = _stmt.getLong(_columnIndexOfAarAeAssigneeUidNum)
          _item_1 = AssignmentAssigneeRefEntity(_tmpAarAeUidNum,_tmpAarType,_tmpAarAeAssigneeUid,_tmpAarAeAssigneeUidNum)
          _tmpRelation.add(_item_1)
        }
      }
    } finally {
      _stmt.close()
    }
  }

  private fun __fetchRelationshipAssignmentLearningResourceRefEntityAsworldRespectDatalayerDbSchoolEntitiesAssignmentLearningResourceRefEntity(_connection: SQLiteConnection, _map: LongSparseArray<MutableList<AssignmentLearningResourceRefEntity>>) {
    if (_map.isEmpty()) {
      return
    }
    if (_map.size() > 999) {
      recursiveFetchLongSparseArray(_map, true) { _tmpMap ->
        __fetchRelationshipAssignmentLearningResourceRefEntityAsworldRespectDatalayerDbSchoolEntitiesAssignmentLearningResourceRefEntity(_connection, _tmpMap)
      }
      return
    }
    val _stringBuilder: StringBuilder = StringBuilder()
    _stringBuilder.append("SELECT `alrrAeUidNum`,`alrrLearningUnitManifestUrlHash`,`alrrLearningUnitManifestUrl`,`alrrAppManifestUrl` FROM `AssignmentLearningResourceRefEntity` WHERE `alrrAeUidNum` IN (")
    val _inputSize: Int = _map.size()
    appendPlaceholders(_stringBuilder, _inputSize)
    _stringBuilder.append(")")
    val _sql: String = _stringBuilder.toString()
    val _stmt: SQLiteStatement = _connection.prepare(_sql)
    var _argIndex: Int = 1
    for (i in 0 until _map.size()) {
      val _item: Long = _map.keyAt(i)
      _stmt.bindLong(_argIndex, _item)
      _argIndex++
    }
    try {
      val _itemKeyIndex: Int = getColumnIndex(_stmt, "alrrAeUidNum")
      if (_itemKeyIndex == -1) {
        return
      }
      val _columnIndexOfAlrrAeUidNum: Int = 0
      val _columnIndexOfAlrrLearningUnitManifestUrlHash: Int = 1
      val _columnIndexOfAlrrLearningUnitManifestUrl: Int = 2
      val _columnIndexOfAlrrAppManifestUrl: Int = 3
      while (_stmt.step()) {
        val _tmpKey: Long
        _tmpKey = _stmt.getLong(_itemKeyIndex)
        val _tmpRelation: MutableList<AssignmentLearningResourceRefEntity>? = _map.get(_tmpKey)
        if (_tmpRelation != null) {
          val _item_1: AssignmentLearningResourceRefEntity
          val _tmpAlrrAeUidNum: Long
          _tmpAlrrAeUidNum = _stmt.getLong(_columnIndexOfAlrrAeUidNum)
          val _tmpAlrrLearningUnitManifestUrlHash: Long
          _tmpAlrrLearningUnitManifestUrlHash = _stmt.getLong(_columnIndexOfAlrrLearningUnitManifestUrlHash)
          val _tmpAlrrLearningUnitManifestUrl: Url
          val _tmp: String?
          if (_stmt.isNull(_columnIndexOfAlrrLearningUnitManifestUrl)) {
            _tmp = null
          } else {
            _tmp = _stmt.getText(_columnIndexOfAlrrLearningUnitManifestUrl)
          }
          val _tmp_1: Url? = __sharedConverters.toUrl(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.")
          } else {
            _tmpAlrrLearningUnitManifestUrl = _tmp_1
          }
          val _tmpAlrrAppManifestUrl: Url
          val _tmp_2: String?
          if (_stmt.isNull(_columnIndexOfAlrrAppManifestUrl)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getText(_columnIndexOfAlrrAppManifestUrl)
          }
          val _tmp_3: Url? = __sharedConverters.toUrl(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.")
          } else {
            _tmpAlrrAppManifestUrl = _tmp_3
          }
          _item_1 = AssignmentLearningResourceRefEntity(_tmpAlrrAeUidNum,_tmpAlrrLearningUnitManifestUrlHash,_tmpAlrrLearningUnitManifestUrl,_tmpAlrrAppManifestUrl)
          _tmpRelation.add(_item_1)
        }
      }
    } finally {
      _stmt.close()
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
