/*
 * Decompiled with CFR 0.152.
 */
package world.respect.datalayer.db.school.daos;

import androidx.collection.LongSparseArray;
import androidx.paging.PagingSource;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomRawQuery;
import androidx.room.coroutines.FlowUtil;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.DBUtil;
import androidx.room.util.RelationUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.SQLiteConnection;
import androidx.sqlite.SQLiteStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlinx.coroutines.flow.Flow;
import kotlinx.datetime.LocalDate;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import world.respect.datalayer.db.school.SchoolTypeConverters;
import world.respect.datalayer.db.school.daos.PersonEntityDao;
import world.respect.datalayer.db.school.daos.PersonEntityDao_Impl;
import world.respect.datalayer.db.school.entities.PersonEntity;
import world.respect.datalayer.db.school.entities.PersonEntityWithRoles;
import world.respect.datalayer.db.school.entities.PersonRelatedPersonEntity;
import world.respect.datalayer.db.school.entities.PersonRoleEntity;
import world.respect.datalayer.school.model.PersonGenderEnum;
import world.respect.datalayer.school.model.PersonRoleEnum;
import world.respect.datalayer.school.model.PersonStatusEnum;
import world.respect.datalayer.school.model.composites.PersonListDetails;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 72\u00020\u0001:\u00017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0096@\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0096@\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u001a2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0014\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001aH\u0016J\u0014\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u001c0\u001aH\u0016J\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140\u001c2\u0006\u0010 \u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0012J\"\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00140\u001c2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00100\u001cH\u0096@\u00a2\u0006\u0002\u0010#JF\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u00140%2\u0006\u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020&2\b\u0010)\u001a\u0004\u0018\u00010\u00162\u0006\u0010*\u001a\u00020\u0010H\u0016JF\u0010+\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u001d0%2\u0006\u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020&2\b\u0010)\u001a\u0004\u0018\u00010\u00162\u0006\u0010*\u001a\u00020\u0010H\u0016J\u001c\u0010,\u001a\b\u0012\u0004\u0012\u00020\b0\u001c2\u0006\u0010-\u001a\u00020\u0016H\u0096@\u00a2\u0006\u0002\u0010\u0017J$\u0010.\u001a\u00020\f2\u0006\u0010/\u001a\u0002002\u0012\u00101\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002040302H\u0002J$\u00105\u001a\u00020\f2\u0006\u0010/\u001a\u0002002\u0012\u00101\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002060302H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lworld/respect/datalayer/db/school/daos/PersonEntityDao_Impl;", "Lworld/respect/datalayer/db/school/daos/PersonEntityDao;", "__db", "Landroidx/room/RoomDatabase;", "<init>", "(Landroidx/room/RoomDatabase;)V", "__insertAdapterOfPersonEntity", "Landroidx/room/EntityInsertAdapter;", "Lworld/respect/datalayer/db/school/entities/PersonEntity;", "__schoolTypeConverters", "Lworld/respect/datalayer/db/school/SchoolTypeConverters;", "insert", "", "personEntity", "(Lworld/respect/datalayer/db/school/entities/PersonEntity;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getLastModifiedByGuid", "", "guidHash", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUsername", "Lworld/respect/datalayer/db/school/entities/PersonEntityWithRoles;", "username", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByGuidNum", "findByGuidHashAsFlow", "Lkotlinx/coroutines/flow/Flow;", "findAllListDetailsAsFlow", "", "Lworld/respect/datalayer/school/model/composites/PersonListDetails;", "findAllAsFlow", "findAll", "since", "findByUidList", "uidNums", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findAllAsPagingSource", "Landroidx/paging/PagingSource;", "", "inClazzGuidHash", "inClazzRoleFlag", "filterByName", "timeNow", "findAllListDetailsAsPagingSource", "getAllUsers", "sourcedId", "__fetchRelationshipPersonRoleEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRoleEntity", "_connection", "Landroidx/sqlite/SQLiteConnection;", "_map", "Landroidx/collection/LongSparseArray;", "", "Lworld/respect/datalayer/db/school/entities/PersonRoleEntity;", "__fetchRelationshipPersonRelatedPersonEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRelatedPersonEntity", "Lworld/respect/datalayer/db/school/entities/PersonRelatedPersonEntity;", "Companion", "respect-datalayer-db_debug"})
public final class PersonEntityDao_Impl
implements PersonEntityDao {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RoomDatabase __db;
    @NotNull
    private final EntityInsertAdapter<PersonEntity> __insertAdapterOfPersonEntity;
    @NotNull
    private final SchoolTypeConverters __schoolTypeConverters;

    public PersonEntityDao_Impl(@NotNull RoomDatabase __db) {
        Intrinsics.checkNotNullParameter((Object)__db, (String)"__db");
        this.__schoolTypeConverters = new SchoolTypeConverters();
        this.__db = __db;
        this.__insertAdapterOfPersonEntity = (EntityInsertAdapter)new EntityInsertAdapter<PersonEntity>(){

            protected String createQuery() {
                return "INSERT OR REPLACE INTO `PersonEntity` (`pGuid`,`pGuidHash`,`pActive`,`pStatus`,`pLastModified`,`pStored`,`pMetadata`,`pUsername`,`pGivenName`,`pFamilyName`,`pMiddleName`,`pGender`,`pDateOfBirth`,`pEmail`,`pPhoneNumber`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(SQLiteStatement statement, PersonEntity entity) {
                Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                statement.bindText(1, entity.getPGuid());
                statement.bindLong(2, entity.getPGuidHash());
                int _tmp = entity.getPActive() ? 1 : 0;
                statement.bindLong(3, (long)_tmp);
                int _tmp_1 = __schoolTypeConverters.fromPersonStatusEnum(entity.getPStatus());
                statement.bindLong(4, (long)_tmp_1);
                statement.bindLong(5, entity.getPLastModified());
                statement.bindLong(6, entity.getPStored());
                JsonObject _tmpPMetadata = entity.getPMetadata();
                String _tmp_2 = __schoolTypeConverters.fromJsonObject(_tmpPMetadata);
                if (_tmp_2 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_2);
                }
                String _tmpPUsername = entity.getPUsername();
                if (_tmpPUsername == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmpPUsername);
                }
                statement.bindText(9, entity.getPGivenName());
                statement.bindText(10, entity.getPFamilyName());
                String _tmpPMiddleName = entity.getPMiddleName();
                if (_tmpPMiddleName == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, _tmpPMiddleName);
                }
                int _tmp_3 = __schoolTypeConverters.fromPersonGenderEnum(entity.getPGender());
                statement.bindLong(12, (long)_tmp_3);
                LocalDate _tmpPDateOfBirth = entity.getPDateOfBirth();
                Long _tmp_4 = __schoolTypeConverters.fromLocalDate(_tmpPDateOfBirth);
                if (_tmp_4 == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindLong(13, _tmp_4.longValue());
                }
                String _tmpPEmail = entity.getPEmail();
                if (_tmpPEmail == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindText(14, _tmpPEmail);
                }
                String _tmpPPhoneNumber = entity.getPPhoneNumber();
                if (_tmpPPhoneNumber == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindText(15, _tmpPPhoneNumber);
                }
            }
        };
    }

    @Override
    @Nullable
    public Object insert(@NotNull PersonEntity personEntity, @NotNull Continuation<? super Unit> $completion) {
        Object object = DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> PersonEntityDao_Impl.insert$lambda$0(this, personEntity, arg_0), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object getLastModifiedByGuid(long guidHash, @NotNull Continuation<? super Long> $completion) {
        String _sql = "\n        SELECT PersonEntity.pLastModified\n          FROM PersonEntity\n         WHERE PersonEntity.pGuidHash = ?\n         LIMIT 1\n    ";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> PersonEntityDao_Impl.getLastModifiedByGuid$lambda$0(_sql, guidHash, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object findByUsername(@NotNull String username, @NotNull Continuation<? super PersonEntityWithRoles> $completion) {
        String _sql = "\n        SELECT * \n         FROM PersonEntity\n        WHERE pUsername = ?\n    ";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)true, arg_0 -> PersonEntityDao_Impl.findByUsername$lambda$0(_sql, username, this, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object findByGuidNum(long guidHash, @NotNull Continuation<? super PersonEntityWithRoles> $completion) {
        String _sql = "\n       SELECT * \n         FROM PersonEntity\n        WHERE pGuidHash = ?\n    ";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)true, arg_0 -> PersonEntityDao_Impl.findByGuidNum$lambda$0(_sql, guidHash, this, arg_0), $completion);
    }

    @Override
    @NotNull
    public Flow<PersonEntityWithRoles> findByGuidHashAsFlow(long guidHash) {
        String _sql = "\n        SELECT * \n         FROM PersonEntity\n        WHERE pGuidHash = ?\n    ";
        String[] stringArray = new String[]{"PersonRoleEntity", "PersonRelatedPersonEntity", "PersonEntity"};
        return FlowUtil.createFlow((RoomDatabase)this.__db, (boolean)true, (String[])stringArray, arg_0 -> PersonEntityDao_Impl.findByGuidHashAsFlow$lambda$0(_sql, guidHash, this, arg_0));
    }

    @Override
    @NotNull
    public Flow<List<PersonListDetails>> findAllListDetailsAsFlow() {
        String _sql = "\n        SELECT PersonEntity.pGuid AS guid, \n               PersonEntity.pGivenName AS givenName, \n               PersonEntity.pFamilyName AS familyName, \n               PersonEntity.pUsername AS username\n          FROM PersonEntity\n    ";
        String[] stringArray = new String[]{"PersonEntity"};
        return FlowUtil.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])stringArray, arg_0 -> PersonEntityDao_Impl.findAllListDetailsAsFlow$lambda$0(_sql, arg_0));
    }

    @Override
    @NotNull
    public Flow<List<PersonEntityWithRoles>> findAllAsFlow() {
        String _sql = "\n        SELECT * \n         FROM PersonEntity\n    ";
        String[] stringArray = new String[]{"PersonRoleEntity", "PersonRelatedPersonEntity", "PersonEntity"};
        return FlowUtil.createFlow((RoomDatabase)this.__db, (boolean)true, (String[])stringArray, arg_0 -> PersonEntityDao_Impl.findAllAsFlow$lambda$0(_sql, this, arg_0));
    }

    @Override
    @Nullable
    public Object findAll(long since, @NotNull Continuation<? super List<PersonEntityWithRoles>> $completion) {
        String _sql = "\n        SELECT * \n         FROM PersonEntity\n        WHERE PersonEntity.pStored > ? \n    ";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> PersonEntityDao_Impl.findAll$lambda$0(_sql, since, this, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object findByUidList(@NotNull List<Long> uidNums, @NotNull Continuation<? super List<PersonEntityWithRoles>> $completion) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("        SELECT PersonEntity.*");
        _stringBuilder.append("\n");
        _stringBuilder.append("          FROM PersonEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("         WHERE PersonEntity.pGuidHash IN (");
        int _inputSize = uidNums.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") ");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        String string = _stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String _sql = string;
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)true, arg_0 -> PersonEntityDao_Impl.findByUidList$lambda$0(_sql, uidNums, this, arg_0), $completion);
    }

    @Override
    @NotNull
    public PagingSource<Integer, PersonEntityWithRoles> findAllAsPagingSource(long since, long guidHash, long inClazzGuidHash, int inClazzRoleFlag, @Nullable String filterByName, long timeNow) {
        String _sql = "\n        SELECT * \n         FROM PersonEntity\n        WHERE PersonEntity.pStored > ? \n          AND (? = 0 OR PersonEntity.pGuidHash = ?)\n          AND (? = 0 OR\n               EXISTS(\n                    SELECT EnrollmentEntity.eUid\n                      FROM EnrollmentEntity\n                     WHERE EnrollmentEntity.ePersonUidNum = PersonEntity.pGuidHash\n                       AND EnrollmentEntity.eClassUidNum = ?\n                       AND (? = 0 OR EnrollmentEntity.eRole = ?)\n                       AND ? BETWEEN\n                                    COALESCE(EnrollmentEntity.eBeginDate, 0) AND\n                                    COALESCE(EnrollmentEntity.eEndDate, 9223372036854775807)         \n               )\n              ) \n         AND (? IS NULL \n              OR (PersonEntity.pGivenName || ' ' || PersonEntity.pFamilyName) LIKE ('%' || ? || '%'))\n     ORDER BY PersonEntity.pGivenName\n    ";
        RoomRawQuery _rawQuery = new RoomRawQuery(_sql, arg_0 -> PersonEntityDao_Impl.findAllAsPagingSource$lambda$0(since, guidHash, inClazzGuidHash, inClazzRoleFlag, timeNow, filterByName, arg_0));
        RoomDatabase roomDatabase = this.__db;
        String[] stringArray = new String[]{"PersonRoleEntity", "PersonRelatedPersonEntity", "PersonEntity", "EnrollmentEntity"};
        String[] stringArray2 = stringArray;
        return (PagingSource)new LimitOffsetPagingSource<PersonEntityWithRoles>(_rawQuery, this, roomDatabase, stringArray2){
            final /* synthetic */ PersonEntityDao_Impl this$0;
            {
                this.this$0 = $receiver;
                super($_rawQuery, $super_call_param$1, $super_call_param$2);
            }

            protected Object convertRows(RoomRawQuery limitOffsetQuery, int itemCount, Continuation<? super List<PersonEntityWithRoles>> $completion) {
                return DBUtil.performSuspending((RoomDatabase)PersonEntityDao_Impl.access$get__db$p(this.this$0), (boolean)true, (boolean)false, arg_0 -> findAllAsPagingSource.1.convertRows$lambda$0(limitOffsetQuery, this.this$0, arg_0), $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static final List convertRows$lambda$0(RoomRawQuery $limitOffsetQuery, PersonEntityDao_Impl this$0, SQLiteConnection _connection) {
                List list2;
                Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
                SQLiteStatement _stmt = _connection.prepare($limitOffsetQuery.getSql());
                $limitOffsetQuery.getBindingFunction().invoke((Object)_stmt);
                try {
                    int _columnIndexOfPGuid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pGuid");
                    int _columnIndexOfPGuidHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pGuidHash");
                    int _columnIndexOfPActive = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pActive");
                    int _columnIndexOfPStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pStatus");
                    int _columnIndexOfPLastModified = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pLastModified");
                    int _columnIndexOfPStored = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pStored");
                    int _columnIndexOfPMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pMetadata");
                    int _columnIndexOfPUsername = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pUsername");
                    int _columnIndexOfPGivenName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pGivenName");
                    int _columnIndexOfPFamilyName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pFamilyName");
                    int _columnIndexOfPMiddleName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pMiddleName");
                    int _columnIndexOfPGender = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pGender");
                    int _columnIndexOfPDateOfBirth = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pDateOfBirth");
                    int _columnIndexOfPEmail = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pEmail");
                    int _columnIndexOfPPhoneNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pPhoneNumber");
                    LongSparseArray _collectionRoles = new LongSparseArray(0, 1, null);
                    LongSparseArray _collectionRelatedPersons = new LongSparseArray(0, 1, null);
                    while (_stmt.step()) {
                        long _tmpKey = 0L;
                        _tmpKey = _stmt.getLong(_columnIndexOfPGuidHash);
                        if (!_collectionRoles.containsKey(_tmpKey)) {
                            _collectionRoles.put(_tmpKey, (Object)new ArrayList<E>());
                        }
                        long _tmpKey_1 = 0L;
                        _tmpKey_1 = _stmt.getLong(_columnIndexOfPGuidHash);
                        if (_collectionRelatedPersons.containsKey(_tmpKey_1)) continue;
                        _collectionRelatedPersons.put(_tmpKey_1, (Object)new ArrayList<E>());
                    }
                    _stmt.reset();
                    PersonEntityDao_Impl.access$__fetchRelationshipPersonRoleEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRoleEntity(this$0, _connection, _collectionRoles);
                    PersonEntityDao_Impl.access$__fetchRelationshipPersonRelatedPersonEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRelatedPersonEntity(this$0, _connection, _collectionRelatedPersons);
                    List _result = new ArrayList<E>();
                    while (_stmt.step()) {
                        PersonEntityWithRoles _item = null;
                        PersonEntity _tmpPerson = null;
                        String _tmpPGuid = null;
                        _tmpPGuid = _stmt.getText(_columnIndexOfPGuid);
                        long _tmpPGuidHash = 0L;
                        _tmpPGuidHash = _stmt.getLong(_columnIndexOfPGuidHash);
                        boolean _tmpPActive = false;
                        int _tmp = 0;
                        _tmp = (int)_stmt.getLong(_columnIndexOfPActive);
                        _tmpPActive = _tmp != 0;
                        PersonStatusEnum _tmpPStatus = null;
                        int _tmp_1 = 0;
                        _tmp_1 = (int)_stmt.getLong(_columnIndexOfPStatus);
                        _tmpPStatus = PersonEntityDao_Impl.access$get__schoolTypeConverters$p(this$0).toPersonStatusEnum(_tmp_1);
                        long _tmpPLastModified = 0L;
                        _tmpPLastModified = _stmt.getLong(_columnIndexOfPLastModified);
                        long _tmpPStored = 0L;
                        _tmpPStored = _stmt.getLong(_columnIndexOfPStored);
                        JsonObject _tmpPMetadata = null;
                        String _tmp_2 = null;
                        _tmp_2 = _stmt.isNull(_columnIndexOfPMetadata) ? null : _stmt.getText(_columnIndexOfPMetadata);
                        _tmpPMetadata = PersonEntityDao_Impl.access$get__schoolTypeConverters$p(this$0).toJsonObject(_tmp_2);
                        String _tmpPUsername = null;
                        _tmpPUsername = _stmt.isNull(_columnIndexOfPUsername) ? null : _stmt.getText(_columnIndexOfPUsername);
                        String _tmpPGivenName = null;
                        _tmpPGivenName = _stmt.getText(_columnIndexOfPGivenName);
                        String _tmpPFamilyName = null;
                        _tmpPFamilyName = _stmt.getText(_columnIndexOfPFamilyName);
                        String _tmpPMiddleName = null;
                        _tmpPMiddleName = _stmt.isNull(_columnIndexOfPMiddleName) ? null : _stmt.getText(_columnIndexOfPMiddleName);
                        PersonGenderEnum _tmpPGender = null;
                        int _tmp_3 = 0;
                        _tmp_3 = (int)_stmt.getLong(_columnIndexOfPGender);
                        _tmpPGender = PersonEntityDao_Impl.access$get__schoolTypeConverters$p(this$0).toPersonGenderEnum(_tmp_3);
                        LocalDate _tmpPDateOfBirth = null;
                        Long _tmp_4 = null;
                        _tmp_4 = _stmt.isNull(_columnIndexOfPDateOfBirth) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfPDateOfBirth));
                        _tmpPDateOfBirth = PersonEntityDao_Impl.access$get__schoolTypeConverters$p(this$0).toLocalDate(_tmp_4);
                        String _tmpPEmail = null;
                        _tmpPEmail = _stmt.isNull(_columnIndexOfPEmail) ? null : _stmt.getText(_columnIndexOfPEmail);
                        String _tmpPPhoneNumber = null;
                        _tmpPPhoneNumber = _stmt.isNull(_columnIndexOfPPhoneNumber) ? null : _stmt.getText(_columnIndexOfPPhoneNumber);
                        _tmpPerson = new PersonEntity(_tmpPGuid, _tmpPGuidHash, _tmpPActive, _tmpPStatus, _tmpPLastModified, _tmpPStored, _tmpPMetadata, _tmpPUsername, _tmpPGivenName, _tmpPFamilyName, _tmpPMiddleName, _tmpPGender, _tmpPDateOfBirth, _tmpPEmail, _tmpPPhoneNumber);
                        List _tmpRolesCollection = null;
                        long _tmpKey_2 = 0L;
                        _tmpKey_2 = _stmt.getLong(_columnIndexOfPGuidHash);
                        Object object = _collectionRoles.get(_tmpKey_2);
                        if (object == null) {
                            String string = "Required value was null.";
                            throw new IllegalStateException(string.toString());
                        }
                        _tmpRolesCollection = (List)object;
                        List _tmpRelatedPersonsCollection = null;
                        long _tmpKey_3 = 0L;
                        _tmpKey_3 = _stmt.getLong(_columnIndexOfPGuidHash);
                        Object object2 = _collectionRelatedPersons.get(_tmpKey_3);
                        if (object2 == null) {
                            String string = "Required value was null.";
                            throw new IllegalStateException(string.toString());
                        }
                        _tmpRelatedPersonsCollection = (List)object2;
                        _item = new PersonEntityWithRoles(_tmpPerson, _tmpRolesCollection, _tmpRelatedPersonsCollection);
                        _result.add(_item);
                    }
                    list2 = _result;
                }
                finally {
                    _stmt.close();
                }
                return list2;
            }
        };
    }

    @Override
    @NotNull
    public PagingSource<Integer, PersonListDetails> findAllListDetailsAsPagingSource(long since, long guidHash, long inClazzGuidHash, int inClazzRoleFlag, @Nullable String filterByName, long timeNow) {
        String _sql = "\n        SELECT PersonEntity.pGuid AS guid, \n               PersonEntity.pGivenName AS givenName, \n               PersonEntity.pFamilyName AS familyName, \n               PersonEntity.pUsername AS username\n          FROM PersonEntity\n        WHERE PersonEntity.pStored > ? \n          AND (? = 0 OR PersonEntity.pGuidHash = ?)\n          AND (? = 0 OR\n               EXISTS(\n                    SELECT EnrollmentEntity.eUid\n                      FROM EnrollmentEntity\n                     WHERE EnrollmentEntity.ePersonUidNum = PersonEntity.pGuidHash\n                       AND EnrollmentEntity.eClassUidNum = ?\n                       AND (? = 0 OR EnrollmentEntity.eRole = ?)\n                       AND ? BETWEEN\n                                    COALESCE(EnrollmentEntity.eBeginDate, 0) AND\n                                    COALESCE(EnrollmentEntity.eEndDate, 9223372036854775807)         \n               )\n              ) \n         AND (? IS NULL \n              OR (PersonEntity.pGivenName || ' ' || PersonEntity.pFamilyName) LIKE ('%' || ? || '%'))\n     ORDER BY PersonEntity.pGivenName\n    ";
        RoomRawQuery _rawQuery = new RoomRawQuery(_sql, arg_0 -> PersonEntityDao_Impl.findAllListDetailsAsPagingSource$lambda$0(since, guidHash, inClazzGuidHash, inClazzRoleFlag, timeNow, filterByName, arg_0));
        RoomDatabase roomDatabase = this.__db;
        String[] stringArray = new String[]{"PersonEntity", "EnrollmentEntity"};
        String[] stringArray2 = stringArray;
        return (PagingSource)new LimitOffsetPagingSource<PersonListDetails>(_rawQuery, this, roomDatabase, stringArray2){
            final /* synthetic */ PersonEntityDao_Impl this$0;
            {
                this.this$0 = $receiver;
                super($_rawQuery, $super_call_param$1, $super_call_param$2);
            }

            protected Object convertRows(RoomRawQuery limitOffsetQuery, int itemCount, Continuation<? super List<PersonListDetails>> $completion) {
                return DBUtil.performSuspending((RoomDatabase)PersonEntityDao_Impl.access$get__db$p(this.this$0), (boolean)true, (boolean)false, arg_0 -> findAllListDetailsAsPagingSource.1.convertRows$lambda$0(limitOffsetQuery, arg_0), $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static final List convertRows$lambda$0(RoomRawQuery $limitOffsetQuery, SQLiteConnection _connection) {
                List list2;
                Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
                SQLiteStatement _stmt = _connection.prepare($limitOffsetQuery.getSql());
                $limitOffsetQuery.getBindingFunction().invoke((Object)_stmt);
                try {
                    int _columnIndexOfGuid = 0;
                    int _columnIndexOfGivenName = 1;
                    int _columnIndexOfFamilyName = 2;
                    int _columnIndexOfUsername = 3;
                    List _result = new ArrayList<E>();
                    while (_stmt.step()) {
                        PersonListDetails _item = null;
                        String _tmpGuid = null;
                        _tmpGuid = _stmt.getText(_columnIndexOfGuid);
                        String _tmpGivenName = null;
                        _tmpGivenName = _stmt.getText(_columnIndexOfGivenName);
                        String _tmpFamilyName = null;
                        _tmpFamilyName = _stmt.getText(_columnIndexOfFamilyName);
                        String _tmpUsername = null;
                        _tmpUsername = _stmt.isNull(_columnIndexOfUsername) ? null : _stmt.getText(_columnIndexOfUsername);
                        _item = new PersonListDetails(_tmpGuid, _tmpGivenName, _tmpFamilyName, _tmpUsername, null, null);
                        _result.add(_item);
                    }
                    list2 = _result;
                }
                finally {
                    _stmt.close();
                }
                return list2;
            }
        };
    }

    @Override
    @Nullable
    public Object getAllUsers(@NotNull String sourcedId, @NotNull Continuation<? super List<PersonEntity>> $completion) {
        String _sql = "\n            SELECT * \n            FROM PersonEntity\n            WHERE pGuid = ?\n            ";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> PersonEntityDao_Impl.getAllUsers$lambda$0(_sql, sourcedId, this, arg_0), $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void __fetchRelationshipPersonRoleEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRoleEntity(SQLiteConnection _connection, LongSparseArray<List<PersonRoleEntity>> _map) {
        if (_map.isEmpty()) {
            return;
        }
        if (_map.size() > 999) {
            RelationUtil.recursiveFetchLongSparseArray(_map, (boolean)true, arg_0 -> PersonEntityDao_Impl.__fetchRelationshipPersonRoleEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRoleEntity$lambda$0(this, _connection, arg_0));
            return;
        }
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT `prUid`,`prPersonGuidHash`,`prIsPrimaryRole`,`prRoleEnum`,`prBeginDate`,`prEndDate` FROM `PersonRoleEntity` WHERE `prPersonGuidHash` IN (");
        int _inputSize = _map.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String string = _stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String _sql = string;
        SQLiteStatement _stmt = _connection.prepare(_sql);
        int _argIndex = 1;
        int n = _map.size();
        for (int i = 0; i < n; ++i) {
            long _item = _map.keyAt(i);
            _stmt.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        try {
            int _itemKeyIndex = SQLiteStatementUtil.getColumnIndex((SQLiteStatement)_stmt, (String)"prPersonGuidHash");
            if (_itemKeyIndex == -1) {
                return;
            }
            int _columnIndexOfPrUid = 0;
            int _columnIndexOfPrPersonGuidHash = 1;
            int _columnIndexOfPrIsPrimaryRole = 2;
            int _columnIndexOfPrRoleEnum = 3;
            int _columnIndexOfPrBeginDate = 4;
            int _columnIndexOfPrEndDate = 5;
            while (_stmt.step()) {
                long _tmpKey = 0L;
                _tmpKey = _stmt.getLong(_itemKeyIndex);
                List _tmpRelation = (List)_map.get(_tmpKey);
                if (_tmpRelation == null) continue;
                PersonRoleEntity _item_1 = null;
                int _tmpPrUid = 0;
                _tmpPrUid = (int)_stmt.getLong(_columnIndexOfPrUid);
                long _tmpPrPersonGuidHash = 0L;
                _tmpPrPersonGuidHash = _stmt.getLong(_columnIndexOfPrPersonGuidHash);
                boolean _tmpPrIsPrimaryRole = false;
                int _tmp = 0;
                _tmp = (int)_stmt.getLong(_columnIndexOfPrIsPrimaryRole);
                _tmpPrIsPrimaryRole = _tmp != 0;
                PersonRoleEnum _tmpPrRoleEnum = null;
                int _tmp_1 = 0;
                _tmp_1 = (int)_stmt.getLong(_columnIndexOfPrRoleEnum);
                _tmpPrRoleEnum = this.__schoolTypeConverters.toPersonRoleType(_tmp_1);
                LocalDate _tmpPrBeginDate = null;
                Long _tmp_2 = null;
                _tmp_2 = _stmt.isNull(_columnIndexOfPrBeginDate) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfPrBeginDate));
                _tmpPrBeginDate = this.__schoolTypeConverters.toLocalDate(_tmp_2);
                LocalDate _tmpPrEndDate = null;
                Long _tmp_3 = null;
                _tmp_3 = _stmt.isNull(_columnIndexOfPrEndDate) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfPrEndDate));
                _tmpPrEndDate = this.__schoolTypeConverters.toLocalDate(_tmp_3);
                _item_1 = new PersonRoleEntity(_tmpPrUid, _tmpPrPersonGuidHash, _tmpPrIsPrimaryRole, _tmpPrRoleEnum, _tmpPrBeginDate, _tmpPrEndDate);
                _tmpRelation.add(_item_1);
            }
        }
        finally {
            _stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void __fetchRelationshipPersonRelatedPersonEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRelatedPersonEntity(SQLiteConnection _connection, LongSparseArray<List<PersonRelatedPersonEntity>> _map) {
        if (_map.isEmpty()) {
            return;
        }
        if (_map.size() > 999) {
            RelationUtil.recursiveFetchLongSparseArray(_map, (boolean)true, arg_0 -> PersonEntityDao_Impl.__fetchRelationshipPersonRelatedPersonEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRelatedPersonEntity$lambda$0(this, _connection, arg_0));
            return;
        }
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT `prpUid`,`prpPersonUidNum`,`prpOtherPersonUid`,`prpOtherPersonUidNum` FROM `PersonRelatedPersonEntity` WHERE `prpPersonUidNum` IN (");
        int _inputSize = _map.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String string = _stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String _sql = string;
        SQLiteStatement _stmt = _connection.prepare(_sql);
        int _argIndex = 1;
        int n = _map.size();
        for (int i = 0; i < n; ++i) {
            long _item = _map.keyAt(i);
            _stmt.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        try {
            int _itemKeyIndex = SQLiteStatementUtil.getColumnIndex((SQLiteStatement)_stmt, (String)"prpPersonUidNum");
            if (_itemKeyIndex == -1) {
                return;
            }
            int _columnIndexOfPrpUid = 0;
            int _columnIndexOfPrpPersonUidNum = 1;
            int _columnIndexOfPrpOtherPersonUid = 2;
            int _columnIndexOfPrpOtherPersonUidNum = 3;
            while (_stmt.step()) {
                long _tmpKey = 0L;
                _tmpKey = _stmt.getLong(_itemKeyIndex);
                List _tmpRelation = (List)_map.get(_tmpKey);
                if (_tmpRelation == null) continue;
                PersonRelatedPersonEntity _item_1 = null;
                int _tmpPrpUid = 0;
                _tmpPrpUid = (int)_stmt.getLong(_columnIndexOfPrpUid);
                long _tmpPrpPersonUidNum = 0L;
                _tmpPrpPersonUidNum = _stmt.getLong(_columnIndexOfPrpPersonUidNum);
                String _tmpPrpOtherPersonUid = null;
                _tmpPrpOtherPersonUid = _stmt.getText(_columnIndexOfPrpOtherPersonUid);
                long _tmpPrpOtherPersonUidNum = 0L;
                _tmpPrpOtherPersonUidNum = _stmt.getLong(_columnIndexOfPrpOtherPersonUidNum);
                _item_1 = new PersonRelatedPersonEntity(_tmpPrpUid, _tmpPrpPersonUidNum, _tmpPrpOtherPersonUid, _tmpPrpOtherPersonUidNum);
                _tmpRelation.add(_item_1);
            }
        }
        finally {
            _stmt.close();
        }
    }

    private static final Unit insert$lambda$0(PersonEntityDao_Impl this$0, PersonEntity $personEntity, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        this$0.__insertAdapterOfPersonEntity.insert(_connection, (Object)$personEntity);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Long getLastModifiedByGuid$lambda$0(String $_sql, long $guidHash, SQLiteConnection _connection) {
        Long l;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, $guidHash);
            Long _result = null;
            _result = _stmt.step() ? (_stmt.isNull(0) ? null : Long.valueOf(_stmt.getLong(0))) : null;
            l = _result;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final PersonEntityWithRoles findByUsername$lambda$0(String $_sql, String $username, PersonEntityDao_Impl this$0, SQLiteConnection _connection) {
        PersonEntityWithRoles personEntityWithRoles;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindText(_argIndex, $username);
            int _columnIndexOfPGuid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pGuid");
            int _columnIndexOfPGuidHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pGuidHash");
            int _columnIndexOfPActive = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pActive");
            int _columnIndexOfPStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pStatus");
            int _columnIndexOfPLastModified = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pLastModified");
            int _columnIndexOfPStored = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pStored");
            int _columnIndexOfPMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pMetadata");
            int _columnIndexOfPUsername = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pUsername");
            int _columnIndexOfPGivenName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pGivenName");
            int _columnIndexOfPFamilyName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pFamilyName");
            int _columnIndexOfPMiddleName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pMiddleName");
            int _columnIndexOfPGender = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pGender");
            int _columnIndexOfPDateOfBirth = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pDateOfBirth");
            int _columnIndexOfPEmail = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pEmail");
            int _columnIndexOfPPhoneNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pPhoneNumber");
            LongSparseArray _collectionRoles = new LongSparseArray(0, 1, null);
            LongSparseArray _collectionRelatedPersons = new LongSparseArray(0, 1, null);
            while (_stmt.step()) {
                long _tmpKey = 0L;
                _tmpKey = _stmt.getLong(_columnIndexOfPGuidHash);
                if (!_collectionRoles.containsKey(_tmpKey)) {
                    _collectionRoles.put(_tmpKey, (Object)new ArrayList());
                }
                long _tmpKey_1 = 0L;
                _tmpKey_1 = _stmt.getLong(_columnIndexOfPGuidHash);
                if (_collectionRelatedPersons.containsKey(_tmpKey_1)) continue;
                _collectionRelatedPersons.put(_tmpKey_1, (Object)new ArrayList());
            }
            _stmt.reset();
            this$0.__fetchRelationshipPersonRoleEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRoleEntity(_connection, (LongSparseArray<List<PersonRoleEntity>>)_collectionRoles);
            this$0.__fetchRelationshipPersonRelatedPersonEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRelatedPersonEntity(_connection, (LongSparseArray<List<PersonRelatedPersonEntity>>)_collectionRelatedPersons);
            PersonEntityWithRoles _result = null;
            if (_stmt.step()) {
                PersonEntity _tmpPerson = null;
                String _tmpPGuid = null;
                _tmpPGuid = _stmt.getText(_columnIndexOfPGuid);
                long _tmpPGuidHash = 0L;
                _tmpPGuidHash = _stmt.getLong(_columnIndexOfPGuidHash);
                boolean _tmpPActive = false;
                int _tmp = 0;
                _tmp = (int)_stmt.getLong(_columnIndexOfPActive);
                _tmpPActive = _tmp != 0;
                PersonStatusEnum _tmpPStatus = null;
                int _tmp_1 = 0;
                _tmp_1 = (int)_stmt.getLong(_columnIndexOfPStatus);
                _tmpPStatus = this$0.__schoolTypeConverters.toPersonStatusEnum(_tmp_1);
                long _tmpPLastModified = 0L;
                _tmpPLastModified = _stmt.getLong(_columnIndexOfPLastModified);
                long _tmpPStored = 0L;
                _tmpPStored = _stmt.getLong(_columnIndexOfPStored);
                JsonObject _tmpPMetadata = null;
                String _tmp_2 = null;
                _tmp_2 = _stmt.isNull(_columnIndexOfPMetadata) ? null : _stmt.getText(_columnIndexOfPMetadata);
                _tmpPMetadata = this$0.__schoolTypeConverters.toJsonObject(_tmp_2);
                String _tmpPUsername = null;
                _tmpPUsername = _stmt.isNull(_columnIndexOfPUsername) ? null : _stmt.getText(_columnIndexOfPUsername);
                String _tmpPGivenName = null;
                _tmpPGivenName = _stmt.getText(_columnIndexOfPGivenName);
                String _tmpPFamilyName = null;
                _tmpPFamilyName = _stmt.getText(_columnIndexOfPFamilyName);
                String _tmpPMiddleName = null;
                _tmpPMiddleName = _stmt.isNull(_columnIndexOfPMiddleName) ? null : _stmt.getText(_columnIndexOfPMiddleName);
                PersonGenderEnum _tmpPGender = null;
                int _tmp_3 = 0;
                _tmp_3 = (int)_stmt.getLong(_columnIndexOfPGender);
                _tmpPGender = this$0.__schoolTypeConverters.toPersonGenderEnum(_tmp_3);
                LocalDate _tmpPDateOfBirth = null;
                Long _tmp_4 = null;
                _tmp_4 = _stmt.isNull(_columnIndexOfPDateOfBirth) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfPDateOfBirth));
                _tmpPDateOfBirth = this$0.__schoolTypeConverters.toLocalDate(_tmp_4);
                String _tmpPEmail = null;
                _tmpPEmail = _stmt.isNull(_columnIndexOfPEmail) ? null : _stmt.getText(_columnIndexOfPEmail);
                String _tmpPPhoneNumber = null;
                _tmpPPhoneNumber = _stmt.isNull(_columnIndexOfPPhoneNumber) ? null : _stmt.getText(_columnIndexOfPPhoneNumber);
                _tmpPerson = new PersonEntity(_tmpPGuid, _tmpPGuidHash, _tmpPActive, _tmpPStatus, _tmpPLastModified, _tmpPStored, _tmpPMetadata, _tmpPUsername, _tmpPGivenName, _tmpPFamilyName, _tmpPMiddleName, _tmpPGender, _tmpPDateOfBirth, _tmpPEmail, _tmpPPhoneNumber);
                List _tmpRolesCollection = null;
                long _tmpKey_2 = 0L;
                _tmpKey_2 = _stmt.getLong(_columnIndexOfPGuidHash);
                Object object = _collectionRoles.get(_tmpKey_2);
                if (object == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                _tmpRolesCollection = (List)object;
                List _tmpRelatedPersonsCollection = null;
                long _tmpKey_3 = 0L;
                _tmpKey_3 = _stmt.getLong(_columnIndexOfPGuidHash);
                Object object2 = _collectionRelatedPersons.get(_tmpKey_3);
                if (object2 == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                _tmpRelatedPersonsCollection = (List)object2;
                _result = new PersonEntityWithRoles(_tmpPerson, _tmpRolesCollection, _tmpRelatedPersonsCollection);
            } else {
                _result = null;
            }
            personEntityWithRoles = _result;
        }
        return personEntityWithRoles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final PersonEntityWithRoles findByGuidNum$lambda$0(String $_sql, long $guidHash, PersonEntityDao_Impl this$0, SQLiteConnection _connection) {
        PersonEntityWithRoles personEntityWithRoles;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, $guidHash);
            int _columnIndexOfPGuid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pGuid");
            int _columnIndexOfPGuidHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pGuidHash");
            int _columnIndexOfPActive = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pActive");
            int _columnIndexOfPStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pStatus");
            int _columnIndexOfPLastModified = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pLastModified");
            int _columnIndexOfPStored = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pStored");
            int _columnIndexOfPMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pMetadata");
            int _columnIndexOfPUsername = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pUsername");
            int _columnIndexOfPGivenName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pGivenName");
            int _columnIndexOfPFamilyName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pFamilyName");
            int _columnIndexOfPMiddleName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pMiddleName");
            int _columnIndexOfPGender = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pGender");
            int _columnIndexOfPDateOfBirth = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pDateOfBirth");
            int _columnIndexOfPEmail = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pEmail");
            int _columnIndexOfPPhoneNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pPhoneNumber");
            LongSparseArray _collectionRoles = new LongSparseArray(0, 1, null);
            LongSparseArray _collectionRelatedPersons = new LongSparseArray(0, 1, null);
            while (_stmt.step()) {
                long _tmpKey = 0L;
                _tmpKey = _stmt.getLong(_columnIndexOfPGuidHash);
                if (!_collectionRoles.containsKey(_tmpKey)) {
                    _collectionRoles.put(_tmpKey, (Object)new ArrayList());
                }
                long _tmpKey_1 = 0L;
                _tmpKey_1 = _stmt.getLong(_columnIndexOfPGuidHash);
                if (_collectionRelatedPersons.containsKey(_tmpKey_1)) continue;
                _collectionRelatedPersons.put(_tmpKey_1, (Object)new ArrayList());
            }
            _stmt.reset();
            this$0.__fetchRelationshipPersonRoleEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRoleEntity(_connection, (LongSparseArray<List<PersonRoleEntity>>)_collectionRoles);
            this$0.__fetchRelationshipPersonRelatedPersonEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRelatedPersonEntity(_connection, (LongSparseArray<List<PersonRelatedPersonEntity>>)_collectionRelatedPersons);
            PersonEntityWithRoles _result = null;
            if (_stmt.step()) {
                PersonEntity _tmpPerson = null;
                String _tmpPGuid = null;
                _tmpPGuid = _stmt.getText(_columnIndexOfPGuid);
                long _tmpPGuidHash = 0L;
                _tmpPGuidHash = _stmt.getLong(_columnIndexOfPGuidHash);
                boolean _tmpPActive = false;
                int _tmp = 0;
                _tmp = (int)_stmt.getLong(_columnIndexOfPActive);
                _tmpPActive = _tmp != 0;
                PersonStatusEnum _tmpPStatus = null;
                int _tmp_1 = 0;
                _tmp_1 = (int)_stmt.getLong(_columnIndexOfPStatus);
                _tmpPStatus = this$0.__schoolTypeConverters.toPersonStatusEnum(_tmp_1);
                long _tmpPLastModified = 0L;
                _tmpPLastModified = _stmt.getLong(_columnIndexOfPLastModified);
                long _tmpPStored = 0L;
                _tmpPStored = _stmt.getLong(_columnIndexOfPStored);
                JsonObject _tmpPMetadata = null;
                String _tmp_2 = null;
                _tmp_2 = _stmt.isNull(_columnIndexOfPMetadata) ? null : _stmt.getText(_columnIndexOfPMetadata);
                _tmpPMetadata = this$0.__schoolTypeConverters.toJsonObject(_tmp_2);
                String _tmpPUsername = null;
                _tmpPUsername = _stmt.isNull(_columnIndexOfPUsername) ? null : _stmt.getText(_columnIndexOfPUsername);
                String _tmpPGivenName = null;
                _tmpPGivenName = _stmt.getText(_columnIndexOfPGivenName);
                String _tmpPFamilyName = null;
                _tmpPFamilyName = _stmt.getText(_columnIndexOfPFamilyName);
                String _tmpPMiddleName = null;
                _tmpPMiddleName = _stmt.isNull(_columnIndexOfPMiddleName) ? null : _stmt.getText(_columnIndexOfPMiddleName);
                PersonGenderEnum _tmpPGender = null;
                int _tmp_3 = 0;
                _tmp_3 = (int)_stmt.getLong(_columnIndexOfPGender);
                _tmpPGender = this$0.__schoolTypeConverters.toPersonGenderEnum(_tmp_3);
                LocalDate _tmpPDateOfBirth = null;
                Long _tmp_4 = null;
                _tmp_4 = _stmt.isNull(_columnIndexOfPDateOfBirth) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfPDateOfBirth));
                _tmpPDateOfBirth = this$0.__schoolTypeConverters.toLocalDate(_tmp_4);
                String _tmpPEmail = null;
                _tmpPEmail = _stmt.isNull(_columnIndexOfPEmail) ? null : _stmt.getText(_columnIndexOfPEmail);
                String _tmpPPhoneNumber = null;
                _tmpPPhoneNumber = _stmt.isNull(_columnIndexOfPPhoneNumber) ? null : _stmt.getText(_columnIndexOfPPhoneNumber);
                _tmpPerson = new PersonEntity(_tmpPGuid, _tmpPGuidHash, _tmpPActive, _tmpPStatus, _tmpPLastModified, _tmpPStored, _tmpPMetadata, _tmpPUsername, _tmpPGivenName, _tmpPFamilyName, _tmpPMiddleName, _tmpPGender, _tmpPDateOfBirth, _tmpPEmail, _tmpPPhoneNumber);
                List _tmpRolesCollection = null;
                long _tmpKey_2 = 0L;
                _tmpKey_2 = _stmt.getLong(_columnIndexOfPGuidHash);
                Object object = _collectionRoles.get(_tmpKey_2);
                if (object == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                _tmpRolesCollection = (List)object;
                List _tmpRelatedPersonsCollection = null;
                long _tmpKey_3 = 0L;
                _tmpKey_3 = _stmt.getLong(_columnIndexOfPGuidHash);
                Object object2 = _collectionRelatedPersons.get(_tmpKey_3);
                if (object2 == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                _tmpRelatedPersonsCollection = (List)object2;
                _result = new PersonEntityWithRoles(_tmpPerson, _tmpRolesCollection, _tmpRelatedPersonsCollection);
            } else {
                _result = null;
            }
            personEntityWithRoles = _result;
        }
        return personEntityWithRoles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final PersonEntityWithRoles findByGuidHashAsFlow$lambda$0(String $_sql, long $guidHash, PersonEntityDao_Impl this$0, SQLiteConnection _connection) {
        PersonEntityWithRoles personEntityWithRoles;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, $guidHash);
            int _columnIndexOfPGuid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pGuid");
            int _columnIndexOfPGuidHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pGuidHash");
            int _columnIndexOfPActive = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pActive");
            int _columnIndexOfPStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pStatus");
            int _columnIndexOfPLastModified = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pLastModified");
            int _columnIndexOfPStored = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pStored");
            int _columnIndexOfPMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pMetadata");
            int _columnIndexOfPUsername = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pUsername");
            int _columnIndexOfPGivenName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pGivenName");
            int _columnIndexOfPFamilyName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pFamilyName");
            int _columnIndexOfPMiddleName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pMiddleName");
            int _columnIndexOfPGender = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pGender");
            int _columnIndexOfPDateOfBirth = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pDateOfBirth");
            int _columnIndexOfPEmail = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pEmail");
            int _columnIndexOfPPhoneNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pPhoneNumber");
            LongSparseArray _collectionRoles = new LongSparseArray(0, 1, null);
            LongSparseArray _collectionRelatedPersons = new LongSparseArray(0, 1, null);
            while (_stmt.step()) {
                long _tmpKey = 0L;
                _tmpKey = _stmt.getLong(_columnIndexOfPGuidHash);
                if (!_collectionRoles.containsKey(_tmpKey)) {
                    _collectionRoles.put(_tmpKey, (Object)new ArrayList());
                }
                long _tmpKey_1 = 0L;
                _tmpKey_1 = _stmt.getLong(_columnIndexOfPGuidHash);
                if (_collectionRelatedPersons.containsKey(_tmpKey_1)) continue;
                _collectionRelatedPersons.put(_tmpKey_1, (Object)new ArrayList());
            }
            _stmt.reset();
            this$0.__fetchRelationshipPersonRoleEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRoleEntity(_connection, (LongSparseArray<List<PersonRoleEntity>>)_collectionRoles);
            this$0.__fetchRelationshipPersonRelatedPersonEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRelatedPersonEntity(_connection, (LongSparseArray<List<PersonRelatedPersonEntity>>)_collectionRelatedPersons);
            PersonEntityWithRoles _result = null;
            if (_stmt.step()) {
                PersonEntity _tmpPerson = null;
                String _tmpPGuid = null;
                _tmpPGuid = _stmt.getText(_columnIndexOfPGuid);
                long _tmpPGuidHash = 0L;
                _tmpPGuidHash = _stmt.getLong(_columnIndexOfPGuidHash);
                boolean _tmpPActive = false;
                int _tmp = 0;
                _tmp = (int)_stmt.getLong(_columnIndexOfPActive);
                _tmpPActive = _tmp != 0;
                PersonStatusEnum _tmpPStatus = null;
                int _tmp_1 = 0;
                _tmp_1 = (int)_stmt.getLong(_columnIndexOfPStatus);
                _tmpPStatus = this$0.__schoolTypeConverters.toPersonStatusEnum(_tmp_1);
                long _tmpPLastModified = 0L;
                _tmpPLastModified = _stmt.getLong(_columnIndexOfPLastModified);
                long _tmpPStored = 0L;
                _tmpPStored = _stmt.getLong(_columnIndexOfPStored);
                JsonObject _tmpPMetadata = null;
                String _tmp_2 = null;
                _tmp_2 = _stmt.isNull(_columnIndexOfPMetadata) ? null : _stmt.getText(_columnIndexOfPMetadata);
                _tmpPMetadata = this$0.__schoolTypeConverters.toJsonObject(_tmp_2);
                String _tmpPUsername = null;
                _tmpPUsername = _stmt.isNull(_columnIndexOfPUsername) ? null : _stmt.getText(_columnIndexOfPUsername);
                String _tmpPGivenName = null;
                _tmpPGivenName = _stmt.getText(_columnIndexOfPGivenName);
                String _tmpPFamilyName = null;
                _tmpPFamilyName = _stmt.getText(_columnIndexOfPFamilyName);
                String _tmpPMiddleName = null;
                _tmpPMiddleName = _stmt.isNull(_columnIndexOfPMiddleName) ? null : _stmt.getText(_columnIndexOfPMiddleName);
                PersonGenderEnum _tmpPGender = null;
                int _tmp_3 = 0;
                _tmp_3 = (int)_stmt.getLong(_columnIndexOfPGender);
                _tmpPGender = this$0.__schoolTypeConverters.toPersonGenderEnum(_tmp_3);
                LocalDate _tmpPDateOfBirth = null;
                Long _tmp_4 = null;
                _tmp_4 = _stmt.isNull(_columnIndexOfPDateOfBirth) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfPDateOfBirth));
                _tmpPDateOfBirth = this$0.__schoolTypeConverters.toLocalDate(_tmp_4);
                String _tmpPEmail = null;
                _tmpPEmail = _stmt.isNull(_columnIndexOfPEmail) ? null : _stmt.getText(_columnIndexOfPEmail);
                String _tmpPPhoneNumber = null;
                _tmpPPhoneNumber = _stmt.isNull(_columnIndexOfPPhoneNumber) ? null : _stmt.getText(_columnIndexOfPPhoneNumber);
                _tmpPerson = new PersonEntity(_tmpPGuid, _tmpPGuidHash, _tmpPActive, _tmpPStatus, _tmpPLastModified, _tmpPStored, _tmpPMetadata, _tmpPUsername, _tmpPGivenName, _tmpPFamilyName, _tmpPMiddleName, _tmpPGender, _tmpPDateOfBirth, _tmpPEmail, _tmpPPhoneNumber);
                List _tmpRolesCollection = null;
                long _tmpKey_2 = 0L;
                _tmpKey_2 = _stmt.getLong(_columnIndexOfPGuidHash);
                Object object = _collectionRoles.get(_tmpKey_2);
                if (object == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                _tmpRolesCollection = (List)object;
                List _tmpRelatedPersonsCollection = null;
                long _tmpKey_3 = 0L;
                _tmpKey_3 = _stmt.getLong(_columnIndexOfPGuidHash);
                Object object2 = _collectionRelatedPersons.get(_tmpKey_3);
                if (object2 == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                _tmpRelatedPersonsCollection = (List)object2;
                _result = new PersonEntityWithRoles(_tmpPerson, _tmpRolesCollection, _tmpRelatedPersonsCollection);
            } else {
                _result = null;
            }
            personEntityWithRoles = _result;
        }
        return personEntityWithRoles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List findAllListDetailsAsFlow$lambda$0(String $_sql, SQLiteConnection _connection) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _columnIndexOfGuid = 0;
            int _columnIndexOfGivenName = 1;
            int _columnIndexOfFamilyName = 2;
            int _columnIndexOfUsername = 3;
            List _result = new ArrayList();
            while (_stmt.step()) {
                PersonListDetails _item = null;
                String _tmpGuid = null;
                _tmpGuid = _stmt.getText(_columnIndexOfGuid);
                String _tmpGivenName = null;
                _tmpGivenName = _stmt.getText(_columnIndexOfGivenName);
                String _tmpFamilyName = null;
                _tmpFamilyName = _stmt.getText(_columnIndexOfFamilyName);
                String _tmpUsername = null;
                _tmpUsername = _stmt.isNull(_columnIndexOfUsername) ? null : _stmt.getText(_columnIndexOfUsername);
                _item = new PersonListDetails(_tmpGuid, _tmpGivenName, _tmpFamilyName, _tmpUsername, null, null);
                _result.add(_item);
            }
            list2 = _result;
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List findAllAsFlow$lambda$0(String $_sql, PersonEntityDao_Impl this$0, SQLiteConnection _connection) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _columnIndexOfPGuid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pGuid");
            int _columnIndexOfPGuidHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pGuidHash");
            int _columnIndexOfPActive = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pActive");
            int _columnIndexOfPStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pStatus");
            int _columnIndexOfPLastModified = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pLastModified");
            int _columnIndexOfPStored = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pStored");
            int _columnIndexOfPMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pMetadata");
            int _columnIndexOfPUsername = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pUsername");
            int _columnIndexOfPGivenName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pGivenName");
            int _columnIndexOfPFamilyName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pFamilyName");
            int _columnIndexOfPMiddleName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pMiddleName");
            int _columnIndexOfPGender = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pGender");
            int _columnIndexOfPDateOfBirth = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pDateOfBirth");
            int _columnIndexOfPEmail = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pEmail");
            int _columnIndexOfPPhoneNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pPhoneNumber");
            LongSparseArray _collectionRoles = new LongSparseArray(0, 1, null);
            LongSparseArray _collectionRelatedPersons = new LongSparseArray(0, 1, null);
            while (_stmt.step()) {
                long _tmpKey = 0L;
                _tmpKey = _stmt.getLong(_columnIndexOfPGuidHash);
                if (!_collectionRoles.containsKey(_tmpKey)) {
                    _collectionRoles.put(_tmpKey, (Object)new ArrayList());
                }
                long _tmpKey_1 = 0L;
                _tmpKey_1 = _stmt.getLong(_columnIndexOfPGuidHash);
                if (_collectionRelatedPersons.containsKey(_tmpKey_1)) continue;
                _collectionRelatedPersons.put(_tmpKey_1, (Object)new ArrayList());
            }
            _stmt.reset();
            this$0.__fetchRelationshipPersonRoleEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRoleEntity(_connection, (LongSparseArray<List<PersonRoleEntity>>)_collectionRoles);
            this$0.__fetchRelationshipPersonRelatedPersonEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRelatedPersonEntity(_connection, (LongSparseArray<List<PersonRelatedPersonEntity>>)_collectionRelatedPersons);
            List _result = new ArrayList();
            while (_stmt.step()) {
                PersonEntityWithRoles _item = null;
                PersonEntity _tmpPerson = null;
                String _tmpPGuid = null;
                _tmpPGuid = _stmt.getText(_columnIndexOfPGuid);
                long _tmpPGuidHash = 0L;
                _tmpPGuidHash = _stmt.getLong(_columnIndexOfPGuidHash);
                boolean _tmpPActive = false;
                int _tmp = 0;
                _tmp = (int)_stmt.getLong(_columnIndexOfPActive);
                _tmpPActive = _tmp != 0;
                PersonStatusEnum _tmpPStatus = null;
                int _tmp_1 = 0;
                _tmp_1 = (int)_stmt.getLong(_columnIndexOfPStatus);
                _tmpPStatus = this$0.__schoolTypeConverters.toPersonStatusEnum(_tmp_1);
                long _tmpPLastModified = 0L;
                _tmpPLastModified = _stmt.getLong(_columnIndexOfPLastModified);
                long _tmpPStored = 0L;
                _tmpPStored = _stmt.getLong(_columnIndexOfPStored);
                JsonObject _tmpPMetadata = null;
                String _tmp_2 = null;
                _tmp_2 = _stmt.isNull(_columnIndexOfPMetadata) ? null : _stmt.getText(_columnIndexOfPMetadata);
                _tmpPMetadata = this$0.__schoolTypeConverters.toJsonObject(_tmp_2);
                String _tmpPUsername = null;
                _tmpPUsername = _stmt.isNull(_columnIndexOfPUsername) ? null : _stmt.getText(_columnIndexOfPUsername);
                String _tmpPGivenName = null;
                _tmpPGivenName = _stmt.getText(_columnIndexOfPGivenName);
                String _tmpPFamilyName = null;
                _tmpPFamilyName = _stmt.getText(_columnIndexOfPFamilyName);
                String _tmpPMiddleName = null;
                _tmpPMiddleName = _stmt.isNull(_columnIndexOfPMiddleName) ? null : _stmt.getText(_columnIndexOfPMiddleName);
                PersonGenderEnum _tmpPGender = null;
                int _tmp_3 = 0;
                _tmp_3 = (int)_stmt.getLong(_columnIndexOfPGender);
                _tmpPGender = this$0.__schoolTypeConverters.toPersonGenderEnum(_tmp_3);
                LocalDate _tmpPDateOfBirth = null;
                Long _tmp_4 = null;
                _tmp_4 = _stmt.isNull(_columnIndexOfPDateOfBirth) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfPDateOfBirth));
                _tmpPDateOfBirth = this$0.__schoolTypeConverters.toLocalDate(_tmp_4);
                String _tmpPEmail = null;
                _tmpPEmail = _stmt.isNull(_columnIndexOfPEmail) ? null : _stmt.getText(_columnIndexOfPEmail);
                String _tmpPPhoneNumber = null;
                _tmpPPhoneNumber = _stmt.isNull(_columnIndexOfPPhoneNumber) ? null : _stmt.getText(_columnIndexOfPPhoneNumber);
                _tmpPerson = new PersonEntity(_tmpPGuid, _tmpPGuidHash, _tmpPActive, _tmpPStatus, _tmpPLastModified, _tmpPStored, _tmpPMetadata, _tmpPUsername, _tmpPGivenName, _tmpPFamilyName, _tmpPMiddleName, _tmpPGender, _tmpPDateOfBirth, _tmpPEmail, _tmpPPhoneNumber);
                List _tmpRolesCollection = null;
                long _tmpKey_2 = 0L;
                _tmpKey_2 = _stmt.getLong(_columnIndexOfPGuidHash);
                Object object = _collectionRoles.get(_tmpKey_2);
                if (object == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                _tmpRolesCollection = (List)object;
                List _tmpRelatedPersonsCollection = null;
                long _tmpKey_3 = 0L;
                _tmpKey_3 = _stmt.getLong(_columnIndexOfPGuidHash);
                Object object2 = _collectionRelatedPersons.get(_tmpKey_3);
                if (object2 == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                _tmpRelatedPersonsCollection = (List)object2;
                _item = new PersonEntityWithRoles(_tmpPerson, _tmpRolesCollection, _tmpRelatedPersonsCollection);
                _result.add(_item);
            }
            list2 = _result;
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List findAll$lambda$0(String $_sql, long $since, PersonEntityDao_Impl this$0, SQLiteConnection _connection) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, $since);
            int _columnIndexOfPGuid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pGuid");
            int _columnIndexOfPGuidHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pGuidHash");
            int _columnIndexOfPActive = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pActive");
            int _columnIndexOfPStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pStatus");
            int _columnIndexOfPLastModified = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pLastModified");
            int _columnIndexOfPStored = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pStored");
            int _columnIndexOfPMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pMetadata");
            int _columnIndexOfPUsername = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pUsername");
            int _columnIndexOfPGivenName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pGivenName");
            int _columnIndexOfPFamilyName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pFamilyName");
            int _columnIndexOfPMiddleName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pMiddleName");
            int _columnIndexOfPGender = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pGender");
            int _columnIndexOfPDateOfBirth = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pDateOfBirth");
            int _columnIndexOfPEmail = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pEmail");
            int _columnIndexOfPPhoneNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pPhoneNumber");
            LongSparseArray _collectionRoles = new LongSparseArray(0, 1, null);
            LongSparseArray _collectionRelatedPersons = new LongSparseArray(0, 1, null);
            while (_stmt.step()) {
                long _tmpKey = 0L;
                _tmpKey = _stmt.getLong(_columnIndexOfPGuidHash);
                if (!_collectionRoles.containsKey(_tmpKey)) {
                    _collectionRoles.put(_tmpKey, (Object)new ArrayList());
                }
                long _tmpKey_1 = 0L;
                _tmpKey_1 = _stmt.getLong(_columnIndexOfPGuidHash);
                if (_collectionRelatedPersons.containsKey(_tmpKey_1)) continue;
                _collectionRelatedPersons.put(_tmpKey_1, (Object)new ArrayList());
            }
            _stmt.reset();
            this$0.__fetchRelationshipPersonRoleEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRoleEntity(_connection, (LongSparseArray<List<PersonRoleEntity>>)_collectionRoles);
            this$0.__fetchRelationshipPersonRelatedPersonEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRelatedPersonEntity(_connection, (LongSparseArray<List<PersonRelatedPersonEntity>>)_collectionRelatedPersons);
            List _result = new ArrayList();
            while (_stmt.step()) {
                PersonEntityWithRoles _item = null;
                PersonEntity _tmpPerson = null;
                String _tmpPGuid = null;
                _tmpPGuid = _stmt.getText(_columnIndexOfPGuid);
                long _tmpPGuidHash = 0L;
                _tmpPGuidHash = _stmt.getLong(_columnIndexOfPGuidHash);
                boolean _tmpPActive = false;
                int _tmp = 0;
                _tmp = (int)_stmt.getLong(_columnIndexOfPActive);
                _tmpPActive = _tmp != 0;
                PersonStatusEnum _tmpPStatus = null;
                int _tmp_1 = 0;
                _tmp_1 = (int)_stmt.getLong(_columnIndexOfPStatus);
                _tmpPStatus = this$0.__schoolTypeConverters.toPersonStatusEnum(_tmp_1);
                long _tmpPLastModified = 0L;
                _tmpPLastModified = _stmt.getLong(_columnIndexOfPLastModified);
                long _tmpPStored = 0L;
                _tmpPStored = _stmt.getLong(_columnIndexOfPStored);
                JsonObject _tmpPMetadata = null;
                String _tmp_2 = null;
                _tmp_2 = _stmt.isNull(_columnIndexOfPMetadata) ? null : _stmt.getText(_columnIndexOfPMetadata);
                _tmpPMetadata = this$0.__schoolTypeConverters.toJsonObject(_tmp_2);
                String _tmpPUsername = null;
                _tmpPUsername = _stmt.isNull(_columnIndexOfPUsername) ? null : _stmt.getText(_columnIndexOfPUsername);
                String _tmpPGivenName = null;
                _tmpPGivenName = _stmt.getText(_columnIndexOfPGivenName);
                String _tmpPFamilyName = null;
                _tmpPFamilyName = _stmt.getText(_columnIndexOfPFamilyName);
                String _tmpPMiddleName = null;
                _tmpPMiddleName = _stmt.isNull(_columnIndexOfPMiddleName) ? null : _stmt.getText(_columnIndexOfPMiddleName);
                PersonGenderEnum _tmpPGender = null;
                int _tmp_3 = 0;
                _tmp_3 = (int)_stmt.getLong(_columnIndexOfPGender);
                _tmpPGender = this$0.__schoolTypeConverters.toPersonGenderEnum(_tmp_3);
                LocalDate _tmpPDateOfBirth = null;
                Long _tmp_4 = null;
                _tmp_4 = _stmt.isNull(_columnIndexOfPDateOfBirth) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfPDateOfBirth));
                _tmpPDateOfBirth = this$0.__schoolTypeConverters.toLocalDate(_tmp_4);
                String _tmpPEmail = null;
                _tmpPEmail = _stmt.isNull(_columnIndexOfPEmail) ? null : _stmt.getText(_columnIndexOfPEmail);
                String _tmpPPhoneNumber = null;
                _tmpPPhoneNumber = _stmt.isNull(_columnIndexOfPPhoneNumber) ? null : _stmt.getText(_columnIndexOfPPhoneNumber);
                _tmpPerson = new PersonEntity(_tmpPGuid, _tmpPGuidHash, _tmpPActive, _tmpPStatus, _tmpPLastModified, _tmpPStored, _tmpPMetadata, _tmpPUsername, _tmpPGivenName, _tmpPFamilyName, _tmpPMiddleName, _tmpPGender, _tmpPDateOfBirth, _tmpPEmail, _tmpPPhoneNumber);
                List _tmpRolesCollection = null;
                long _tmpKey_2 = 0L;
                _tmpKey_2 = _stmt.getLong(_columnIndexOfPGuidHash);
                Object object = _collectionRoles.get(_tmpKey_2);
                if (object == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                _tmpRolesCollection = (List)object;
                List _tmpRelatedPersonsCollection = null;
                long _tmpKey_3 = 0L;
                _tmpKey_3 = _stmt.getLong(_columnIndexOfPGuidHash);
                Object object2 = _collectionRelatedPersons.get(_tmpKey_3);
                if (object2 == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                _tmpRelatedPersonsCollection = (List)object2;
                _item = new PersonEntityWithRoles(_tmpPerson, _tmpRolesCollection, _tmpRelatedPersonsCollection);
                _result.add(_item);
            }
            list2 = _result;
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List findByUidList$lambda$0(String $_sql, List $uidNums, PersonEntityDao_Impl this$0, SQLiteConnection _connection) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            Iterator iterator = $uidNums.iterator();
            while (iterator.hasNext()) {
                long _item = ((Number)iterator.next()).longValue();
                _stmt.bindLong(_argIndex, _item);
                ++_argIndex;
            }
            int _columnIndexOfPGuid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pGuid");
            int _columnIndexOfPGuidHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pGuidHash");
            int _columnIndexOfPActive = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pActive");
            int _columnIndexOfPStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pStatus");
            int _columnIndexOfPLastModified = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pLastModified");
            int _columnIndexOfPStored = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pStored");
            int _columnIndexOfPMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pMetadata");
            int _columnIndexOfPUsername = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pUsername");
            int _columnIndexOfPGivenName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pGivenName");
            int _columnIndexOfPFamilyName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pFamilyName");
            int _columnIndexOfPMiddleName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pMiddleName");
            int _columnIndexOfPGender = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pGender");
            int _columnIndexOfPDateOfBirth = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pDateOfBirth");
            int _columnIndexOfPEmail = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pEmail");
            int _columnIndexOfPPhoneNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pPhoneNumber");
            LongSparseArray _collectionRoles = new LongSparseArray(0, 1, null);
            LongSparseArray _collectionRelatedPersons = new LongSparseArray(0, 1, null);
            while (_stmt.step()) {
                long _tmpKey = 0L;
                _tmpKey = _stmt.getLong(_columnIndexOfPGuidHash);
                if (!_collectionRoles.containsKey(_tmpKey)) {
                    _collectionRoles.put(_tmpKey, (Object)new ArrayList());
                }
                long _tmpKey_1 = 0L;
                _tmpKey_1 = _stmt.getLong(_columnIndexOfPGuidHash);
                if (_collectionRelatedPersons.containsKey(_tmpKey_1)) continue;
                _collectionRelatedPersons.put(_tmpKey_1, (Object)new ArrayList());
            }
            _stmt.reset();
            this$0.__fetchRelationshipPersonRoleEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRoleEntity(_connection, (LongSparseArray<List<PersonRoleEntity>>)_collectionRoles);
            this$0.__fetchRelationshipPersonRelatedPersonEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRelatedPersonEntity(_connection, (LongSparseArray<List<PersonRelatedPersonEntity>>)_collectionRelatedPersons);
            List _result = new ArrayList();
            while (_stmt.step()) {
                PersonEntityWithRoles _item_1 = null;
                PersonEntity _tmpPerson = null;
                String _tmpPGuid = null;
                _tmpPGuid = _stmt.getText(_columnIndexOfPGuid);
                long _tmpPGuidHash = 0L;
                _tmpPGuidHash = _stmt.getLong(_columnIndexOfPGuidHash);
                boolean _tmpPActive = false;
                int _tmp = 0;
                _tmp = (int)_stmt.getLong(_columnIndexOfPActive);
                _tmpPActive = _tmp != 0;
                PersonStatusEnum _tmpPStatus = null;
                int _tmp_1 = 0;
                _tmp_1 = (int)_stmt.getLong(_columnIndexOfPStatus);
                _tmpPStatus = this$0.__schoolTypeConverters.toPersonStatusEnum(_tmp_1);
                long _tmpPLastModified = 0L;
                _tmpPLastModified = _stmt.getLong(_columnIndexOfPLastModified);
                long _tmpPStored = 0L;
                _tmpPStored = _stmt.getLong(_columnIndexOfPStored);
                JsonObject _tmpPMetadata = null;
                String _tmp_2 = null;
                _tmp_2 = _stmt.isNull(_columnIndexOfPMetadata) ? null : _stmt.getText(_columnIndexOfPMetadata);
                _tmpPMetadata = this$0.__schoolTypeConverters.toJsonObject(_tmp_2);
                String _tmpPUsername = null;
                _tmpPUsername = _stmt.isNull(_columnIndexOfPUsername) ? null : _stmt.getText(_columnIndexOfPUsername);
                String _tmpPGivenName = null;
                _tmpPGivenName = _stmt.getText(_columnIndexOfPGivenName);
                String _tmpPFamilyName = null;
                _tmpPFamilyName = _stmt.getText(_columnIndexOfPFamilyName);
                String _tmpPMiddleName = null;
                _tmpPMiddleName = _stmt.isNull(_columnIndexOfPMiddleName) ? null : _stmt.getText(_columnIndexOfPMiddleName);
                PersonGenderEnum _tmpPGender = null;
                int _tmp_3 = 0;
                _tmp_3 = (int)_stmt.getLong(_columnIndexOfPGender);
                _tmpPGender = this$0.__schoolTypeConverters.toPersonGenderEnum(_tmp_3);
                LocalDate _tmpPDateOfBirth = null;
                Long _tmp_4 = null;
                _tmp_4 = _stmt.isNull(_columnIndexOfPDateOfBirth) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfPDateOfBirth));
                _tmpPDateOfBirth = this$0.__schoolTypeConverters.toLocalDate(_tmp_4);
                String _tmpPEmail = null;
                _tmpPEmail = _stmt.isNull(_columnIndexOfPEmail) ? null : _stmt.getText(_columnIndexOfPEmail);
                String _tmpPPhoneNumber = null;
                _tmpPPhoneNumber = _stmt.isNull(_columnIndexOfPPhoneNumber) ? null : _stmt.getText(_columnIndexOfPPhoneNumber);
                _tmpPerson = new PersonEntity(_tmpPGuid, _tmpPGuidHash, _tmpPActive, _tmpPStatus, _tmpPLastModified, _tmpPStored, _tmpPMetadata, _tmpPUsername, _tmpPGivenName, _tmpPFamilyName, _tmpPMiddleName, _tmpPGender, _tmpPDateOfBirth, _tmpPEmail, _tmpPPhoneNumber);
                List _tmpRolesCollection = null;
                long _tmpKey_2 = 0L;
                _tmpKey_2 = _stmt.getLong(_columnIndexOfPGuidHash);
                Object object = _collectionRoles.get(_tmpKey_2);
                if (object == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                _tmpRolesCollection = (List)object;
                List _tmpRelatedPersonsCollection = null;
                long _tmpKey_3 = 0L;
                _tmpKey_3 = _stmt.getLong(_columnIndexOfPGuidHash);
                Object object2 = _collectionRelatedPersons.get(_tmpKey_3);
                if (object2 == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                _tmpRelatedPersonsCollection = (List)object2;
                _item_1 = new PersonEntityWithRoles(_tmpPerson, _tmpRolesCollection, _tmpRelatedPersonsCollection);
                _result.add(_item_1);
            }
            list2 = _result;
        }
        return list2;
    }

    private static final Unit findAllAsPagingSource$lambda$0(long $since, long $guidHash, long $inClazzGuidHash, int $inClazzRoleFlag, long $timeNow, String $filterByName, SQLiteStatement _stmt) {
        Intrinsics.checkNotNullParameter((Object)_stmt, (String)"_stmt");
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, $since);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, $guidHash);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, $guidHash);
        _argIndex = 4;
        _stmt.bindLong(_argIndex, $inClazzGuidHash);
        _argIndex = 5;
        _stmt.bindLong(_argIndex, $inClazzGuidHash);
        _argIndex = 6;
        _stmt.bindLong(_argIndex, (long)$inClazzRoleFlag);
        _argIndex = 7;
        _stmt.bindLong(_argIndex, (long)$inClazzRoleFlag);
        _argIndex = 8;
        _stmt.bindLong(_argIndex, $timeNow);
        _argIndex = 9;
        if ($filterByName == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindText(_argIndex, $filterByName);
        }
        _argIndex = 10;
        if ($filterByName == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindText(_argIndex, $filterByName);
        }
        return Unit.INSTANCE;
    }

    private static final Unit findAllListDetailsAsPagingSource$lambda$0(long $since, long $guidHash, long $inClazzGuidHash, int $inClazzRoleFlag, long $timeNow, String $filterByName, SQLiteStatement _stmt) {
        Intrinsics.checkNotNullParameter((Object)_stmt, (String)"_stmt");
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, $since);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, $guidHash);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, $guidHash);
        _argIndex = 4;
        _stmt.bindLong(_argIndex, $inClazzGuidHash);
        _argIndex = 5;
        _stmt.bindLong(_argIndex, $inClazzGuidHash);
        _argIndex = 6;
        _stmt.bindLong(_argIndex, (long)$inClazzRoleFlag);
        _argIndex = 7;
        _stmt.bindLong(_argIndex, (long)$inClazzRoleFlag);
        _argIndex = 8;
        _stmt.bindLong(_argIndex, $timeNow);
        _argIndex = 9;
        if ($filterByName == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindText(_argIndex, $filterByName);
        }
        _argIndex = 10;
        if ($filterByName == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindText(_argIndex, $filterByName);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List getAllUsers$lambda$0(String $_sql, String $sourcedId, PersonEntityDao_Impl this$0, SQLiteConnection _connection) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindText(_argIndex, $sourcedId);
            int _columnIndexOfPGuid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pGuid");
            int _columnIndexOfPGuidHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pGuidHash");
            int _columnIndexOfPActive = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pActive");
            int _columnIndexOfPStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pStatus");
            int _columnIndexOfPLastModified = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pLastModified");
            int _columnIndexOfPStored = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pStored");
            int _columnIndexOfPMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pMetadata");
            int _columnIndexOfPUsername = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pUsername");
            int _columnIndexOfPGivenName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pGivenName");
            int _columnIndexOfPFamilyName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pFamilyName");
            int _columnIndexOfPMiddleName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pMiddleName");
            int _columnIndexOfPGender = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pGender");
            int _columnIndexOfPDateOfBirth = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pDateOfBirth");
            int _columnIndexOfPEmail = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pEmail");
            int _columnIndexOfPPhoneNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pPhoneNumber");
            List _result = new ArrayList();
            while (_stmt.step()) {
                PersonEntity _item = null;
                String _tmpPGuid = null;
                _tmpPGuid = _stmt.getText(_columnIndexOfPGuid);
                long _tmpPGuidHash = 0L;
                _tmpPGuidHash = _stmt.getLong(_columnIndexOfPGuidHash);
                boolean _tmpPActive = false;
                int _tmp = 0;
                _tmp = (int)_stmt.getLong(_columnIndexOfPActive);
                _tmpPActive = _tmp != 0;
                PersonStatusEnum _tmpPStatus = null;
                int _tmp_1 = 0;
                _tmp_1 = (int)_stmt.getLong(_columnIndexOfPStatus);
                _tmpPStatus = this$0.__schoolTypeConverters.toPersonStatusEnum(_tmp_1);
                long _tmpPLastModified = 0L;
                _tmpPLastModified = _stmt.getLong(_columnIndexOfPLastModified);
                long _tmpPStored = 0L;
                _tmpPStored = _stmt.getLong(_columnIndexOfPStored);
                JsonObject _tmpPMetadata = null;
                String _tmp_2 = null;
                _tmp_2 = _stmt.isNull(_columnIndexOfPMetadata) ? null : _stmt.getText(_columnIndexOfPMetadata);
                _tmpPMetadata = this$0.__schoolTypeConverters.toJsonObject(_tmp_2);
                String _tmpPUsername = null;
                _tmpPUsername = _stmt.isNull(_columnIndexOfPUsername) ? null : _stmt.getText(_columnIndexOfPUsername);
                String _tmpPGivenName = null;
                _tmpPGivenName = _stmt.getText(_columnIndexOfPGivenName);
                String _tmpPFamilyName = null;
                _tmpPFamilyName = _stmt.getText(_columnIndexOfPFamilyName);
                String _tmpPMiddleName = null;
                _tmpPMiddleName = _stmt.isNull(_columnIndexOfPMiddleName) ? null : _stmt.getText(_columnIndexOfPMiddleName);
                PersonGenderEnum _tmpPGender = null;
                int _tmp_3 = 0;
                _tmp_3 = (int)_stmt.getLong(_columnIndexOfPGender);
                _tmpPGender = this$0.__schoolTypeConverters.toPersonGenderEnum(_tmp_3);
                LocalDate _tmpPDateOfBirth = null;
                Long _tmp_4 = null;
                _tmp_4 = _stmt.isNull(_columnIndexOfPDateOfBirth) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfPDateOfBirth));
                _tmpPDateOfBirth = this$0.__schoolTypeConverters.toLocalDate(_tmp_4);
                String _tmpPEmail = null;
                _tmpPEmail = _stmt.isNull(_columnIndexOfPEmail) ? null : _stmt.getText(_columnIndexOfPEmail);
                String _tmpPPhoneNumber = null;
                _tmpPPhoneNumber = _stmt.isNull(_columnIndexOfPPhoneNumber) ? null : _stmt.getText(_columnIndexOfPPhoneNumber);
                _item = new PersonEntity(_tmpPGuid, _tmpPGuidHash, _tmpPActive, _tmpPStatus, _tmpPLastModified, _tmpPStored, _tmpPMetadata, _tmpPUsername, _tmpPGivenName, _tmpPFamilyName, _tmpPMiddleName, _tmpPGender, _tmpPDateOfBirth, _tmpPEmail, _tmpPPhoneNumber);
                _result.add(_item);
            }
            list2 = _result;
        }
        return list2;
    }

    private static final Unit __fetchRelationshipPersonRoleEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRoleEntity$lambda$0(PersonEntityDao_Impl this$0, SQLiteConnection $_connection, LongSparseArray _tmpMap) {
        Intrinsics.checkNotNullParameter((Object)_tmpMap, (String)"_tmpMap");
        this$0.__fetchRelationshipPersonRoleEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRoleEntity($_connection, (LongSparseArray<List<PersonRoleEntity>>)_tmpMap);
        return Unit.INSTANCE;
    }

    private static final Unit __fetchRelationshipPersonRelatedPersonEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRelatedPersonEntity$lambda$0(PersonEntityDao_Impl this$0, SQLiteConnection $_connection, LongSparseArray _tmpMap) {
        Intrinsics.checkNotNullParameter((Object)_tmpMap, (String)"_tmpMap");
        this$0.__fetchRelationshipPersonRelatedPersonEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRelatedPersonEntity($_connection, (LongSparseArray<List<PersonRelatedPersonEntity>>)_tmpMap);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ RoomDatabase access$get__db$p(PersonEntityDao_Impl $this) {
        return $this.__db;
    }

    public static final /* synthetic */ void access$__fetchRelationshipPersonRoleEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRoleEntity(PersonEntityDao_Impl $this, SQLiteConnection _connection, LongSparseArray _map) {
        $this.__fetchRelationshipPersonRoleEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRoleEntity(_connection, (LongSparseArray<List<PersonRoleEntity>>)_map);
    }

    public static final /* synthetic */ void access$__fetchRelationshipPersonRelatedPersonEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRelatedPersonEntity(PersonEntityDao_Impl $this, SQLiteConnection _connection, LongSparseArray _map) {
        $this.__fetchRelationshipPersonRelatedPersonEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRelatedPersonEntity(_connection, (LongSparseArray<List<PersonRelatedPersonEntity>>)_map);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lworld/respect/datalayer/db/school/daos/PersonEntityDao_Impl$Companion;", "", "<init>", "()V", "getRequiredConverters", "", "Lkotlin/reflect/KClass;", "respect-datalayer-db_debug"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<KClass<?>> getRequiredConverters() {
            return CollectionsKt.emptyList();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

