package world.respect.datalayer.db.school.daos

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import javax.`annotation`.processing.Generated
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.reflect.KClass
import world.respect.datalayer.db.school.entities.AssignmentLearningResourceRefEntity
import world.respect.datalayer.db.shared.SharedConverters

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class AssignmentLearningResourceRefEntityDao_Impl(
  __db: RoomDatabase,
) : AssignmentLearningResourceRefEntityDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfAssignmentLearningResourceRefEntity:
      EntityInsertAdapter<AssignmentLearningResourceRefEntity>

  private val __sharedConverters: SharedConverters = SharedConverters()
  init {
    this.__db = __db
    this.__insertAdapterOfAssignmentLearningResourceRefEntity = object : EntityInsertAdapter<AssignmentLearningResourceRefEntity>() {
      protected override fun createQuery(): String = "INSERT OR REPLACE INTO `AssignmentLearningResourceRefEntity` (`alrrAeUidNum`,`alrrLearningUnitManifestUrlHash`,`alrrLearningUnitManifestUrl`,`alrrAppManifestUrl`) VALUES (?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: AssignmentLearningResourceRefEntity) {
        statement.bindLong(1, entity.alrrAeUidNum)
        statement.bindLong(2, entity.alrrLearningUnitManifestUrlHash)
        val _tmp: String? = __sharedConverters.fromUrl(entity.alrrLearningUnitManifestUrl)
        if (_tmp == null) {
          statement.bindNull(3)
        } else {
          statement.bindText(3, _tmp)
        }
        val _tmp_1: String? = __sharedConverters.fromUrl(entity.alrrAppManifestUrl)
        if (_tmp_1 == null) {
          statement.bindNull(4)
        } else {
          statement.bindText(4, _tmp_1)
        }
      }
    }
  }

  public override suspend fun upsert(entities: List<AssignmentLearningResourceRefEntity>): Unit = performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfAssignmentLearningResourceRefEntity.insert(_connection, entities)
  }

  public override suspend fun deleteByAssignmentUidNum(uidNum: Long) {
    val _sql: String = """
        |
        |        DELETE FROM AssignmentLearningResourceRefEntity
        |         WHERE alrrAeUidNum = ?
        |    
        """.trimMargin()
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, uidNum)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
