/*
 * Decompiled with CFR 0.152.
 */
package world.respect.datalayer.db.school.daos;

import androidx.paging.PagingSource;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomRawQuery;
import androidx.room.coroutines.FlowUtil;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.SQLiteConnection;
import androidx.sqlite.SQLiteStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.time.Instant;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import world.respect.datalayer.db.school.SchoolTypeConverters;
import world.respect.datalayer.db.school.daos.ClassEntityDao;
import world.respect.datalayer.db.school.daos.ClassEntityDao_Impl;
import world.respect.datalayer.db.school.entities.ClassEntity;
import world.respect.datalayer.db.shared.SharedConverters;
import world.respect.datalayer.school.model.StatusEnum;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0007\u0018\u0000 *2\u00020\u0001:\u0001*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0096@\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0018\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0016J.\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\b0\u001a2\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0018\u0010\u001f\u001a\u0004\u0018\u00010\b2\u0006\u0010 \u001a\u00020\u001eH\u0096@\u00a2\u0006\u0002\u0010!J\u0018\u0010\"\u001a\u0004\u0018\u00010\b2\u0006\u0010 \u001a\u00020\u001eH\u0096@\u00a2\u0006\u0002\u0010!J.\u0010#\u001a\b\u0012\u0004\u0012\u00020\b0$2\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0096@\u00a2\u0006\u0002\u0010%J\"\u0010&\u001a\b\u0012\u0004\u0012\u00020\b0$2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00140$H\u0096@\u00a2\u0006\u0002\u0010(J\u0018\u0010)\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0096@\u00a2\u0006\u0002\u0010!R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lworld/respect/datalayer/db/school/daos/ClassEntityDao_Impl;", "Lworld/respect/datalayer/db/school/daos/ClassEntityDao;", "__db", "Landroidx/room/RoomDatabase;", "<init>", "(Landroidx/room/RoomDatabase;)V", "__insertAdapterOfClassEntity", "Landroidx/room/EntityInsertAdapter;", "Lworld/respect/datalayer/db/school/entities/ClassEntity;", "__schoolTypeConverters", "Lworld/respect/datalayer/db/school/SchoolTypeConverters;", "__sharedConverters", "Lworld/respect/datalayer/db/shared/SharedConverters;", "upsert", "", "classEntity", "(Lworld/respect/datalayer/db/school/entities/ClassEntity;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByGuidHashAsFlow", "Lkotlinx/coroutines/flow/Flow;", "guidHash", "", "findByGuid", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getLastModifiedByGuid", "uidNum", "findAllAsPagingSource", "Landroidx/paging/PagingSource;", "", "since", "code", "", "findByTeacherInviteCode", "inviteCode", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByStudentInviteCode", "list", "", "(JJLjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUidList", "uids", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByInviteCode", "Companion", "respect-datalayer-db_release"})
public final class ClassEntityDao_Impl
implements ClassEntityDao {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RoomDatabase __db;
    @NotNull
    private final EntityInsertAdapter<ClassEntity> __insertAdapterOfClassEntity;
    @NotNull
    private final SchoolTypeConverters __schoolTypeConverters;
    @NotNull
    private final SharedConverters __sharedConverters;

    public ClassEntityDao_Impl(@NotNull RoomDatabase __db) {
        Intrinsics.checkNotNullParameter((Object)__db, (String)"__db");
        this.__schoolTypeConverters = new SchoolTypeConverters();
        this.__sharedConverters = new SharedConverters();
        this.__db = __db;
        this.__insertAdapterOfClassEntity = (EntityInsertAdapter)new EntityInsertAdapter<ClassEntity>(){

            protected String createQuery() {
                return "INSERT OR REPLACE INTO `ClassEntity` (`cGuid`,`cGuidHash`,`cTitle`,`cStatus`,`cDescription`,`cLastModified`,`cStored`,`cTeacherInviteCode`,`cStudentInviteCode`) VALUES (?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(SQLiteStatement statement, ClassEntity entity) {
                Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                statement.bindText(1, entity.getCGuid());
                statement.bindLong(2, entity.getCGuidHash());
                statement.bindText(3, entity.getCTitle());
                int _tmp = __schoolTypeConverters.fromStatusEnum(entity.getCStatus());
                statement.bindLong(4, (long)_tmp);
                String _tmpCDescription = entity.getCDescription();
                if (_tmpCDescription == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmpCDescription);
                }
                Long _tmp_1 = __sharedConverters.fromInstant(entity.getCLastModified());
                if (_tmp_1 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindLong(6, _tmp_1.longValue());
                }
                Long _tmp_2 = __sharedConverters.fromInstant(entity.getCStored());
                if (_tmp_2 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindLong(7, _tmp_2.longValue());
                }
                String _tmpCTeacherInviteCode = entity.getCTeacherInviteCode();
                if (_tmpCTeacherInviteCode == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmpCTeacherInviteCode);
                }
                String _tmpCStudentInviteCode = entity.getCStudentInviteCode();
                if (_tmpCStudentInviteCode == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmpCStudentInviteCode);
                }
            }
        };
    }

    @Override
    @Nullable
    public Object upsert(@NotNull ClassEntity classEntity, @NotNull Continuation<? super Unit> $completion) {
        Object object = DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> ClassEntityDao_Impl.upsert$lambda$0(this, classEntity, arg_0), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    public Flow<ClassEntity> findByGuidHashAsFlow(long guidHash) {
        String _sql = "\n        SELECT * \n         FROM ClassEntity\n        WHERE ClassEntity.cGuidHash = ?\n    ";
        String[] stringArray = new String[]{"ClassEntity"};
        return FlowUtil.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])stringArray, arg_0 -> ClassEntityDao_Impl.findByGuidHashAsFlow$lambda$0(_sql, guidHash, this, arg_0));
    }

    @Override
    @Nullable
    public Object findByGuid(long guidHash, @NotNull Continuation<? super ClassEntity> $completion) {
        String _sql = "\n        SELECT * \n         FROM ClassEntity\n        WHERE ClassEntity.cGuidHash = ?\n    ";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> ClassEntityDao_Impl.findByGuid$lambda$0(_sql, guidHash, this, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object getLastModifiedByGuid(long uidNum, @NotNull Continuation<? super Long> $completion) {
        String _sql = "\n        SELECT ClassEntity.cLastModified\n          FROM ClassEntity\n         WHERE ClassEntity.cGuidHash = ? \n    ";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> ClassEntityDao_Impl.getLastModifiedByGuid$lambda$0(_sql, uidNum, arg_0), $completion);
    }

    @Override
    @NotNull
    public PagingSource<Integer, ClassEntity> findAllAsPagingSource(long since, long guidHash, @Nullable String code) {
        String _sql = "\n       SELECT ClassEntity.* \n         FROM ClassEntity\n        WHERE ClassEntity.cStored > ? \n          AND (? = 0 OR ClassEntity.cGuidHash = ?)\n          AND (? IS NULL \n                OR ClassEntity.cStudentInviteCode = ?\n                OR ClassEntity.cTeacherInviteCode = ?)\n     ORDER BY ClassEntity.cTitle\n        ";
        RoomRawQuery _rawQuery = new RoomRawQuery(_sql, arg_0 -> ClassEntityDao_Impl.findAllAsPagingSource$lambda$0(since, guidHash, code, arg_0));
        RoomDatabase roomDatabase = this.__db;
        String[] stringArray = new String[]{"ClassEntity"};
        String[] stringArray2 = stringArray;
        return (PagingSource)new LimitOffsetPagingSource<ClassEntity>(_rawQuery, this, roomDatabase, stringArray2){
            final /* synthetic */ ClassEntityDao_Impl this$0;
            {
                this.this$0 = $receiver;
                super($_rawQuery, $super_call_param$1, $super_call_param$2);
            }

            protected Object convertRows(RoomRawQuery limitOffsetQuery, int itemCount, Continuation<? super List<ClassEntity>> $completion) {
                return DBUtil.performSuspending((RoomDatabase)ClassEntityDao_Impl.access$get__db$p(this.this$0), (boolean)true, (boolean)false, arg_0 -> findAllAsPagingSource.1.convertRows$lambda$0(limitOffsetQuery, this.this$0, arg_0), $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static final List convertRows$lambda$0(RoomRawQuery $limitOffsetQuery, ClassEntityDao_Impl this$0, SQLiteConnection _connection) {
                List list2;
                Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
                SQLiteStatement _stmt = _connection.prepare($limitOffsetQuery.getSql());
                $limitOffsetQuery.getBindingFunction().invoke((Object)_stmt);
                try {
                    int _columnIndexOfCGuid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cGuid");
                    int _columnIndexOfCGuidHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cGuidHash");
                    int _columnIndexOfCTitle = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cTitle");
                    int _columnIndexOfCStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cStatus");
                    int _columnIndexOfCDescription = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cDescription");
                    int _columnIndexOfCLastModified = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cLastModified");
                    int _columnIndexOfCStored = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cStored");
                    int _columnIndexOfCTeacherInviteCode = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cTeacherInviteCode");
                    int _columnIndexOfCStudentInviteCode = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cStudentInviteCode");
                    List _result = new ArrayList<E>();
                    while (_stmt.step()) {
                        ClassEntity _item = null;
                        String _tmpCGuid = null;
                        _tmpCGuid = _stmt.getText(_columnIndexOfCGuid);
                        long _tmpCGuidHash = 0L;
                        _tmpCGuidHash = _stmt.getLong(_columnIndexOfCGuidHash);
                        String _tmpCTitle = null;
                        _tmpCTitle = _stmt.getText(_columnIndexOfCTitle);
                        StatusEnum _tmpCStatus = null;
                        int _tmp = 0;
                        _tmp = (int)_stmt.getLong(_columnIndexOfCStatus);
                        _tmpCStatus = ClassEntityDao_Impl.access$get__schoolTypeConverters$p(this$0).toStatusEnum(_tmp);
                        String _tmpCDescription = null;
                        _tmpCDescription = _stmt.isNull(_columnIndexOfCDescription) ? null : _stmt.getText(_columnIndexOfCDescription);
                        Instant _tmpCLastModified = null;
                        Long _tmp_1 = null;
                        _tmp_1 = _stmt.isNull(_columnIndexOfCLastModified) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfCLastModified));
                        Instant _tmp_2 = ClassEntityDao_Impl.access$get__sharedConverters$p(this$0).toInstant(_tmp_1);
                        if (_tmp_2 == null) {
                            throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                        }
                        _tmpCLastModified = _tmp_2;
                        Instant _tmpCStored = null;
                        Long _tmp_3 = null;
                        _tmp_3 = _stmt.isNull(_columnIndexOfCStored) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfCStored));
                        Instant _tmp_4 = ClassEntityDao_Impl.access$get__sharedConverters$p(this$0).toInstant(_tmp_3);
                        if (_tmp_4 == null) {
                            throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                        }
                        _tmpCStored = _tmp_4;
                        String _tmpCTeacherInviteCode = null;
                        _tmpCTeacherInviteCode = _stmt.isNull(_columnIndexOfCTeacherInviteCode) ? null : _stmt.getText(_columnIndexOfCTeacherInviteCode);
                        String _tmpCStudentInviteCode = null;
                        _tmpCStudentInviteCode = _stmt.isNull(_columnIndexOfCStudentInviteCode) ? null : _stmt.getText(_columnIndexOfCStudentInviteCode);
                        _item = new ClassEntity(_tmpCGuid, _tmpCGuidHash, _tmpCTitle, _tmpCStatus, _tmpCDescription, _tmpCLastModified, _tmpCStored, _tmpCTeacherInviteCode, _tmpCStudentInviteCode);
                        _result.add(_item);
                    }
                    list2 = _result;
                }
                finally {
                    _stmt.close();
                }
                return list2;
            }
        };
    }

    @Override
    @Nullable
    public Object findByTeacherInviteCode(@NotNull String inviteCode, @NotNull Continuation<? super ClassEntity> $completion) {
        String _sql = "\n        SELECT * \n          FROM ClassEntity \n        WHERE cTeacherInviteCode = ?\n    ";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> ClassEntityDao_Impl.findByTeacherInviteCode$lambda$0(_sql, inviteCode, this, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object findByStudentInviteCode(@NotNull String inviteCode, @NotNull Continuation<? super ClassEntity> $completion) {
        String _sql = "\n        SELECT * \n          FROM ClassEntity \n        WHERE cStudentInviteCode = ?\n    ";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> ClassEntityDao_Impl.findByStudentInviteCode$lambda$0(_sql, inviteCode, this, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object list(long since, long guidHash, @Nullable String code, @NotNull Continuation<? super List<ClassEntity>> $completion) {
        String _sql = "\n       SELECT ClassEntity.* \n         FROM ClassEntity\n        WHERE ClassEntity.cStored > ? \n          AND (? = 0 OR ClassEntity.cGuidHash = ?)\n          AND (? IS NULL \n                OR ClassEntity.cStudentInviteCode = ?\n                OR ClassEntity.cTeacherInviteCode = ?)\n     ORDER BY ClassEntity.cTitle\n        ";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> ClassEntityDao_Impl.list$lambda$0(_sql, since, guidHash, code, this, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object findByUidList(@NotNull List<Long> uids, @NotNull Continuation<? super List<ClassEntity>> $completion) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("        SELECT ClassEntity.*");
        _stringBuilder.append("\n");
        _stringBuilder.append("          FROM ClassEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("         WHERE ClassEntity.cGuidHash in (");
        int _inputSize = uids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") ");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        String string = _stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String _sql = string;
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> ClassEntityDao_Impl.findByUidList$lambda$0(_sql, uids, this, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object findByInviteCode(@NotNull String code, @NotNull Continuation<? super ClassEntity> $completion) {
        String _sql = "\n        SELECT ClassEntity.*\n          FROM ClassEntity\n         WHERE ClassEntity.cStudentInviteCode = ?\n            OR ClassEntity.cTeacherInviteCode = ?\n    ";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> ClassEntityDao_Impl.findByInviteCode$lambda$0(_sql, code, this, arg_0), $completion);
    }

    private static final Unit upsert$lambda$0(ClassEntityDao_Impl this$0, ClassEntity $classEntity, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        this$0.__insertAdapterOfClassEntity.insert(_connection, (Object)$classEntity);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ClassEntity findByGuidHashAsFlow$lambda$0(String $_sql, long $guidHash, ClassEntityDao_Impl this$0, SQLiteConnection _connection) {
        ClassEntity classEntity;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, $guidHash);
            int _columnIndexOfCGuid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cGuid");
            int _columnIndexOfCGuidHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cGuidHash");
            int _columnIndexOfCTitle = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cTitle");
            int _columnIndexOfCStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cStatus");
            int _columnIndexOfCDescription = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cDescription");
            int _columnIndexOfCLastModified = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cLastModified");
            int _columnIndexOfCStored = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cStored");
            int _columnIndexOfCTeacherInviteCode = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cTeacherInviteCode");
            int _columnIndexOfCStudentInviteCode = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cStudentInviteCode");
            ClassEntity _result = null;
            if (_stmt.step()) {
                String _tmpCGuid = null;
                _tmpCGuid = _stmt.getText(_columnIndexOfCGuid);
                long _tmpCGuidHash = 0L;
                _tmpCGuidHash = _stmt.getLong(_columnIndexOfCGuidHash);
                String _tmpCTitle = null;
                _tmpCTitle = _stmt.getText(_columnIndexOfCTitle);
                StatusEnum _tmpCStatus = null;
                int _tmp = 0;
                _tmp = (int)_stmt.getLong(_columnIndexOfCStatus);
                _tmpCStatus = this$0.__schoolTypeConverters.toStatusEnum(_tmp);
                String _tmpCDescription = null;
                _tmpCDescription = _stmt.isNull(_columnIndexOfCDescription) ? null : _stmt.getText(_columnIndexOfCDescription);
                Instant _tmpCLastModified = null;
                Long _tmp_1 = null;
                _tmp_1 = _stmt.isNull(_columnIndexOfCLastModified) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfCLastModified));
                Instant _tmp_2 = this$0.__sharedConverters.toInstant(_tmp_1);
                if (_tmp_2 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpCLastModified = _tmp_2;
                Instant _tmpCStored = null;
                Long _tmp_3 = null;
                _tmp_3 = _stmt.isNull(_columnIndexOfCStored) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfCStored));
                Instant _tmp_4 = this$0.__sharedConverters.toInstant(_tmp_3);
                if (_tmp_4 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpCStored = _tmp_4;
                String _tmpCTeacherInviteCode = null;
                _tmpCTeacherInviteCode = _stmt.isNull(_columnIndexOfCTeacherInviteCode) ? null : _stmt.getText(_columnIndexOfCTeacherInviteCode);
                String _tmpCStudentInviteCode = null;
                _tmpCStudentInviteCode = _stmt.isNull(_columnIndexOfCStudentInviteCode) ? null : _stmt.getText(_columnIndexOfCStudentInviteCode);
                _result = new ClassEntity(_tmpCGuid, _tmpCGuidHash, _tmpCTitle, _tmpCStatus, _tmpCDescription, _tmpCLastModified, _tmpCStored, _tmpCTeacherInviteCode, _tmpCStudentInviteCode);
            } else {
                _result = null;
            }
            classEntity = _result;
        }
        return classEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ClassEntity findByGuid$lambda$0(String $_sql, long $guidHash, ClassEntityDao_Impl this$0, SQLiteConnection _connection) {
        ClassEntity classEntity;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, $guidHash);
            int _columnIndexOfCGuid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cGuid");
            int _columnIndexOfCGuidHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cGuidHash");
            int _columnIndexOfCTitle = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cTitle");
            int _columnIndexOfCStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cStatus");
            int _columnIndexOfCDescription = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cDescription");
            int _columnIndexOfCLastModified = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cLastModified");
            int _columnIndexOfCStored = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cStored");
            int _columnIndexOfCTeacherInviteCode = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cTeacherInviteCode");
            int _columnIndexOfCStudentInviteCode = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cStudentInviteCode");
            ClassEntity _result = null;
            if (_stmt.step()) {
                String _tmpCGuid = null;
                _tmpCGuid = _stmt.getText(_columnIndexOfCGuid);
                long _tmpCGuidHash = 0L;
                _tmpCGuidHash = _stmt.getLong(_columnIndexOfCGuidHash);
                String _tmpCTitle = null;
                _tmpCTitle = _stmt.getText(_columnIndexOfCTitle);
                StatusEnum _tmpCStatus = null;
                int _tmp = 0;
                _tmp = (int)_stmt.getLong(_columnIndexOfCStatus);
                _tmpCStatus = this$0.__schoolTypeConverters.toStatusEnum(_tmp);
                String _tmpCDescription = null;
                _tmpCDescription = _stmt.isNull(_columnIndexOfCDescription) ? null : _stmt.getText(_columnIndexOfCDescription);
                Instant _tmpCLastModified = null;
                Long _tmp_1 = null;
                _tmp_1 = _stmt.isNull(_columnIndexOfCLastModified) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfCLastModified));
                Instant _tmp_2 = this$0.__sharedConverters.toInstant(_tmp_1);
                if (_tmp_2 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpCLastModified = _tmp_2;
                Instant _tmpCStored = null;
                Long _tmp_3 = null;
                _tmp_3 = _stmt.isNull(_columnIndexOfCStored) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfCStored));
                Instant _tmp_4 = this$0.__sharedConverters.toInstant(_tmp_3);
                if (_tmp_4 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpCStored = _tmp_4;
                String _tmpCTeacherInviteCode = null;
                _tmpCTeacherInviteCode = _stmt.isNull(_columnIndexOfCTeacherInviteCode) ? null : _stmt.getText(_columnIndexOfCTeacherInviteCode);
                String _tmpCStudentInviteCode = null;
                _tmpCStudentInviteCode = _stmt.isNull(_columnIndexOfCStudentInviteCode) ? null : _stmt.getText(_columnIndexOfCStudentInviteCode);
                _result = new ClassEntity(_tmpCGuid, _tmpCGuidHash, _tmpCTitle, _tmpCStatus, _tmpCDescription, _tmpCLastModified, _tmpCStored, _tmpCTeacherInviteCode, _tmpCStudentInviteCode);
            } else {
                _result = null;
            }
            classEntity = _result;
        }
        return classEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Long getLastModifiedByGuid$lambda$0(String $_sql, long $uidNum, SQLiteConnection _connection) {
        Long l;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, $uidNum);
            Long _result = null;
            _result = _stmt.step() ? (_stmt.isNull(0) ? null : Long.valueOf(_stmt.getLong(0))) : null;
            l = _result;
        }
        return l;
    }

    private static final Unit findAllAsPagingSource$lambda$0(long $since, long $guidHash, String $code, SQLiteStatement _stmt) {
        Intrinsics.checkNotNullParameter((Object)_stmt, (String)"_stmt");
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, $since);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, $guidHash);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, $guidHash);
        _argIndex = 4;
        if ($code == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindText(_argIndex, $code);
        }
        _argIndex = 5;
        if ($code == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindText(_argIndex, $code);
        }
        _argIndex = 6;
        if ($code == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindText(_argIndex, $code);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ClassEntity findByTeacherInviteCode$lambda$0(String $_sql, String $inviteCode, ClassEntityDao_Impl this$0, SQLiteConnection _connection) {
        ClassEntity classEntity;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindText(_argIndex, $inviteCode);
            int _columnIndexOfCGuid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cGuid");
            int _columnIndexOfCGuidHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cGuidHash");
            int _columnIndexOfCTitle = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cTitle");
            int _columnIndexOfCStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cStatus");
            int _columnIndexOfCDescription = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cDescription");
            int _columnIndexOfCLastModified = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cLastModified");
            int _columnIndexOfCStored = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cStored");
            int _columnIndexOfCTeacherInviteCode = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cTeacherInviteCode");
            int _columnIndexOfCStudentInviteCode = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cStudentInviteCode");
            ClassEntity _result = null;
            if (_stmt.step()) {
                String _tmpCGuid = null;
                _tmpCGuid = _stmt.getText(_columnIndexOfCGuid);
                long _tmpCGuidHash = 0L;
                _tmpCGuidHash = _stmt.getLong(_columnIndexOfCGuidHash);
                String _tmpCTitle = null;
                _tmpCTitle = _stmt.getText(_columnIndexOfCTitle);
                StatusEnum _tmpCStatus = null;
                int _tmp = 0;
                _tmp = (int)_stmt.getLong(_columnIndexOfCStatus);
                _tmpCStatus = this$0.__schoolTypeConverters.toStatusEnum(_tmp);
                String _tmpCDescription = null;
                _tmpCDescription = _stmt.isNull(_columnIndexOfCDescription) ? null : _stmt.getText(_columnIndexOfCDescription);
                Instant _tmpCLastModified = null;
                Long _tmp_1 = null;
                _tmp_1 = _stmt.isNull(_columnIndexOfCLastModified) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfCLastModified));
                Instant _tmp_2 = this$0.__sharedConverters.toInstant(_tmp_1);
                if (_tmp_2 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpCLastModified = _tmp_2;
                Instant _tmpCStored = null;
                Long _tmp_3 = null;
                _tmp_3 = _stmt.isNull(_columnIndexOfCStored) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfCStored));
                Instant _tmp_4 = this$0.__sharedConverters.toInstant(_tmp_3);
                if (_tmp_4 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpCStored = _tmp_4;
                String _tmpCTeacherInviteCode = null;
                _tmpCTeacherInviteCode = _stmt.isNull(_columnIndexOfCTeacherInviteCode) ? null : _stmt.getText(_columnIndexOfCTeacherInviteCode);
                String _tmpCStudentInviteCode = null;
                _tmpCStudentInviteCode = _stmt.isNull(_columnIndexOfCStudentInviteCode) ? null : _stmt.getText(_columnIndexOfCStudentInviteCode);
                _result = new ClassEntity(_tmpCGuid, _tmpCGuidHash, _tmpCTitle, _tmpCStatus, _tmpCDescription, _tmpCLastModified, _tmpCStored, _tmpCTeacherInviteCode, _tmpCStudentInviteCode);
            } else {
                _result = null;
            }
            classEntity = _result;
        }
        return classEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ClassEntity findByStudentInviteCode$lambda$0(String $_sql, String $inviteCode, ClassEntityDao_Impl this$0, SQLiteConnection _connection) {
        ClassEntity classEntity;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindText(_argIndex, $inviteCode);
            int _columnIndexOfCGuid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cGuid");
            int _columnIndexOfCGuidHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cGuidHash");
            int _columnIndexOfCTitle = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cTitle");
            int _columnIndexOfCStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cStatus");
            int _columnIndexOfCDescription = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cDescription");
            int _columnIndexOfCLastModified = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cLastModified");
            int _columnIndexOfCStored = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cStored");
            int _columnIndexOfCTeacherInviteCode = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cTeacherInviteCode");
            int _columnIndexOfCStudentInviteCode = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cStudentInviteCode");
            ClassEntity _result = null;
            if (_stmt.step()) {
                String _tmpCGuid = null;
                _tmpCGuid = _stmt.getText(_columnIndexOfCGuid);
                long _tmpCGuidHash = 0L;
                _tmpCGuidHash = _stmt.getLong(_columnIndexOfCGuidHash);
                String _tmpCTitle = null;
                _tmpCTitle = _stmt.getText(_columnIndexOfCTitle);
                StatusEnum _tmpCStatus = null;
                int _tmp = 0;
                _tmp = (int)_stmt.getLong(_columnIndexOfCStatus);
                _tmpCStatus = this$0.__schoolTypeConverters.toStatusEnum(_tmp);
                String _tmpCDescription = null;
                _tmpCDescription = _stmt.isNull(_columnIndexOfCDescription) ? null : _stmt.getText(_columnIndexOfCDescription);
                Instant _tmpCLastModified = null;
                Long _tmp_1 = null;
                _tmp_1 = _stmt.isNull(_columnIndexOfCLastModified) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfCLastModified));
                Instant _tmp_2 = this$0.__sharedConverters.toInstant(_tmp_1);
                if (_tmp_2 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpCLastModified = _tmp_2;
                Instant _tmpCStored = null;
                Long _tmp_3 = null;
                _tmp_3 = _stmt.isNull(_columnIndexOfCStored) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfCStored));
                Instant _tmp_4 = this$0.__sharedConverters.toInstant(_tmp_3);
                if (_tmp_4 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpCStored = _tmp_4;
                String _tmpCTeacherInviteCode = null;
                _tmpCTeacherInviteCode = _stmt.isNull(_columnIndexOfCTeacherInviteCode) ? null : _stmt.getText(_columnIndexOfCTeacherInviteCode);
                String _tmpCStudentInviteCode = null;
                _tmpCStudentInviteCode = _stmt.isNull(_columnIndexOfCStudentInviteCode) ? null : _stmt.getText(_columnIndexOfCStudentInviteCode);
                _result = new ClassEntity(_tmpCGuid, _tmpCGuidHash, _tmpCTitle, _tmpCStatus, _tmpCDescription, _tmpCLastModified, _tmpCStored, _tmpCTeacherInviteCode, _tmpCStudentInviteCode);
            } else {
                _result = null;
            }
            classEntity = _result;
        }
        return classEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List list$lambda$0(String $_sql, long $since, long $guidHash, String $code, ClassEntityDao_Impl this$0, SQLiteConnection _connection) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, $since);
            _argIndex = 2;
            _stmt.bindLong(_argIndex, $guidHash);
            _argIndex = 3;
            _stmt.bindLong(_argIndex, $guidHash);
            _argIndex = 4;
            if ($code == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindText(_argIndex, $code);
            }
            _argIndex = 5;
            if ($code == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindText(_argIndex, $code);
            }
            _argIndex = 6;
            if ($code == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindText(_argIndex, $code);
            }
            int _columnIndexOfCGuid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cGuid");
            int _columnIndexOfCGuidHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cGuidHash");
            int _columnIndexOfCTitle = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cTitle");
            int _columnIndexOfCStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cStatus");
            int _columnIndexOfCDescription = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cDescription");
            int _columnIndexOfCLastModified = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cLastModified");
            int _columnIndexOfCStored = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cStored");
            int _columnIndexOfCTeacherInviteCode = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cTeacherInviteCode");
            int _columnIndexOfCStudentInviteCode = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cStudentInviteCode");
            List _result = new ArrayList();
            while (_stmt.step()) {
                ClassEntity _item = null;
                String _tmpCGuid = null;
                _tmpCGuid = _stmt.getText(_columnIndexOfCGuid);
                long _tmpCGuidHash = 0L;
                _tmpCGuidHash = _stmt.getLong(_columnIndexOfCGuidHash);
                String _tmpCTitle = null;
                _tmpCTitle = _stmt.getText(_columnIndexOfCTitle);
                StatusEnum _tmpCStatus = null;
                int _tmp = 0;
                _tmp = (int)_stmt.getLong(_columnIndexOfCStatus);
                _tmpCStatus = this$0.__schoolTypeConverters.toStatusEnum(_tmp);
                String _tmpCDescription = null;
                _tmpCDescription = _stmt.isNull(_columnIndexOfCDescription) ? null : _stmt.getText(_columnIndexOfCDescription);
                Instant _tmpCLastModified = null;
                Long _tmp_1 = null;
                _tmp_1 = _stmt.isNull(_columnIndexOfCLastModified) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfCLastModified));
                Instant _tmp_2 = this$0.__sharedConverters.toInstant(_tmp_1);
                if (_tmp_2 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpCLastModified = _tmp_2;
                Instant _tmpCStored = null;
                Long _tmp_3 = null;
                _tmp_3 = _stmt.isNull(_columnIndexOfCStored) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfCStored));
                Instant _tmp_4 = this$0.__sharedConverters.toInstant(_tmp_3);
                if (_tmp_4 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpCStored = _tmp_4;
                String _tmpCTeacherInviteCode = null;
                _tmpCTeacherInviteCode = _stmt.isNull(_columnIndexOfCTeacherInviteCode) ? null : _stmt.getText(_columnIndexOfCTeacherInviteCode);
                String _tmpCStudentInviteCode = null;
                _tmpCStudentInviteCode = _stmt.isNull(_columnIndexOfCStudentInviteCode) ? null : _stmt.getText(_columnIndexOfCStudentInviteCode);
                _item = new ClassEntity(_tmpCGuid, _tmpCGuidHash, _tmpCTitle, _tmpCStatus, _tmpCDescription, _tmpCLastModified, _tmpCStored, _tmpCTeacherInviteCode, _tmpCStudentInviteCode);
                _result.add(_item);
            }
            list2 = _result;
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List findByUidList$lambda$0(String $_sql, List $uids, ClassEntityDao_Impl this$0, SQLiteConnection _connection) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            Iterator iterator = $uids.iterator();
            while (iterator.hasNext()) {
                long _item = ((Number)iterator.next()).longValue();
                _stmt.bindLong(_argIndex, _item);
                ++_argIndex;
            }
            int _columnIndexOfCGuid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cGuid");
            int _columnIndexOfCGuidHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cGuidHash");
            int _columnIndexOfCTitle = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cTitle");
            int _columnIndexOfCStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cStatus");
            int _columnIndexOfCDescription = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cDescription");
            int _columnIndexOfCLastModified = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cLastModified");
            int _columnIndexOfCStored = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cStored");
            int _columnIndexOfCTeacherInviteCode = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cTeacherInviteCode");
            int _columnIndexOfCStudentInviteCode = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cStudentInviteCode");
            List _result = new ArrayList();
            while (_stmt.step()) {
                ClassEntity _item_1 = null;
                String _tmpCGuid = null;
                _tmpCGuid = _stmt.getText(_columnIndexOfCGuid);
                long _tmpCGuidHash = 0L;
                _tmpCGuidHash = _stmt.getLong(_columnIndexOfCGuidHash);
                String _tmpCTitle = null;
                _tmpCTitle = _stmt.getText(_columnIndexOfCTitle);
                StatusEnum _tmpCStatus = null;
                int _tmp = 0;
                _tmp = (int)_stmt.getLong(_columnIndexOfCStatus);
                _tmpCStatus = this$0.__schoolTypeConverters.toStatusEnum(_tmp);
                String _tmpCDescription = null;
                _tmpCDescription = _stmt.isNull(_columnIndexOfCDescription) ? null : _stmt.getText(_columnIndexOfCDescription);
                Instant _tmpCLastModified = null;
                Long _tmp_1 = null;
                _tmp_1 = _stmt.isNull(_columnIndexOfCLastModified) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfCLastModified));
                Instant _tmp_2 = this$0.__sharedConverters.toInstant(_tmp_1);
                if (_tmp_2 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpCLastModified = _tmp_2;
                Instant _tmpCStored = null;
                Long _tmp_3 = null;
                _tmp_3 = _stmt.isNull(_columnIndexOfCStored) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfCStored));
                Instant _tmp_4 = this$0.__sharedConverters.toInstant(_tmp_3);
                if (_tmp_4 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpCStored = _tmp_4;
                String _tmpCTeacherInviteCode = null;
                _tmpCTeacherInviteCode = _stmt.isNull(_columnIndexOfCTeacherInviteCode) ? null : _stmt.getText(_columnIndexOfCTeacherInviteCode);
                String _tmpCStudentInviteCode = null;
                _tmpCStudentInviteCode = _stmt.isNull(_columnIndexOfCStudentInviteCode) ? null : _stmt.getText(_columnIndexOfCStudentInviteCode);
                _item_1 = new ClassEntity(_tmpCGuid, _tmpCGuidHash, _tmpCTitle, _tmpCStatus, _tmpCDescription, _tmpCLastModified, _tmpCStored, _tmpCTeacherInviteCode, _tmpCStudentInviteCode);
                _result.add(_item_1);
            }
            list2 = _result;
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ClassEntity findByInviteCode$lambda$0(String $_sql, String $code, ClassEntityDao_Impl this$0, SQLiteConnection _connection) {
        ClassEntity classEntity;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindText(_argIndex, $code);
            _argIndex = 2;
            _stmt.bindText(_argIndex, $code);
            int _columnIndexOfCGuid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cGuid");
            int _columnIndexOfCGuidHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cGuidHash");
            int _columnIndexOfCTitle = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cTitle");
            int _columnIndexOfCStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cStatus");
            int _columnIndexOfCDescription = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cDescription");
            int _columnIndexOfCLastModified = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cLastModified");
            int _columnIndexOfCStored = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cStored");
            int _columnIndexOfCTeacherInviteCode = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cTeacherInviteCode");
            int _columnIndexOfCStudentInviteCode = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cStudentInviteCode");
            ClassEntity _result = null;
            if (_stmt.step()) {
                String _tmpCGuid = null;
                _tmpCGuid = _stmt.getText(_columnIndexOfCGuid);
                long _tmpCGuidHash = 0L;
                _tmpCGuidHash = _stmt.getLong(_columnIndexOfCGuidHash);
                String _tmpCTitle = null;
                _tmpCTitle = _stmt.getText(_columnIndexOfCTitle);
                StatusEnum _tmpCStatus = null;
                int _tmp = 0;
                _tmp = (int)_stmt.getLong(_columnIndexOfCStatus);
                _tmpCStatus = this$0.__schoolTypeConverters.toStatusEnum(_tmp);
                String _tmpCDescription = null;
                _tmpCDescription = _stmt.isNull(_columnIndexOfCDescription) ? null : _stmt.getText(_columnIndexOfCDescription);
                Instant _tmpCLastModified = null;
                Long _tmp_1 = null;
                _tmp_1 = _stmt.isNull(_columnIndexOfCLastModified) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfCLastModified));
                Instant _tmp_2 = this$0.__sharedConverters.toInstant(_tmp_1);
                if (_tmp_2 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpCLastModified = _tmp_2;
                Instant _tmpCStored = null;
                Long _tmp_3 = null;
                _tmp_3 = _stmt.isNull(_columnIndexOfCStored) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfCStored));
                Instant _tmp_4 = this$0.__sharedConverters.toInstant(_tmp_3);
                if (_tmp_4 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpCStored = _tmp_4;
                String _tmpCTeacherInviteCode = null;
                _tmpCTeacherInviteCode = _stmt.isNull(_columnIndexOfCTeacherInviteCode) ? null : _stmt.getText(_columnIndexOfCTeacherInviteCode);
                String _tmpCStudentInviteCode = null;
                _tmpCStudentInviteCode = _stmt.isNull(_columnIndexOfCStudentInviteCode) ? null : _stmt.getText(_columnIndexOfCStudentInviteCode);
                _result = new ClassEntity(_tmpCGuid, _tmpCGuidHash, _tmpCTitle, _tmpCStatus, _tmpCDescription, _tmpCLastModified, _tmpCStored, _tmpCTeacherInviteCode, _tmpCStudentInviteCode);
            } else {
                _result = null;
            }
            classEntity = _result;
        }
        return classEntity;
    }

    public static final /* synthetic */ RoomDatabase access$get__db$p(ClassEntityDao_Impl $this) {
        return $this.__db;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lworld/respect/datalayer/db/school/daos/ClassEntityDao_Impl$Companion;", "", "<init>", "()V", "getRequiredConverters", "", "Lkotlin/reflect/KClass;", "respect-datalayer-db_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<KClass<?>> getRequiredConverters() {
            return CollectionsKt.emptyList();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

