package world.respect.datalayer.db.opds.daos

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.coroutines.createFlow
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import javax.`annotation`.processing.Generated
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass
import kotlin.time.Instant
import kotlinx.coroutines.flow.Flow
import world.respect.datalayer.db.school.entities.PersonPasskeyEntity
import world.respect.datalayer.db.shared.SharedConverters

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class PersonPasskeyEntityDao_Impl(
  __db: RoomDatabase,
) : PersonPasskeyEntityDao() {
  private val __db: RoomDatabase

  private val __insertAdapterOfPersonPasskeyEntity: EntityInsertAdapter<PersonPasskeyEntity>

  private val __sharedConverters: SharedConverters = SharedConverters()
  init {
    this.__db = __db
    this.__insertAdapterOfPersonPasskeyEntity = object : EntityInsertAdapter<PersonPasskeyEntity>() {
      protected override fun createQuery(): String = "INSERT OR REPLACE INTO `PersonPasskeyEntity` (`ppPersonUidNum`,`ppCredentialId`,`ppLastModified`,`ppStored`,`ppAttestationObj`,`ppClientDataJson`,`ppOriginString`,`ppChallengeString`,`ppPublicKey`,`isRevoked`,`ppDeviceName`,`ppTimeCreated`,`ppAaguid`,`ppProviderName`,`ppIconLight`,`ppIconDark`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: PersonPasskeyEntity) {
        statement.bindLong(1, entity.ppPersonUidNum)
        statement.bindText(2, entity.ppCredentialId)
        val _tmp: Long? = __sharedConverters.fromInstant(entity.ppLastModified)
        if (_tmp == null) {
          statement.bindNull(3)
        } else {
          statement.bindLong(3, _tmp)
        }
        val _tmp_1: Long? = __sharedConverters.fromInstant(entity.ppStored)
        if (_tmp_1 == null) {
          statement.bindNull(4)
        } else {
          statement.bindLong(4, _tmp_1)
        }
        val _tmpPpAttestationObj: String? = entity.ppAttestationObj
        if (_tmpPpAttestationObj == null) {
          statement.bindNull(5)
        } else {
          statement.bindText(5, _tmpPpAttestationObj)
        }
        val _tmpPpClientDataJson: String? = entity.ppClientDataJson
        if (_tmpPpClientDataJson == null) {
          statement.bindNull(6)
        } else {
          statement.bindText(6, _tmpPpClientDataJson)
        }
        val _tmpPpOriginString: String? = entity.ppOriginString
        if (_tmpPpOriginString == null) {
          statement.bindNull(7)
        } else {
          statement.bindText(7, _tmpPpOriginString)
        }
        val _tmpPpChallengeString: String? = entity.ppChallengeString
        if (_tmpPpChallengeString == null) {
          statement.bindNull(8)
        } else {
          statement.bindText(8, _tmpPpChallengeString)
        }
        val _tmpPpPublicKey: String? = entity.ppPublicKey
        if (_tmpPpPublicKey == null) {
          statement.bindNull(9)
        } else {
          statement.bindText(9, _tmpPpPublicKey)
        }
        statement.bindLong(10, entity.isRevoked.toLong())
        statement.bindText(11, entity.ppDeviceName)
        val _tmp_2: Long? = __sharedConverters.fromInstant(entity.ppTimeCreated)
        if (_tmp_2 == null) {
          statement.bindNull(12)
        } else {
          statement.bindLong(12, _tmp_2)
        }
        statement.bindText(13, entity.ppAaguid)
        statement.bindText(14, entity.ppProviderName)
        statement.bindText(15, entity.ppIconLight)
        statement.bindText(16, entity.ppIconDark)
      }
    }
  }

  public override suspend fun upsertAsync(personPasskey: List<PersonPasskeyEntity>): Unit = performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfPersonPasskeyEntity.insert(_connection, personPasskey)
  }

  public override suspend fun allPasskey(): List<String> {
    val _sql: String = """
        |
        |        SELECT ppCredentialId
        |          FROM PersonPasskeyEntity
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        val _result: MutableList<String> = mutableListOf()
        while (_stmt.step()) {
          val _item: String
          _item = _stmt.getText(0)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun getAllActivePasskeys(uid: Long): Flow<List<PersonPasskeyEntity>> {
    val _sql: String = """
        |
        |        SELECT * 
        |          FROM PersonPasskeyEntity
        |         WHERE isRevoked = 0
        |           AND ppPersonUidNum = ?
        |    
        """.trimMargin()
    return createFlow(__db, false, arrayOf("PersonPasskeyEntity")) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, uid)
        val _columnIndexOfPpPersonUidNum: Int = getColumnIndexOrThrow(_stmt, "ppPersonUidNum")
        val _columnIndexOfPpCredentialId: Int = getColumnIndexOrThrow(_stmt, "ppCredentialId")
        val _columnIndexOfPpLastModified: Int = getColumnIndexOrThrow(_stmt, "ppLastModified")
        val _columnIndexOfPpStored: Int = getColumnIndexOrThrow(_stmt, "ppStored")
        val _columnIndexOfPpAttestationObj: Int = getColumnIndexOrThrow(_stmt, "ppAttestationObj")
        val _columnIndexOfPpClientDataJson: Int = getColumnIndexOrThrow(_stmt, "ppClientDataJson")
        val _columnIndexOfPpOriginString: Int = getColumnIndexOrThrow(_stmt, "ppOriginString")
        val _columnIndexOfPpChallengeString: Int = getColumnIndexOrThrow(_stmt, "ppChallengeString")
        val _columnIndexOfPpPublicKey: Int = getColumnIndexOrThrow(_stmt, "ppPublicKey")
        val _columnIndexOfIsRevoked: Int = getColumnIndexOrThrow(_stmt, "isRevoked")
        val _columnIndexOfPpDeviceName: Int = getColumnIndexOrThrow(_stmt, "ppDeviceName")
        val _columnIndexOfPpTimeCreated: Int = getColumnIndexOrThrow(_stmt, "ppTimeCreated")
        val _columnIndexOfPpAaguid: Int = getColumnIndexOrThrow(_stmt, "ppAaguid")
        val _columnIndexOfPpProviderName: Int = getColumnIndexOrThrow(_stmt, "ppProviderName")
        val _columnIndexOfPpIconLight: Int = getColumnIndexOrThrow(_stmt, "ppIconLight")
        val _columnIndexOfPpIconDark: Int = getColumnIndexOrThrow(_stmt, "ppIconDark")
        val _result: MutableList<PersonPasskeyEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: PersonPasskeyEntity
          val _tmpPpPersonUidNum: Long
          _tmpPpPersonUidNum = _stmt.getLong(_columnIndexOfPpPersonUidNum)
          val _tmpPpCredentialId: String
          _tmpPpCredentialId = _stmt.getText(_columnIndexOfPpCredentialId)
          val _tmpPpLastModified: Instant
          val _tmp: Long?
          if (_stmt.isNull(_columnIndexOfPpLastModified)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfPpLastModified)
          }
          val _tmp_1: Instant? = __sharedConverters.toInstant(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPpLastModified = _tmp_1
          }
          val _tmpPpStored: Instant
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfPpStored)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfPpStored)
          }
          val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPpStored = _tmp_3
          }
          val _tmpPpAttestationObj: String?
          if (_stmt.isNull(_columnIndexOfPpAttestationObj)) {
            _tmpPpAttestationObj = null
          } else {
            _tmpPpAttestationObj = _stmt.getText(_columnIndexOfPpAttestationObj)
          }
          val _tmpPpClientDataJson: String?
          if (_stmt.isNull(_columnIndexOfPpClientDataJson)) {
            _tmpPpClientDataJson = null
          } else {
            _tmpPpClientDataJson = _stmt.getText(_columnIndexOfPpClientDataJson)
          }
          val _tmpPpOriginString: String?
          if (_stmt.isNull(_columnIndexOfPpOriginString)) {
            _tmpPpOriginString = null
          } else {
            _tmpPpOriginString = _stmt.getText(_columnIndexOfPpOriginString)
          }
          val _tmpPpChallengeString: String?
          if (_stmt.isNull(_columnIndexOfPpChallengeString)) {
            _tmpPpChallengeString = null
          } else {
            _tmpPpChallengeString = _stmt.getText(_columnIndexOfPpChallengeString)
          }
          val _tmpPpPublicKey: String?
          if (_stmt.isNull(_columnIndexOfPpPublicKey)) {
            _tmpPpPublicKey = null
          } else {
            _tmpPpPublicKey = _stmt.getText(_columnIndexOfPpPublicKey)
          }
          val _tmpIsRevoked: Int
          _tmpIsRevoked = _stmt.getLong(_columnIndexOfIsRevoked).toInt()
          val _tmpPpDeviceName: String
          _tmpPpDeviceName = _stmt.getText(_columnIndexOfPpDeviceName)
          val _tmpPpTimeCreated: Instant
          val _tmp_4: Long?
          if (_stmt.isNull(_columnIndexOfPpTimeCreated)) {
            _tmp_4 = null
          } else {
            _tmp_4 = _stmt.getLong(_columnIndexOfPpTimeCreated)
          }
          val _tmp_5: Instant? = __sharedConverters.toInstant(_tmp_4)
          if (_tmp_5 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPpTimeCreated = _tmp_5
          }
          val _tmpPpAaguid: String
          _tmpPpAaguid = _stmt.getText(_columnIndexOfPpAaguid)
          val _tmpPpProviderName: String
          _tmpPpProviderName = _stmt.getText(_columnIndexOfPpProviderName)
          val _tmpPpIconLight: String
          _tmpPpIconLight = _stmt.getText(_columnIndexOfPpIconLight)
          val _tmpPpIconDark: String
          _tmpPpIconDark = _stmt.getText(_columnIndexOfPpIconDark)
          _item = PersonPasskeyEntity(_tmpPpPersonUidNum,_tmpPpCredentialId,_tmpPpLastModified,_tmpPpStored,_tmpPpAttestationObj,_tmpPpClientDataJson,_tmpPpOriginString,_tmpPpChallengeString,_tmpPpPublicKey,_tmpIsRevoked,_tmpPpDeviceName,_tmpPpTimeCreated,_tmpPpAaguid,_tmpPpProviderName,_tmpPpIconLight,_tmpPpIconDark)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun getAllActivePasskeysList(uid: Long): List<PersonPasskeyEntity> {
    val _sql: String = """
        |
        |        SELECT * 
        |          FROM PersonPasskeyEntity
        |         WHERE isRevoked = 0
        |           AND ppPersonUidNum = ?
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, uid)
        val _columnIndexOfPpPersonUidNum: Int = getColumnIndexOrThrow(_stmt, "ppPersonUidNum")
        val _columnIndexOfPpCredentialId: Int = getColumnIndexOrThrow(_stmt, "ppCredentialId")
        val _columnIndexOfPpLastModified: Int = getColumnIndexOrThrow(_stmt, "ppLastModified")
        val _columnIndexOfPpStored: Int = getColumnIndexOrThrow(_stmt, "ppStored")
        val _columnIndexOfPpAttestationObj: Int = getColumnIndexOrThrow(_stmt, "ppAttestationObj")
        val _columnIndexOfPpClientDataJson: Int = getColumnIndexOrThrow(_stmt, "ppClientDataJson")
        val _columnIndexOfPpOriginString: Int = getColumnIndexOrThrow(_stmt, "ppOriginString")
        val _columnIndexOfPpChallengeString: Int = getColumnIndexOrThrow(_stmt, "ppChallengeString")
        val _columnIndexOfPpPublicKey: Int = getColumnIndexOrThrow(_stmt, "ppPublicKey")
        val _columnIndexOfIsRevoked: Int = getColumnIndexOrThrow(_stmt, "isRevoked")
        val _columnIndexOfPpDeviceName: Int = getColumnIndexOrThrow(_stmt, "ppDeviceName")
        val _columnIndexOfPpTimeCreated: Int = getColumnIndexOrThrow(_stmt, "ppTimeCreated")
        val _columnIndexOfPpAaguid: Int = getColumnIndexOrThrow(_stmt, "ppAaguid")
        val _columnIndexOfPpProviderName: Int = getColumnIndexOrThrow(_stmt, "ppProviderName")
        val _columnIndexOfPpIconLight: Int = getColumnIndexOrThrow(_stmt, "ppIconLight")
        val _columnIndexOfPpIconDark: Int = getColumnIndexOrThrow(_stmt, "ppIconDark")
        val _result: MutableList<PersonPasskeyEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: PersonPasskeyEntity
          val _tmpPpPersonUidNum: Long
          _tmpPpPersonUidNum = _stmt.getLong(_columnIndexOfPpPersonUidNum)
          val _tmpPpCredentialId: String
          _tmpPpCredentialId = _stmt.getText(_columnIndexOfPpCredentialId)
          val _tmpPpLastModified: Instant
          val _tmp: Long?
          if (_stmt.isNull(_columnIndexOfPpLastModified)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfPpLastModified)
          }
          val _tmp_1: Instant? = __sharedConverters.toInstant(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPpLastModified = _tmp_1
          }
          val _tmpPpStored: Instant
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfPpStored)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfPpStored)
          }
          val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPpStored = _tmp_3
          }
          val _tmpPpAttestationObj: String?
          if (_stmt.isNull(_columnIndexOfPpAttestationObj)) {
            _tmpPpAttestationObj = null
          } else {
            _tmpPpAttestationObj = _stmt.getText(_columnIndexOfPpAttestationObj)
          }
          val _tmpPpClientDataJson: String?
          if (_stmt.isNull(_columnIndexOfPpClientDataJson)) {
            _tmpPpClientDataJson = null
          } else {
            _tmpPpClientDataJson = _stmt.getText(_columnIndexOfPpClientDataJson)
          }
          val _tmpPpOriginString: String?
          if (_stmt.isNull(_columnIndexOfPpOriginString)) {
            _tmpPpOriginString = null
          } else {
            _tmpPpOriginString = _stmt.getText(_columnIndexOfPpOriginString)
          }
          val _tmpPpChallengeString: String?
          if (_stmt.isNull(_columnIndexOfPpChallengeString)) {
            _tmpPpChallengeString = null
          } else {
            _tmpPpChallengeString = _stmt.getText(_columnIndexOfPpChallengeString)
          }
          val _tmpPpPublicKey: String?
          if (_stmt.isNull(_columnIndexOfPpPublicKey)) {
            _tmpPpPublicKey = null
          } else {
            _tmpPpPublicKey = _stmt.getText(_columnIndexOfPpPublicKey)
          }
          val _tmpIsRevoked: Int
          _tmpIsRevoked = _stmt.getLong(_columnIndexOfIsRevoked).toInt()
          val _tmpPpDeviceName: String
          _tmpPpDeviceName = _stmt.getText(_columnIndexOfPpDeviceName)
          val _tmpPpTimeCreated: Instant
          val _tmp_4: Long?
          if (_stmt.isNull(_columnIndexOfPpTimeCreated)) {
            _tmp_4 = null
          } else {
            _tmp_4 = _stmt.getLong(_columnIndexOfPpTimeCreated)
          }
          val _tmp_5: Instant? = __sharedConverters.toInstant(_tmp_4)
          if (_tmp_5 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPpTimeCreated = _tmp_5
          }
          val _tmpPpAaguid: String
          _tmpPpAaguid = _stmt.getText(_columnIndexOfPpAaguid)
          val _tmpPpProviderName: String
          _tmpPpProviderName = _stmt.getText(_columnIndexOfPpProviderName)
          val _tmpPpIconLight: String
          _tmpPpIconLight = _stmt.getText(_columnIndexOfPpIconLight)
          val _tmpPpIconDark: String
          _tmpPpIconDark = _stmt.getText(_columnIndexOfPpIconDark)
          _item = PersonPasskeyEntity(_tmpPpPersonUidNum,_tmpPpCredentialId,_tmpPpLastModified,_tmpPpStored,_tmpPpAttestationObj,_tmpPpClientDataJson,_tmpPpOriginString,_tmpPpChallengeString,_tmpPpPublicKey,_tmpIsRevoked,_tmpPpDeviceName,_tmpPpTimeCreated,_tmpPpAaguid,_tmpPpProviderName,_tmpPpIconLight,_tmpPpIconDark)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findPersonPasskeyFromClientDataJson(id: String): PersonPasskeyEntity? {
    val _sql: String = """
        |
        |        SELECT *
        |          FROM PersonPasskeyEntity
        |         WHERE PersonPasskeyEntity.ppCredentialId = ?
        |           AND PersonPasskeyEntity.isRevoked = 0
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, id)
        val _columnIndexOfPpPersonUidNum: Int = getColumnIndexOrThrow(_stmt, "ppPersonUidNum")
        val _columnIndexOfPpCredentialId: Int = getColumnIndexOrThrow(_stmt, "ppCredentialId")
        val _columnIndexOfPpLastModified: Int = getColumnIndexOrThrow(_stmt, "ppLastModified")
        val _columnIndexOfPpStored: Int = getColumnIndexOrThrow(_stmt, "ppStored")
        val _columnIndexOfPpAttestationObj: Int = getColumnIndexOrThrow(_stmt, "ppAttestationObj")
        val _columnIndexOfPpClientDataJson: Int = getColumnIndexOrThrow(_stmt, "ppClientDataJson")
        val _columnIndexOfPpOriginString: Int = getColumnIndexOrThrow(_stmt, "ppOriginString")
        val _columnIndexOfPpChallengeString: Int = getColumnIndexOrThrow(_stmt, "ppChallengeString")
        val _columnIndexOfPpPublicKey: Int = getColumnIndexOrThrow(_stmt, "ppPublicKey")
        val _columnIndexOfIsRevoked: Int = getColumnIndexOrThrow(_stmt, "isRevoked")
        val _columnIndexOfPpDeviceName: Int = getColumnIndexOrThrow(_stmt, "ppDeviceName")
        val _columnIndexOfPpTimeCreated: Int = getColumnIndexOrThrow(_stmt, "ppTimeCreated")
        val _columnIndexOfPpAaguid: Int = getColumnIndexOrThrow(_stmt, "ppAaguid")
        val _columnIndexOfPpProviderName: Int = getColumnIndexOrThrow(_stmt, "ppProviderName")
        val _columnIndexOfPpIconLight: Int = getColumnIndexOrThrow(_stmt, "ppIconLight")
        val _columnIndexOfPpIconDark: Int = getColumnIndexOrThrow(_stmt, "ppIconDark")
        val _result: PersonPasskeyEntity?
        if (_stmt.step()) {
          val _tmpPpPersonUidNum: Long
          _tmpPpPersonUidNum = _stmt.getLong(_columnIndexOfPpPersonUidNum)
          val _tmpPpCredentialId: String
          _tmpPpCredentialId = _stmt.getText(_columnIndexOfPpCredentialId)
          val _tmpPpLastModified: Instant
          val _tmp: Long?
          if (_stmt.isNull(_columnIndexOfPpLastModified)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfPpLastModified)
          }
          val _tmp_1: Instant? = __sharedConverters.toInstant(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPpLastModified = _tmp_1
          }
          val _tmpPpStored: Instant
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfPpStored)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfPpStored)
          }
          val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPpStored = _tmp_3
          }
          val _tmpPpAttestationObj: String?
          if (_stmt.isNull(_columnIndexOfPpAttestationObj)) {
            _tmpPpAttestationObj = null
          } else {
            _tmpPpAttestationObj = _stmt.getText(_columnIndexOfPpAttestationObj)
          }
          val _tmpPpClientDataJson: String?
          if (_stmt.isNull(_columnIndexOfPpClientDataJson)) {
            _tmpPpClientDataJson = null
          } else {
            _tmpPpClientDataJson = _stmt.getText(_columnIndexOfPpClientDataJson)
          }
          val _tmpPpOriginString: String?
          if (_stmt.isNull(_columnIndexOfPpOriginString)) {
            _tmpPpOriginString = null
          } else {
            _tmpPpOriginString = _stmt.getText(_columnIndexOfPpOriginString)
          }
          val _tmpPpChallengeString: String?
          if (_stmt.isNull(_columnIndexOfPpChallengeString)) {
            _tmpPpChallengeString = null
          } else {
            _tmpPpChallengeString = _stmt.getText(_columnIndexOfPpChallengeString)
          }
          val _tmpPpPublicKey: String?
          if (_stmt.isNull(_columnIndexOfPpPublicKey)) {
            _tmpPpPublicKey = null
          } else {
            _tmpPpPublicKey = _stmt.getText(_columnIndexOfPpPublicKey)
          }
          val _tmpIsRevoked: Int
          _tmpIsRevoked = _stmt.getLong(_columnIndexOfIsRevoked).toInt()
          val _tmpPpDeviceName: String
          _tmpPpDeviceName = _stmt.getText(_columnIndexOfPpDeviceName)
          val _tmpPpTimeCreated: Instant
          val _tmp_4: Long?
          if (_stmt.isNull(_columnIndexOfPpTimeCreated)) {
            _tmp_4 = null
          } else {
            _tmp_4 = _stmt.getLong(_columnIndexOfPpTimeCreated)
          }
          val _tmp_5: Instant? = __sharedConverters.toInstant(_tmp_4)
          if (_tmp_5 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPpTimeCreated = _tmp_5
          }
          val _tmpPpAaguid: String
          _tmpPpAaguid = _stmt.getText(_columnIndexOfPpAaguid)
          val _tmpPpProviderName: String
          _tmpPpProviderName = _stmt.getText(_columnIndexOfPpProviderName)
          val _tmpPpIconLight: String
          _tmpPpIconLight = _stmt.getText(_columnIndexOfPpIconLight)
          val _tmpPpIconDark: String
          _tmpPpIconDark = _stmt.getText(_columnIndexOfPpIconDark)
          _result = PersonPasskeyEntity(_tmpPpPersonUidNum,_tmpPpCredentialId,_tmpPpLastModified,_tmpPpStored,_tmpPpAttestationObj,_tmpPpClientDataJson,_tmpPpOriginString,_tmpPpChallengeString,_tmpPpPublicKey,_tmpIsRevoked,_tmpPpDeviceName,_tmpPpTimeCreated,_tmpPpAaguid,_tmpPpProviderName,_tmpPpIconLight,_tmpPpIconDark)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findByPersonUidAndCredentialId(uid: Long, credentialId: String): PersonPasskeyEntity? {
    val _sql: String = """
        |
        |        SELECT PersonPasskeyEntity.*
        |          FROM PersonPasskeyEntity
        |         WHERE PersonPasskeyEntity.ppPersonUidNum = ?
        |           AND PersonPasskeyEntity.ppCredentialId = ?
        |           AND PersonPasskeyEntity.isRevoked = 0
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, uid)
        _argIndex = 2
        _stmt.bindText(_argIndex, credentialId)
        val _columnIndexOfPpPersonUidNum: Int = getColumnIndexOrThrow(_stmt, "ppPersonUidNum")
        val _columnIndexOfPpCredentialId: Int = getColumnIndexOrThrow(_stmt, "ppCredentialId")
        val _columnIndexOfPpLastModified: Int = getColumnIndexOrThrow(_stmt, "ppLastModified")
        val _columnIndexOfPpStored: Int = getColumnIndexOrThrow(_stmt, "ppStored")
        val _columnIndexOfPpAttestationObj: Int = getColumnIndexOrThrow(_stmt, "ppAttestationObj")
        val _columnIndexOfPpClientDataJson: Int = getColumnIndexOrThrow(_stmt, "ppClientDataJson")
        val _columnIndexOfPpOriginString: Int = getColumnIndexOrThrow(_stmt, "ppOriginString")
        val _columnIndexOfPpChallengeString: Int = getColumnIndexOrThrow(_stmt, "ppChallengeString")
        val _columnIndexOfPpPublicKey: Int = getColumnIndexOrThrow(_stmt, "ppPublicKey")
        val _columnIndexOfIsRevoked: Int = getColumnIndexOrThrow(_stmt, "isRevoked")
        val _columnIndexOfPpDeviceName: Int = getColumnIndexOrThrow(_stmt, "ppDeviceName")
        val _columnIndexOfPpTimeCreated: Int = getColumnIndexOrThrow(_stmt, "ppTimeCreated")
        val _columnIndexOfPpAaguid: Int = getColumnIndexOrThrow(_stmt, "ppAaguid")
        val _columnIndexOfPpProviderName: Int = getColumnIndexOrThrow(_stmt, "ppProviderName")
        val _columnIndexOfPpIconLight: Int = getColumnIndexOrThrow(_stmt, "ppIconLight")
        val _columnIndexOfPpIconDark: Int = getColumnIndexOrThrow(_stmt, "ppIconDark")
        val _result: PersonPasskeyEntity?
        if (_stmt.step()) {
          val _tmpPpPersonUidNum: Long
          _tmpPpPersonUidNum = _stmt.getLong(_columnIndexOfPpPersonUidNum)
          val _tmpPpCredentialId: String
          _tmpPpCredentialId = _stmt.getText(_columnIndexOfPpCredentialId)
          val _tmpPpLastModified: Instant
          val _tmp: Long?
          if (_stmt.isNull(_columnIndexOfPpLastModified)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfPpLastModified)
          }
          val _tmp_1: Instant? = __sharedConverters.toInstant(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPpLastModified = _tmp_1
          }
          val _tmpPpStored: Instant
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfPpStored)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfPpStored)
          }
          val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPpStored = _tmp_3
          }
          val _tmpPpAttestationObj: String?
          if (_stmt.isNull(_columnIndexOfPpAttestationObj)) {
            _tmpPpAttestationObj = null
          } else {
            _tmpPpAttestationObj = _stmt.getText(_columnIndexOfPpAttestationObj)
          }
          val _tmpPpClientDataJson: String?
          if (_stmt.isNull(_columnIndexOfPpClientDataJson)) {
            _tmpPpClientDataJson = null
          } else {
            _tmpPpClientDataJson = _stmt.getText(_columnIndexOfPpClientDataJson)
          }
          val _tmpPpOriginString: String?
          if (_stmt.isNull(_columnIndexOfPpOriginString)) {
            _tmpPpOriginString = null
          } else {
            _tmpPpOriginString = _stmt.getText(_columnIndexOfPpOriginString)
          }
          val _tmpPpChallengeString: String?
          if (_stmt.isNull(_columnIndexOfPpChallengeString)) {
            _tmpPpChallengeString = null
          } else {
            _tmpPpChallengeString = _stmt.getText(_columnIndexOfPpChallengeString)
          }
          val _tmpPpPublicKey: String?
          if (_stmt.isNull(_columnIndexOfPpPublicKey)) {
            _tmpPpPublicKey = null
          } else {
            _tmpPpPublicKey = _stmt.getText(_columnIndexOfPpPublicKey)
          }
          val _tmpIsRevoked: Int
          _tmpIsRevoked = _stmt.getLong(_columnIndexOfIsRevoked).toInt()
          val _tmpPpDeviceName: String
          _tmpPpDeviceName = _stmt.getText(_columnIndexOfPpDeviceName)
          val _tmpPpTimeCreated: Instant
          val _tmp_4: Long?
          if (_stmt.isNull(_columnIndexOfPpTimeCreated)) {
            _tmp_4 = null
          } else {
            _tmp_4 = _stmt.getLong(_columnIndexOfPpTimeCreated)
          }
          val _tmp_5: Instant? = __sharedConverters.toInstant(_tmp_4)
          if (_tmp_5 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPpTimeCreated = _tmp_5
          }
          val _tmpPpAaguid: String
          _tmpPpAaguid = _stmt.getText(_columnIndexOfPpAaguid)
          val _tmpPpProviderName: String
          _tmpPpProviderName = _stmt.getText(_columnIndexOfPpProviderName)
          val _tmpPpIconLight: String
          _tmpPpIconLight = _stmt.getText(_columnIndexOfPpIconLight)
          val _tmpPpIconDark: String
          _tmpPpIconDark = _stmt.getText(_columnIndexOfPpIconDark)
          _result = PersonPasskeyEntity(_tmpPpPersonUidNum,_tmpPpCredentialId,_tmpPpLastModified,_tmpPpStored,_tmpPpAttestationObj,_tmpPpClientDataJson,_tmpPpOriginString,_tmpPpChallengeString,_tmpPpPublicKey,_tmpIsRevoked,_tmpPpDeviceName,_tmpPpTimeCreated,_tmpPpAaguid,_tmpPpProviderName,_tmpPpIconLight,_tmpPpIconDark)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findAll(personGuidNumber: Long, includeRevoked: Int): List<PersonPasskeyEntity> {
    val _sql: String = """
        |
        |        SELECT PersonPasskeyEntity.*
        |          FROM PersonPasskeyEntity
        |         WHERE PersonPasskeyEntity.ppPersonUidNum = ?
        |           AND (? = 1 
        |                OR PersonPasskeyEntity.isRevoked = 0)
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, personGuidNumber)
        _argIndex = 2
        _stmt.bindLong(_argIndex, includeRevoked.toLong())
        val _columnIndexOfPpPersonUidNum: Int = getColumnIndexOrThrow(_stmt, "ppPersonUidNum")
        val _columnIndexOfPpCredentialId: Int = getColumnIndexOrThrow(_stmt, "ppCredentialId")
        val _columnIndexOfPpLastModified: Int = getColumnIndexOrThrow(_stmt, "ppLastModified")
        val _columnIndexOfPpStored: Int = getColumnIndexOrThrow(_stmt, "ppStored")
        val _columnIndexOfPpAttestationObj: Int = getColumnIndexOrThrow(_stmt, "ppAttestationObj")
        val _columnIndexOfPpClientDataJson: Int = getColumnIndexOrThrow(_stmt, "ppClientDataJson")
        val _columnIndexOfPpOriginString: Int = getColumnIndexOrThrow(_stmt, "ppOriginString")
        val _columnIndexOfPpChallengeString: Int = getColumnIndexOrThrow(_stmt, "ppChallengeString")
        val _columnIndexOfPpPublicKey: Int = getColumnIndexOrThrow(_stmt, "ppPublicKey")
        val _columnIndexOfIsRevoked: Int = getColumnIndexOrThrow(_stmt, "isRevoked")
        val _columnIndexOfPpDeviceName: Int = getColumnIndexOrThrow(_stmt, "ppDeviceName")
        val _columnIndexOfPpTimeCreated: Int = getColumnIndexOrThrow(_stmt, "ppTimeCreated")
        val _columnIndexOfPpAaguid: Int = getColumnIndexOrThrow(_stmt, "ppAaguid")
        val _columnIndexOfPpProviderName: Int = getColumnIndexOrThrow(_stmt, "ppProviderName")
        val _columnIndexOfPpIconLight: Int = getColumnIndexOrThrow(_stmt, "ppIconLight")
        val _columnIndexOfPpIconDark: Int = getColumnIndexOrThrow(_stmt, "ppIconDark")
        val _result: MutableList<PersonPasskeyEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: PersonPasskeyEntity
          val _tmpPpPersonUidNum: Long
          _tmpPpPersonUidNum = _stmt.getLong(_columnIndexOfPpPersonUidNum)
          val _tmpPpCredentialId: String
          _tmpPpCredentialId = _stmt.getText(_columnIndexOfPpCredentialId)
          val _tmpPpLastModified: Instant
          val _tmp: Long?
          if (_stmt.isNull(_columnIndexOfPpLastModified)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfPpLastModified)
          }
          val _tmp_1: Instant? = __sharedConverters.toInstant(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPpLastModified = _tmp_1
          }
          val _tmpPpStored: Instant
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfPpStored)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfPpStored)
          }
          val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPpStored = _tmp_3
          }
          val _tmpPpAttestationObj: String?
          if (_stmt.isNull(_columnIndexOfPpAttestationObj)) {
            _tmpPpAttestationObj = null
          } else {
            _tmpPpAttestationObj = _stmt.getText(_columnIndexOfPpAttestationObj)
          }
          val _tmpPpClientDataJson: String?
          if (_stmt.isNull(_columnIndexOfPpClientDataJson)) {
            _tmpPpClientDataJson = null
          } else {
            _tmpPpClientDataJson = _stmt.getText(_columnIndexOfPpClientDataJson)
          }
          val _tmpPpOriginString: String?
          if (_stmt.isNull(_columnIndexOfPpOriginString)) {
            _tmpPpOriginString = null
          } else {
            _tmpPpOriginString = _stmt.getText(_columnIndexOfPpOriginString)
          }
          val _tmpPpChallengeString: String?
          if (_stmt.isNull(_columnIndexOfPpChallengeString)) {
            _tmpPpChallengeString = null
          } else {
            _tmpPpChallengeString = _stmt.getText(_columnIndexOfPpChallengeString)
          }
          val _tmpPpPublicKey: String?
          if (_stmt.isNull(_columnIndexOfPpPublicKey)) {
            _tmpPpPublicKey = null
          } else {
            _tmpPpPublicKey = _stmt.getText(_columnIndexOfPpPublicKey)
          }
          val _tmpIsRevoked: Int
          _tmpIsRevoked = _stmt.getLong(_columnIndexOfIsRevoked).toInt()
          val _tmpPpDeviceName: String
          _tmpPpDeviceName = _stmt.getText(_columnIndexOfPpDeviceName)
          val _tmpPpTimeCreated: Instant
          val _tmp_4: Long?
          if (_stmt.isNull(_columnIndexOfPpTimeCreated)) {
            _tmp_4 = null
          } else {
            _tmp_4 = _stmt.getLong(_columnIndexOfPpTimeCreated)
          }
          val _tmp_5: Instant? = __sharedConverters.toInstant(_tmp_4)
          if (_tmp_5 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPpTimeCreated = _tmp_5
          }
          val _tmpPpAaguid: String
          _tmpPpAaguid = _stmt.getText(_columnIndexOfPpAaguid)
          val _tmpPpProviderName: String
          _tmpPpProviderName = _stmt.getText(_columnIndexOfPpProviderName)
          val _tmpPpIconLight: String
          _tmpPpIconLight = _stmt.getText(_columnIndexOfPpIconLight)
          val _tmpPpIconDark: String
          _tmpPpIconDark = _stmt.getText(_columnIndexOfPpIconDark)
          _item = PersonPasskeyEntity(_tmpPpPersonUidNum,_tmpPpCredentialId,_tmpPpLastModified,_tmpPpStored,_tmpPpAttestationObj,_tmpPpClientDataJson,_tmpPpOriginString,_tmpPpChallengeString,_tmpPpPublicKey,_tmpIsRevoked,_tmpPpDeviceName,_tmpPpTimeCreated,_tmpPpAaguid,_tmpPpProviderName,_tmpPpIconLight,_tmpPpIconDark)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun findAllAsFlow(personGuidNumber: Long, includeRevoked: Int): Flow<List<PersonPasskeyEntity>> {
    val _sql: String = """
        |
        |        SELECT PersonPasskeyEntity.*
        |          FROM PersonPasskeyEntity
        |         WHERE PersonPasskeyEntity.ppPersonUidNum = ?
        |           AND (? = 1 
        |                OR PersonPasskeyEntity.isRevoked = 0)
        |    
        """.trimMargin()
    return createFlow(__db, false, arrayOf("PersonPasskeyEntity")) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, personGuidNumber)
        _argIndex = 2
        _stmt.bindLong(_argIndex, includeRevoked.toLong())
        val _columnIndexOfPpPersonUidNum: Int = getColumnIndexOrThrow(_stmt, "ppPersonUidNum")
        val _columnIndexOfPpCredentialId: Int = getColumnIndexOrThrow(_stmt, "ppCredentialId")
        val _columnIndexOfPpLastModified: Int = getColumnIndexOrThrow(_stmt, "ppLastModified")
        val _columnIndexOfPpStored: Int = getColumnIndexOrThrow(_stmt, "ppStored")
        val _columnIndexOfPpAttestationObj: Int = getColumnIndexOrThrow(_stmt, "ppAttestationObj")
        val _columnIndexOfPpClientDataJson: Int = getColumnIndexOrThrow(_stmt, "ppClientDataJson")
        val _columnIndexOfPpOriginString: Int = getColumnIndexOrThrow(_stmt, "ppOriginString")
        val _columnIndexOfPpChallengeString: Int = getColumnIndexOrThrow(_stmt, "ppChallengeString")
        val _columnIndexOfPpPublicKey: Int = getColumnIndexOrThrow(_stmt, "ppPublicKey")
        val _columnIndexOfIsRevoked: Int = getColumnIndexOrThrow(_stmt, "isRevoked")
        val _columnIndexOfPpDeviceName: Int = getColumnIndexOrThrow(_stmt, "ppDeviceName")
        val _columnIndexOfPpTimeCreated: Int = getColumnIndexOrThrow(_stmt, "ppTimeCreated")
        val _columnIndexOfPpAaguid: Int = getColumnIndexOrThrow(_stmt, "ppAaguid")
        val _columnIndexOfPpProviderName: Int = getColumnIndexOrThrow(_stmt, "ppProviderName")
        val _columnIndexOfPpIconLight: Int = getColumnIndexOrThrow(_stmt, "ppIconLight")
        val _columnIndexOfPpIconDark: Int = getColumnIndexOrThrow(_stmt, "ppIconDark")
        val _result: MutableList<PersonPasskeyEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: PersonPasskeyEntity
          val _tmpPpPersonUidNum: Long
          _tmpPpPersonUidNum = _stmt.getLong(_columnIndexOfPpPersonUidNum)
          val _tmpPpCredentialId: String
          _tmpPpCredentialId = _stmt.getText(_columnIndexOfPpCredentialId)
          val _tmpPpLastModified: Instant
          val _tmp: Long?
          if (_stmt.isNull(_columnIndexOfPpLastModified)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfPpLastModified)
          }
          val _tmp_1: Instant? = __sharedConverters.toInstant(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPpLastModified = _tmp_1
          }
          val _tmpPpStored: Instant
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfPpStored)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfPpStored)
          }
          val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPpStored = _tmp_3
          }
          val _tmpPpAttestationObj: String?
          if (_stmt.isNull(_columnIndexOfPpAttestationObj)) {
            _tmpPpAttestationObj = null
          } else {
            _tmpPpAttestationObj = _stmt.getText(_columnIndexOfPpAttestationObj)
          }
          val _tmpPpClientDataJson: String?
          if (_stmt.isNull(_columnIndexOfPpClientDataJson)) {
            _tmpPpClientDataJson = null
          } else {
            _tmpPpClientDataJson = _stmt.getText(_columnIndexOfPpClientDataJson)
          }
          val _tmpPpOriginString: String?
          if (_stmt.isNull(_columnIndexOfPpOriginString)) {
            _tmpPpOriginString = null
          } else {
            _tmpPpOriginString = _stmt.getText(_columnIndexOfPpOriginString)
          }
          val _tmpPpChallengeString: String?
          if (_stmt.isNull(_columnIndexOfPpChallengeString)) {
            _tmpPpChallengeString = null
          } else {
            _tmpPpChallengeString = _stmt.getText(_columnIndexOfPpChallengeString)
          }
          val _tmpPpPublicKey: String?
          if (_stmt.isNull(_columnIndexOfPpPublicKey)) {
            _tmpPpPublicKey = null
          } else {
            _tmpPpPublicKey = _stmt.getText(_columnIndexOfPpPublicKey)
          }
          val _tmpIsRevoked: Int
          _tmpIsRevoked = _stmt.getLong(_columnIndexOfIsRevoked).toInt()
          val _tmpPpDeviceName: String
          _tmpPpDeviceName = _stmt.getText(_columnIndexOfPpDeviceName)
          val _tmpPpTimeCreated: Instant
          val _tmp_4: Long?
          if (_stmt.isNull(_columnIndexOfPpTimeCreated)) {
            _tmp_4 = null
          } else {
            _tmp_4 = _stmt.getLong(_columnIndexOfPpTimeCreated)
          }
          val _tmp_5: Instant? = __sharedConverters.toInstant(_tmp_4)
          if (_tmp_5 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPpTimeCreated = _tmp_5
          }
          val _tmpPpAaguid: String
          _tmpPpAaguid = _stmt.getText(_columnIndexOfPpAaguid)
          val _tmpPpProviderName: String
          _tmpPpProviderName = _stmt.getText(_columnIndexOfPpProviderName)
          val _tmpPpIconLight: String
          _tmpPpIconLight = _stmt.getText(_columnIndexOfPpIconLight)
          val _tmpPpIconDark: String
          _tmpPpIconDark = _stmt.getText(_columnIndexOfPpIconDark)
          _item = PersonPasskeyEntity(_tmpPpPersonUidNum,_tmpPpCredentialId,_tmpPpLastModified,_tmpPpStored,_tmpPpAttestationObj,_tmpPpClientDataJson,_tmpPpOriginString,_tmpPpChallengeString,_tmpPpPublicKey,_tmpIsRevoked,_tmpPpDeviceName,_tmpPpTimeCreated,_tmpPpAaguid,_tmpPpProviderName,_tmpPpIconLight,_tmpPpIconDark)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun getLastModifiedByPersonUidAndKeyId(personUidNum: Long, passKeyId: String): Long? {
    val _sql: String = """
        |
        |        SELECT PersonPasskeyEntity.ppLastModified
        |          FROM PersonPasskeyEntity
        |         WHERE PersonPasskeyEntity.ppPersonUidNum = ?
        |           AND PersonPasskeyEntity.ppCredentialId = ?
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, personUidNum)
        _argIndex = 2
        _stmt.bindText(_argIndex, passKeyId)
        val _result: Long?
        if (_stmt.step()) {
          if (_stmt.isNull(0)) {
            _result = null
          } else {
            _result = _stmt.getLong(0)
          }
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun revokePersonPasskey(personUidNum: Long, passKeyId: String) {
    val _sql: String = """
        |
        |        UPDATE PersonPasskeyEntity
        |           SET isRevoked = 1
        |         WHERE ppPersonUidNum = ?
        |           AND ppCredentialId = ?
        |    
        """.trimMargin()
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, personUidNum)
        _argIndex = 2
        _stmt.bindText(_argIndex, passKeyId)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
