/*
 * Decompiled with CFR 0.152.
 */
package world.respect.server.util.ext;

import androidx.paging.PagingSource;
import io.ktor.http.DateUtilsKt;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.Url;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.auth.AuthenticationContext;
import io.ktor.server.auth.AuthenticationKt;
import io.ktor.server.auth.UserIdPrincipal;
import io.ktor.server.response.ApplicationResponsePropertiesKt;
import io.ktor.util.date.DateJvmKt;
import io.ktor.util.reflect.TypeInfo;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.time.Clock;
import kotlin.time.Instant;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.qualifier.TypeQualifier;
import org.koin.core.registry.ScopeRegistry;
import org.koin.core.scope.Scope;
import world.respect.datalayer.AuthenticatedUserPrincipalId;
import world.respect.datalayer.DataLoadState;
import world.respect.datalayer.DataReadyState;
import world.respect.datalayer.NoDataLoadedState;
import world.respect.datalayer.ext.DataLoadStateExtKt;
import world.respect.datalayer.respect.model.SchoolDirectoryEntry;
import world.respect.datalayer.shared.ModelWithTimes;
import world.respect.datalayer.shared.ModelWithTimesExtKt;
import world.respect.libutil.util.throwable.ForbiddenException;
import world.respect.server.util.ext.ApplicationRequestExtKt;
import world.respect.server.util.ext.ApplicationResponseExtKt;
import world.respect.shared.domain.account.RespectAccount;
import world.respect.shared.util.di.RespectAccountScopeId;
import world.respect.shared.util.di.SchoolDirectoryEntryScopeId;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0002\u001a\n\u0010\u0007\u001a\u00020\u0006*\u00020\u0002\u001a@\u0010\b\u001a\u00020\t\"\n\b\u0000\u0010\n\u0018\u0001*\u00020\u000b*\u00020\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u0002H\n0\u0010H\u0086H\u00a2\u0006\u0002\u0010\u0011\u001a,\u0010\u0012\u001a\u00020\t\"\n\b\u0000\u0010\n\u0018\u0001*\u00020\u000b*\u00020\u00022\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\n0\u0014H\u0086H\u00a2\u0006\u0002\u0010\u0015\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0016"}, d2={"virtualHost", "Lio/ktor/http/Url;", "Lio/ktor/server/application/ApplicationCall;", "getVirtualHost", "(Lio/ktor/server/application/ApplicationCall;)Lio/ktor/http/Url;", "getSchoolKoinScope", "Lorg/koin/core/scope/Scope;", "requireAccountScope", "respondOffsetLimitPaging", "", "T", "", "params", "Landroidx/paging/PagingSource$LoadParams;", "", "pagingSource", "Landroidx/paging/PagingSource;", "(Lio/ktor/server/application/ApplicationCall;Landroidx/paging/PagingSource$LoadParams;Landroidx/paging/PagingSource;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "respondDataLoadState", "dataLoadState", "Lworld/respect/datalayer/DataLoadState;", "(Lio/ktor/server/application/ApplicationCall;Lworld/respect/datalayer/DataLoadState;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "respect-server"})
@SourceDebugExtension(value={"SMAP\nApplicationCallExt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApplicationCallExt.kt\nworld/respect/server/util/ext/ApplicationCallExtKt\n+ 2 Koin.kt\norg/koin/core/Koin\n+ 3 Authentication.kt\nio/ktor/server/auth/AuthenticationKt\n+ 4 AuthenticationContext.kt\nio/ktor/server/auth/AuthenticationContext\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 ApplicationResponseFunctions.kt\nio/ktor/server/response/ApplicationResponseFunctionsKt\n+ 7 Type.kt\nio/ktor/util/reflect/TypeKt\n*L\n1#1,177:1\n241#2,2:178\n211#2,2:190\n132#3,9:180\n97#4:189\n1#5:192\n28#6:193\n29#6:203\n28#6:204\n29#6:214\n28#6:215\n29#6:225\n28#6:226\n29#6:236\n28#6:237\n29#6:247\n28#6:248\n29#6:258\n28#6:259\n29#6:269\n69#7:194\n84#7,8:195\n69#7:205\n84#7,8:206\n69#7:216\n84#7,8:217\n69#7:227\n84#7,8:228\n69#7:238\n84#7,8:239\n69#7:249\n84#7,8:250\n69#7:260\n84#7,8:261\n*S KotlinDebug\n*F\n+ 1 ApplicationCallExt.kt\nworld/respect/server/util/ext/ApplicationCallExtKt\n*L\n44#1:178,2\n60#1:190,2\n52#1:180,9\n52#1:189\n104#1:193\n104#1:203\n108#1:204\n108#1:214\n149#1:215\n149#1:225\n157#1:226\n157#1:236\n164#1:237\n164#1:247\n168#1:248\n168#1:258\n172#1:259\n172#1:269\n104#1:194\n104#1:195,8\n108#1:205\n108#1:206,8\n149#1:216\n149#1:217,8\n157#1:227\n157#1:228,8\n164#1:238\n164#1:239,8\n168#1:249\n168#1:250,8\n172#1:260\n172#1:261,8\n*E\n"})
public final class ApplicationCallExtKt {
    @NotNull
    public static final Url getVirtualHost(@NotNull ApplicationCall $this$virtualHost) {
        Intrinsics.checkNotNullParameter($this$virtualHost, "<this>");
        return ApplicationRequestExtKt.getVirtualHost($this$virtualHost.getRequest());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Scope getSchoolKoinScope(@NotNull ApplicationCall $this$getSchoolKoinScope) {
        void this_$iv;
        Intrinsics.checkNotNullParameter($this$getSchoolKoinScope, "<this>");
        Koin koin = org.koin.ktor.ext.ApplicationCallExtKt.getKoin($this$getSchoolKoinScope);
        String scopeId$iv = new SchoolDirectoryEntryScopeId(ApplicationRequestExtKt.getVirtualHost($this$getSchoolKoinScope.getRequest()), null).getScopeId();
        boolean $i$f$getOrCreateScope = false;
        TypeQualifier qualifier$iv = new TypeQualifier(Reflection.getOrCreateKotlinClass(SchoolDirectoryEntry.class));
        Scope scope2 = this_$iv.getScopeRegistry().getScopeOrNull(scopeId$iv);
        if (scope2 == null) {
            scope2 = Koin.createScope$default((Koin)this_$iv, scopeId$iv, qualifier$iv, null, null, 12, null);
        }
        return scope2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Scope requireAccountScope(@NotNull ApplicationCall $this$requireAccountScope) {
        void this_$iv$iv$iv;
        void $this$principal$iv$iv;
        Intrinsics.checkNotNullParameter($this$requireAccountScope, "<this>");
        ApplicationCall $this$principal$iv = $this$requireAccountScope;
        boolean $i$f$principal4 = false;
        ApplicationCall applicationCall = $this$principal$iv;
        String provider$iv$iv = null;
        boolean $i$f$principal2 = false;
        AuthenticationContext authenticationContext = AuthenticationKt.getAuthentication((ApplicationCall)$this$principal$iv$iv);
        String provider$iv$iv$iv = provider$iv$iv;
        boolean $i$f$principal3 = false;
        UserIdPrincipal userIdPrincipal = (UserIdPrincipal)this_$iv$iv$iv.principal(provider$iv$iv$iv, Reflection.getOrCreateKotlinClass(UserIdPrincipal.class));
        if (userIdPrincipal == null) {
            throw new ForbiddenException("Not authenticated", null, 2, null);
        }
        UserIdPrincipal authPrincipalId = userIdPrincipal;
        String scopeId = new RespectAccountScopeId(ApplicationRequestExtKt.getVirtualHost($this$requireAccountScope.getRequest()), new AuthenticatedUserPrincipalId(authPrincipalId.getName())).getScopeId();
        Scope scope2 = org.koin.ktor.ext.ApplicationCallExtKt.getKoin($this$requireAccountScope).getScopeOrNull(scopeId);
        if (scope2 == null) {
            void this_$iv;
            Scope scope3;
            Koin $i$f$principal4 = org.koin.ktor.ext.ApplicationCallExtKt.getKoin($this$requireAccountScope);
            String scopeId$iv = scopeId;
            boolean $i$f$createScope = false;
            TypeQualifier qualifier$iv = new TypeQualifier(Reflection.getOrCreateKotlinClass(RespectAccount.class));
            Scope it = scope3 = ScopeRegistry.createScope$default(this_$iv.getScopeRegistry(), scopeId$iv, qualifier$iv, null, null, 8, null);
            boolean bl = false;
            Scope[] scopeArray = new Scope[]{ApplicationCallExtKt.getSchoolKoinScope($this$requireAccountScope)};
            it.linkTo(scopeArray);
            scope2 = scope3;
        }
        return scope2;
    }

    public static final /* synthetic */ <T> Object respondOffsetLimitPaging(ApplicationCall $this$respondOffsetLimitPaging, PagingSource.LoadParams<Integer> params, PagingSource<Integer, T> pagingSource, Continuation<? super Unit> $completion) {
        PagingSource.LoadResult pagingLoadResult;
        boolean $i$f$respondOffsetLimitPaging = false;
        Instant consistentThrough = Clock.System.INSTANCE.now();
        InlineMarker.mark(0);
        Object object = pagingSource.load(params, $completion);
        InlineMarker.mark(1);
        PagingSource.LoadResult loadResult = pagingLoadResult = (PagingSource.LoadResult)object;
        if (loadResult instanceof PagingSource.LoadResult.Page) {
            KType kType;
            ApplicationCall $this$respond$iv;
            List message$iv;
            boolean $i$f$respond;
            Comparable<Instant> it;
            Object object2;
            Instant maxLastStored;
            List list2;
            List unwrappedList = ((PagingSource.LoadResult.Page)pagingLoadResult).getData();
            Object firstItem = CollectionsKt.firstOrNull(unwrappedList);
            if (firstItem instanceof ModelWithTimes) {
                Intrinsics.checkNotNull(unwrappedList, "null cannot be cast to non-null type kotlin.collections.List<world.respect.datalayer.shared.ModelWithTimes>");
                list2 = unwrappedList;
            } else {
                list2 = null;
            }
            List modelsWithTimes = list2;
            ApplicationResponsePropertiesKt.header($this$respondOffsetLimitPaging.getResponse(), "X-Consistent-Through", consistentThrough.toString());
            if (((PagingSource.LoadResult.Page)pagingLoadResult).getItemsBefore() != Integer.MIN_VALUE && ((PagingSource.LoadResult.Page)pagingLoadResult).getItemsAfter() != Integer.MIN_VALUE) {
                int totalItems = ((PagingSource.LoadResult.Page)pagingLoadResult).getItemsBefore() + ((PagingSource.LoadResult.Page)pagingLoadResult).getItemsAfter() + ((PagingSource.LoadResult.Page)pagingLoadResult).getData().size();
                ApplicationResponsePropertiesKt.header($this$respondOffsetLimitPaging.getResponse(), "X-Total-Count", totalItems);
            }
            Instant instant = maxLastStored = modelsWithTimes != null ? ModelWithTimesExtKt.maxLastStoredOrNull(modelsWithTimes) : null;
            if (maxLastStored != null) {
                object2 = maxLastStored;
                it = object2;
                boolean bl = false;
                ApplicationResponseExtKt.lastModified($this$respondOffsetLimitPaging.getResponse(), it);
                v3 = (Instant)object2;
            } else {
                v3 = null;
            }
            if (maxLastStored != null && ApplicationRequestExtKt.validateIfNotModifiedSince($this$respondOffsetLimitPaging.getRequest(), maxLastStored)) {
                KType kType2;
                object2 = $this$respondOffsetLimitPaging;
                it = HttpStatusCode.Companion.getNotModified();
                $i$f$respond = false;
                List list3 = message$iv;
                ApplicationCall applicationCall = $this$respond$iv;
                boolean $i$f$typeInfo = false;
                KClass kClass = Reflection.getOrCreateKotlinClass(HttpStatusCode.class);
                boolean $i$f$typeOfOrNull = false;
                try {
                    kType2 = Reflection.typeOf(HttpStatusCode.class);
                }
                catch (Throwable throwable) {
                    kType2 = null;
                }
                KType kType3 = kType2;
                KClass kClass2 = kClass;
                TypeInfo typeInfo = new TypeInfo(kClass2, kType3);
                InlineMarker.mark(0);
                applicationCall.respond(list3, typeInfo, $completion);
                InlineMarker.mark(1);
                return Unit.INSTANCE;
            }
            $this$respond$iv = $this$respondOffsetLimitPaging;
            message$iv = unwrappedList;
            $i$f$respond = false;
            List list4 = message$iv;
            ApplicationCall applicationCall = $this$respond$iv;
            boolean $i$f$typeInfo = false;
            KClass kClass = Reflection.getOrCreateKotlinClass(List.class);
            boolean $i$f$typeOfOrNull = false;
            try {
                Intrinsics.reifiedOperationMarker(6, "T");
                kType = Reflection.typeOf(List.class, KTypeProjection.Companion.invariant(null));
            }
            catch (Throwable throwable) {
                kType = null;
            }
            KType kType4 = kType;
            KClass kClass3 = kClass;
            TypeInfo typeInfo = new TypeInfo(kClass3, kType4);
            InlineMarker.mark(0);
            applicationCall.respond(list4, typeInfo, $completion);
            InlineMarker.mark(1);
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ <T> Object respondDataLoadState(ApplicationCall $this$respondDataLoadState, DataLoadState<T> dataLoadState, Continuation<? super Unit> $completion) {
        KType kType;
        boolean $i$f$respond;
        Object object;
        boolean $i$f$respondDataLoadState = false;
        String string2 = dataLoadState.getMetaInfo().getEtag();
        if (string2 != null) {
            object = string2;
            String it = object;
            boolean bl = false;
            ApplicationResponsePropertiesKt.header($this$respondDataLoadState.getResponse(), HttpHeaders.INSTANCE.getETag(), it);
            v0 = (String)object;
        } else {
            v0 = null;
        }
        Long lastModTimeStamp = DataLoadStateExtKt.lastModifiedForHttpResponseHeader(dataLoadState);
        if (lastModTimeStamp != null) {
            object = lastModTimeStamp;
            long it = ((Number)object).longValue();
            boolean bl = false;
            ApplicationResponsePropertiesKt.header($this$respondDataLoadState.getResponse(), HttpHeaders.INSTANCE.getLastModified(), DateUtilsKt.toHttpDate(DateJvmKt.GMTDate(it)));
            v1 = (Long)object;
        } else {
            v1 = null;
        }
        if (dataLoadState.getMetaInfo().getConsistentThrough() > 0L) {
            ApplicationResponsePropertiesKt.header($this$respondDataLoadState.getResponse(), "X-Consistent-Through", Instant.Companion.fromEpochMilliseconds(dataLoadState.getMetaInfo().getConsistentThrough()).toString());
        }
        if (lastModTimeStamp != null && ApplicationRequestExtKt.validateIfNotModifiedSince($this$respondDataLoadState.getRequest(), Instant.Companion.fromEpochMilliseconds(lastModTimeStamp))) {
            KType kType2;
            void $this$respond$iv;
            void message$iv2;
            object = $this$respondDataLoadState;
            HttpStatusCode it = HttpStatusCode.Companion.getNotModified();
            boolean $i$f$respond2 = false;
            void bl = message$iv2;
            void var9_20 = $this$respond$iv;
            boolean $i$f$typeInfo = false;
            KClass kClass = Reflection.getOrCreateKotlinClass(HttpStatusCode.class);
            boolean $i$f$typeOfOrNull = false;
            try {
                kType2 = Reflection.typeOf(HttpStatusCode.class);
            }
            catch (Throwable throwable) {
                kType2 = null;
            }
            KType kType3 = kType2;
            KClass kClass2 = kClass;
            TypeInfo typeInfo = new TypeInfo(kClass2, kType3);
            InlineMarker.mark(0);
            var9_20.respond(bl, typeInfo, $completion);
            InlineMarker.mark(1);
            return Unit.INSTANCE;
        }
        String ifNoneMatchRequestHeader = $this$respondDataLoadState.getRequest().getHeaders().get(HttpHeaders.INSTANCE.getIfNoneMatch());
        if (ifNoneMatchRequestHeader != null && Intrinsics.areEqual(ifNoneMatchRequestHeader, dataLoadState.getMetaInfo().getEtag())) {
            KType kType4;
            void $this$respond$iv;
            void message$iv;
            ApplicationCall message$iv2 = $this$respondDataLoadState;
            HttpStatusCode $i$f$respond2 = HttpStatusCode.Companion.getNotModified();
            $i$f$respond = false;
            void var9_21 = message$iv;
            void var10_26 = $this$respond$iv;
            boolean $i$f$typeInfo = false;
            KClass kClass = Reflection.getOrCreateKotlinClass(HttpStatusCode.class);
            boolean $i$f$typeOfOrNull = false;
            try {
                kType4 = Reflection.typeOf(HttpStatusCode.class);
            }
            catch (Throwable throwable) {
                kType4 = null;
            }
            KType kType5 = kType4;
            KClass kClass3 = kClass;
            TypeInfo typeInfo = new TypeInfo(kClass3, kType5);
            InlineMarker.mark(0);
            var10_26.respond(var9_21, typeInfo, $completion);
            InlineMarker.mark(1);
            return Unit.INSTANCE;
        }
        if (dataLoadState instanceof DataReadyState) {
            KType kType6;
            ApplicationCall $this$respond$iv = $this$respondDataLoadState;
            Object message$iv = ((DataReadyState)dataLoadState).getData();
            $i$f$respond = false;
            Object t = message$iv;
            ApplicationCall applicationCall = $this$respond$iv;
            boolean $i$f$typeInfo = false;
            Intrinsics.reifiedOperationMarker(4, "T");
            KClass kClass = Reflection.getOrCreateKotlinClass(Object.class);
            boolean $i$f$typeOfOrNull = false;
            try {
                Intrinsics.reifiedOperationMarker(6, "T");
                kType6 = null;
            }
            catch (Throwable throwable) {
                kType6 = null;
            }
            KType kType7 = kType6;
            KClass kClass4 = kClass;
            TypeInfo typeInfo = new TypeInfo(kClass4, kType7);
            InlineMarker.mark(0);
            applicationCall.respond(t, typeInfo, $completion);
            InlineMarker.mark(1);
            return Unit.INSTANCE;
        }
        if (dataLoadState instanceof NoDataLoadedState && ((NoDataLoadedState)dataLoadState).getReason() == NoDataLoadedState.Reason.NOT_FOUND) {
            KType kType8;
            ApplicationCall $this$respond$iv = $this$respondDataLoadState;
            HttpStatusCode message$iv = HttpStatusCode.Companion.getNotFound();
            $i$f$respond = false;
            HttpStatusCode httpStatusCode = message$iv;
            ApplicationCall applicationCall = $this$respond$iv;
            boolean $i$f$typeInfo = false;
            KClass kClass = Reflection.getOrCreateKotlinClass(HttpStatusCode.class);
            boolean $i$f$typeOfOrNull = false;
            try {
                kType8 = Reflection.typeOf(HttpStatusCode.class);
            }
            catch (Throwable throwable) {
                kType8 = null;
            }
            KType kType9 = kType8;
            KClass kClass5 = kClass;
            TypeInfo typeInfo = new TypeInfo(kClass5, kType9);
            InlineMarker.mark(0);
            applicationCall.respond(httpStatusCode, typeInfo, $completion);
            InlineMarker.mark(1);
            return Unit.INSTANCE;
        }
        ApplicationCall $this$respond$iv = $this$respondDataLoadState;
        HttpStatusCode message$iv = HttpStatusCode.Companion.getServiceUnavailable();
        $i$f$respond = false;
        HttpStatusCode httpStatusCode = message$iv;
        ApplicationCall applicationCall = $this$respond$iv;
        boolean $i$f$typeInfo = false;
        KClass kClass = Reflection.getOrCreateKotlinClass(HttpStatusCode.class);
        boolean $i$f$typeOfOrNull = false;
        try {
            kType = Reflection.typeOf(HttpStatusCode.class);
        }
        catch (Throwable throwable) {
            kType = null;
        }
        KType kType10 = kType;
        KClass kClass6 = kClass;
        TypeInfo typeInfo = new TypeInfo(kClass6, kType10);
        InlineMarker.mark(0);
        applicationCall.respond(httpStatusCode, typeInfo, $completion);
        InlineMarker.mark(1);
        return Unit.INSTANCE;
    }
}

