/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.asn1;

import java.io.IOException;
import org.apache.kerby.asn1.Asn1Binder;
import org.apache.kerby.asn1.parse.Asn1ParseResult;
import org.apache.kerby.asn1.type.Asn1Collection;
import org.apache.kerby.asn1.type.Asn1Constructed;
import org.apache.kerby.asn1.type.Asn1Simple;
import org.apache.kerby.asn1.type.Asn1Specific;
import org.apache.kerby.asn1.type.Asn1Type;

public final class Asn1Converter {
    private Asn1Converter() {
    }

    public static Asn1Type convert(Asn1ParseResult parseResult, boolean isLazy) throws IOException {
        if (Asn1Simple.isSimple(parseResult.tag())) {
            return Asn1Converter.convertAsSimple(parseResult);
        }
        if (Asn1Collection.isCollection(parseResult.tag())) {
            return Asn1Converter.convertAsCollection(parseResult, isLazy);
        }
        if (!parseResult.tag().isPrimitive()) {
            Asn1Constructed tmpValue = new Asn1Constructed(parseResult.tag());
            tmpValue.decode(parseResult);
            return tmpValue;
        }
        if (parseResult.isTagSpecific()) {
            Asn1Specific app = new Asn1Specific(parseResult.tag());
            app.decode(parseResult);
            return app;
        }
        throw new IOException("Unexpected item: " + parseResult.simpleInfo());
    }

    public static Asn1Type convertAsSimple(Asn1ParseResult parseResult) throws IOException {
        Asn1Simple<?> value = Asn1Simple.createSimple(parseResult.tagNo());
        value.useDefinitiveLength(parseResult.isDefinitiveLength());
        Asn1Binder.bind(parseResult, value);
        return value;
    }

    public static Asn1Type convertAsCollection(Asn1ParseResult parseResult, boolean isLazy) throws IOException {
        Asn1Collection value = Asn1Collection.createCollection(parseResult.tag());
        value.useDefinitiveLength(parseResult.isDefinitiveLength());
        value.setLazy(isLazy);
        Asn1Binder.bind(parseResult, value);
        return value;
    }

    public static Asn1Type convertAs(Asn1ParseResult parseResult, Class<? extends Asn1Type> type2) throws IOException {
        Asn1Type value;
        try {
            value = type2.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid type: " + type2.getCanonicalName(), e);
        }
        Asn1Binder.bind(parseResult, value);
        return value;
    }
}

