/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.Collector;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CollectorContext {
    private final Map<String, Object> collectorMap;
    private final Map<String, Object> collectorLoadMap;

    public CollectorContext() {
        this(new HashMap<String, Object>(), new HashMap<String, Object>());
    }

    public CollectorContext(Map<String, Object> collectorMap, Map<String, Object> collectorLoadMap) {
        this.collectorMap = collectorMap;
        this.collectorLoadMap = collectorLoadMap;
    }

    public <E> void add(String name, Collector<E> collector2) {
        this.collectorMap.put(name, collector2);
    }

    public <E> void add(String name, Object object) {
        this.collectorMap.put(name, object);
    }

    public Object get(String name) {
        Object object = this.collectorMap.get(name);
        if (object instanceof Collector && this.collectorLoadMap.get(name) != null) {
            return this.collectorLoadMap.get(name);
        }
        return this.collectorMap.get(name);
    }

    public Map<String, Object> getCollectorMap() {
        return this.collectorMap;
    }

    public Map<String, Object> getAll() {
        HashMap<String, Object> mergedMap = new HashMap<String, Object>();
        mergedMap.putAll(this.collectorMap);
        mergedMap.putAll(this.collectorLoadMap);
        return mergedMap;
    }

    public void combineWithCollector(String name, Object data2) {
        Object object = this.collectorMap.get(name);
        if (object instanceof Collector) {
            Collector collector2 = (Collector)object;
            collector2.combine(data2);
        }
    }

    public void loadCollectors() {
        Set<Map.Entry<String, Object>> entrySet = this.collectorMap.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            if (!(entry.getValue() instanceof Collector)) continue;
            Collector collector2 = (Collector)entry.getValue();
            this.collectorLoadMap.put(entry.getKey(), collector2.collect());
        }
    }
}

