/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.webauthn4j.data.attestation.statement.AttestationCertificatePath;
import com.webauthn4j.data.attestation.statement.CertificateBaseAttestationStatement;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.verifier.exception.ConstraintViolationException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(value={"format"})
@JsonTypeName(value="apple")
public class AppleAnonymousAttestationStatement
implements CertificateBaseAttestationStatement {
    public static final String FORMAT = "apple";
    @JsonProperty
    private final AttestationCertificatePath x5c;

    public AppleAnonymousAttestationStatement(@JsonProperty(value="x5c") @NotNull AttestationCertificatePath x5c) {
        AssertUtil.notNull(x5c, "x5c must not be null");
        this.x5c = x5c;
    }

    @Override
    @NotNull
    public AttestationCertificatePath getX5c() {
        return this.x5c;
    }

    @Override
    @JsonIgnore
    @NotNull
    public String getFormat() {
        return FORMAT;
    }

    @Override
    public void validate() {
        if (this.x5c.isEmpty()) {
            throw new ConstraintViolationException("No attestation certificate is found in apple anonymous attestation statement.");
        }
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppleAnonymousAttestationStatement that = (AppleAnonymousAttestationStatement)o;
        return Objects.equals(this.x5c, that.x5c);
    }

    public int hashCode() {
        return Objects.hash(this.x5c);
    }

    public String toString() {
        return "AppleAnonymousAttestationStatement(x5c=" + this.x5c + ")";
    }
}

