/*
 * Decompiled with CFR 0.152.
 */
package world.respect.shared.domain.phonenumber;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.i18n.phonenumbers.AsYouTypeFormatter;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import world.respect.shared.domain.phonenumber.AsYouTypeFormatterJvmKt;
import world.respect.shared.domain.phonenumber.IAsYouTypeFormatter;
import world.respect.shared.domain.phonenumber.IPhoneNumber;
import world.respect.shared.domain.phonenumber.IPhoneNumberUtil;
import world.respect.shared.domain.phonenumber.PhoneNumberJvm;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lworld/respect/shared/domain/phonenumber/PhoneNumberUtilJvm;", "Lworld/respect/shared/domain/phonenumber/IPhoneNumberUtil;", "phoneNumberUtil", "Lcom/google/i18n/phonenumbers/PhoneNumberUtil;", "<init>", "(Lcom/google/i18n/phonenumbers/PhoneNumberUtil;)V", "getAsYouTypeFormatter", "Lworld/respect/shared/domain/phonenumber/IAsYouTypeFormatter;", "regionCode", "", "getSupportedRegions", "", "getCountryCodeForRegion", "", "region", "getRegionForCountryCode", "countryCode", "parse", "Lworld/respect/shared/domain/phonenumber/IPhoneNumber;", "numberToParse", "defaultRegion", "isValidNumber", "", "number", "formatInternational", "respect-lib-shared"})
@StabilityInferred(parameters=0)
public final class PhoneNumberUtilJvm
implements IPhoneNumberUtil {
    @NotNull
    private final PhoneNumberUtil phoneNumberUtil;
    public static final int $stable = 8;

    public PhoneNumberUtilJvm(@NotNull PhoneNumberUtil phoneNumberUtil) {
        Intrinsics.checkNotNullParameter((Object)phoneNumberUtil, (String)"phoneNumberUtil");
        this.phoneNumberUtil = phoneNumberUtil;
    }

    @Override
    @NotNull
    public IAsYouTypeFormatter getAsYouTypeFormatter(@Nullable String regionCode) {
        AsYouTypeFormatter asYouTypeFormatter = this.phoneNumberUtil.getAsYouTypeFormatter(regionCode);
        Intrinsics.checkNotNullExpressionValue((Object)asYouTypeFormatter, (String)"getAsYouTypeFormatter(...)");
        return AsYouTypeFormatterJvmKt.asIAsYouTypeFormatter(asYouTypeFormatter);
    }

    @Override
    @NotNull
    public Set<String> getSupportedRegions() {
        Set set = this.phoneNumberUtil.getSupportedRegions();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getSupportedRegions(...)");
        return set;
    }

    @Override
    public int getCountryCodeForRegion(@NotNull String region) {
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        return this.phoneNumberUtil.getCountryCodeForRegion(region);
    }

    @Override
    @NotNull
    public String getRegionForCountryCode(int countryCode) {
        String string2 = this.phoneNumberUtil.getRegionCodeForCountryCode(countryCode);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getRegionCodeForCountryCode(...)");
        return string2;
    }

    @Override
    @NotNull
    public IPhoneNumber parse(@NotNull String numberToParse, @Nullable String defaultRegion) {
        Intrinsics.checkNotNullParameter((Object)numberToParse, (String)"numberToParse");
        Phonenumber.PhoneNumber phoneNumber = this.phoneNumberUtil.parse((CharSequence)numberToParse, defaultRegion);
        Intrinsics.checkNotNullExpressionValue((Object)phoneNumber, (String)"parse(...)");
        return new PhoneNumberJvm(phoneNumber);
    }

    @Override
    public boolean isValidNumber(@NotNull IPhoneNumber number) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        return this.phoneNumberUtil.isValidNumber(((PhoneNumberJvm)number).getPhoneNumber$respect_lib_shared());
    }

    @Override
    @NotNull
    public String formatInternational(@NotNull IPhoneNumber number) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        String string2 = this.phoneNumberUtil.format(((PhoneNumberJvm)number).getPhoneNumber$respect_lib_shared(), PhoneNumberUtil.PhoneNumberFormat.INTERNATIONAL);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }
}

