/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.PublicKeyCredentialDescriptor;
import com.webauthn4j.data.UserVerificationRequirement;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.data.extension.client.AuthenticationExtensionClientInput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientInputs;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.CollectionUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PublicKeyCredentialRequestOptions {
    private final Challenge challenge;
    private final Long timeout;
    private final String rpId;
    private final List<PublicKeyCredentialDescriptor> allowCredentials;
    private final UserVerificationRequirement userVerification;
    private final AuthenticationExtensionsClientInputs<AuthenticationExtensionClientInput> extensions;

    @JsonCreator
    public PublicKeyCredentialRequestOptions(@JsonProperty(value="challenge") @NotNull Challenge challenge, @JsonProperty(value="timeout") @Nullable Long timeout, @JsonProperty(value="rpId") @Nullable String rpId, @JsonProperty(value="allowCredentials") @Nullable List<PublicKeyCredentialDescriptor> allowCredentials, @JsonProperty(value="userVerification") @Nullable UserVerificationRequirement userVerification, @JsonProperty(value="extensions") @Nullable AuthenticationExtensionsClientInputs<AuthenticationExtensionClientInput> extensions) {
        AssertUtil.notNull((Object)challenge, (String)"challenge must not be null");
        this.challenge = challenge;
        this.timeout = timeout;
        this.rpId = rpId;
        this.allowCredentials = CollectionUtil.unmodifiableList(allowCredentials);
        this.userVerification = userVerification;
        this.extensions = extensions;
    }

    @NotNull
    public Challenge getChallenge() {
        return this.challenge;
    }

    @Nullable
    public Long getTimeout() {
        return this.timeout;
    }

    @Nullable
    public String getRpId() {
        return this.rpId;
    }

    @Nullable
    public List<PublicKeyCredentialDescriptor> getAllowCredentials() {
        return this.allowCredentials;
    }

    @Nullable
    public UserVerificationRequirement getUserVerification() {
        return this.userVerification;
    }

    @Nullable
    public AuthenticationExtensionsClientInputs<AuthenticationExtensionClientInput> getExtensions() {
        return this.extensions;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicKeyCredentialRequestOptions that = (PublicKeyCredentialRequestOptions)o;
        return Objects.equals(this.challenge, that.challenge) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.rpId, that.rpId) && Objects.equals(this.allowCredentials, that.allowCredentials) && Objects.equals(this.userVerification, that.userVerification) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.challenge, this.timeout, this.rpId, this.allowCredentials, this.userVerification, this.extensions);
    }

    public String toString() {
        return "PublicKeyCredentialRequestOptions(challenge=" + this.challenge + ", timeout=" + this.timeout + ", rpId=" + this.rpId + ", allowCredentials=" + this.allowCredentials + ", userVerification=" + this.userVerification + ", extensions=" + this.extensions + ")";
    }
}

