/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.serialization;

import androidx.annotation.RestrictTo;
import androidx.navigation.CollectionNavType;
import androidx.navigation.NavType;
import androidx.navigation.serialization.RouteSerializerKt;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.AbstractEncoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.modules.SerializersModuleBuildersKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B1\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u001a\u0010\u0006\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ \u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00120\u00072\u0006\u0010\u0016\u001a\u00020\u0002J)\u0010\u0017\u001a\u00020\u0018\"\u0004\b\u0001\u0010\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00010\u00192\u0006\u0010\u0016\u001a\u0002H\u0001H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0014H\u0016J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\b\u0010!\u001a\u00020\u0018H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0012\u0010$\u001a\u00020\u00182\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Landroidx/navigation/serialization/RouteEncoder;", "T", "", "Lkotlinx/serialization/encoding/AbstractEncoder;", "serializer", "Lkotlinx/serialization/KSerializer;", "typeMap", "", "", "Landroidx/navigation/NavType;", "<init>", "(Lkotlinx/serialization/KSerializer;Ljava/util/Map;)V", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "map", "", "", "elementIndex", "", "encodeToArgMap", "value", "encodeSerializableValue", "", "Lkotlinx/serialization/SerializationStrategy;", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "encodeElement", "", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "index", "encodeValue", "encodeNull", "encodeInline", "Lkotlinx/serialization/encoding/Encoder;", "internalEncodeValue", "navigation-common"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class RouteEncoder<T>
extends AbstractEncoder {
    @NotNull
    private final KSerializer<T> serializer;
    @NotNull
    private final Map<String, NavType<Object>> typeMap;
    @NotNull
    private final SerializersModule serializersModule;
    @NotNull
    private final Map<String, List<String>> map;
    private int elementIndex;

    public RouteEncoder(@NotNull KSerializer<T> serializer2, @NotNull Map<String, ? extends NavType<Object>> typeMap) {
        Intrinsics.checkNotNullParameter(serializer2, "serializer");
        Intrinsics.checkNotNullParameter(typeMap, "typeMap");
        this.serializer = serializer2;
        this.typeMap = typeMap;
        this.serializersModule = SerializersModuleBuildersKt.EmptySerializersModule();
        this.map = new LinkedHashMap();
        this.elementIndex = -1;
    }

    @Override
    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @NotNull
    public final Map<String, List<String>> encodeToArgMap(@NotNull Object value) {
        Intrinsics.checkNotNullParameter(value, "value");
        super.encodeSerializableValue((SerializationStrategy)this.serializer, value);
        return MapsKt.toMap(this.map);
    }

    @Override
    public <T> void encodeSerializableValue(@NotNull SerializationStrategy<? super T> serializer2, T value) {
        Intrinsics.checkNotNullParameter(serializer2, "serializer");
        this.internalEncodeValue(value);
    }

    @Override
    public boolean encodeElement(@NotNull SerialDescriptor descriptor2, int index2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        this.elementIndex = index2;
        return true;
    }

    @Override
    public void encodeValue(@NotNull Object value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.internalEncodeValue(value);
    }

    @Override
    public void encodeNull() {
        this.internalEncodeValue(null);
    }

    @Override
    @NotNull
    public Encoder encodeInline(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (RouteSerializerKt.isValueClass(descriptor2)) {
            this.elementIndex = 0;
        }
        return super.encodeInline(descriptor2);
    }

    private final void internalEncodeValue(Object value) {
        String argName = this.serializer.getDescriptor().getElementName(this.elementIndex);
        NavType<Object> navType = this.typeMap.get(argName);
        if (navType == null) {
            boolean $i$a$-checkNotNull-RouteEncoder$internalEncodeValue$22 = false;
            String $i$a$-checkNotNull-RouteEncoder$internalEncodeValue$22 = "Cannot find NavType for argument " + argName + ". Please provide NavType through typeMap.";
            throw new IllegalStateException($i$a$-checkNotNull-RouteEncoder$internalEncodeValue$22.toString());
        }
        List<String> parsedValue = navType instanceof CollectionNavType ? ((CollectionNavType)navType).serializeAsValues(value) : CollectionsKt.listOf(navType.serializeAsValue(value));
        this.map.put(argName, parsedValue);
    }
}

