/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.-SegmentedByteString;
import okio.Buffer;
import okio.ByteString;
import okio.ForwardingSink;
import okio.Segment;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0001\u001bB\u0019\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nB\u0019\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\u0006\u0010\rB!\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\u0010J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\r\u0010\u0018\u001a\u00020\u000fH\u0007\u00a2\u0006\u0002\b\u001aR\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u000f8G\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001c"}, d2={"Lokio/HashingSink;", "Lokio/ForwardingSink;", "Lokio/Sink;", "sink", "digest", "Ljava/security/MessageDigest;", "<init>", "(Lokio/Sink;Ljava/security/MessageDigest;)V", "algorithm", "", "(Lokio/Sink;Ljava/lang/String;)V", "mac", "Ljavax/crypto/Mac;", "(Lokio/Sink;Ljavax/crypto/Mac;)V", "key", "Lokio/ByteString;", "(Lokio/Sink;Lokio/ByteString;Ljava/lang/String;)V", "messageDigest", "write", "", "source", "Lokio/Buffer;", "byteCount", "", "hash", "()Lokio/ByteString;", "-deprecated_hash", "Companion", "okio"})
@SourceDebugExtension(value={"SMAP\nHashingSink.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HashingSink.kt\nokio/HashingSink\n+ 2 Util.kt\nokio/-SegmentedByteString\n*L\n1#1,149:1\n85#2:150\n*S KotlinDebug\n*F\n+ 1 HashingSink.kt\nokio/HashingSink\n*L\n76#1:150\n*E\n"})
public final class HashingSink
extends ForwardingSink
implements Sink {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final MessageDigest messageDigest;
    @Nullable
    private final Mac mac;

    public HashingSink(@NotNull Sink sink2, @NotNull MessageDigest digest) {
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        super(sink2);
        this.messageDigest = digest;
        this.mac = null;
    }

    public HashingSink(@NotNull Sink sink2, @NotNull String algorithm) {
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(...)");
        this(sink2, messageDigest);
    }

    public HashingSink(@NotNull Sink sink2, @NotNull Mac mac) {
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)mac, (String)"mac");
        super(sink2);
        this.mac = mac;
        this.messageDigest = null;
    }

    /*
     * WARNING - void declaration
     */
    public HashingSink(@NotNull Sink sink2, @NotNull ByteString key, @NotNull String algorithm) {
        Sink sink3;
        HashingSink hashingSink;
        Mac mac;
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Sink sink4 = sink2;
        HashingSink hashingSink2 = this;
        try {
            void $this$_init__u24lambda_u240;
            Mac mac2 = mac = Mac.getInstance(algorithm);
            Sink sink5 = sink4;
            HashingSink hashingSink3 = hashingSink2;
            boolean bl = false;
            $this$_init__u24lambda_u240.init(new SecretKeySpec(key.toByteArray(), algorithm));
            Unit unit = Unit.INSTANCE;
            hashingSink = hashingSink3;
            sink3 = sink5;
        }
        catch (InvalidKeyException $this$_init__u24lambda_u240) {
            void e;
            HashingSink hashingSink4 = hashingSink2;
            Sink sink6 = sink4;
            throw new IllegalArgumentException((Throwable)e);
        }
        Mac mac3 = mac;
        Intrinsics.checkNotNull((Object)mac3);
        hashingSink(sink3, mac3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(@NotNull Buffer source2, long byteCount) throws IOException {
        int toHash;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        -SegmentedByteString.checkOffsetAndCount(source2.size(), 0L, byteCount);
        Segment segment = source2.head;
        Intrinsics.checkNotNull((Object)segment);
        Segment s = segment;
        for (long hashedCount = 0L; hashedCount < byteCount; hashedCount += (long)toHash) {
            void a$iv;
            long l = byteCount - hashedCount;
            int b$iv = s.limit - s.pos;
            boolean $i$f$minOf = false;
            toHash = (int)Math.min((long)a$iv, (long)b$iv);
            if (this.messageDigest != null) {
                this.messageDigest.update(s.data, s.pos, toHash);
            } else {
                Mac mac = this.mac;
                Intrinsics.checkNotNull((Object)mac);
                mac.update(s.data, s.pos, toHash);
            }
            Intrinsics.checkNotNull((Object)s.next);
        }
        super.write(source2, byteCount);
    }

    @JvmName(name="hash")
    @NotNull
    public final ByteString hash() {
        byte[] byArray;
        if (this.messageDigest != null) {
            byArray = this.messageDigest.digest();
        } else {
            Mac mac = this.mac;
            Intrinsics.checkNotNull((Object)mac);
            byArray = mac.doFinal();
        }
        byte[] result = byArray;
        Intrinsics.checkNotNull((Object)result);
        return new ByteString(result);
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="hash", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_hash")
    @NotNull
    public final ByteString -deprecated_hash() {
        return this.hash();
    }

    @JvmStatic
    @NotNull
    public static final HashingSink md5(@NotNull Sink sink2) {
        return Companion.md5(sink2);
    }

    @JvmStatic
    @NotNull
    public static final HashingSink sha1(@NotNull Sink sink2) {
        return Companion.sha1(sink2);
    }

    @JvmStatic
    @NotNull
    public static final HashingSink sha256(@NotNull Sink sink2) {
        return Companion.sha256(sink2);
    }

    @JvmStatic
    @NotNull
    public static final HashingSink sha512(@NotNull Sink sink2) {
        return Companion.sha512(sink2);
    }

    @JvmStatic
    @NotNull
    public static final HashingSink hmacSha1(@NotNull Sink sink2, @NotNull ByteString key) {
        return Companion.hmacSha1(sink2, key);
    }

    @JvmStatic
    @NotNull
    public static final HashingSink hmacSha256(@NotNull Sink sink2, @NotNull ByteString key) {
        return Companion.hmacSha256(sink2, key);
    }

    @JvmStatic
    @NotNull
    public static final HashingSink hmacSha512(@NotNull Sink sink2, @NotNull ByteString key) {
        return Companion.hmacSha512(sink2, key);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0007J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0007J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0007\u00a8\u0006\u0010"}, d2={"Lokio/HashingSink$Companion;", "", "<init>", "()V", "md5", "Lokio/HashingSink;", "sink", "Lokio/Sink;", "sha1", "sha256", "sha512", "hmacSha1", "key", "Lokio/ByteString;", "hmacSha256", "hmacSha512", "okio"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final HashingSink md5(@NotNull Sink sink2) {
            Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
            return new HashingSink(sink2, "MD5");
        }

        @JvmStatic
        @NotNull
        public final HashingSink sha1(@NotNull Sink sink2) {
            Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
            return new HashingSink(sink2, "SHA-1");
        }

        @JvmStatic
        @NotNull
        public final HashingSink sha256(@NotNull Sink sink2) {
            Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
            return new HashingSink(sink2, "SHA-256");
        }

        @JvmStatic
        @NotNull
        public final HashingSink sha512(@NotNull Sink sink2) {
            Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
            return new HashingSink(sink2, "SHA-512");
        }

        @JvmStatic
        @NotNull
        public final HashingSink hmacSha1(@NotNull Sink sink2, @NotNull ByteString key) {
            Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return new HashingSink(sink2, key, "HmacSHA1");
        }

        @JvmStatic
        @NotNull
        public final HashingSink hmacSha256(@NotNull Sink sink2, @NotNull ByteString key) {
            Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return new HashingSink(sink2, key, "HmacSHA256");
        }

        @JvmStatic
        @NotNull
        public final HashingSink hmacSha512(@NotNull Sink sink2, @NotNull ByteString key) {
            Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return new HashingSink(sink2, key, "HmacSHA512");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

