/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy.grid;

import androidx.compose.foundation.internal.InlineClassHelperKt;
import androidx.compose.foundation.lazy.grid.LazyGridDslKt;
import androidx.compose.runtime.Stable;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.Dp;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\bg\u0018\u00002\u00020\u0001:\u0003\b\t\nJ\"\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Landroidx/compose/foundation/lazy/grid/GridCells;", "", "calculateCrossAxisCellSizes", "", "", "Landroidx/compose/ui/unit/Density;", "availableSize", "spacing", "Fixed", "Adaptive", "FixedSize", "foundation"})
@Stable
public interface GridCells {
    @NotNull
    public List<Integer> calculateCrossAxisCellSizes(@NotNull Density var1, int var2, int var3);

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\n2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\tH\u0016J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002R\u0010\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0012"}, d2={"Landroidx/compose/foundation/lazy/grid/GridCells$Adaptive;", "Landroidx/compose/foundation/lazy/grid/GridCells;", "minSize", "Landroidx/compose/ui/unit/Dp;", "<init>", "(FLkotlin/jvm/internal/DefaultConstructorMarker;)V", "F", "calculateCrossAxisCellSizes", "", "", "Landroidx/compose/ui/unit/Density;", "availableSize", "spacing", "hashCode", "equals", "", "other", "", "foundation"})
    @StabilityInferred(parameters=1)
    @SourceDebugExtension(value={"SMAP\nLazyGridDsl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyGridDsl.kt\nandroidx/compose/foundation/lazy/grid/GridCells$Adaptive\n+ 2 Dp.kt\nandroidx/compose/ui/unit/DpKt\n+ 3 InlineClassHelper.kt\nandroidx/compose/foundation/internal/InlineClassHelperKt\n*L\n1#1,653:1\n113#2:654\n97#3,4:655\n*S KotlinDebug\n*F\n+ 1 LazyGridDsl.kt\nandroidx/compose/foundation/lazy/grid/GridCells$Adaptive\n*L\n356#1:654\n356#1:655,4\n*E\n"})
    public static final class Adaptive
    implements GridCells {
        private final float minSize;
        public static final int $stable;

        private Adaptive(float minSize) {
            this.minSize = minSize;
            boolean $this$dp$iv = false;
            boolean $i$f$getDp = false;
            boolean value$iv = Dp.compareTo-0680j_4((float)this.minSize, (float)Dp.constructor-impl((float)((float)$this$dp$iv))) > 0;
            boolean $i$f$requirePrecondition = false;
            if (!value$iv) {
                boolean bl = false;
                InlineClassHelperKt.throwIllegalArgumentException("Provided min size should be larger than zero.");
            }
        }

        @Override
        @NotNull
        public List<Integer> calculateCrossAxisCellSizes(@NotNull Density $this$calculateCrossAxisCellSizes, int availableSize, int spacing) {
            Intrinsics.checkNotNullParameter((Object)$this$calculateCrossAxisCellSizes, (String)"<this>");
            int count = Math.max((availableSize + spacing) / ($this$calculateCrossAxisCellSizes.roundToPx-0680j_4(this.minSize) + spacing), 1);
            return LazyGridDslKt.access$calculateCellsCrossAxisSizeImpl(availableSize, count, spacing);
        }

        public int hashCode() {
            return Dp.hashCode-impl((float)this.minSize);
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof Adaptive && Dp.equals-impl0((float)this.minSize, (float)((Adaptive)other).minSize);
        }

        public /* synthetic */ Adaptive(float minSize, DefaultConstructorMarker $constructor_marker) {
            this(minSize);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Landroidx/compose/foundation/lazy/grid/GridCells$Fixed;", "Landroidx/compose/foundation/lazy/grid/GridCells;", "count", "", "<init>", "(I)V", "calculateCrossAxisCellSizes", "", "Landroidx/compose/ui/unit/Density;", "availableSize", "spacing", "hashCode", "equals", "", "other", "", "foundation"})
    @StabilityInferred(parameters=1)
    @SourceDebugExtension(value={"SMAP\nLazyGridDsl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyGridDsl.kt\nandroidx/compose/foundation/lazy/grid/GridCells$Fixed\n+ 2 InlineClassHelper.kt\nandroidx/compose/foundation/internal/InlineClassHelperKt\n*L\n1#1,653:1\n97#2,4:654\n*S KotlinDebug\n*F\n+ 1 LazyGridDsl.kt\nandroidx/compose/foundation/lazy/grid/GridCells$Fixed\n*L\n327#1:654,4\n*E\n"})
    public static final class Fixed
    implements GridCells {
        private final int count;
        public static final int $stable;

        public Fixed(int count) {
            this.count = count;
            boolean value$iv = this.count > 0;
            boolean $i$f$requirePrecondition = false;
            if (!value$iv) {
                boolean bl = false;
                InlineClassHelperKt.throwIllegalArgumentException("Provided count should be larger than zero");
            }
        }

        @Override
        @NotNull
        public List<Integer> calculateCrossAxisCellSizes(@NotNull Density $this$calculateCrossAxisCellSizes, int availableSize, int spacing) {
            Intrinsics.checkNotNullParameter((Object)$this$calculateCrossAxisCellSizes, (String)"<this>");
            return LazyGridDslKt.access$calculateCellsCrossAxisSizeImpl(availableSize, this.count, spacing);
        }

        public int hashCode() {
            return -this.count;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof Fixed && this.count == ((Fixed)other).count;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\n2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\tH\u0016J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002R\u0010\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0012"}, d2={"Landroidx/compose/foundation/lazy/grid/GridCells$FixedSize;", "Landroidx/compose/foundation/lazy/grid/GridCells;", "size", "Landroidx/compose/ui/unit/Dp;", "<init>", "(FLkotlin/jvm/internal/DefaultConstructorMarker;)V", "F", "calculateCrossAxisCellSizes", "", "", "Landroidx/compose/ui/unit/Density;", "availableSize", "spacing", "hashCode", "equals", "", "other", "", "foundation"})
    @StabilityInferred(parameters=1)
    @SourceDebugExtension(value={"SMAP\nLazyGridDsl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyGridDsl.kt\nandroidx/compose/foundation/lazy/grid/GridCells$FixedSize\n+ 2 Dp.kt\nandroidx/compose/ui/unit/DpKt\n+ 3 InlineClassHelper.kt\nandroidx/compose/foundation/internal/InlineClassHelperKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,653:1\n113#2:654\n97#3,4:655\n1#4:659\n*S KotlinDebug\n*F\n+ 1 LazyGridDsl.kt\nandroidx/compose/foundation/lazy/grid/GridCells$FixedSize\n*L\n389#1:654\n389#1:655,4\n*E\n"})
    public static final class FixedSize
    implements GridCells {
        private final float size;
        public static final int $stable;

        private FixedSize(float size) {
            this.size = size;
            boolean $this$dp$iv = false;
            boolean $i$f$getDp = false;
            boolean value$iv = Dp.compareTo-0680j_4((float)this.size, (float)Dp.constructor-impl((float)((float)$this$dp$iv))) > 0;
            boolean $i$f$requirePrecondition = false;
            if (!value$iv) {
                boolean bl = false;
                InlineClassHelperKt.throwIllegalArgumentException("Provided size should be larger than zero.");
            }
        }

        @Override
        @NotNull
        public List<Integer> calculateCrossAxisCellSizes(@NotNull Density $this$calculateCrossAxisCellSizes, int availableSize, int spacing) {
            List list;
            Intrinsics.checkNotNullParameter((Object)$this$calculateCrossAxisCellSizes, (String)"<this>");
            int cellSize = $this$calculateCrossAxisCellSizes.roundToPx-0680j_4(this.size);
            if (cellSize + spacing < availableSize + spacing) {
                int cellCount = (availableSize + spacing) / (cellSize + spacing);
                ArrayList<Integer> arrayList = new ArrayList<Integer>(cellCount);
                int n = 0;
                while (n < cellCount) {
                    int n2;
                    int n3 = n2 = n++;
                    ArrayList<Integer> arrayList2 = arrayList;
                    boolean bl = false;
                    arrayList2.add(cellSize);
                }
                list = arrayList;
            } else {
                int n = 1;
                ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
                int n4 = 0;
                while (n4 < n) {
                    int n5;
                    int it = n5 = n4++;
                    ArrayList<Integer> arrayList3 = arrayList;
                    boolean bl = false;
                    arrayList3.add(availableSize);
                }
                list = arrayList;
            }
            return list;
        }

        public int hashCode() {
            return Dp.hashCode-impl((float)this.size);
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof FixedSize && Dp.equals-impl0((float)this.size, (float)((FixedSize)other).size);
        }

        public /* synthetic */ FixedSize(float size, DefaultConstructorMarker $constructor_marker) {
            this(size);
        }
    }
}

