/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.extension.authenticator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.attestation.authenticator.COSEKey;
import com.webauthn4j.util.ArrayUtil;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class HMACGetSecretAuthenticatorInput {
    private final COSEKey keyAgreement;
    private final byte[] saltEnc;
    private final byte[] saltAuth;

    @JsonCreator
    public HMACGetSecretAuthenticatorInput(@JsonProperty(value="1") @NotNull COSEKey keyAgreement, @JsonProperty(value="2") @NotNull byte[] saltEnc, @JsonProperty(value="3") @NotNull byte[] saltAuth) {
        this.keyAgreement = keyAgreement;
        this.saltEnc = ArrayUtil.clone((byte[])saltEnc);
        this.saltAuth = ArrayUtil.clone((byte[])saltAuth);
    }

    @NotNull
    public COSEKey getKeyAgreement() {
        return this.keyAgreement;
    }

    @NotNull
    public byte[] getSaltEnc() {
        return ArrayUtil.clone((byte[])this.saltEnc);
    }

    @NotNull
    public byte[] getSaltAuth() {
        return ArrayUtil.clone((byte[])this.saltAuth);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HMACGetSecretAuthenticatorInput that = (HMACGetSecretAuthenticatorInput)o;
        return Objects.equals(this.keyAgreement, that.keyAgreement) && Arrays.equals(this.saltEnc, that.saltEnc) && Arrays.equals(this.saltAuth, that.saltAuth);
    }

    public int hashCode() {
        int result = Objects.hash(this.keyAgreement);
        result = 31 * result + Arrays.hashCode(this.saltEnc);
        result = 31 * result + Arrays.hashCode(this.saltAuth);
        return result;
    }
}

