package world.respect.datalayer.db.networkvalidation.daos

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import javax.`annotation`.processing.Generated
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.reflect.KClass
import world.respect.datalayer.db.networkvalidation.entities.NetworkValidationInfoEntity

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class NetworkValidationInfoEntityDao_Impl(
  __db: RoomDatabase,
) : NetworkValidationInfoEntityDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfNetworkValidationInfoEntity:
      EntityInsertAdapter<NetworkValidationInfoEntity>
  init {
    this.__db = __db
    this.__insertAdapterOfNetworkValidationInfoEntity = object : EntityInsertAdapter<NetworkValidationInfoEntity>() {
      protected override fun createQuery(): String = "INSERT OR REPLACE INTO `NetworkValidationInfoEntity` (`nviUrlHash`,`nviKey`,`nviVaryHeader`,`nviLastModified`,`nviEtag`,`nviConsistentThrough`,`nviLastChecked`) VALUES (?,?,?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: NetworkValidationInfoEntity) {
        statement.bindLong(1, entity.nviUrlHash)
        statement.bindLong(2, entity.nviKey)
        val _tmpNviVaryHeader: String? = entity.nviVaryHeader
        if (_tmpNviVaryHeader == null) {
          statement.bindNull(3)
        } else {
          statement.bindText(3, _tmpNviVaryHeader)
        }
        statement.bindLong(4, entity.nviLastModified)
        val _tmpNviEtag: String? = entity.nviEtag
        if (_tmpNviEtag == null) {
          statement.bindNull(5)
        } else {
          statement.bindText(5, _tmpNviEtag)
        }
        statement.bindLong(6, entity.nviConsistentThrough)
        statement.bindLong(7, entity.nviLastChecked)
      }
    }
  }

  public override suspend fun upsert(entity: NetworkValidationInfoEntity): Unit = performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfNetworkValidationInfoEntity.insert(_connection, entity)
  }

  public override suspend fun getLatestVaryHeaderByUrlHash(nviUrlHash: Long): String? {
    val _sql: String = """
        |
        |        SELECT NetworkValidationInfoEntity.nviVaryHeader 
        |          FROM NetworkValidationInfoEntity
        |         WHERE NetworkValidationInfoEntity.nviUrlHash = ?
        |      ORDER BY NetworkValidationInfoEntity.nviLastChecked DESC
        |         LIMIT 1
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, nviUrlHash)
        val _result: String?
        if (_stmt.step()) {
          if (_stmt.isNull(0)) {
            _result = null
          } else {
            _result = _stmt.getText(0)
          }
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun getValidationInfo(urlHash: Long, validationInfoKey: Long): NetworkValidationInfoEntity? {
    val _sql: String = """
        |
        |        SELECT NetworkValidationInfoEntity.* 
        |          FROM NetworkValidationInfoEntity
        |         WHERE NetworkValidationInfoEntity.nviUrlHash = ?
        |           AND NetworkValidationInfoEntity.nviKey = ?
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, urlHash)
        _argIndex = 2
        _stmt.bindLong(_argIndex, validationInfoKey)
        val _columnIndexOfNviUrlHash: Int = getColumnIndexOrThrow(_stmt, "nviUrlHash")
        val _columnIndexOfNviKey: Int = getColumnIndexOrThrow(_stmt, "nviKey")
        val _columnIndexOfNviVaryHeader: Int = getColumnIndexOrThrow(_stmt, "nviVaryHeader")
        val _columnIndexOfNviLastModified: Int = getColumnIndexOrThrow(_stmt, "nviLastModified")
        val _columnIndexOfNviEtag: Int = getColumnIndexOrThrow(_stmt, "nviEtag")
        val _columnIndexOfNviConsistentThrough: Int = getColumnIndexOrThrow(_stmt, "nviConsistentThrough")
        val _columnIndexOfNviLastChecked: Int = getColumnIndexOrThrow(_stmt, "nviLastChecked")
        val _result: NetworkValidationInfoEntity?
        if (_stmt.step()) {
          val _tmpNviUrlHash: Long
          _tmpNviUrlHash = _stmt.getLong(_columnIndexOfNviUrlHash)
          val _tmpNviKey: Long
          _tmpNviKey = _stmt.getLong(_columnIndexOfNviKey)
          val _tmpNviVaryHeader: String?
          if (_stmt.isNull(_columnIndexOfNviVaryHeader)) {
            _tmpNviVaryHeader = null
          } else {
            _tmpNviVaryHeader = _stmt.getText(_columnIndexOfNviVaryHeader)
          }
          val _tmpNviLastModified: Long
          _tmpNviLastModified = _stmt.getLong(_columnIndexOfNviLastModified)
          val _tmpNviEtag: String?
          if (_stmt.isNull(_columnIndexOfNviEtag)) {
            _tmpNviEtag = null
          } else {
            _tmpNviEtag = _stmt.getText(_columnIndexOfNviEtag)
          }
          val _tmpNviConsistentThrough: Long
          _tmpNviConsistentThrough = _stmt.getLong(_columnIndexOfNviConsistentThrough)
          val _tmpNviLastChecked: Long
          _tmpNviLastChecked = _stmt.getLong(_columnIndexOfNviLastChecked)
          _result = NetworkValidationInfoEntity(_tmpNviUrlHash,_tmpNviKey,_tmpNviVaryHeader,_tmpNviLastModified,_tmpNviEtag,_tmpNviConsistentThrough,_tmpNviLastChecked)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
