/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input;

import androidx.compose.foundation.text.UndoManagerKt;
import androidx.compose.foundation.text.input.TextFieldBuffer;
import androidx.compose.foundation.text.input.TextFieldCharSequence;
import androidx.compose.foundation.text.input.TextUndoManager;
import androidx.compose.foundation.text.input.internal.undo.TextDeleteType;
import androidx.compose.foundation.text.input.internal.undo.TextEditType;
import androidx.compose.foundation.text.input.internal.undo.TextUndoOperation;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u001a\u0016\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a.\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0000\"\u0018\u0010\r\u001a\u00020\f*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u000e\u0010\u000f\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"merge", "Landroidx/compose/foundation/text/input/internal/undo/TextUndoOperation;", "next", "recordChanges", "", "Landroidx/compose/foundation/text/input/TextUndoManager;", "pre", "Landroidx/compose/foundation/text/input/TextFieldCharSequence;", "post", "changes", "Landroidx/compose/foundation/text/input/TextFieldBuffer$ChangeList;", "allowMerge", "", "isNewLineInsert", "(Landroidx/compose/foundation/text/input/internal/undo/TextUndoOperation;)Z", "TEXT_UNDO_CAPACITY", "", "foundation"})
public final class TextUndoManagerKt {
    private static final int TEXT_UNDO_CAPACITY = 100;

    @Nullable
    public static final TextUndoOperation merge(@NotNull TextUndoOperation $this$merge, @NotNull TextUndoOperation next2) {
        Intrinsics.checkNotNullParameter($this$merge, "<this>");
        Intrinsics.checkNotNullParameter(next2, "next");
        if (!$this$merge.getCanMerge() || !next2.getCanMerge()) {
            return null;
        }
        if (next2.getTimeInMillis() < $this$merge.getTimeInMillis() || next2.getTimeInMillis() - $this$merge.getTimeInMillis() >= (long)UndoManagerKt.getSNAPSHOTS_INTERVAL_MILLIS()) {
            return null;
        }
        if (TextUndoManagerKt.isNewLineInsert($this$merge) || TextUndoManagerKt.isNewLineInsert(next2)) {
            return null;
        }
        if ($this$merge.getTextEditType() != next2.getTextEditType()) {
            return null;
        }
        if ($this$merge.getTextEditType() == TextEditType.Insert && $this$merge.getIndex() + $this$merge.getPostText().length() == next2.getIndex()) {
            return new TextUndoOperation($this$merge.getIndex(), "", $this$merge.getPostText() + next2.getPostText(), $this$merge.getPreSelection-d9O1mEE(), next2.getPostSelection-d9O1mEE(), $this$merge.getTimeInMillis(), false, 64, null);
        }
        if ($this$merge.getTextEditType() == TextEditType.Delete && $this$merge.getDeletionType() == next2.getDeletionType() && ($this$merge.getDeletionType() == TextDeleteType.Start || $this$merge.getDeletionType() == TextDeleteType.End)) {
            if ($this$merge.getIndex() == next2.getIndex() + next2.getPreText().length()) {
                return new TextUndoOperation(next2.getIndex(), next2.getPreText() + $this$merge.getPreText(), "", $this$merge.getPreSelection-d9O1mEE(), next2.getPostSelection-d9O1mEE(), $this$merge.getTimeInMillis(), false, 64, null);
            }
            if ($this$merge.getIndex() == next2.getIndex()) {
                return new TextUndoOperation($this$merge.getIndex(), $this$merge.getPreText() + next2.getPreText(), "", $this$merge.getPreSelection-d9O1mEE(), next2.getPostSelection-d9O1mEE(), $this$merge.getTimeInMillis(), false, 64, null);
            }
        }
        return null;
    }

    public static final void recordChanges(@NotNull TextUndoManager $this$recordChanges, @NotNull TextFieldCharSequence pre2, @NotNull TextFieldCharSequence post2, @NotNull TextFieldBuffer.ChangeList changes, boolean allowMerge) {
        Intrinsics.checkNotNullParameter($this$recordChanges, "<this>");
        Intrinsics.checkNotNullParameter(pre2, "pre");
        Intrinsics.checkNotNullParameter(post2, "post");
        Intrinsics.checkNotNullParameter(changes, "changes");
        if (changes.getChangeCount() > 1) {
            $this$recordChanges.record(new TextUndoOperation(0, pre2.toString(), post2.toString(), pre2.getSelection-d9O1mEE(), post2.getSelection-d9O1mEE(), 0L, false, 32, null));
        } else if (changes.getChangeCount() == 1) {
            long preRange = changes.getOriginalRange--jx7JFs(0);
            long postRange = changes.getRange--jx7JFs(0);
            if (!TextRange.getCollapsed-impl(preRange) || !TextRange.getCollapsed-impl(postRange)) {
                $this$recordChanges.record(new TextUndoOperation(TextRange.getMin-impl(preRange), TextRangeKt.substring-FDrldGo(pre2, preRange), TextRangeKt.substring-FDrldGo(post2, postRange), pre2.getSelection-d9O1mEE(), post2.getSelection-d9O1mEE(), 0L, allowMerge, 32, null));
            }
        }
    }

    public static /* synthetic */ void recordChanges$default(TextUndoManager textUndoManager, TextFieldCharSequence textFieldCharSequence, TextFieldCharSequence textFieldCharSequence2, TextFieldBuffer.ChangeList changeList, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        TextUndoManagerKt.recordChanges(textUndoManager, textFieldCharSequence, textFieldCharSequence2, changeList, bl);
    }

    private static final boolean isNewLineInsert(TextUndoOperation $this$isNewLineInsert) {
        return Intrinsics.areEqual($this$isNewLineInsert.getPostText(), "\n") || Intrinsics.areEqual($this$isNewLineInsert.getPostText(), "\r\n");
    }
}

