/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.MessageSourceValidationMessage;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.utils.JsonNodeUtil;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleOfValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(MultipleOfValidator.class);
    private final BigDecimal divisor;

    public MultipleOfValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.MULTIPLE_OF, validationContext);
        this.divisor = this.getDivisor(schemaNode);
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node2, JsonNode rootNode, JsonNodePath instanceLocation) {
        BigDecimal dividend;
        MultipleOfValidator.debug(logger, executionContext, node2, rootNode, instanceLocation);
        if (this.divisor != null && (dividend = this.getDividend(node2)) != null && dividend.divideAndRemainder(this.divisor)[1].abs().compareTo(BigDecimal.ZERO) > 0) {
            return Collections.singleton(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(node2)).instanceLocation(instanceLocation)).locale(executionContext.getExecutionConfig().getLocale())).failFast(executionContext.isFailFast())).arguments(this.divisor)).build());
        }
        return Collections.emptySet();
    }

    protected BigDecimal getDivisor(JsonNode schemaNode) {
        double divisor;
        if (schemaNode.isNumber() && (divisor = schemaNode.doubleValue()) != 0.0) {
            return schemaNode.isBigDecimal() ? schemaNode.decimalValue() : BigDecimal.valueOf(divisor);
        }
        return null;
    }

    protected BigDecimal getDividend(JsonNode node2) {
        if (node2.isNumber()) {
            return node2.isBigDecimal() ? node2.decimalValue() : BigDecimal.valueOf(node2.doubleValue());
        }
        if (this.validationContext.getConfig().isTypeLoose() && JsonNodeUtil.isNumber(node2, this.validationContext.getConfig())) {
            return new BigDecimal(node2.textValue());
        }
        return null;
    }
}

