/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty.http1;

import io.ktor.server.application.Application;
import io.ktor.server.application.PipelineCall;
import io.ktor.server.engine.BaseApplicationCall;
import io.ktor.server.netty.NettyApplicationCall;
import io.ktor.server.netty.NettyDirectEncoder;
import io.ktor.server.netty.http1.NettyHttp1ApplicationRequest;
import io.ktor.server.netty.http1.NettyHttp1ApplicationResponse;
import io.ktor.utils.io.ByteReadChannel;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B9\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0010\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0019\u0010\u001b\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0018\u001a\u00020\u0012H\u0010\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010 \u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u0005H\u0010\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010#\u001a\u00020\u0012H\u0010\u00a2\u0006\u0004\b!\u0010\"R\u001a\u0010$\u001a\u00020\u000b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'R\u001a\u0010)\u001a\u00020(8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,R\u001a\u0010.\u001a\u00020-8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b.\u0010/\u001a\u0004\b0\u00101\u00a8\u00062"}, d2={"Lio/ktor/server/netty/http1/NettyHttp1ApplicationCall;", "Lio/ktor/server/netty/NettyApplicationCall;", "Lkotlinx/coroutines/CoroutineScope;", "Lio/ktor/server/application/Application;", "application", "Lio/netty/channel/ChannelHandlerContext;", "context", "Lio/netty/handler/codec/http/HttpRequest;", "httpRequest", "Lio/ktor/utils/io/ByteReadChannel;", "requestBodyChannel", "Lkotlin/coroutines/CoroutineContext;", "engineContext", "userContext", "<init>", "(Lio/ktor/server/application/Application;Lio/netty/channel/ChannelHandlerContext;Lio/netty/handler/codec/http/HttpRequest;Lio/ktor/utils/io/ByteReadChannel;Lkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/CoroutineContext;)V", "Lio/netty/buffer/ByteBuf;", "buf", "", "isLastContent", "", "prepareMessage$ktor_server_netty", "(Lio/netty/buffer/ByteBuf;Z)Ljava/lang/Object;", "prepareMessage", "lastTransformed", "prepareEndOfStreamMessage$ktor_server_netty", "(Z)Ljava/lang/Object;", "prepareEndOfStreamMessage", "dst", "", "upgrade$ktor_server_netty", "(Lio/netty/channel/ChannelHandlerContext;)V", "upgrade", "isContextCloseRequired$ktor_server_netty", "()Z", "isContextCloseRequired", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "Lio/ktor/server/netty/http1/NettyHttp1ApplicationRequest;", "request", "Lio/ktor/server/netty/http1/NettyHttp1ApplicationRequest;", "getRequest", "()Lio/ktor/server/netty/http1/NettyHttp1ApplicationRequest;", "Lio/ktor/server/netty/http1/NettyHttp1ApplicationResponse;", "response", "Lio/ktor/server/netty/http1/NettyHttp1ApplicationResponse;", "getResponse", "()Lio/ktor/server/netty/http1/NettyHttp1ApplicationResponse;", "ktor-server-netty"})
public final class NettyHttp1ApplicationCall
extends NettyApplicationCall
implements CoroutineScope {
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private final NettyHttp1ApplicationRequest request;
    @NotNull
    private final NettyHttp1ApplicationResponse response;

    public NettyHttp1ApplicationCall(@NotNull Application application, @NotNull ChannelHandlerContext context, @NotNull HttpRequest httpRequest, @Nullable ByteReadChannel requestBodyChannel, @NotNull CoroutineContext engineContext, @NotNull CoroutineContext userContext) {
        Intrinsics.checkNotNullParameter(application, "application");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(httpRequest, "httpRequest");
        Intrinsics.checkNotNullParameter(engineContext, "engineContext");
        Intrinsics.checkNotNullParameter(userContext, "userContext");
        super(application, context, httpRequest);
        this.coroutineContext = userContext;
        PipelineCall pipelineCall = this;
        ByteReadChannel byteReadChannel = requestBodyChannel;
        if (byteReadChannel == null) {
            byteReadChannel = ByteReadChannel.Companion.getEmpty();
        }
        this.request = new NettyHttp1ApplicationRequest(pipelineCall, engineContext, context, httpRequest, byteReadChannel);
        NettyApplicationCall nettyApplicationCall = this;
        HttpVersion httpVersion = httpRequest.protocolVersion();
        Intrinsics.checkNotNullExpressionValue(httpVersion, "protocolVersion(...)");
        this.response = new NettyHttp1ApplicationResponse(nettyApplicationCall, context, engineContext, userContext, httpVersion);
        BaseApplicationCall.putResponseAttribute$default(this, null, 1, null);
    }

    @Override
    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    @Override
    @NotNull
    public NettyHttp1ApplicationRequest getRequest() {
        return this.request;
    }

    @Override
    @NotNull
    public NettyHttp1ApplicationResponse getResponse() {
        return this.response;
    }

    @Override
    @NotNull
    public Object prepareMessage$ktor_server_netty(@NotNull ByteBuf buf, boolean isLastContent) {
        Intrinsics.checkNotNullParameter(buf, "buf");
        if (this.isByteBufferContent$ktor_server_netty()) {
            return super.prepareMessage$ktor_server_netty(buf, isLastContent);
        }
        return new DefaultHttpContent(buf);
    }

    @Override
    @Nullable
    public Object prepareEndOfStreamMessage$ktor_server_netty(boolean lastTransformed) {
        if (this.isByteBufferContent$ktor_server_netty()) {
            return super.prepareEndOfStreamMessage$ktor_server_netty(lastTransformed);
        }
        return LastHttpContent.EMPTY_LAST_CONTENT;
    }

    @Override
    public void upgrade$ktor_server_netty(@NotNull ChannelHandlerContext dst) {
        ChannelPipeline channelPipeline;
        Intrinsics.checkNotNullParameter(dst, "dst");
        if (this.isByteBufferContent$ktor_server_netty()) {
            super.upgrade$ktor_server_netty(dst);
            return;
        }
        ChannelPipeline $this$upgrade_u24lambda_u240 = channelPipeline = dst.pipeline();
        boolean bl = false;
        $this$upgrade_u24lambda_u240.replace(HttpServerCodec.class, "direct-encoder", (ChannelHandler)new NettyDirectEncoder());
    }

    @Override
    public boolean isContextCloseRequired$ktor_server_netty() {
        return !this.isByteBufferContent$ktor_server_netty();
    }
}

