/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime.internal.format.formatter;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.datetime.internal.MathKt;
import kotlinx.datetime.internal.format.formatter.FormatterStructure;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00002\b\u0012\u0004\u0012\u0002H\u00010\u0002B+\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ)\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u00002\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lkotlinx/datetime/internal/format/formatter/ReducedIntFormatterStructure;", "T", "Lkotlinx/datetime/internal/format/formatter/FormatterStructure;", "number", "Lkotlin/Function1;", "", "digits", "base", "<init>", "(Lkotlin/jvm/functions/Function1;II)V", "format", "", "obj", "builder", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "minusNotRequired", "", "(Ljava/lang/Object;Ljava/lang/Appendable;Z)V", "kotlinx-datetime"})
public final class ReducedIntFormatterStructure<T>
implements FormatterStructure<T> {
    @NotNull
    private final Function1<T, Integer> number;
    private final int digits;
    private final int base;

    public ReducedIntFormatterStructure(@NotNull Function1<? super T, Integer> number, int digits, int base) {
        Intrinsics.checkNotNullParameter(number, "number");
        this.number = number;
        this.digits = digits;
        this.base = base;
    }

    @Override
    public void format(T obj, @NotNull Appendable builder, boolean minusNotRequired) {
        Appendable appendable;
        Intrinsics.checkNotNullParameter(builder, "builder");
        int number = ((Number)this.number.invoke(obj)).intValue();
        int n = MathKt.getPOWERS_OF_TEN()[this.digits];
        int n2 = number - this.base;
        boolean bl = 0 <= n2 ? n2 < n : false;
        if (bl) {
            String numberStr = String.valueOf(number % MathKt.getPOWERS_OF_TEN()[this.digits]);
            String zeroPaddingStr = StringsKt.repeat("0", Math.max(0, this.digits - numberStr.length()));
            CharSequence[] charSequenceArray = new CharSequence[]{zeroPaddingStr, numberStr};
            appendable = StringsKt.append(builder, charSequenceArray);
        } else {
            if (number >= 0) {
                builder.append("+");
            }
            appendable = builder.append(String.valueOf(number));
        }
    }
}

