/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import java.io.EOFException;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.CoreKt;
import kotlinx.io.InternalIoApi;
import kotlinx.io.PeekSource;
import kotlinx.io.RawSink;
import kotlinx.io.RawSource;
import kotlinx.io.Source;
import kotlinx.io._UtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\u0010\b\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J\b\u0010\u0015\u001a\u00020\tH\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J \u0010\u0011\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001bH\u0016J\u0018\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020 H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u001bH\u0016J\b\u0010%\u001a\u00020\u0012H\u0016J\u0010\u0010&\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J\b\u0010'\u001a\u00020\u0001H\u0016J\b\u0010(\u001a\u00020\u0017H\u0016J\b\u0010)\u001a\u00020*H\u0016J\t\u0010+\u001a\u00020\u0017H\u0082\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\u000b8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006,"}, d2={"Lkotlinx/io/RealSource;", "Lkotlinx/io/Source;", "source", "Lkotlinx/io/RawSource;", "<init>", "(Lkotlinx/io/RawSource;)V", "getSource", "()Lkotlinx/io/RawSource;", "closed", "", "bufferField", "Lkotlinx/io/Buffer;", "buffer", "getBuffer$annotations", "()V", "getBuffer", "()Lkotlinx/io/Buffer;", "readAtMostTo", "", "sink", "byteCount", "exhausted", "require", "", "request", "readByte", "", "", "", "startIndex", "endIndex", "readTo", "Lkotlinx/io/RawSink;", "transferTo", "readShort", "", "readInt", "readLong", "skip", "peek", "close", "toString", "", "checkNotClosed", "kotlinx-io-core"})
@SourceDebugExtension(value={"SMAP\nRealSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealSource.kt\nkotlinx/io/RealSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 -Util.kt\nkotlinx/io/_UtilKt\n*L\n1#1,162:1\n159#1:163\n160#1:165\n159#1:167\n160#1:169\n159#1:170\n160#1:172\n159#1:176\n160#1:178\n159#1:180\n160#1:182\n1#2:164\n1#2:166\n1#2:168\n1#2:171\n1#2:173\n1#2:177\n1#2:179\n1#2:181\n1#2:183\n38#3:174\n110#3:175\n*S KotlinDebug\n*F\n+ 1 RealSource.kt\nkotlinx/io/RealSource\n*L\n38#1:163\n38#1:165\n51#1:167\n51#1:169\n60#1:170\n60#1:172\n127#1:176\n127#1:178\n144#1:180\n144#1:182\n38#1:164\n51#1:168\n60#1:171\n127#1:177\n144#1:181\n74#1:174\n80#1:175\n*E\n"})
public final class RealSource
implements Source {
    @NotNull
    private final RawSource source;
    @JvmField
    public boolean closed;
    @NotNull
    private final Buffer bufferField;

    public RealSource(@NotNull RawSource source2) {
        Intrinsics.checkNotNullParameter(source2, "source");
        this.source = source2;
        this.bufferField = new Buffer();
    }

    @NotNull
    public final RawSource getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public Buffer getBuffer() {
        return this.bufferField;
    }

    @InternalIoApi
    public static /* synthetic */ void getBuffer$annotations() {
    }

    @Override
    public long readAtMostTo(@NotNull Buffer sink2, long byteCount) {
        long read2;
        Intrinsics.checkNotNullParameter(sink2, "sink");
        RealSource this_$iv = this;
        boolean $i$f$checkNotClosed = false;
        if (!(!this_$iv.closed)) {
            boolean bl = false;
            String string = "Source is closed.";
            throw new IllegalStateException(string.toString());
        }
        if (!(byteCount >= 0L)) {
            boolean bl = false;
            String string = "byteCount: " + byteCount;
            throw new IllegalArgumentException(string.toString());
        }
        if (this.bufferField.getSize() == 0L && (read2 = this.source.readAtMostTo(this.bufferField, 8192L)) == -1L) {
            return -1L;
        }
        long toRead = Math.min(byteCount, this.bufferField.getSize());
        return this.bufferField.readAtMostTo(sink2, toRead);
    }

    @Override
    public boolean exhausted() {
        RealSource this_$iv = this;
        boolean $i$f$checkNotClosed = false;
        if (!(!this_$iv.closed)) {
            boolean bl = false;
            String string = "Source is closed.";
            throw new IllegalStateException(string.toString());
        }
        return this.bufferField.exhausted() && this.source.readAtMostTo(this.bufferField, 8192L) == -1L;
    }

    @Override
    public void require(long byteCount) {
        if (!this.request(byteCount)) {
            throw new EOFException("Source doesn't contain required number of bytes (" + byteCount + ").");
        }
    }

    @Override
    public boolean request(long byteCount) {
        RealSource this_$iv = this;
        boolean $i$f$checkNotClosed = false;
        if (!(!this_$iv.closed)) {
            boolean bl = false;
            String string = "Source is closed.";
            throw new IllegalStateException(string.toString());
        }
        if (!(byteCount >= 0L)) {
            boolean bl = false;
            String string = "byteCount: " + byteCount;
            throw new IllegalArgumentException(string.toString());
        }
        while (this.bufferField.getSize() < byteCount) {
            if (this.source.readAtMostTo(this.bufferField, 8192L) != -1L) continue;
            return false;
        }
        return true;
    }

    @Override
    public byte readByte() {
        this.require(1L);
        return this.bufferField.readByte();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readAtMostTo(@NotNull byte[] sink2, int startIndex, int endIndex) {
        void a$iv;
        long read2;
        int startIndex$iv;
        void size$iv;
        Intrinsics.checkNotNullParameter(sink2, "sink");
        int n = sink2.length;
        int n2 = startIndex;
        int endIndex$iv = endIndex;
        boolean $i$f$checkBounds = false;
        _UtilKt.checkBounds((long)size$iv, (long)startIndex$iv, (long)endIndex$iv);
        if (this.bufferField.getSize() == 0L && (read2 = this.source.readAtMostTo(this.bufferField, 8192L)) == -1L) {
            return -1;
        }
        startIndex$iv = endIndex - startIndex;
        long b$iv = this.bufferField.getSize();
        boolean $i$f$minOf = false;
        int toRead = (int)Math.min((long)a$iv, b$iv);
        return this.bufferField.readAtMostTo(sink2, startIndex, startIndex + toRead);
    }

    @Override
    public void readTo(@NotNull RawSink sink2, long byteCount) {
        Intrinsics.checkNotNullParameter(sink2, "sink");
        try {
            this.require(byteCount);
        }
        catch (EOFException e) {
            sink2.write(this.bufferField, this.bufferField.getSize());
            throw e;
        }
        this.bufferField.readTo(sink2, byteCount);
    }

    @Override
    public long transferTo(@NotNull RawSink sink2) {
        Intrinsics.checkNotNullParameter(sink2, "sink");
        long totalBytesWritten = 0L;
        while (this.source.readAtMostTo(this.bufferField, 8192L) != -1L) {
            long emitByteCount = this.bufferField.completeSegmentByteCount$kotlinx_io_core();
            if (emitByteCount <= 0L) continue;
            totalBytesWritten += emitByteCount;
            sink2.write(this.bufferField, emitByteCount);
        }
        if (this.bufferField.getSize() > 0L) {
            totalBytesWritten += this.bufferField.getSize();
            sink2.write(this.bufferField, this.bufferField.getSize());
        }
        return totalBytesWritten;
    }

    @Override
    public short readShort() {
        this.require(2L);
        return this.bufferField.readShort();
    }

    @Override
    public int readInt() {
        this.require(4L);
        return this.bufferField.readInt();
    }

    @Override
    public long readLong() {
        this.require(8L);
        return this.bufferField.readLong();
    }

    @Override
    public void skip(long byteCount) {
        long toSkip;
        RealSource this_$iv = this;
        boolean $i$f$checkNotClosed = false;
        if (!(!this_$iv.closed)) {
            boolean $i$a$-check-RealSource$checkNotClosed$1$iv22 = false;
            String $i$a$-check-RealSource$checkNotClosed$1$iv22 = "Source is closed.";
            throw new IllegalStateException($i$a$-check-RealSource$checkNotClosed$1$iv22.toString());
        }
        if (!(byteCount >= 0L)) {
            boolean bl = false;
            String string = "byteCount: " + byteCount;
            throw new IllegalArgumentException(string.toString());
        }
        for (long remainingByteCount = byteCount; remainingByteCount > 0L; remainingByteCount -= toSkip) {
            if (this.bufferField.getSize() == 0L && this.source.readAtMostTo(this.bufferField, 8192L) == -1L) {
                throw new EOFException("Source exhausted before skipping " + byteCount + " bytes (only " + (remainingByteCount - byteCount) + " bytes were skipped).");
            }
            toSkip = Math.min(remainingByteCount, this.bufferField.getSize());
            this.bufferField.skip(toSkip);
        }
    }

    @Override
    @NotNull
    public Source peek() {
        RealSource this_$iv = this;
        boolean $i$f$checkNotClosed = false;
        if (!(!this_$iv.closed)) {
            boolean bl = false;
            String string = "Source is closed.";
            throw new IllegalStateException(string.toString());
        }
        return CoreKt.buffered(new PeekSource(this));
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.source.close();
        this.bufferField.clear();
    }

    @NotNull
    public String toString() {
        return "buffered(" + this.source + ')';
    }

    private final void checkNotClosed() {
        boolean $i$f$checkNotClosed = false;
        if (!(!this.closed)) {
            boolean bl = false;
            String string = "Source is closed.";
            throw new IllegalStateException(string.toString());
        }
    }
}

