/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.DateTimeException;
import java.time.format.DateTimeParseException;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.DateTimeFormatException;
import kotlinx.datetime.DayOfWeek;
import kotlinx.datetime.LocalDateKt;
import kotlinx.datetime.LocalDateRange;
import kotlinx.datetime.Month;
import kotlinx.datetime.MonthKt;
import kotlinx.datetime.Ser;
import kotlinx.datetime.format.DateTimeFormat;
import kotlinx.datetime.format.DateTimeFormatBuilder;
import kotlinx.datetime.format.LocalDateFormat;
import kotlinx.datetime.format.LocalDateFormatKt;
import kotlinx.datetime.internal.MathKt;
import kotlinx.datetime.internal.UtilKt;
import kotlinx.datetime.serializers.LocalDateSerializer;
import kotlinx.serialization.KSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@kotlinx.serialization.Serializable(with=LocalDateSerializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 92\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u00029:B\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B!\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\u000bB!\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\f\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\rB!\b\u0017\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\u0010J\b\u0010\u0019\u001a\u00020\u000eH\u0001J\b\u0010 \u001a\u00020\"H\u0001J\u0011\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010(\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0000H\u0086\u0002J\u0013\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,H\u0096\u0002J\b\u0010-\u001a\u00020\bH\u0016J\b\u0010.\u001a\u00020/H\u0016J\u0011\u00100\u001a\u00020\b2\u0006\u0010+\u001a\u00020\u0000H\u0096\u0002J\u0006\u00101\u001a\u000202J\r\u00103\u001a\u00020\bH\u0001\u00a2\u0006\u0002\b1J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0002J\b\u00108\u001a\u00020,H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0014R\u0011\u0010\t\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u000f\u001a\u00020\b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001b\u0010\u0017\u001a\u0004\b\u001c\u0010\u0014R\u0011\u0010\n\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0014R\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010#\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0014\u00a8\u0006;"}, d2={"Lkotlinx/datetime/LocalDate;", "", "Ljava/io/Serializable;", "value", "Ljava/time/LocalDate;", "<init>", "(Ljava/time/LocalDate;)V", "year", "", "month", "day", "(III)V", "Lkotlinx/datetime/Month;", "(ILkotlinx/datetime/Month;I)V", "Ljava/time/Month;", "dayOfMonth", "(ILjava/time/Month;I)V", "getValue$kotlinx_datetime", "()Ljava/time/LocalDate;", "getYear", "()I", "monthNumber", "getMonthNumber$annotations", "()V", "getMonthNumber", "getMonth", "()Lkotlinx/datetime/Month;", "getDayOfMonth$annotations", "getDayOfMonth", "getDay", "dayOfWeek", "Lkotlinx/datetime/DayOfWeek;", "getDayOfWeek", "()Lkotlinx/datetime/DayOfWeek;", "Ljava/time/DayOfWeek;", "dayOfYear", "getDayOfYear", "rangeTo", "Lkotlinx/datetime/LocalDateRange;", "that", "rangeUntil", "equals", "", "other", "", "hashCode", "toString", "", "compareTo", "toEpochDays", "", "toEpochDaysJvm", "readObject", "", "ois", "Ljava/io/ObjectInputStream;", "writeReplace", "Companion", "Formats", "kotlinx-datetime"})
public final class LocalDate
implements Comparable<LocalDate>,
Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final java.time.LocalDate value;
    @NotNull
    private static final LocalDate MIN;
    @NotNull
    private static final LocalDate MAX;
    private static final long serialVersionUID = 0L;

    public LocalDate(@NotNull java.time.LocalDate value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.value = value;
    }

    @NotNull
    public final java.time.LocalDate getValue$kotlinx_datetime() {
        return this.value;
    }

    /*
     * WARNING - void declaration
     */
    public LocalDate(int year2, int month2, int day2) {
        java.time.LocalDate localDate;
        LocalDate localDate2;
        LocalDate localDate3 = this;
        try {
            localDate2 = localDate3;
            localDate = java.time.LocalDate.of(year2, month2, day2);
        }
        catch (DateTimeException dateTimeException) {
            void e;
            LocalDate localDate4 = localDate3;
            throw new IllegalArgumentException((Throwable)e);
        }
        java.time.LocalDate localDate5 = localDate;
        Intrinsics.checkNotNull(localDate5);
        localDate2(localDate5);
    }

    public LocalDate(int year2, @NotNull Month month2, int day2) {
        Intrinsics.checkNotNullParameter((Object)month2, "month");
        this(year2, MonthKt.getNumber(month2), day2);
    }

    @Deprecated(message="Use kotlinx.datetime.Month", replaceWith=@ReplaceWith(expression="LocalDate(year, month.toKotlinMonth(), dayOfMonth)", imports={}))
    public LocalDate(int year2, @NotNull java.time.Month month2, int dayOfMonth2) {
        Intrinsics.checkNotNullParameter(month2, "month");
        this(year2, ConvertersKt.toKotlinMonth(month2), dayOfMonth2);
    }

    public final int getYear() {
        return this.value.getYear();
    }

    public final int getMonthNumber() {
        return this.value.getMonthValue();
    }

    @Deprecated(message="Use the 'month' property instead", replaceWith=@ReplaceWith(expression="this.month.number", imports={}), level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getMonthNumber$annotations() {
    }

    @NotNull
    public final Month getMonth() {
        java.time.Month month2 = this.value.getMonth();
        Intrinsics.checkNotNullExpressionValue(month2, "getMonth(...)");
        return ConvertersKt.toKotlinMonth(month2);
    }

    @PublishedApi
    @NotNull
    public final java.time.Month getMonth() {
        java.time.Month month2 = this.value.getMonth();
        Intrinsics.checkNotNullExpressionValue(month2, "getMonth(...)");
        return month2;
    }

    public final int getDayOfMonth() {
        return this.value.getDayOfMonth();
    }

    @Deprecated(message="Use the 'day' property instead", replaceWith=@ReplaceWith(expression="this.day", imports={}), level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getDayOfMonth$annotations() {
    }

    public final int getDay() {
        return this.value.getDayOfMonth();
    }

    @NotNull
    public final DayOfWeek getDayOfWeek() {
        java.time.DayOfWeek dayOfWeek = this.value.getDayOfWeek();
        Intrinsics.checkNotNullExpressionValue(dayOfWeek, "getDayOfWeek(...)");
        return ConvertersKt.toKotlinDayOfWeek(dayOfWeek);
    }

    @PublishedApi
    @NotNull
    public final java.time.DayOfWeek getDayOfWeek() {
        java.time.DayOfWeek dayOfWeek = this.value.getDayOfWeek();
        Intrinsics.checkNotNullExpressionValue(dayOfWeek, "getDayOfWeek(...)");
        return dayOfWeek;
    }

    public final int getDayOfYear() {
        return this.value.getDayOfYear();
    }

    @NotNull
    public final LocalDateRange rangeTo(@NotNull LocalDate that) {
        Intrinsics.checkNotNullParameter(that, "that");
        return LocalDateRange.Companion.fromRangeTo$kotlinx_datetime(this, that);
    }

    @NotNull
    public final LocalDateRange rangeUntil(@NotNull LocalDate that) {
        Intrinsics.checkNotNullParameter(that, "that");
        return LocalDateRange.Companion.fromRangeUntil$kotlinx_datetime(this, that);
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof LocalDate && Intrinsics.areEqual(this.value, ((LocalDate)other).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @NotNull
    public String toString() {
        String string = this.value.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @Override
    public int compareTo(@NotNull LocalDate other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.value.compareTo(other.value);
    }

    public final long toEpochDays() {
        return this.value.toEpochDay();
    }

    @PublishedApi
    @JvmName(name="toEpochDays")
    public final int toEpochDays() {
        return MathKt.clampToInt(this.value.toEpochDay());
    }

    private final void readObject(ObjectInputStream ois) {
        throw new InvalidObjectException("kotlinx.datetime.LocalDate must be deserialized via kotlinx.datetime.Ser");
    }

    private final Object writeReplace() {
        return new Ser(2, this);
    }

    static {
        java.time.LocalDate localDate = java.time.LocalDate.MIN;
        Intrinsics.checkNotNullExpressionValue(localDate, "MIN");
        MIN = new LocalDate(localDate);
        java.time.LocalDate localDate2 = java.time.LocalDate.MAX;
        Intrinsics.checkNotNullExpressionValue(localDate2, "MAX");
        MAX = new LocalDate(localDate2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tJ\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0014J%\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017\u00a2\u0006\u0002\b\u001aJ\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u001dR\u0014\u0010\f\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u000e\u0010\u001b\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lkotlinx/datetime/LocalDate$Companion;", "", "<init>", "()V", "parse", "Lkotlinx/datetime/LocalDate;", "input", "", "format", "Lkotlinx/datetime/format/DateTimeFormat;", "isoString", "", "MIN", "getMIN$kotlinx_datetime", "()Lkotlinx/datetime/LocalDate;", "MAX", "getMAX$kotlinx_datetime", "fromEpochDays", "epochDays", "", "", "Format", "block", "Lkotlin/Function1;", "Lkotlinx/datetime/format/DateTimeFormatBuilder$WithDate;", "", "Lkotlin/ExtensionFunctionType;", "serialVersionUID", "serializer", "Lkotlinx/serialization/KSerializer;", "kotlinx-datetime"})
    @SourceDebugExtension(value={"SMAP\nLocalDate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalDate.kt\nkotlinx/datetime/LocalDate$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n1#2:211\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LocalDate parse(@NotNull CharSequence input, @NotNull DateTimeFormat<LocalDate> format) {
            LocalDate localDate;
            Intrinsics.checkNotNullParameter(input, "input");
            Intrinsics.checkNotNullParameter(format, "format");
            if (format == Formats.INSTANCE.getISO()) {
                LocalDate localDate2;
                try {
                    String sanitizedInput = UtilKt.removeLeadingZerosFromLongYearFormLocalDate(((Object)input).toString());
                    java.time.LocalDate p0 = java.time.LocalDate.parse(sanitizedInput);
                    boolean bl = false;
                    localDate2 = new LocalDate(p0);
                }
                catch (DateTimeParseException e) {
                    throw new DateTimeFormatException(e);
                }
                localDate = localDate2;
            } else {
                localDate = format.parse(input);
            }
            return localDate;
        }

        public static /* synthetic */ LocalDate parse$default(Companion companion, CharSequence charSequence, DateTimeFormat dateTimeFormat, int n, Object object) {
            if ((n & 2) != 0) {
                dateTimeFormat = LocalDateKt.getIsoDateFormat();
            }
            return companion.parse(charSequence, dateTimeFormat);
        }

        @Deprecated(message="This overload is only kept for binary compatibility", level=DeprecationLevel.HIDDEN)
        public final /* synthetic */ LocalDate parse(String isoString) {
            Intrinsics.checkNotNullParameter(isoString, "isoString");
            return kotlinx.datetime.LocalDate$Companion.parse$default(this, isoString, null, 2, null);
        }

        @NotNull
        public final LocalDate getMIN$kotlinx_datetime() {
            return MIN;
        }

        @NotNull
        public final LocalDate getMAX$kotlinx_datetime() {
            return MAX;
        }

        @NotNull
        public final LocalDate fromEpochDays(long epochDays) {
            LocalDate localDate;
            try {
                java.time.LocalDate localDate2 = java.time.LocalDate.ofEpochDay(epochDays);
                Intrinsics.checkNotNullExpressionValue(localDate2, "ofEpochDay(...)");
                localDate = new LocalDate(localDate2);
            }
            catch (DateTimeException e) {
                throw new IllegalArgumentException(e);
            }
            return localDate;
        }

        @NotNull
        public final LocalDate fromEpochDays(int epochDays) {
            return this.fromEpochDays((long)epochDays);
        }

        @NotNull
        public final DateTimeFormat<LocalDate> Format(@NotNull Function1<? super DateTimeFormatBuilder.WithDate, Unit> block) {
            Intrinsics.checkNotNullParameter(block, "block");
            return LocalDateFormat.Companion.build(block);
        }

        @NotNull
        public final KSerializer<LocalDate> serializer() {
            return LocalDateSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lkotlinx/datetime/LocalDate$Formats;", "", "<init>", "()V", "ISO", "Lkotlinx/datetime/format/DateTimeFormat;", "Lkotlinx/datetime/LocalDate;", "getISO", "()Lkotlinx/datetime/format/DateTimeFormat;", "ISO_BASIC", "getISO_BASIC", "kotlinx-datetime"})
    public static final class Formats {
        @NotNull
        public static final Formats INSTANCE = new Formats();
        @NotNull
        private static final DateTimeFormat<LocalDate> ISO_BASIC = LocalDateFormatKt.getISO_DATE_BASIC();

        private Formats() {
        }

        @NotNull
        public final DateTimeFormat<LocalDate> getISO() {
            return LocalDateFormatKt.getISO_DATE();
        }

        @NotNull
        public final DateTimeFormat<LocalDate> getISO_BASIC() {
            return ISO_BASIC;
        }
    }
}

