/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ContentType;
import io.ktor.http.ContentTypesKt;
import io.ktor.http.MimesKt;
import io.ktor.util.CharsetKt;
import io.ktor.util.CollectionsKt;
import io.ktor.util.TextKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\r\u001a\u0019\u0010\u0004\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u0019\u0010\u0007\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0007\u0010\u0005\u001a\u001f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\b*\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0004\b\t\u0010\n\u001a\u001f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\b*\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0001\u00a2\u0006\u0004\b\f\u0010\n\u001a\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\b*\u00020\u0003\u00a2\u0006\u0004\b\r\u0010\u000e\u001a\u0019\u0010\u000f\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\u00030\bH\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a\u0013\u0010\u0012\u001a\u00020\u0011*\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a\u0013\u0010\u0014\u001a\u00020\u0003*\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001aC\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\b0\u001a\"\u0004\b\u0000\u0010\u0016\"\u0004\b\u0001\u0010\u0017*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00190\u0018H\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001c\u001a\u0013\u0010\u001d\u001a\u00020\u0003*\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001e\"-\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\b0\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\"-\u0010&\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\b0\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010 \u001a\u0004\b%\u0010\"\u00a8\u0006'"}, d2={"Lio/ktor/http/ContentType$Companion;", "", "extension", "Lio/ktor/http/ContentType;", "defaultForFileExtension", "(Lio/ktor/http/ContentType$Companion;Ljava/lang/String;)Lio/ktor/http/ContentType;", "path", "defaultForFilePath", "", "fromFilePath", "(Lio/ktor/http/ContentType$Companion;Ljava/lang/String;)Ljava/util/List;", "ext", "fromFileExtension", "fileExtensions", "(Lio/ktor/http/ContentType;)Ljava/util/List;", "selectDefault", "(Ljava/util/List;)Lio/ktor/http/ContentType;", "", "matchApplicationTypeWithCharset", "(Lio/ktor/http/ContentType;)Z", "withCharsetUTF8IfNeeded", "(Lio/ktor/http/ContentType;)Lio/ktor/http/ContentType;", "A", "B", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "", "groupByPairs", "(Lkotlin/sequences/Sequence;)Ljava/util/Map;", "toContentType", "(Ljava/lang/String;)Lio/ktor/http/ContentType;", "contentTypesByExtensions$delegate", "Lkotlin/Lazy;", "getContentTypesByExtensions", "()Ljava/util/Map;", "contentTypesByExtensions", "extensionsByContentType$delegate", "getExtensionsByContentType", "extensionsByContentType", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nFileContentType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileContentType.kt\nio/ktor/http/FileContentTypeKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n996#2:115\n1025#2,3:116\n1028#2,3:126\n382#3,7:119\n463#3:129\n413#3:130\n1252#4,2:131\n1563#4:133\n1634#4,3:134\n1255#4:137\n1#5:138\n*S KotlinDebug\n*F\n+ 1 FileContentType.kt\nio/ktor/http/FileContentTypeKt\n*L\n106#1:115\n106#1:116,3\n106#1:126,3\n106#1:119,7\n107#1:129\n107#1:130\n107#1:131,2\n107#1:133\n107#1:134,3\n107#1:137\n*E\n"})
public final class FileContentTypeKt {
    @NotNull
    private static final Lazy contentTypesByExtensions$delegate = LazyKt.lazy(FileContentTypeKt::contentTypesByExtensions_delegate$lambda$1);
    @NotNull
    private static final Lazy extensionsByContentType$delegate = LazyKt.lazy(FileContentTypeKt::extensionsByContentType_delegate$lambda$3);

    @NotNull
    public static final ContentType defaultForFileExtension(@NotNull ContentType.Companion $this$defaultForFileExtension, @NotNull String extension) {
        Intrinsics.checkNotNullParameter($this$defaultForFileExtension, "<this>");
        Intrinsics.checkNotNullParameter(extension, "extension");
        return FileContentTypeKt.selectDefault(FileContentTypeKt.fromFileExtension(ContentType.Companion, extension));
    }

    @NotNull
    public static final ContentType defaultForFilePath(@NotNull ContentType.Companion $this$defaultForFilePath, @NotNull String path) {
        Intrinsics.checkNotNullParameter($this$defaultForFilePath, "<this>");
        Intrinsics.checkNotNullParameter(path, "path");
        return FileContentTypeKt.selectDefault(FileContentTypeKt.fromFilePath(ContentType.Companion, path));
    }

    @NotNull
    public static final List<ContentType> fromFilePath(@NotNull ContentType.Companion $this$fromFilePath, @NotNull String path) {
        Intrinsics.checkNotNullParameter($this$fromFilePath, "<this>");
        Intrinsics.checkNotNullParameter(path, "path");
        int slashIndex = StringsKt.lastIndexOfAny$default((CharSequence)path, CharsetKt.toCharArray("/\\"), 0, false, 6, null);
        int index = StringsKt.indexOf$default((CharSequence)path, '.', slashIndex + 1, false, 4, null);
        if (index == -1) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        String string = path.substring(index + 1);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        return FileContentTypeKt.fromFileExtension($this$fromFilePath, string);
    }

    @NotNull
    public static final List<ContentType> fromFileExtension(@NotNull ContentType.Companion $this$fromFileExtension, @NotNull String ext) {
        Intrinsics.checkNotNullParameter($this$fromFileExtension, "<this>");
        Intrinsics.checkNotNullParameter(ext, "ext");
        String current = TextKt.toLowerCasePreservingASCIIRules(StringsKt.removePrefix(ext, (CharSequence)"."));
        while (((CharSequence)current).length() > 0) {
            List<ContentType> type = FileContentTypeKt.getContentTypesByExtensions().get(current);
            if (type != null) {
                return type;
            }
            current = StringsKt.substringAfter(current, ".", "");
        }
        return kotlin.collections.CollectionsKt.emptyList();
    }

    @NotNull
    public static final List<String> fileExtensions(@NotNull ContentType $this$fileExtensions) {
        Intrinsics.checkNotNullParameter($this$fileExtensions, "<this>");
        List<String> list = FileContentTypeKt.getExtensionsByContentType().get($this$fileExtensions);
        if (list == null && (list = FileContentTypeKt.getExtensionsByContentType().get($this$fileExtensions.withoutParameters())) == null) {
            list = kotlin.collections.CollectionsKt.emptyList();
        }
        return list;
    }

    private static final Map<String, List<ContentType>> getContentTypesByExtensions() {
        Lazy lazy = contentTypesByExtensions$delegate;
        return (Map)lazy.getValue();
    }

    private static final Map<ContentType, List<String>> getExtensionsByContentType() {
        Lazy lazy = extensionsByContentType$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public static final ContentType selectDefault(@NotNull List<ContentType> $this$selectDefault) {
        Intrinsics.checkNotNullParameter($this$selectDefault, "<this>");
        ContentType contentType = kotlin.collections.CollectionsKt.firstOrNull($this$selectDefault);
        if (contentType == null) {
            contentType = ContentType.Application.INSTANCE.getOctetStream();
        }
        ContentType contentType2 = contentType;
        return contentType2.match(ContentType.Text.INSTANCE.getAny()) ? FileContentTypeKt.withCharsetUTF8IfNeeded(contentType2) : (contentType2.match(ContentType.Image.INSTANCE.getSVG()) ? FileContentTypeKt.withCharsetUTF8IfNeeded(contentType2) : (FileContentTypeKt.matchApplicationTypeWithCharset(contentType2) ? FileContentTypeKt.withCharsetUTF8IfNeeded(contentType2) : contentType2));
    }

    private static final boolean matchApplicationTypeWithCharset(ContentType $this$matchApplicationTypeWithCharset) {
        if (!$this$matchApplicationTypeWithCharset.match(ContentType.Application.INSTANCE.getAny())) {
            return false;
        }
        return $this$matchApplicationTypeWithCharset.match(ContentType.Application.INSTANCE.getAtom()) || $this$matchApplicationTypeWithCharset.match(ContentType.Application.INSTANCE.getJavaScript()) || $this$matchApplicationTypeWithCharset.match(ContentType.Application.INSTANCE.getRss()) || $this$matchApplicationTypeWithCharset.match(ContentType.Application.INSTANCE.getXml()) || $this$matchApplicationTypeWithCharset.match(ContentType.Application.INSTANCE.getXml_Dtd());
    }

    private static final ContentType withCharsetUTF8IfNeeded(ContentType $this$withCharsetUTF8IfNeeded) {
        if (ContentTypesKt.charset($this$withCharsetUTF8IfNeeded) != null) {
            return $this$withCharsetUTF8IfNeeded;
        }
        return ContentTypesKt.withCharset($this$withCharsetUTF8IfNeeded, Charsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <A, B> Map<A, List<B>> groupByPairs(@NotNull Sequence<? extends Pair<? extends A, ? extends B>> $this$groupByPairs) {
        void $this$mapValuesTo$iv$iv;
        Object value$iv$iv$iv;
        Object key$iv$iv;
        Map $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$groupByPairs, "<this>");
        Sequence<? extends Pair<? extends A, ? extends B>> $this$groupBy$iv = $this$groupByPairs;
        boolean $i$f$groupBy = false;
        Sequence<? extends Pair<? extends A, ? extends B>> sequence2 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object element$iv$iv = iterator2.next();
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            key$iv$iv = it.getFirst();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv;
            void e;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl3 = false;
            Iterable $this$map$iv = (Iterable)e.getValue();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                collection.add(it.getSecond());
            }
            List list = (List)destination$iv$iv2;
            map3.put(k, list);
        }
        return destination$iv$iv;
    }

    @NotNull
    public static final ContentType toContentType(@NotNull String $this$toContentType) {
        ContentType contentType;
        Intrinsics.checkNotNullParameter($this$toContentType, "<this>");
        try {
            contentType = ContentType.Companion.parse($this$toContentType);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Failed to parse " + $this$toContentType, e);
        }
        return contentType;
    }

    private static final Map contentTypesByExtensions_delegate$lambda$1() {
        Map map2;
        Map $this$contentTypesByExtensions_delegate_u24lambda_u241_u24lambda_u240 = map2 = CollectionsKt.caseInsensitiveMap();
        boolean bl = false;
        $this$contentTypesByExtensions_delegate_u24lambda_u241_u24lambda_u240.putAll(FileContentTypeKt.groupByPairs(kotlin.collections.CollectionsKt.asSequence((Iterable)MimesKt.getMimes())));
        return map2;
    }

    private static final Pair extensionsByContentType_delegate$lambda$3$lambda$2(Pair pair) {
        Intrinsics.checkNotNullParameter(pair, "<destruct>");
        String first2 = (String)pair.component1();
        ContentType second2 = (ContentType)pair.component2();
        return TuplesKt.to(second2, first2);
    }

    private static final Map extensionsByContentType_delegate$lambda$3() {
        return FileContentTypeKt.groupByPairs(SequencesKt.map(kotlin.collections.CollectionsKt.asSequence((Iterable)MimesKt.getMimes()), FileContentTypeKt::extensionsByContentType_delegate$lambda$3$lambda$2));
    }
}

