package com.ustadmobile.core.db.dao

import androidx.paging.PagingSource
import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.HolidayCalendar
import com.ustadmobile.lib.db.entities.HolidayCalendarWithNumEntries
import kotlin.IllegalStateException
import kotlin.Int
import kotlin.Long
import kotlin.Unit
import kotlin.collections.List
import kotlinx.coroutines.flow.Flow

public class HolidayCalendarDao_DoorWrapper(
  private val _db: RoomDatabase,
  private val _dao: HolidayCalendarDao,
) : HolidayCalendarDao() {
  override fun findAllHolidaysWithEntriesCount(): PagingSource<Int, HolidayCalendarWithNumEntries> =
      _dao.findAllHolidaysWithEntriesCount()

  override fun replaceList(list: List<HolidayCalendar>): Unit = throw
      IllegalStateException("replaceList: synchronous db access is NOT possible on Javascript!")

  override fun findAllHolidaysLiveData(): Flow<List<HolidayCalendar>> =
      _dao.findAllHolidaysLiveData()

  override fun findByUidLive(uid: Long): Flow<HolidayCalendar?> = _dao.findByUidLive(uid)

  override suspend fun updateAsync(entity: HolidayCalendar): Int {
    entity.umCalendarLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    return _dao.updateAsync(entity)
  }

  override suspend fun findByUid(uid: Long): HolidayCalendar? = _dao.findByUid(uid)

  override suspend fun findByUidAsync(uid: Long): HolidayCalendar? = _dao.findByUidAsync(uid)

  public override fun insert(entity: HolidayCalendar): Long = throw
      IllegalStateException("insert: synchronous db access is NOT possible on Javascript!")

  public override suspend fun insertAsync(entity: HolidayCalendar): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.umCalendarUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(28)
      entity.umCalendarUid = _newPk
    }
    entity.umCalendarLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.umCalendarUid
  }

  public override fun insertList(entityList: List<HolidayCalendar>): Unit = throw
      IllegalStateException("insertList: synchronous db access is NOT possible on Javascript!")

  public override fun update(entity: HolidayCalendar): Unit = throw
      IllegalStateException("update: synchronous db access is NOT possible on Javascript!")
}
