/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import androidx.paging.PagingSource;
import androidx.room.Dao;
import androidx.room.Query;
import androidx.room.Update;
import com.ustadmobile.core.db.dao.BaseDao;
import com.ustadmobile.lib.db.composites.ClazzAndDetailPermissions;
import com.ustadmobile.lib.db.composites.ClazzAndDisplayDetails;
import com.ustadmobile.lib.db.composites.ClazzNameAndTerminology;
import com.ustadmobile.lib.db.entities.Clazz;
import com.ustadmobile.lib.db.entities.ClazzWithHolidayCalendarAndAndTerminology;
import com.ustadmobile.lib.db.entities.ClazzWithListDisplayDetails;
import com.ustadmobile.lib.db.entities.UidAndLabel;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH'J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH'J\u0014\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000e0\u0005H'J\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u00a7@\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u00a7@\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0012H'J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0018\u001a\u00020\bH'J\u0018\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00052\u0006\u0010\u0018\u001a\u00020\bH'J\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00052\u0006\u0010\u0018\u001a\u00020\bH'J\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0018\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u000e2\u0006\u0010\u001f\u001a\u00020\bH'JR\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!2\u0006\u0010$\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020\bH'J$\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010+\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010,J\"\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u000e2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u00a7@\u00a2\u0006\u0002\u00100J\u0018\u00101\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001020\u00052\u0006\u0010\t\u001a\u00020\bH'J\u0018\u00103\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00052\u0006\u0010\t\u001a\u00020\bH'J\u0018\u00104\u001a\u0004\u0018\u00010\u00122\u0006\u0010\t\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\fJ(\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001060\u00052\u0006\u0010\t\u001a\u00020\b2\u0006\u0010(\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH'J\"\u00107\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00120\u000eH\u00a7@\u00a2\u0006\u0002\u00100J\u0018\u00109\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00052\u0006\u0010\t\u001a\u00020\bH'J\u0016\u0010:\u001a\u00020\"2\u0006\u0010;\u001a\u00020\u0002H\u00a7@\u00a2\u0006\u0002\u0010<J\u001e\u0010=\u001a\u00020>2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010?\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010,\u00a8\u0006@"}, d2={"Lcom/ustadmobile/core/db/dao/ClazzDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/Clazz;", "()V", "clazzAndDetailPermissionsAsFlow", "Lkotlinx/coroutines/flow/Flow;", "Lcom/ustadmobile/lib/db/composites/ClazzAndDetailPermissions;", "accountPersonUid", "", "clazzUid", "clazzUidExistsAsync", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findAll", "", "findAllLive", "findByClazzCode", "code", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByClazzCodeFromWeb", "findByClazzName", "name", "findByUid", "uid", "findByUidAsFlow", "findByUidAsync", "findByUidLive", "findByUidWithHolidayCalendarAsync", "Lcom/ustadmobile/lib/db/entities/ClazzWithHolidayCalendarAndAndTerminology;", "findClazzesWithEffectiveHolidayCalendarAndFilter", "filterUid", "findClazzesWithPermission", "Landroidx/paging/PagingSource;", "", "Lcom/ustadmobile/lib/db/entities/ClazzWithListDisplayDetails;", "searchQuery", "excludeSelectedClazzList", "sortOrder", "filter", "currentTime", "permission", "findOneRosterUserClazzes", "filterByEnrolledMemberPersonUid", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getClassNamesFromListOfIds", "Lcom/ustadmobile/lib/db/entities/UidAndLabel;", "ids", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getClazzNameAndTerminologyAsFlow", "Lcom/ustadmobile/lib/db/composites/ClazzNameAndTerminology;", "getClazzNameAsFlow", "getClazzTimeZoneByClazzUidAsync", "getClazzWithDisplayDetails", "Lcom/ustadmobile/lib/db/composites/ClazzAndDisplayDetails;", "getCoursesByName", "names", "getTitleByUidAsFlow", "updateAsync", "entity", "(Lcom/ustadmobile/lib/db/entities/Clazz;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateClazzAttendanceAverageAsync", "", "timeChanged", "lib-database_debug"})
@Dao
public abstract class ClazzDao
implements BaseDao<Clazz> {
    @Query(value="SELECT * FROM Clazz WHERE clazzUid = :uid")
    @Nullable
    public abstract Clazz findByUid(long var1);

    @Query(value="SELECT * From Clazz WHERE clazzUid = :uid")
    @NotNull
    public abstract Flow<Clazz> findByUidLive(long var1);

    @Query(value="SELECT * FROM Clazz WHERE clazzCode = :code")
    @Nullable
    public abstract Object findByClazzCode(@NotNull String var1, @NotNull Continuation<? super Clazz> var2);

    @Query(value="SELECT * FROM Clazz WHERE clazzCode = :code")
    @Nullable
    public abstract Object findByClazzCodeFromWeb(@NotNull String var1, @NotNull Continuation<? super Clazz> var2);

    @Query(value="SELECT * FROM Clazz WHERE CAST(isClazzActive AS INTEGER) = 1")
    @NotNull
    public abstract Flow<List<Clazz>> findAllLive();

    @Query(value="SELECT * FROM Clazz WHERE CAST(isClazzActive AS INTEGER) = 1")
    @NotNull
    public abstract List<Clazz> findAll();

    @Query(value="SELECT * FROM Clazz WHERE clazzUid = :clazzUid")
    @Nullable
    public abstract Object findByUidAsync(long var1, @NotNull Continuation<? super Clazz> var3);

    @Query(value="\n        SELECT EXISTS(\n               SELECT Clazz.clazzUid\n                 FROM Clazz\n                WHERE Clazz.clazzUid = :clazzUid)\n    ")
    @Nullable
    public abstract Object clazzUidExistsAsync(long var1, @NotNull Continuation<? super Boolean> var3);

    @Query(value="SELECT * FROM Clazz WHERE clazzUid = :uid")
    @NotNull
    public abstract Flow<Clazz> findByUidAsFlow(long var1);

    @Query(value="\n        SELECT Clazz.*, \n               CoursePicture.*,\n               HolidayCalendar.*, \n               CourseTerminology.*\n          FROM Clazz \n               LEFT JOIN HolidayCalendar \n                         ON Clazz.clazzHolidayUMCalendarUid = HolidayCalendar.umCalendarUid\n\n               LEFT JOIN CourseTerminology\n                         ON CourseTerminology.ctUid = Clazz.clazzTerminologyUid\n                      \n               LEFT JOIN CoursePicture\n                         ON CoursePicture.coursePictureUid = :uid\n         WHERE Clazz.clazzUid = :uid")
    @Nullable
    public abstract Object findByUidWithHolidayCalendarAsync(long var1, @NotNull Continuation<? super ClazzWithHolidayCalendarAndAndTerminology> var3);

    @Update(entity=Object.class, onConflict=3)
    @Nullable
    public abstract Object updateAsync(@NotNull Clazz var1, @NotNull Continuation<? super Integer> var2);

    @Query(value="\n        SELECT Clazz.*, ClazzEnrolment.*, CoursePicture.*,\n               (SELECT COUNT(DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid) \n                  FROM ClazzEnrolment \n                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid \n                   AND clazzEnrolmentRole = 1000 \n                   AND :currentTime BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                       AND ClazzEnrolment.clazzEnrolmentDateLeft) AS numStudents,\n               (SELECT COUNT(DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid) \n                  FROM ClazzEnrolment \n                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid \n                   AND clazzEnrolmentRole = 1001\n                   AND :currentTime BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                        AND ClazzEnrolment.clazzEnrolmentDateLeft) AS numTeachers,\n               '' AS teacherNames,\n               0 AS lastRecorded,\n               CourseTerminology.*\n          FROM Clazz\n               LEFT JOIN ClazzEnrolment \n                    ON ClazzEnrolment.clazzEnrolmentUid =\n                       COALESCE(\n                       (SELECT ClazzEnrolment.clazzEnrolmentUid \n                          FROM ClazzEnrolment\n                         WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                           AND ClazzEnrolment.clazzEnrolmentActive\n                           AND ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid \n                      ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC   \n                         LIMIT 1), 0)\n                LEFT JOIN CourseTerminology   \n                          ON CourseTerminology.ctUid = Clazz.clazzTerminologyUid\n                LEFT JOIN CoursePicture\n                          ON CoursePicture.coursePictureUid = Clazz.clazzUid           \n\n         WHERE /* Begin permission check clause */\n               :accountPersonUid != 0\n           AND (\n                    Clazz.clazzOwnerPersonUid = :accountPersonUid\n                 OR EXISTS(SELECT CoursePermission.cpUid\n                             FROM CoursePermission\n                            WHERE CoursePermission.cpClazzUid = Clazz.clazzUid\n                              AND (   CoursePermission.cpToPersonUid = :accountPersonUid \n                                   OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment.clazzEnrolmentRole )\n                              AND (CoursePermission.cpPermissionsFlag & :permission) > 0 \n                              AND NOT CoursePermission.cpIsDeleted)   \n                 OR (\n        SELECT \n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE :accountPersonUid != 0 \n                  AND SystemPermission.spToPersonUid = :accountPersonUid\n                  AND (SystemPermission.spPermissionsFlag &\n    \n          :permission\n        \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n      \n    )             \n                )\n                /* End permission check clause */ \n           AND CAST(Clazz.isClazzActive AS INTEGER) = 1\n           AND Clazz.clazzName like :searchQuery\n           AND (Clazz.clazzUid NOT IN (:excludeSelectedClazzList))\n           AND ( :filter = 0 OR (CASE WHEN :filter = 5 \n                                      THEN :currentTime BETWEEN Clazz.clazzStartTime AND Clazz.clazzEndTime\n                                      ELSE :currentTime > Clazz.clazzEndTime \n                                      END))\n      GROUP BY Clazz.clazzUid, ClazzEnrolment.clazzEnrolmentUid, CourseTerminology.ctUid, CoursePicture.coursePictureUid\n      ORDER BY CASE :sortOrder\n               WHEN 3 THEN Clazz.attendanceAverage\n               ELSE 0\n               END ASC,\n               CASE :sortOrder\n               WHEN 1 THEN Clazz.clazzName\n               ELSE ''\n               END ASC,\n               CASE :sortOrder\n               WHEN 4 THEN Clazz.attendanceAverage\n               ELSE 0\n               END DESC,\n               CASE :sortOrder\n               WHEN 2 THEN clazz.Clazzname\n               ELSE ''\n               END DESC\n    ")
    @NotNull
    public abstract PagingSource<Integer, ClazzWithListDisplayDetails> findClazzesWithPermission(@NotNull String var1, long var2, @NotNull List<Long> var4, int var5, int var6, long var7, long var9);

    @Query(value="SELECT Clazz.clazzUid AS uid, Clazz.clazzName AS labelName From Clazz WHERE clazzUid IN (:ids)")
    @Nullable
    public abstract Object getClassNamesFromListOfIds(@NotNull List<Long> var1, @NotNull Continuation<? super List<UidAndLabel>> var2);

    @Query(value="SELECT * FROM Clazz WHERE clazzName = :name and CAST(isClazzActive AS INTEGER) = 1")
    @NotNull
    public abstract List<Clazz> findByClazzName(@NotNull String var1);

    @Query(value="\n        UPDATE Clazz \n           SET attendanceAverage = \n               COALESCE(CAST(\n                    (SELECT SUM(clazzLogNumPresent) \n                       FROM ClazzLog \n                      WHERE clazzLogClazzUid = :clazzUid\n                       AND clazzLogStatusFlag = 4) AS REAL) /\n                    \n                    CAST(MAX(1.0, \n                        (SELECT SUM(clazzLogNumPresent) + SUM(clazzLogNumPartial) + SUM(clazzLogNumAbsent)\n                        FROM ClazzLog \n                       WHERE clazzLogClazzUid = :clazzUid \n                        AND clazzLogStatusFlag = 4)) AS REAL), 0),\n               clazzLct = :timeChanged         \n         WHERE clazzUid = :clazzUid\n    ")
    @Nullable
    public abstract Object updateClazzAttendanceAverageAsync(long var1, long var3, @NotNull Continuation<? super Unit> var5);

    @Query(value="\n        SELECT Clazz.*,\n               (  (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = :clazzUid), 0) = :accountPersonUid)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = :accountPersonUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = :clazzUid\n                           AND (CoursePermission.cpToPersonUid = :accountPersonUid \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         \n                  32\n                  \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = :accountPersonUid\n                           AND (SystemPermission.spPermissionsFlag & \n    \n                  32\n                  \n        ) > 0)\n               )\n    \n               ) AS hasAttendancePermission,\n               (  (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = :clazzUid), 0) = :accountPersonUid)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = :accountPersonUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = :clazzUid\n                           AND (CoursePermission.cpToPersonUid = :accountPersonUid \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         \n                  8192\n                  \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = :accountPersonUid\n                           AND (SystemPermission.spPermissionsFlag & \n    \n                  8192\n                  \n        ) > 0)\n               )\n    \n               ) AS hasViewMembersPermission,\n               (  (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = :clazzUid), 0) = :accountPersonUid)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = :accountPersonUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = :clazzUid\n                           AND (CoursePermission.cpToPersonUid = :accountPersonUid \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         \n                  128\n                  \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = :accountPersonUid\n                           AND (SystemPermission.spPermissionsFlag & \n    \n                  128\n                  \n        ) > 0)\n               )\n    \n               ) AS hasLearningRecordPermission\n          FROM Clazz\n         WHERE Clazz.clazzUid = :clazzUid\n           AND (  (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = :clazzUid), 0) = :accountPersonUid)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = :accountPersonUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = :clazzUid\n                           AND (CoursePermission.cpToPersonUid = :accountPersonUid \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         \n                  1\n                  \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = :accountPersonUid\n                           AND (SystemPermission.spPermissionsFlag & \n    \n                  1\n                  \n        ) > 0)\n               )\n    \n               )\n    ")
    @NotNull
    public abstract Flow<ClazzAndDetailPermissions> clazzAndDetailPermissionsAsFlow(long var1, long var3);

    @Query(value="\n        SELECT Clazz.*, \n               CoursePicture.*,\n               (SELECT COUNT(DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid) \n                  FROM ClazzEnrolment \n                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid \n                   AND clazzEnrolmentRole = 1000 \n                   AND :currentTime BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                        AND ClazzEnrolment.clazzEnrolmentDateLeft) AS numStudents,\n               (SELECT COUNT(DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid) \n                  FROM ClazzEnrolment \n                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid \n                   AND clazzEnrolmentRole = 1001 \n                   AND :currentTime BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                       AND ClazzEnrolment.clazzEnrolmentDateLeft) AS numTeachers,\n                CourseTerminology.*,\n                (SELECT EXISTS(\n                        SELECT 1\n                          FROM ClazzEnrolment\n                         WHERE ClazzEnrolment.clazzEnrolmentClazzUid = :clazzUid\n                           AND ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                           AND ClazzEnrolment.clazzEnrolmentRole = 1000\n)\n                ) AS activeUserIsStudent\n         FROM Clazz \n              LEFT JOIN CourseTerminology\n                        ON CourseTerminology.ctUid = Clazz.clazzTerminologyUid\n              LEFT JOIN CoursePicture\n                        ON CoursePicture.coursePictureUid = :clazzUid\n        WHERE Clazz.clazzUid = :clazzUid")
    @NotNull
    public abstract Flow<ClazzAndDisplayDetails> getClazzWithDisplayDetails(long var1, long var3, long var5);

    @Query(value="\n        SELECT Clazz.*, \n               HolidayCalendar.*,\n               CourseTerminology.*,\n               CoursePicture.*\n         FROM Clazz \n              LEFT JOIN HolidayCalendar \n              ON ((clazz.clazzHolidayUMCalendarUid != 0 \n                AND HolidayCalendar.umCalendarUid = clazz.clazzHolidayUMCalendarUid)\n                OR clazz.clazzHolidayUMCalendarUid = 0 AND clazz.clazzSchoolUid = 0 \n                AND HolidayCalendar.umCalendarUid = 0) \n              LEFT JOIN CourseTerminology\n              ON CourseTerminology.ctUid = Clazz.clazzTerminologyUid\n              \n              LEFT JOIN CoursePicture\n                        ON CoursePicture.coursePictureUid = 0\n                \n        WHERE :filterUid = 0 \n           OR Clazz.clazzUid = :filterUid\n    ")
    @NotNull
    public abstract List<ClazzWithHolidayCalendarAndAndTerminology> findClazzesWithEffectiveHolidayCalendarAndFilter(long var1);

    @Query(value="\n        SELECT Clazz.clazzName\n          FROM Clazz\n         WHERE Clazz.clazzUid = :clazzUid\n    ")
    @NotNull
    public abstract Flow<String> getTitleByUidAsFlow(long var1);

    @Query(value="\n        SELECT Clazz.clazzName AS clazzName,\n               CourseTerminology.*\n          FROM Clazz\n               LEFT JOIN CourseTerminology\n                         ON CourseTerminology.ctUid = Clazz.clazzTerminologyUid\n         WHERE Clazz.clazzUid = :clazzUid                \n    ")
    @NotNull
    public abstract Flow<ClazzNameAndTerminology> getClazzNameAndTerminologyAsFlow(long var1);

    @Query(value="\n        SELECT Clazz.clazzName AS clazzName\n          FROM Clazz\n         WHERE Clazz.clazzUid = :clazzUid                \n    ")
    @NotNull
    public abstract Flow<String> getClazzNameAsFlow(long var1);

    @Query(value="\n        SELECT Clazz.clazzTimeZone\n          FROM Clazz\n         WHERE Clazz.clazzUid = :clazzUid \n    ")
    @Nullable
    public abstract Object getClazzTimeZoneByClazzUidAsync(long var1, @NotNull Continuation<? super String> var3);

    @Query(value="\n        SELECT Clazz.*\n          FROM Clazz\n         WHERE Clazz.clazzName IN (:names) \n    ")
    @Nullable
    public abstract Object getCoursesByName(@NotNull List<String> var1, @NotNull Continuation<? super List<? extends Clazz>> var2);

    @Query(value="\n        SELECT Clazz.*\n          FROM CLAZZ\n               LEFT JOIN ClazzEnrolment \n                    ON ClazzEnrolment.clazzEnrolmentUid =\n                       COALESCE(\n                       (SELECT ClazzEnrolment.clazzEnrolmentUid \n                          FROM ClazzEnrolment\n                         WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                           AND ClazzEnrolment.clazzEnrolmentActive\n                           AND ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid \n                      ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC   \n                         LIMIT 1), 0)\n          WHERE (   Clazz.clazzOwnerPersonUid = :accountPersonUid\n                 OR EXISTS(SELECT CoursePermission.cpUid\n                             FROM CoursePermission\n                            WHERE CoursePermission.cpClazzUid = Clazz.clazzUid\n                              AND (   CoursePermission.cpToPersonUid = :accountPersonUid \n                                   OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment.clazzEnrolmentRole )\n                              AND (CoursePermission.cpPermissionsFlag & 1) > 0 \n                              AND NOT CoursePermission.cpIsDeleted)   \n                 OR (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE :accountPersonUid != 0 \n                  AND SystemPermission.spToPersonUid = :accountPersonUid\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                     1\n                     \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    \n                    )             \n                )\n           AND EXISTS \n                (SELECT ClazzEnrolment.clazzEnrolmentUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :filterByEnrolledMemberPersonUid\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid\n                )  \n    ")
    @Nullable
    public abstract Object findOneRosterUserClazzes(long var1, long var3, @NotNull Continuation<? super List<? extends Clazz>> var5);
}

