/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import androidx.paging.PagingSource;
import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.Update;
import com.ustadmobile.core.db.dao.BaseDao;
import com.ustadmobile.lib.db.composites.PersonAndListDisplayDetails;
import com.ustadmobile.lib.db.composites.PersonAndPicture;
import com.ustadmobile.lib.db.composites.PersonNames;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.PersonAndDisplayDetail;
import com.ustadmobile.lib.db.entities.PersonAuth;
import com.ustadmobile.lib.db.entities.PersonGroup;
import com.ustadmobile.lib.db.entities.PersonGroupMember;
import com.ustadmobile.lib.db.entities.PersonUidAndPasswordHash;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000bH'J\u0018\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH'J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000bH\u00a7@\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH'J \u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\r2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH'J \u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\r2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000bH'J\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0014\u001a\u00020\u000bH\u00a7@\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\r2\u0006\u0010\n\u001a\u00020\u000bH'J\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H'J \u0010\u001b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\bJH\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000b0 2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u00052\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u0007H'JN\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020!0(2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000b0 2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u00052\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u0007H'J\u0018\u0010)\u001a\u0004\u0018\u00010\u00022\u0006\u0010*\u001a\u00020\u000bH\u00a7@\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\bJ\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00020 H'J\u0018\u0010.\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010/0\r2\u0006\u0010\n\u001a\u00020\u000bH'J\u0018\u00100\u001a\u0004\u0018\u00010/2\u0006\u0010\n\u001a\u00020\u000bH\u00a7@\u00a2\u0006\u0002\u0010\u000fJ\u001c\u00101\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00020 H\u00a7@\u00a2\u0006\u0002\u00104J\u0016\u00105\u001a\u0002022\u0006\u00106\u001a\u00020\u0002H\u00a7@\u00a2\u0006\u0002\u00107J\u0010\u00108\u001a\u0002022\u0006\u00109\u001a\u00020:H'J\u0016\u0010;\u001a\u00020\u000b2\u0006\u0010<\u001a\u00020=H\u00a7@\u00a2\u0006\u0002\u0010>J\u0016\u0010?\u001a\u00020\u000b2\u0006\u0010@\u001a\u00020AH\u00a7@\u00a2\u0006\u0002\u0010BJ$\u0010C\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070 2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00070 H\u00a7@\u00a2\u0006\u0002\u00104J\u0016\u0010E\u001a\u00020\u00052\u0006\u0010F\u001a\u00020\u0002H\u00a7@\u00a2\u0006\u0002\u00107J&\u0010G\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010H\u001a\u00020\u000bH\u00a7@\u00a2\u0006\u0002\u0010I\u00a8\u0006J"}, d2={"Lcom/ustadmobile/core/db/dao/PersonDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/Person;", "()V", "countUsername", "", "username", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUid", "uid", "", "findByUidAsFlow", "Lkotlinx/coroutines/flow/Flow;", "findByUidAsync", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUidLive", "findByUidWithDisplayDetailsFlow", "Lcom/ustadmobile/lib/db/entities/PersonAndDisplayDetail;", "personUid", "accountPersonUid", "findByUidWithDisplayDetailsLive", "activeUserPersonUid", "findByUidWithPicture", "Lcom/ustadmobile/lib/db/composites/PersonAndPicture;", "findByUidWithPictureAsFlow", "findByUsername", "findByUsernameAndPasswordHash2", "passwordHash", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUsernameAsync", "findPersonsWithPermissionAsList", "", "Lcom/ustadmobile/lib/db/composites/PersonAndListDisplayDetails;", "timestamp", "excludeClazz", "excludeSelected", "sortOrder", "searchText", "findPersonsWithPermissionAsPagingSource", "Landroidx/paging/PagingSource;", "findSystemAccount", "nodeId", "findUidAndPasswordHashAsync", "Lcom/ustadmobile/lib/db/entities/PersonUidAndPasswordHash;", "getAllPerson", "getNamesByUid", "Lcom/ustadmobile/lib/db/composites/PersonNames;", "getNamesByUidAsync", "insertListAsync", "", "entityList", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "insertOrReplace", "person", "(Lcom/ustadmobile/lib/db/entities/Person;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "insertPersonAuth", "personAuth", "Lcom/ustadmobile/lib/db/entities/PersonAuth;", "insertPersonGroup", "personGroup", "Lcom/ustadmobile/lib/db/entities/PersonGroup;", "(Lcom/ustadmobile/lib/db/entities/PersonGroup;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "insertPersonGroupMember", "personGroupMember", "Lcom/ustadmobile/lib/db/entities/PersonGroupMember;", "(Lcom/ustadmobile/lib/db/entities/PersonGroupMember;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "selectExistingUsernames", "usernames", "updateAsync", "entity", "updateUsername", "currentTime", "(JLjava/lang/String;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database_release"})
@Dao
public abstract class PersonDao
implements BaseDao<Person> {
    @Insert(entity=Object.class, onConflict=3)
    @Nullable
    public abstract Object insertListAsync(@NotNull List<Person> var1, @NotNull Continuation<? super Unit> var2);

    @Insert(entity=Object.class, onConflict=1)
    @Nullable
    public abstract Object insertOrReplace(@NotNull Person var1, @NotNull Continuation<? super Unit> var2);

    @Query(value="SELECT COUNT(*) FROM Person where Person.username = :username")
    @Nullable
    public abstract Object countUsername(@NotNull String var1, @NotNull Continuation<? super Integer> var2);

    @Query(value="\n        SELECT Person.personUid, Person.firstNames, Person.lastName, \n               PersonAuth.passwordHash\n          FROM Person\n               JOIN PersonAuth\n                    ON Person.personUid = PersonAuth.personAuthUid\n         WHERE Person.username = :username\n    ")
    @Nullable
    public abstract Object findUidAndPasswordHashAsync(@NotNull String var1, @NotNull Continuation<? super PersonUidAndPasswordHash> var2);

    @Query(value="\n        SELECT Person.*\n          FROM Person\n               JOIN PersonAuth2\n                    ON Person.personUid = PersonAuth2.pauthUid\n         WHERE Person.username = :username \n               AND PersonAuth2.pauthAuth = :passwordHash\n    ")
    @Nullable
    public abstract Object findByUsernameAndPasswordHash2(@NotNull String var1, @NotNull String var2, @NotNull Continuation<? super Person> var3);

    @Insert(entity=Object.class, onConflict=3)
    public abstract void insertPersonAuth(@NotNull PersonAuth var1);

    @Query(value="SELECT Person.* FROM PERSON Where Person.username = :username")
    @Nullable
    public abstract Person findByUsername(@Nullable String var1);

    @Query(value="SELECT Person.* FROM PERSON Where Person.username = :username")
    @Nullable
    public abstract Object findByUsernameAsync(@NotNull String var1, @NotNull Continuation<? super Person> var2);

    @Query(value="\n        SELECT Person.*\n          FROM Person\n         WHERE Person.dateOfBirth = :nodeId\n           AND Person.personType = 1\n    ")
    @Nullable
    public abstract Object findSystemAccount(long var1, @NotNull Continuation<? super Person> var3);

    @Query(value="SELECT * FROM PERSON WHERE Person.personUid = :uid")
    @Nullable
    public abstract Person findByUid(long var1);

    @Query(value="\n        SELECT Person.*, PersonPicture.*\n          FROM Person\n               LEFT JOIN PersonPicture\n                    ON PersonPicture.personPictureUid = Person.personUid\n         WHERE Person.personUid = :accountPersonUid           \n    ")
    @Nullable
    public abstract Object findByUidWithPicture(long var1, @NotNull Continuation<? super PersonAndPicture> var3);

    @Query(value="\n        SELECT Person.*, PersonPicture.*\n          FROM Person\n               LEFT JOIN PersonPicture\n                    ON PersonPicture.personPictureUid = Person.personUid\n         WHERE Person.personUid = :uid           \n    ")
    @NotNull
    public abstract Flow<PersonAndPicture> findByUidWithPictureAsFlow(long var1);

    @Query(value="SELECT * From Person WHERE personUid = :uid")
    @NotNull
    public abstract Flow<Person> findByUidLive(long var1);

    @Query(value="SELECT * FROM Person WHERE personUid = :uid")
    @Nullable
    public abstract Object findByUidAsync(long var1, @NotNull Continuation<? super Person> var3);

    @Query(value="SELECT * FROM Person WHERE personUid = :uid")
    @NotNull
    public abstract Flow<Person> findByUidAsFlow(long var1);

    @Update(entity=Object.class, onConflict=3)
    @Nullable
    public abstract Object updateAsync(@NotNull Person var1, @NotNull Continuation<? super Integer> var2);

    @Insert(entity=Object.class, onConflict=3)
    @Nullable
    public abstract Object insertPersonGroup(@NotNull PersonGroup var1, @NotNull Continuation<? super Long> var2);

    @Insert(entity=Object.class, onConflict=3)
    @Nullable
    public abstract Object insertPersonGroupMember(@NotNull PersonGroupMember var1, @NotNull Continuation<? super Long> var2);

    @Query(value="\n         WITH CanViewPersonUidsViaCoursePermission(personUid) AS\n              /* Select personUids that can be viewed based on CoursePermission given the active user \n                 for their enrolments \n              */\n              (SELECT DISTINCT ClazzEnrolment_ForClazzMember.clazzEnrolmentPersonUid AS personUid\n                 FROM ClazzEnrolment ClazzEnrolment_ForActiveUser\n                      JOIN CoursePermission \n                           ON CoursePermission.cpClazzUid = ClazzEnrolment_ForActiveUser.clazzEnrolmentClazzUid\n                          AND CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForActiveUser.clazzEnrolmentRole\n                          AND (CoursePermission.cpPermissionsFlag & 8192) > 0\n                      JOIN ClazzEnrolment ClazzEnrolment_ForClazzMember\n                           ON ClazzEnrolment_ForClazzMember.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                WHERE :accountPersonUid != 0\n                  AND ClazzEnrolment_ForActiveUser.clazzEnrolmentPersonUid = :accountPersonUid\n                  AND ClazzEnrolment_ForActiveUser.clazzEnrolmentActive\n              \n               UNION\n               /* Select personUids that can be viewed based on CoursePermission for the active user\n                  where the CoursePermission is granted directly to them\n                */   \n               SELECT DISTINCT ClazzEnrolment_ForClazzMember.clazzEnrolmentPersonUid AS personUid\n                 FROM CoursePermission\n                      JOIN ClazzEnrolment ClazzEnrolment_ForClazzMember\n                           ON ClazzEnrolment_ForClazzMember.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                WHERE :accountPersonUid != 0\n                  AND CoursePermission.cpToPersonUid = :accountPersonUid)\n               \n         SELECT Person.*, PersonPicture.*\n           FROM Person\n                LEFT JOIN PersonPicture\n                     ON PersonPicture.personPictureUid = Person.personUid\n          WHERE /* Begin permission check */ \n                (         \n                      (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE :accountPersonUid != 0 \n                  AND SystemPermission.spToPersonUid = :accountPersonUid\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                       8192\n                       \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    )\n                    OR (Person.personUid IN \n                               (SELECT CanViewPersonUidsViaCoursePermission.personUid\n                                  FROM CanViewPersonUidsViaCoursePermission))\n                    OR (Person.personUid = :accountPersonUid)\n                )\n                /* End permission check */\n           AND (:excludeClazz = 0 OR :excludeClazz NOT IN\n                    (SELECT clazzEnrolmentClazzUid \n                       FROM ClazzEnrolment \n                      WHERE clazzEnrolmentPersonUid = Person.personUid \n                            AND :timestamp BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                                AND ClazzEnrolment.clazzEnrolmentDateLeft\n                        AND ClazzEnrolment.clazzEnrolmentActive))\n           AND Person.personType = 0                  \n           AND (Person.personUid NOT IN (:excludeSelected))\n           AND (:searchText = '%' \n               OR Person.firstNames || ' ' || Person.lastName LIKE :searchText)\n      GROUP BY Person.personUid, PersonPicture.personPictureUid\n      ORDER BY CASE(:sortOrder)\n               WHEN 1 THEN Person.firstNames\n               WHEN 3 THEN Person.lastName\n               ELSE ''\n               END ASC,\n               CASE(:sortOrder)\n               WHEN 2 THEN Person.firstNames\n               WHEN 4 THEN Person.lastName\n               ELSE ''\n               END DESC\n    ")
    @NotNull
    public abstract List<PersonAndListDisplayDetails> findPersonsWithPermissionAsList(long var1, long var3, @NotNull List<Long> var5, long var6, int var8, @Nullable String var9);

    public static /* synthetic */ List findPersonsWithPermissionAsList$default(PersonDao personDao, long l, long l2, List list, long l3, int n, String string, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findPersonsWithPermissionAsList");
        }
        if ((n2 & 0x20) != 0) {
            string = "%";
        }
        return personDao.findPersonsWithPermissionAsList(l, l2, list, l3, n, string);
    }

    @Query(value="\n         WITH CanViewPersonUidsViaCoursePermission(personUid) AS\n              /* Select personUids that can be viewed based on CoursePermission given the active user \n                 for their enrolments \n              */\n              (SELECT DISTINCT ClazzEnrolment_ForClazzMember.clazzEnrolmentPersonUid AS personUid\n                 FROM ClazzEnrolment ClazzEnrolment_ForActiveUser\n                      JOIN CoursePermission \n                           ON CoursePermission.cpClazzUid = ClazzEnrolment_ForActiveUser.clazzEnrolmentClazzUid\n                          AND CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForActiveUser.clazzEnrolmentRole\n                          AND (CoursePermission.cpPermissionsFlag & 8192) > 0\n                      JOIN ClazzEnrolment ClazzEnrolment_ForClazzMember\n                           ON ClazzEnrolment_ForClazzMember.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                WHERE :accountPersonUid != 0\n                  AND ClazzEnrolment_ForActiveUser.clazzEnrolmentPersonUid = :accountPersonUid\n                  AND ClazzEnrolment_ForActiveUser.clazzEnrolmentActive\n              \n               UNION\n               /* Select personUids that can be viewed based on CoursePermission for the active user\n                  where the CoursePermission is granted directly to them\n                */   \n               SELECT DISTINCT ClazzEnrolment_ForClazzMember.clazzEnrolmentPersonUid AS personUid\n                 FROM CoursePermission\n                      JOIN ClazzEnrolment ClazzEnrolment_ForClazzMember\n                           ON ClazzEnrolment_ForClazzMember.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                WHERE :accountPersonUid != 0\n                  AND CoursePermission.cpToPersonUid = :accountPersonUid)\n               \n         SELECT Person.*, PersonPicture.*\n           FROM Person\n                LEFT JOIN PersonPicture\n                     ON PersonPicture.personPictureUid = Person.personUid\n          WHERE /* Begin permission check */ \n                (         \n                      (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE :accountPersonUid != 0 \n                  AND SystemPermission.spToPersonUid = :accountPersonUid\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                       8192\n                       \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    )\n                    OR (Person.personUid IN \n                               (SELECT CanViewPersonUidsViaCoursePermission.personUid\n                                  FROM CanViewPersonUidsViaCoursePermission))\n                    OR (Person.personUid = :accountPersonUid)\n                )\n                /* End permission check */\n           AND (:excludeClazz = 0 OR :excludeClazz NOT IN\n                    (SELECT clazzEnrolmentClazzUid \n                       FROM ClazzEnrolment \n                      WHERE clazzEnrolmentPersonUid = Person.personUid \n                            AND :timestamp BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                                AND ClazzEnrolment.clazzEnrolmentDateLeft\n                        AND ClazzEnrolment.clazzEnrolmentActive))\n           AND Person.personType = 0                  \n           AND (Person.personUid NOT IN (:excludeSelected))\n           AND (:searchText = '%' \n               OR Person.firstNames || ' ' || Person.lastName LIKE :searchText)\n      GROUP BY Person.personUid, PersonPicture.personPictureUid\n      ORDER BY CASE(:sortOrder)\n               WHEN 1 THEN Person.firstNames\n               WHEN 3 THEN Person.lastName\n               ELSE ''\n               END ASC,\n               CASE(:sortOrder)\n               WHEN 2 THEN Person.firstNames\n               WHEN 4 THEN Person.lastName\n               ELSE ''\n               END DESC\n    ")
    @NotNull
    public abstract PagingSource<Integer, PersonAndListDisplayDetails> findPersonsWithPermissionAsPagingSource(long var1, long var3, @NotNull List<Long> var5, long var6, int var8, @Nullable String var9);

    public static /* synthetic */ PagingSource findPersonsWithPermissionAsPagingSource$default(PersonDao personDao, long l, long l2, List list, long l3, int n, String string, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findPersonsWithPermissionAsPagingSource");
        }
        if ((n2 & 0x20) != 0) {
            string = "%";
        }
        return personDao.findPersonsWithPermissionAsPagingSource(l, l2, list, l3, n, string);
    }

    @Query(value="\n        SELECT Person.*, PersonParentJoin.* \n          FROM Person\n     LEFT JOIN PersonParentJoin on ppjUid = (\n                SELECT ppjUid \n                  FROM PersonParentJoin\n                 WHERE ppjMinorPersonUid = :personUid \n                       AND ppjParentPersonUid = :activeUserPersonUid \n                LIMIT 1)     \n         WHERE Person.personUid = :personUid\n        ")
    @NotNull
    public abstract Flow<PersonAndDisplayDetail> findByUidWithDisplayDetailsLive(long var1, long var3);

    @Query(value="\n        SELECT Person.*, PersonParentJoin.* , PersonPicture.*, TransferJobItem.*\n          FROM Person\n               LEFT JOIN PersonParentJoin \n                    ON ppjUid =\n                    (SELECT ppjUid \n                       FROM PersonParentJoin\n                      WHERE ppjMinorPersonUid = :personUid \n                        AND ppjParentPersonUid = :accountPersonUid \n                      LIMIT 1)  \n               LEFT JOIN PersonPicture\n                    ON PersonPicture.personPictureUid = :personUid\n               LEFT JOIN TransferJobItem\n                    ON TransferJobItem.tjiUid = \n                       (SELECT TransferJobItem.tjiUid\n                          FROM TransferJobItem\n                         WHERE TransferJobItem.tjiEntityUid = :personUid\n                           AND TransferJobItem.tjiTableId = 50\n                           AND TransferJobItem.tjiEntityEtag = PersonPicture.personPictureLct\n                           AND TransferJobItem.tjiStatus != 21\n                         LIMIT 1)\n                          \n         WHERE Person.personUid = :personUid\n        ")
    @NotNull
    public abstract Flow<PersonAndDisplayDetail> findByUidWithDisplayDetailsFlow(long var1, long var3);

    @Query(value="SELECT * FROM Person")
    @NotNull
    public abstract List<Person> getAllPerson();

    @Query(value="\n        SELECT Person.firstNames, Person.lastName\n          FROM Person\n         WHERE Person.personUid = :uid  \n    ")
    @NotNull
    public abstract Flow<PersonNames> getNamesByUid(long var1);

    @Query(value="\n        SELECT Person.firstNames, Person.lastName\n          FROM Person\n         WHERE Person.personUid = :uid  \n    ")
    @Nullable
    public abstract Object getNamesByUidAsync(long var1, @NotNull Continuation<? super PersonNames> var3);

    @Query(value="\n        UPDATE Person\n           SET username = :username,\n               personLct = :currentTime\n         WHERE Person.personUid = :personUid  \n    ")
    @Nullable
    public abstract Object updateUsername(long var1, @NotNull String var3, long var4, @NotNull Continuation<? super Integer> var6);

    @Query(value="\n        SELECT Person.username\n          FROM Person\n         WHERE Person.username IN (:usernames)\n    ")
    @Nullable
    public abstract Object selectExistingUsernames(@NotNull List<String> var1, @NotNull Continuation<? super List<String>> var2);
}

