package com.ustadmobile.core.db.dao.xapi

import com.ustadmobile.door.DoorConstants
import com.ustadmobile.door.ext.doorWrapper
import com.ustadmobile.door.ext.doorWrapperNodeId
import com.ustadmobile.door.http.DoorHttpServerConfig
import com.ustadmobile.door.http.DoorJsonRequest
import com.ustadmobile.door.http.DoorJsonResponse
import com.ustadmobile.door.message.DoorMessage
import com.ustadmobile.door.replication.DoorReplicationEntity
import com.ustadmobile.lib.db.entities.xapi.ActorEntity
import com.ustadmobile.lib.db.entities.xapi.StateEntity
import kotlin.Boolean
import kotlin.Long
import kotlin.Suppress
import kotlin.collections.buildList
import kotlinx.serialization.builtins.nullable
import kotlinx.serialization.builtins.serializer
import kotlinx.serialization.json.jsonObject

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend fun StateEntityDao.findByActorAndHash_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_actorUid : Long = request.queryParam("actorUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_seHash : Long = request.queryParam("seHash")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_includeDeleted : Boolean = request.queryParam("includeDeleted")?.let {
    json.decodeFromString(Boolean.serializer(), it)
  } ?: false
  val _result_findByActorAndHash = findByActorAndHash(
    accountPersonUid = _arg_accountPersonUid,
    actorUid = _arg_actorUid,
    seHash = _arg_seHash,
    includeDeleted = true,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    _result_findByActorAndHash?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 3_289,
          orUid = 0,
          entity = json.encodeToJsonElement(StateEntity.serializer(), _row).jsonObject,
        )
      )
    }
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun StateEntityDao.findByAgentAndActivity_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_actorUid : Long = request.queryParam("actorUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_seActivityUid : Long = request.queryParam("seActivityUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_registrationUuidHi : Long? = request.queryParam("registrationUuidHi")?.let {
    json.decodeFromString(Long.serializer().nullable, it)
  }
  val _arg_registrationUuidLo : Long? = request.queryParam("registrationUuidLo")?.let {
    json.decodeFromString(Long.serializer().nullable, it)
  }
  val _arg_modifiedSince : Long = request.queryParam("modifiedSince")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findByAgentAndActivity = findByAgentAndActivity(
    accountPersonUid = _arg_accountPersonUid,
    actorUid = _arg_actorUid,
    seActivityUid = _arg_seActivityUid,
    registrationUuidHi = _arg_registrationUuidHi,
    registrationUuidLo = _arg_registrationUuidLo,
    modifiedSince = _arg_modifiedSince,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_findByAgentAndActivity.map {
        _row ->
        DoorReplicationEntity(tableId = 3_289,
          orUid = 0,
          entity = json.encodeToJsonElement(StateEntity.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend fun StateEntityDao.getStateIds_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_actorUid : Long = request.queryParam("actorUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_seActivityUid : Long = request.queryParam("seActivityUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_registrationUuidHi : Long? = request.queryParam("registrationUuidHi")?.let {
    json.decodeFromString(Long.serializer().nullable, it)
  }
  val _arg_registrationUuidLo : Long? = request.queryParam("registrationUuidLo")?.let {
    json.decodeFromString(Long.serializer().nullable, it)
  }
  val _arg_modifiedSince : Long = request.queryParam("modifiedSince")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findByAgentAndActivity = findByAgentAndActivity(
    accountPersonUid = _arg_accountPersonUid,
    actorUid = _arg_actorUid,
    seActivityUid = _arg_seActivityUid,
    registrationUuidHi = _arg_registrationUuidHi,
    registrationUuidLo = _arg_registrationUuidLo,
    modifiedSince = _arg_modifiedSince,
  )
  val _result_findByUidAndPersonUidAsync =
      request.db.doorWrapper.getDaoByClass(ActorDao::class).findByUidAndPersonUidAsync(
    actorUid = _arg_actorUid,
    accountPersonUid = _arg_accountPersonUid,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_findByAgentAndActivity.map {
        _row ->
        DoorReplicationEntity(tableId = 3_289,
          orUid = 0,
          entity = json.encodeToJsonElement(StateEntity.serializer(), _row).jsonObject,
        )
      }
    )
    _result_findByUidAndPersonUidAsync?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 68,
          orUid = 0,
          entity = json.encodeToJsonElement(ActorEntity.serializer(), _row).jsonObject,
        )
      )
    }
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}
