package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.composites.ContentEntryImportJobProgress;
import com.ustadmobile.lib.db.entities.ContentEntryImportJob;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ContentEntryImportJobDao_Impl extends ContentEntryImportJobDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ContentEntryImportJob> __insertionAdapterOfContentEntryImportJob;

  private final SharedSQLiteStatement __preparedStmtOfUpdateItemStatus;

  private final SharedSQLiteStatement __preparedStmtOfUpdateItemStatusAndError;

  private final SharedSQLiteStatement __preparedStmtOfUpdateErrorDismissed;

  private final SharedSQLiteStatement __preparedStmtOfUpdateItemProgress;

  public ContentEntryImportJobDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfContentEntryImportJob = new EntityInsertionAdapter<ContentEntryImportJob>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `ContentEntryImportJob` (`cjiUid`,`sourceUri`,`cjiOriginalFilename`,`cjiContentEntryUid`,`cjiParentContentEntryUid`,`cjiContentEntryVersion`,`cjiItemProgress`,`cjiItemTotal`,`cjiStatus`,`cjiRecursiveStatus`,`cjiPluginId`,`cjiParentCjiUid`,`cjiStartTime`,`cjiFinishTime`,`cjiContentDeletedOnCancellation`,`cjiCompressionLevel`,`cjiError`,`cjiErrorDismissed`,`cjiOwnerPersonUid`,`cjiParams`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ContentEntryImportJob entity) {
        statement.bindLong(1, entity.getCjiUid());
        if (entity.getSourceUri() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getSourceUri());
        }
        if (entity.getCjiOriginalFilename() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getCjiOriginalFilename());
        }
        statement.bindLong(4, entity.getCjiContentEntryUid());
        statement.bindLong(5, entity.getCjiParentContentEntryUid());
        statement.bindLong(6, entity.getCjiContentEntryVersion());
        statement.bindLong(7, entity.getCjiItemProgress());
        statement.bindLong(8, entity.getCjiItemTotal());
        statement.bindLong(9, entity.getCjiStatus());
        statement.bindLong(10, entity.getCjiRecursiveStatus());
        statement.bindLong(11, entity.getCjiPluginId());
        statement.bindLong(12, entity.getCjiParentCjiUid());
        statement.bindLong(13, entity.getCjiStartTime());
        statement.bindLong(14, entity.getCjiFinishTime());
        final int _tmp = entity.getCjiContentDeletedOnCancellation() ? 1 : 0;
        statement.bindLong(15, _tmp);
        statement.bindLong(16, entity.getCjiCompressionLevel());
        if (entity.getCjiError() == null) {
          statement.bindNull(17);
        } else {
          statement.bindString(17, entity.getCjiError());
        }
        final int _tmp_1 = entity.getCjiErrorDismissed() ? 1 : 0;
        statement.bindLong(18, _tmp_1);
        statement.bindLong(19, entity.getCjiOwnerPersonUid());
        if (entity.getCjiParams() == null) {
          statement.bindNull(20);
        } else {
          statement.bindString(20, entity.getCjiParams());
        }
      }
    };
    this.__preparedStmtOfUpdateItemStatus = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE ContentEntryImportJob \n"
                + "           SET cjiStatus = ?\n"
                + "         WHERE cjiUid= ?  \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateItemStatusAndError = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE ContentEntryImportJob \n"
                + "           SET cjiStatus = ?,\n"
                + "               cjiError = ?\n"
                + "         WHERE cjiUid= ?  \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateErrorDismissed = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE ContentEntryImportJob\n"
                + "           SET cjiErrorDismissed = ?\n"
                + "         WHERE cjiUid = ?  \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateItemProgress = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE ContentEntryImportJob\n"
                + "           SET cjiItemProgress = ?,\n"
                + "               cjiItemTotal = ?\n"
                + "         WHERE cjiUid = ?     \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public Object insertJobItem(final ContentEntryImportJob jobItem,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfContentEntryImportJob.insertAndReturnId(jobItem);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object updateItemStatus(final long cjiUid, final int status,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateItemStatus.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, status);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, cjiUid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateItemStatus.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object updateItemStatusAndError(final long cjiUid, final int status, final String error,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateItemStatusAndError.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, status);
        _argIndex = 2;
        if (error == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, error);
        }
        _argIndex = 3;
        _stmt.bindLong(_argIndex, cjiUid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateItemStatusAndError.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object updateErrorDismissed(final long cjiUid, final boolean dismissed,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateErrorDismissed.acquire();
        int _argIndex = 1;
        final int _tmp = dismissed ? 1 : 0;
        _stmt.bindLong(_argIndex, _tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, cjiUid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateErrorDismissed.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object updateItemProgress(final long cjiUid, final long cjiProgress, final long cjiTotal,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateItemProgress.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, cjiProgress);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, cjiTotal);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, cjiUid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateItemProgress.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object findByUidAsync(final long cjiUid,
      final Continuation<? super ContentEntryImportJob> $completion) {
    final String _sql = "\n"
            + "        SELECT ContentEntryImportJob.*\n"
            + "          FROM ContentEntryImportJob\n"
            + "         WHERE cjiUid = ? \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, cjiUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ContentEntryImportJob>() {
      @Override
      @Nullable
      public ContentEntryImportJob call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCjiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiUid");
          final int _cursorIndexOfSourceUri = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUri");
          final int _cursorIndexOfCjiOriginalFilename = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiOriginalFilename");
          final int _cursorIndexOfCjiContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiContentEntryUid");
          final int _cursorIndexOfCjiParentContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiParentContentEntryUid");
          final int _cursorIndexOfCjiContentEntryVersion = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiContentEntryVersion");
          final int _cursorIndexOfCjiItemProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiItemProgress");
          final int _cursorIndexOfCjiItemTotal = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiItemTotal");
          final int _cursorIndexOfCjiStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiStatus");
          final int _cursorIndexOfCjiRecursiveStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiRecursiveStatus");
          final int _cursorIndexOfCjiPluginId = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiPluginId");
          final int _cursorIndexOfCjiParentCjiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiParentCjiUid");
          final int _cursorIndexOfCjiStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiStartTime");
          final int _cursorIndexOfCjiFinishTime = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiFinishTime");
          final int _cursorIndexOfCjiContentDeletedOnCancellation = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiContentDeletedOnCancellation");
          final int _cursorIndexOfCjiCompressionLevel = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiCompressionLevel");
          final int _cursorIndexOfCjiError = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiError");
          final int _cursorIndexOfCjiErrorDismissed = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiErrorDismissed");
          final int _cursorIndexOfCjiOwnerPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiOwnerPersonUid");
          final int _cursorIndexOfCjiParams = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiParams");
          final ContentEntryImportJob _result;
          if (_cursor.moveToFirst()) {
            final long _tmpCjiUid;
            _tmpCjiUid = _cursor.getLong(_cursorIndexOfCjiUid);
            final String _tmpSourceUri;
            if (_cursor.isNull(_cursorIndexOfSourceUri)) {
              _tmpSourceUri = null;
            } else {
              _tmpSourceUri = _cursor.getString(_cursorIndexOfSourceUri);
            }
            final String _tmpCjiOriginalFilename;
            if (_cursor.isNull(_cursorIndexOfCjiOriginalFilename)) {
              _tmpCjiOriginalFilename = null;
            } else {
              _tmpCjiOriginalFilename = _cursor.getString(_cursorIndexOfCjiOriginalFilename);
            }
            final long _tmpCjiContentEntryUid;
            _tmpCjiContentEntryUid = _cursor.getLong(_cursorIndexOfCjiContentEntryUid);
            final long _tmpCjiParentContentEntryUid;
            _tmpCjiParentContentEntryUid = _cursor.getLong(_cursorIndexOfCjiParentContentEntryUid);
            final long _tmpCjiContentEntryVersion;
            _tmpCjiContentEntryVersion = _cursor.getLong(_cursorIndexOfCjiContentEntryVersion);
            final long _tmpCjiItemProgress;
            _tmpCjiItemProgress = _cursor.getLong(_cursorIndexOfCjiItemProgress);
            final long _tmpCjiItemTotal;
            _tmpCjiItemTotal = _cursor.getLong(_cursorIndexOfCjiItemTotal);
            final int _tmpCjiStatus;
            _tmpCjiStatus = _cursor.getInt(_cursorIndexOfCjiStatus);
            final int _tmpCjiRecursiveStatus;
            _tmpCjiRecursiveStatus = _cursor.getInt(_cursorIndexOfCjiRecursiveStatus);
            final int _tmpCjiPluginId;
            _tmpCjiPluginId = _cursor.getInt(_cursorIndexOfCjiPluginId);
            final long _tmpCjiParentCjiUid;
            _tmpCjiParentCjiUid = _cursor.getLong(_cursorIndexOfCjiParentCjiUid);
            final long _tmpCjiStartTime;
            _tmpCjiStartTime = _cursor.getLong(_cursorIndexOfCjiStartTime);
            final long _tmpCjiFinishTime;
            _tmpCjiFinishTime = _cursor.getLong(_cursorIndexOfCjiFinishTime);
            final boolean _tmpCjiContentDeletedOnCancellation;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCjiContentDeletedOnCancellation);
            _tmpCjiContentDeletedOnCancellation = _tmp != 0;
            final int _tmpCjiCompressionLevel;
            _tmpCjiCompressionLevel = _cursor.getInt(_cursorIndexOfCjiCompressionLevel);
            final String _tmpCjiError;
            if (_cursor.isNull(_cursorIndexOfCjiError)) {
              _tmpCjiError = null;
            } else {
              _tmpCjiError = _cursor.getString(_cursorIndexOfCjiError);
            }
            final boolean _tmpCjiErrorDismissed;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfCjiErrorDismissed);
            _tmpCjiErrorDismissed = _tmp_1 != 0;
            final long _tmpCjiOwnerPersonUid;
            _tmpCjiOwnerPersonUid = _cursor.getLong(_cursorIndexOfCjiOwnerPersonUid);
            final String _tmpCjiParams;
            if (_cursor.isNull(_cursorIndexOfCjiParams)) {
              _tmpCjiParams = null;
            } else {
              _tmpCjiParams = _cursor.getString(_cursorIndexOfCjiParams);
            }
            _result = new ContentEntryImportJob(_tmpCjiUid,_tmpSourceUri,_tmpCjiOriginalFilename,_tmpCjiContentEntryUid,_tmpCjiParentContentEntryUid,_tmpCjiContentEntryVersion,_tmpCjiItemProgress,_tmpCjiItemTotal,_tmpCjiStatus,_tmpCjiRecursiveStatus,_tmpCjiPluginId,_tmpCjiParentCjiUid,_tmpCjiStartTime,_tmpCjiFinishTime,_tmpCjiContentDeletedOnCancellation,_tmpCjiCompressionLevel,_tmpCjiError,_tmpCjiErrorDismissed,_tmpCjiOwnerPersonUid,_tmpCjiParams);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findOwnerByUidAsync(final long cjiUid,
      final Continuation<? super Long> $completion) {
    final String _sql = "\n"
            + "        SELECT COALESCE(\n"
            + "               (SELECT ContentEntryImportJob.cjiOwnerPersonUid\n"
            + "                  FROM ContentEntryImportJob\n"
            + "                 WHERE ContentEntryImportJob.cjiUid = ?), 0)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, cjiUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Long _result;
          if (_cursor.moveToFirst()) {
            final long _tmp;
            _tmp = _cursor.getLong(0);
            _result = _tmp;
          } else {
            _result = 0L;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<List<ContentEntryImportJobProgress>> findInProgressJobsByContentEntryUid(
      final long contentEntryUid) {
    final String _sql = "\n"
            + "        SELECT ContentEntryImportJob.cjiUid,\n"
            + "               ContentEntryImportJob.cjiItemProgress,\n"
            + "               ContentEntryImportJob.cjiItemTotal,\n"
            + "               ContentEntryImportJob.cjiStatus,\n"
            + "               ContentEntryImportJob.cjiError,\n"
            + "               ContentEntryImportJob.cjiOwnerPersonUid\n"
            + "          FROM ContentEntryImportJob\n"
            + "         WHERE ContentEntryImportJob.cjiContentEntryUid = ?\n"
            + "           AND (   ContentEntryImportJob.cjiStatus BETWEEN 4 AND 20\n"
            + "                OR (ContentEntryImportJob.cjiStatus = 25 AND NOT ContentEntryImportJob.cjiErrorDismissed))\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, contentEntryUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"ContentEntryImportJob"}, new Callable<List<ContentEntryImportJobProgress>>() {
      @Override
      @NonNull
      public List<ContentEntryImportJobProgress> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCjiUid = 0;
          final int _cursorIndexOfCjiItemProgress = 1;
          final int _cursorIndexOfCjiItemTotal = 2;
          final int _cursorIndexOfCjiStatus = 3;
          final int _cursorIndexOfCjiError = 4;
          final int _cursorIndexOfCjiOwnerPersonUid = 5;
          final List<ContentEntryImportJobProgress> _result = new ArrayList<ContentEntryImportJobProgress>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ContentEntryImportJobProgress _item;
            final long _tmpCjiUid;
            _tmpCjiUid = _cursor.getLong(_cursorIndexOfCjiUid);
            final long _tmpCjiItemProgress;
            _tmpCjiItemProgress = _cursor.getLong(_cursorIndexOfCjiItemProgress);
            final long _tmpCjiItemTotal;
            _tmpCjiItemTotal = _cursor.getLong(_cursorIndexOfCjiItemTotal);
            final int _tmpCjiStatus;
            _tmpCjiStatus = _cursor.getInt(_cursorIndexOfCjiStatus);
            final String _tmpCjiError;
            if (_cursor.isNull(_cursorIndexOfCjiError)) {
              _tmpCjiError = null;
            } else {
              _tmpCjiError = _cursor.getString(_cursorIndexOfCjiError);
            }
            final long _tmpCjiOwnerPersonUid;
            _tmpCjiOwnerPersonUid = _cursor.getLong(_cursorIndexOfCjiOwnerPersonUid);
            _item = new ContentEntryImportJobProgress(_tmpCjiUid,_tmpCjiItemProgress,_tmpCjiItemTotal,_tmpCjiStatus,_tmpCjiError,_tmpCjiOwnerPersonUid);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object findInProgressJobsByContentEntryUidAsync(final long contentEntryUid,
      final Continuation<? super List<ContentEntryImportJobProgress>> $completion) {
    final String _sql = "\n"
            + "        SELECT ContentEntryImportJob.cjiUid,\n"
            + "               ContentEntryImportJob.cjiItemProgress,\n"
            + "               ContentEntryImportJob.cjiItemTotal,\n"
            + "               ContentEntryImportJob.cjiStatus,\n"
            + "               ContentEntryImportJob.cjiError,\n"
            + "               ContentEntryImportJob.cjiOwnerPersonUid\n"
            + "          FROM ContentEntryImportJob\n"
            + "         WHERE ContentEntryImportJob.cjiContentEntryUid = ?\n"
            + "           AND (   ContentEntryImportJob.cjiStatus BETWEEN 4 AND 20\n"
            + "                OR (ContentEntryImportJob.cjiStatus = 25 AND NOT ContentEntryImportJob.cjiErrorDismissed))\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, contentEntryUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ContentEntryImportJobProgress>>() {
      @Override
      @NonNull
      public List<ContentEntryImportJobProgress> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCjiUid = 0;
          final int _cursorIndexOfCjiItemProgress = 1;
          final int _cursorIndexOfCjiItemTotal = 2;
          final int _cursorIndexOfCjiStatus = 3;
          final int _cursorIndexOfCjiError = 4;
          final int _cursorIndexOfCjiOwnerPersonUid = 5;
          final List<ContentEntryImportJobProgress> _result = new ArrayList<ContentEntryImportJobProgress>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ContentEntryImportJobProgress _item;
            final long _tmpCjiUid;
            _tmpCjiUid = _cursor.getLong(_cursorIndexOfCjiUid);
            final long _tmpCjiItemProgress;
            _tmpCjiItemProgress = _cursor.getLong(_cursorIndexOfCjiItemProgress);
            final long _tmpCjiItemTotal;
            _tmpCjiItemTotal = _cursor.getLong(_cursorIndexOfCjiItemTotal);
            final int _tmpCjiStatus;
            _tmpCjiStatus = _cursor.getInt(_cursorIndexOfCjiStatus);
            final String _tmpCjiError;
            if (_cursor.isNull(_cursorIndexOfCjiError)) {
              _tmpCjiError = null;
            } else {
              _tmpCjiError = _cursor.getString(_cursorIndexOfCjiError);
            }
            final long _tmpCjiOwnerPersonUid;
            _tmpCjiOwnerPersonUid = _cursor.getLong(_cursorIndexOfCjiOwnerPersonUid);
            _item = new ContentEntryImportJobProgress(_tmpCjiUid,_tmpCjiItemProgress,_tmpCjiItemTotal,_tmpCjiStatus,_tmpCjiError,_tmpCjiOwnerPersonUid);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
