package com.ustadmobile.core.db.dao

import com.ustadmobile.door.DoorDatabaseRepository
import com.ustadmobile.door.replication.withRepoChangeMonitor
import com.ustadmobile.door.replication.withRepoChangeMonitorAsync
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.lib.db.entities.ContentEntryPicture
import io.ktor.client.HttpClient
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlinx.coroutines.flow.Flow

@Suppress("REDUNDANT_PROJECTION", "LocalVariableName", "ClassName")
public class ContentEntryPictureDao_Repo(
  public val _db: RoomDatabase,
  public val _repo: DoorDatabaseRepository,
  public val _dao: ContentEntryPictureDao,
  public val _httpClient: HttpClient,
  public val _clientId: Long,
  public val _endpoint: String,
) : ContentEntryPictureDao() {
  override suspend fun findByContentEntryUidAsync(entryUid: Long): ContentEntryPicture? {
    val _result = _dao.findByContentEntryUidAsync(entryUid)
    return _result
  }

  override fun findByContentEntryUidLive(entryUid: Long): Flow<ContentEntryPicture?> {
    val _result = _dao.findByContentEntryUidLive(entryUid)
    return _result
  }

  override suspend fun updateAsync(ContentEntryPicture: ContentEntryPicture) {
    _repo.withRepoChangeMonitorAsync("ContentEntryPicture") {
      _dao.updateAsync(ContentEntryPicture)
    }
  }

  public override fun insert(entity: ContentEntryPicture): Long {
    val _result = _repo.withRepoChangeMonitor("ContentEntryPicture") {
      _dao.insert(entity)
    }
    return _result
  }

  public override suspend fun insertAsync(entity: ContentEntryPicture): Long {
    val _result = _repo.withRepoChangeMonitorAsync("ContentEntryPicture") {
      _dao.insertAsync(entity)
    }
    return _result
  }

  public override fun insertList(entityList: List<ContentEntryPicture>) {
    _repo.withRepoChangeMonitor("ContentEntryPicture") {
      _dao.insertList(entityList)
    }
  }

  public override fun update(entity: ContentEntryPicture) {
    _repo.withRepoChangeMonitor("ContentEntryPicture") {
      _dao.update(entity)
    }
  }
}
