package com.ustadmobile.core.db.dao

import androidx.room.Dao
import androidx.room.Query
import androidx.room.Update
import com.ustadmobile.lib.db.entities.Person
import com.ustadmobile.lib.db.entities.PersonAuth
import kotlin.Any
import kotlin.Int
import kotlin.Long
import kotlin.String

@Dao
public actual abstract class PersonAuthDao : BaseDao<PersonAuth> {
  @Query(`value` = "SELECT * FROM PersonAuth WHERE personAuthUid = :uid")
  public actual abstract suspend fun findByUidAsync(uid: Long): PersonAuth?

  @Query(`value` = "SELECT * FROM PersonAuth WHERE personAuthUid = :uid")
  public actual abstract fun findByUid(uid: Long): PersonAuth?

  @Query(`value` = "SELECT * FROM Person WHERE username = :username")
  public actual abstract fun findPersonByUsername(username: String): Person?

  @Update(
    entity = Any::class,
    onConflict = 3,
  )
  public actual abstract suspend fun updateAsync(entity: PersonAuth): Int

  @Query(`value` =
      "UPDATE PersonAuth set passwordHash = :passwordHash  WHERE personAuthUid = :personUid")
  public actual abstract suspend fun updatePasswordForPersonUid(personUid: Long,
      passwordHash: String): Int
}
