package com.ustadmobile.core.db.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import com.ustadmobile.lib.db.entities.PersonAuth2
import kotlin.Any
import kotlin.Long
import kotlin.String
import kotlin.collections.List

@Dao
public actual abstract class PersonAuth2Dao {
  @Insert(
    entity = Any::class,
    onConflict = 3,
  )
  public actual abstract suspend fun insertListAsync(auths: List<PersonAuth2>)

  @Insert(
    onConflict = 1,
    entity = Any::class,
  )
  public actual abstract suspend fun insertAsync(auth: PersonAuth2): Long

  @Query(`value` =
      "\n        SELECT PersonAuth2.*\n          FROM PersonAuth2\n         WHERE PersonAuth2.pauthUid = :personUid \n    ")
  public actual abstract suspend fun findByPersonUid(personUid: Long): PersonAuth2?

  @Query(`value` =
      "\n        SELECT PersonAuth2.*\n          FROM PersonAuth2\n               JOIN Person ON PersonAuth2.pauthUid = Person.personUid\n         WHERE Person.username = :username\n    ")
  public actual abstract suspend fun findByUsername(username: String): PersonAuth2?
}
