package com.ustadmobile.core.db.dao.xapi

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import com.ustadmobile.lib.db.entities.xapi.VerbEntity
import kotlin.Any
import kotlin.Long
import kotlin.collections.List

@Dao
public actual abstract class VerbDao {
  @Insert(
    onConflict = 5,
    entity = Any::class,
  )
  public actual abstract suspend fun insertOrIgnoreAsync(entities: List<VerbEntity>)

  @Query(`value` =
      "\n        SELECT VerbEntity.*\n          FROM VerbEntity\n         WHERE VerbEntity.verbUid = :uid \n    ")
  public actual abstract suspend fun findByUid(uid: Long): VerbEntity?
}
