package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.ContentEntryPicture;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ContentEntryPictureDao_Impl extends ContentEntryPictureDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ContentEntryPicture> __insertionAdapterOfContentEntryPicture;

  private final EntityDeletionOrUpdateAdapter<ContentEntryPicture> __updateAdapterOfContentEntryPicture;

  public ContentEntryPictureDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfContentEntryPicture = new EntityInsertionAdapter<ContentEntryPicture>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `ContentEntryPicture` (`cepUid`,`cepContentEntryUid`,`cepUri`,`cepMd5`,`cepFileSize`,`cepTimestamp`,`cepMimeType`,`cepActive`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ContentEntryPicture entity) {
        statement.bindLong(1, entity.getCepUid());
        statement.bindLong(2, entity.getCepContentEntryUid());
        if (entity.getCepUri() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getCepUri());
        }
        if (entity.getCepMd5() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getCepMd5());
        }
        statement.bindLong(5, entity.getCepFileSize());
        statement.bindLong(6, entity.getCepTimestamp());
        if (entity.getCepMimeType() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getCepMimeType());
        }
        final int _tmp = entity.getCepActive() ? 1 : 0;
        statement.bindLong(8, _tmp);
      }
    };
    this.__updateAdapterOfContentEntryPicture = new EntityDeletionOrUpdateAdapter<ContentEntryPicture>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `ContentEntryPicture` SET `cepUid` = ?,`cepContentEntryUid` = ?,`cepUri` = ?,`cepMd5` = ?,`cepFileSize` = ?,`cepTimestamp` = ?,`cepMimeType` = ?,`cepActive` = ? WHERE `cepUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ContentEntryPicture entity) {
        statement.bindLong(1, entity.getCepUid());
        statement.bindLong(2, entity.getCepContentEntryUid());
        if (entity.getCepUri() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getCepUri());
        }
        if (entity.getCepMd5() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getCepMd5());
        }
        statement.bindLong(5, entity.getCepFileSize());
        statement.bindLong(6, entity.getCepTimestamp());
        if (entity.getCepMimeType() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getCepMimeType());
        }
        final int _tmp = entity.getCepActive() ? 1 : 0;
        statement.bindLong(8, _tmp);
        statement.bindLong(9, entity.getCepUid());
      }
    };
  }

  @Override
  public long insert(final ContentEntryPicture entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfContentEntryPicture.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final ContentEntryPicture entity,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfContentEntryPicture.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void insertList(final List<? extends ContentEntryPicture> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfContentEntryPicture.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final ContentEntryPicture entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfContentEntryPicture.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAsync(final ContentEntryPicture ContentEntryPicture,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __updateAdapterOfContentEntryPicture.handle(ContentEntryPicture);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByContentEntryUidAsync(final long entryUid,
      final Continuation<? super ContentEntryPicture> $completion) {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "          FROM ContentEntryPicture \n"
            + "         WHERE cepContentEntryUid = ?\n"
            + "           AND cepActive\n"
            + "      ORDER BY cepTimestamp DESC \n"
            + "         LIMIT 1\n"
            + "         ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, entryUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ContentEntryPicture>() {
      @Override
      @Nullable
      public ContentEntryPicture call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCepUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepUid");
          final int _cursorIndexOfCepContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepContentEntryUid");
          final int _cursorIndexOfCepUri = CursorUtil.getColumnIndexOrThrow(_cursor, "cepUri");
          final int _cursorIndexOfCepMd5 = CursorUtil.getColumnIndexOrThrow(_cursor, "cepMd5");
          final int _cursorIndexOfCepFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "cepFileSize");
          final int _cursorIndexOfCepTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "cepTimestamp");
          final int _cursorIndexOfCepMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "cepMimeType");
          final int _cursorIndexOfCepActive = CursorUtil.getColumnIndexOrThrow(_cursor, "cepActive");
          final ContentEntryPicture _result;
          if (_cursor.moveToFirst()) {
            _result = new ContentEntryPicture();
            final long _tmpCepUid;
            _tmpCepUid = _cursor.getLong(_cursorIndexOfCepUid);
            _result.setCepUid(_tmpCepUid);
            final long _tmpCepContentEntryUid;
            _tmpCepContentEntryUid = _cursor.getLong(_cursorIndexOfCepContentEntryUid);
            _result.setCepContentEntryUid(_tmpCepContentEntryUid);
            final String _tmpCepUri;
            if (_cursor.isNull(_cursorIndexOfCepUri)) {
              _tmpCepUri = null;
            } else {
              _tmpCepUri = _cursor.getString(_cursorIndexOfCepUri);
            }
            _result.setCepUri(_tmpCepUri);
            final String _tmpCepMd5;
            if (_cursor.isNull(_cursorIndexOfCepMd5)) {
              _tmpCepMd5 = null;
            } else {
              _tmpCepMd5 = _cursor.getString(_cursorIndexOfCepMd5);
            }
            _result.setCepMd5(_tmpCepMd5);
            final int _tmpCepFileSize;
            _tmpCepFileSize = _cursor.getInt(_cursorIndexOfCepFileSize);
            _result.setCepFileSize(_tmpCepFileSize);
            final long _tmpCepTimestamp;
            _tmpCepTimestamp = _cursor.getLong(_cursorIndexOfCepTimestamp);
            _result.setCepTimestamp(_tmpCepTimestamp);
            final String _tmpCepMimeType;
            if (_cursor.isNull(_cursorIndexOfCepMimeType)) {
              _tmpCepMimeType = null;
            } else {
              _tmpCepMimeType = _cursor.getString(_cursorIndexOfCepMimeType);
            }
            _result.setCepMimeType(_tmpCepMimeType);
            final boolean _tmpCepActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCepActive);
            _tmpCepActive = _tmp != 0;
            _result.setCepActive(_tmpCepActive);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<ContentEntryPicture> findByContentEntryUidLive(final long entryUid) {
    final String _sql = "\n"
            + "         SELECT * \n"
            + "          FROM ContentEntryPicture \n"
            + "         WHERE cepContentEntryUid = ?\n"
            + "           AND cepActive\n"
            + "      ORDER BY cepTimestamp DESC \n"
            + "         LIMIT 1\n"
            + "         ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, entryUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"ContentEntryPicture"}, new Callable<ContentEntryPicture>() {
      @Override
      @Nullable
      public ContentEntryPicture call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCepUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepUid");
          final int _cursorIndexOfCepContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepContentEntryUid");
          final int _cursorIndexOfCepUri = CursorUtil.getColumnIndexOrThrow(_cursor, "cepUri");
          final int _cursorIndexOfCepMd5 = CursorUtil.getColumnIndexOrThrow(_cursor, "cepMd5");
          final int _cursorIndexOfCepFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "cepFileSize");
          final int _cursorIndexOfCepTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "cepTimestamp");
          final int _cursorIndexOfCepMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "cepMimeType");
          final int _cursorIndexOfCepActive = CursorUtil.getColumnIndexOrThrow(_cursor, "cepActive");
          final ContentEntryPicture _result;
          if (_cursor.moveToFirst()) {
            _result = new ContentEntryPicture();
            final long _tmpCepUid;
            _tmpCepUid = _cursor.getLong(_cursorIndexOfCepUid);
            _result.setCepUid(_tmpCepUid);
            final long _tmpCepContentEntryUid;
            _tmpCepContentEntryUid = _cursor.getLong(_cursorIndexOfCepContentEntryUid);
            _result.setCepContentEntryUid(_tmpCepContentEntryUid);
            final String _tmpCepUri;
            if (_cursor.isNull(_cursorIndexOfCepUri)) {
              _tmpCepUri = null;
            } else {
              _tmpCepUri = _cursor.getString(_cursorIndexOfCepUri);
            }
            _result.setCepUri(_tmpCepUri);
            final String _tmpCepMd5;
            if (_cursor.isNull(_cursorIndexOfCepMd5)) {
              _tmpCepMd5 = null;
            } else {
              _tmpCepMd5 = _cursor.getString(_cursorIndexOfCepMd5);
            }
            _result.setCepMd5(_tmpCepMd5);
            final int _tmpCepFileSize;
            _tmpCepFileSize = _cursor.getInt(_cursorIndexOfCepFileSize);
            _result.setCepFileSize(_tmpCepFileSize);
            final long _tmpCepTimestamp;
            _tmpCepTimestamp = _cursor.getLong(_cursorIndexOfCepTimestamp);
            _result.setCepTimestamp(_tmpCepTimestamp);
            final String _tmpCepMimeType;
            if (_cursor.isNull(_cursorIndexOfCepMimeType)) {
              _tmpCepMimeType = null;
            } else {
              _tmpCepMimeType = _cursor.getString(_cursorIndexOfCepMimeType);
            }
            _result.setCepMimeType(_tmpCepMimeType);
            final boolean _tmpCepActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCepActive);
            _tmpCepActive = _tmp != 0;
            _result.setCepActive(_tmpCepActive);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
