package com.ustadmobile.core.db.dao

import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.Holiday
import kotlin.Boolean
import kotlin.Long
import kotlin.collections.List

public class HolidayDao_DoorWrapper(
  private val _db: RoomDatabase,
  private val _dao: HolidayDao,
) : HolidayDao() {
  override fun findByHolidayCalendaUid(holidayCalendarUid: Long): List<Holiday> =
      _dao.findByHolidayCalendaUid(holidayCalendarUid)

  override suspend fun findByHolidayCalendaUidAsync(holidayCalendarUid: Long): List<Holiday> =
      _dao.findByHolidayCalendaUidAsync(holidayCalendarUid)

  override fun updateActiveByUid(
    holidayUid: Long,
    active: Boolean,
    changeTime: Long,
  ) {
    _dao.updateActiveByUid(holidayUid, active, changeTime)
  }

  override suspend fun updateAsync(entity: Holiday) {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.holUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(99)
      entity.holUid = _newPk
    }
    entity.holLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.updateAsync(entity)
  }

  public override fun insert(entity: Holiday): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.holUid == 0L) {
      val _newPk = _pkManager.nextId(99)
      entity.holUid = _newPk
    }
    entity.holLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insert(entity)
    return entity.holUid
  }

  public override suspend fun insertAsync(entity: Holiday): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.holUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(99)
      entity.holUid = _newPk
    }
    entity.holLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.holUid
  }

  public override fun insertList(entityList: List<Holiday>) {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.holUid == 0L) {
        val _newPk = _pkManager.nextId(99)
        it.holUid = _newPk
        _generatedPks += _newPk
      }
      it.holLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertList(entityList)
  }

  public override fun update(entity: Holiday) {
    entity.holLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.update(entity)
  }

  public override suspend fun insertListAsync(entityList: List<Holiday>) {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.holUid == 0L) {
        val _newPk = _pkManager.nextIdAsync(99)
        it.holUid = _newPk
        _generatedPks += _newPk
      }
      it.holLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertListAsync(entityList)
  }

  public override suspend fun updateListAsync(entityList: List<Holiday>) {
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      it.holLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.updateListAsync(entityList)
  }
}
