package com.ustadmobile.core.db.dao

import com.ustadmobile.door.DoorConstants
import com.ustadmobile.door.ext.doorWrapperNodeId
import com.ustadmobile.door.http.DoorHttpServerConfig
import com.ustadmobile.door.http.DoorJsonRequest
import com.ustadmobile.door.http.DoorJsonResponse
import com.ustadmobile.door.message.DoorMessage
import com.ustadmobile.door.replication.DoorReplicationEntity
import com.ustadmobile.lib.db.entities.PeerReviewerAllocation
import kotlin.Boolean
import kotlin.Long
import kotlin.Suppress
import kotlin.collections.buildList
import kotlinx.serialization.builtins.serializer
import kotlinx.serialization.json.jsonObject

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun PeerReviewerAllocationDao.getAllPeerReviewerAllocationsByClazzUid_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_clazzUid : Long = request.queryParam("clazzUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_includeInactive : Boolean = request.queryParam("includeInactive")?.let {
    json.decodeFromString(Boolean.serializer(), it)
  } ?: false
  val _result_getAllPeerReviewerAllocationsByClazzUid = getAllPeerReviewerAllocationsByClazzUid(
    clazzUid = _arg_clazzUid,
    includeInactive = _arg_includeInactive,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_getAllPeerReviewerAllocationsByClazzUid.map {
        _row ->
        DoorReplicationEntity(tableId = 140,
          orUid = 0,
          entity = json.encodeToJsonElement(PeerReviewerAllocation.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}
